/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.timetable;

import com.adesoft.arrays.IntArray;
import com.adesoft.timetable.CaseEt;
import com.adesoft.timetable.EventsGroup;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class EventsGroupImpl
implements EventsGroup {
    private final ArrayList cells = new ArrayList();
    private final Rectangle bounds;
    private final int groupOid;
    private final int groupMode;
    private final boolean isRequest;

    public EventsGroupImpl(CaseEt caseEt) {
        this.cells.add(caseEt);
        this.bounds = new Rectangle(caseEt.getShape());
        this.groupOid = caseEt.getGroupOid();
        this.groupMode = caseEt.getGroupMode();
        this.isRequest = caseEt.getEvent().isRequest();
    }

    public int hashCode() {
        if (this.getEvents().isEmpty()) {
            return 0;
        }
        return this.getEvents().get(0).hashCode();
    }

    public boolean equals(Object object) {
        EventsGroup eventsGroup;
        if (this == object) {
            return true;
        }
        if (null != object && object instanceof EventsGroup && (eventsGroup = (EventsGroup)object).getGroupOid() == this.getGroupOid() && this.size() == eventsGroup.size()) {
            int[] nArray = this.getEventsOids();
            int[] nArray2 = eventsGroup.getEventsOids();
            Arrays.sort(nArray);
            Arrays.sort(nArray2);
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (nArray[i] == nArray2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private List getEvents() {
        return this.cells;
    }

    @Override
    public boolean isRequest() {
        return this.isRequest;
    }

    @Override
    public void add(CaseEt caseEt) {
        this.getEvents().add(caseEt);
        this.bounds.add(caseEt.getShape());
    }

    @Override
    public void addEvents(Collection collection) {
        collection.addAll(this.getEvents());
    }

    @Override
    public void add(EventsGroup eventsGroup) {
        eventsGroup.addEvents(this.getEvents());
        this.bounds.add(eventsGroup.getShape());
    }

    @Override
    public CaseEt[] getCells() {
        CaseEt[] caseEtArray = new CaseEt[this.getEvents().size()];
        this.getEvents().toArray(caseEtArray);
        return caseEtArray;
    }

    @Override
    public int size() {
        return this.getEvents().size();
    }

    @Override
    public CaseEt getCell(int n) {
        if (n >= 0 && n < this.cells.size()) {
            return (CaseEt)this.cells.get(n);
        }
        return null;
    }

    @Override
    public CaseEt getFirstCell() {
        return this.getCell(0);
    }

    @Override
    public Color getColor() {
        return this.getFirstCell().getColor();
    }

    @Override
    public int getGroupOid() {
        return this.groupOid;
    }

    @Override
    public int getGroupMode() {
        return this.groupMode;
    }

    @Override
    public Rectangle getShape() {
        return this.bounds;
    }

    @Override
    public boolean isOnOneDay() {
        int n = this.size();
        if (n > 0) {
            int n2 = this.getCell(0).getEvent().getAbsoluteDay();
            for (int i = 1; i < n; ++i) {
                if (n2 == this.getCell(i).getEvent().getAbsoluteDay()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int getStart() {
        return this.getFirstCell().getStart();
    }

    @Override
    public int[] getEventsOids() {
        int n = this.size();
        IntArray intArray = new IntArray(n);
        for (int i = 0; i < n; ++i) {
            intArray.add(this.getCell(i).getEventOid());
        }
        return intArray.getValues();
    }

    @Override
    public boolean contains(CaseEt caseEt) {
        return this.getEvents().contains(caseEt);
    }

    @Override
    public int getDuration() {
        int n = this.size();
        if (0 == n) {
            return 0;
        }
        CaseEt caseEt = this.getFirstCell();
        int n2 = caseEt.getStart();
        int n3 = caseEt.getStart() + caseEt.getDuration();
        for (int i = 0; i < n; ++i) {
            CaseEt caseEt2 = this.getCell(i);
            n2 = Math.min(n2, caseEt2.getStart());
            n3 = Math.max(n3, caseEt2.getStart() + caseEt2.getDuration());
        }
        return n3 - n2;
    }

    @Override
    public double[] getCosts() {
        int n = this.size();
        if (0 == n) {
            return new double[0];
        }
        double[] dArray = null;
        for (int i = 0; i < n; ++i) {
            CaseEt caseEt = this.getCell(i);
            double[] dArray2 = caseEt.getCosts();
            if (null == dArray2) continue;
            if (null == dArray) {
                dArray = new double[dArray2.length];
                Arrays.fill(dArray, 0.0);
            }
            for (int j = 0; j < dArray2.length; ++j) {
                int n2 = j;
                dArray[n2] = dArray[n2] + dArray2[j];
            }
        }
        if (null == dArray) {
            dArray = new double[]{};
        }
        return dArray;
    }

    @Override
    public double getMovingCost() {
        return this.getFirstCell().getMovingCost();
    }

    @Override
    public double getTotalCost(boolean bl) {
        double d = 0.0;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            CaseEt caseEt = this.getCell(i);
            double[] dArray = caseEt.getCosts();
            if (null == dArray) continue;
            for (int j = 0; j < dArray.length; ++j) {
                d += dArray[j];
            }
        }
        double d2 = 0.0;
        if (bl) {
            d2 = this.getMovingCost();
        }
        return d + d2;
    }
}

