/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.timetable;

import com.adesoft.collections.TightList;
import com.adesoft.timetable.Axis;
import com.adesoft.timetable.MyLegend;
import com.adesoft.timetable.Preferences;
import java.awt.FontMetrics;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;

public class Header
implements Serializable {
    private static final long serialVersionUID = 520L;
    public static final SimpleDateFormat format = new SimpleDateFormat();
    protected static final Calendar calendar;
    private final TightList sons;
    protected final String title;
    protected Header father;
    private final boolean visible;

    public Header(String string) {
        this(string, true);
    }

    public Header(String string, boolean bl) {
        this.visible = bl;
        this.title = string;
        this.sons = new TightList();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public final void add(Header header) {
        header.setFather(this);
        this.sons.add((Object)header);
    }

    public Header getRoot() {
        Header header = this;
        while (null != header.getFather()) {
            header = header.getFather();
        }
        return header;
    }

    public Header getFather() {
        return this.father;
    }

    public int getHeight() {
        int n = 0;
        for (int i = this.getSize() - 1; i >= 0; --i) {
            Header header = this.getSonAt(i);
            int n2 = header.getHeight();
            if (n >= n2) continue;
            n = n2;
        }
        if (!this.isVisible()) {
            --n;
        }
        return 1 + n;
    }

    protected void addLeaves(List list) {
        int n = this.getSize();
        if (0 == n) {
            list.add(this);
        } else {
            for (int i = 0; i < n; ++i) {
                this.getSonAt(i).addLeaves(list);
            }
        }
    }

    public Header[] getLeaves() {
        ArrayList arrayList = new ArrayList();
        this.addLeaves(arrayList);
        Header[] headerArray = new Header[arrayList.size()];
        arrayList.toArray(headerArray);
        return headerArray;
    }

    public final Header getLeaf(int n) {
        int n2 = 0;
        int n3 = this.getSize();
        for (int i = 0; i < n3; ++i) {
            int n4 = this.getSonAt(i).getLeafCount();
            if (n < n2 + n4) {
                return this.getSonAt(i).getLeaf(n - n2);
            }
            n2 += n4;
        }
        return this;
    }

    public int getLeafCount() {
        int n = 0;
        for (int i = this.getSize() - 1; i >= 0; --i) {
            n += this.getSonAt(i).getLeafCount();
        }
        return 0 == n ? 1 : n;
    }

    public final int getSize() {
        return this.sons.size();
    }

    public final Header getSonAt(int n) {
        return (Header)this.sons.get(n);
    }

    public int getSizeRecursive(MyLegend myLegend, Axis axis, Preferences preferences) {
        if (this.sons.isEmpty()) {
            if (preferences.isDisplay(16384) && (axis == Axis.Y && preferences.isPortrait() || axis == Axis.X && !preferences.isPortrait())) {
                myLegend.setAcceptToEachStep(true);
            } else {
                myLegend.setAcceptToEachStep(false);
            }
            return 1;
        }
        return this.sons.size() * this.getSonAt(0).getSizeRecursive(myLegend, axis, preferences);
    }

    public String getTitle() {
        return this.title;
    }

    public String getTitle(FontMetrics fontMetrics, double d) {
        return this.title;
    }

    public void setFather(Header header) {
        this.father = header;
    }

    public boolean isFatherOf(Header header) {
        Header header2 = header;
        while (this != header2) {
            if (null != (header2 = header2.getFather())) continue;
            return false;
        }
        return true;
    }

    public boolean hasNoSiblingNode() {
        for (Header header = this.getFather(); null != header; header = header.getFather()) {
            if (1 == header.getSize()) continue;
            return false;
        }
        return true;
    }

    static {
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar = format.getCalendar();
    }
}

