/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.timetable;

import com.adesoft.arrays.BooleanArray;
import com.adesoft.arrays.IntArray;
import com.adesoft.arrays.StringArray;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.text.CharacterIterator;

public final class Labels
extends BreakIterator {
    private final StringBuffer text = new StringBuffer();
    private final StringArray labels;
    private final IntArray sizes = new IntArray();
    private final BooleanArray bolds = new BooleanArray();
    private int currentWord;
    private int current;

    public Labels() {
        this.labels = new StringArray();
    }

    public boolean isEmpty() {
        if (this.labels.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.labels.size(); ++i) {
            if (null == this.labels.get(i)) continue;
            return false;
        }
        return true;
    }

    public StringArray getLabels() {
        return this.labels;
    }

    private void addText(String string, boolean bl) {
        this.labels.add(string);
        this.text.append(string);
        this.sizes.add(string.length());
        this.bolds.add(bl);
    }

    public void addEmpty() {
        this.labels.add((String)null);
        this.sizes.add(0);
        this.bolds.add(false);
    }

    public void addSingle(String string, boolean bl) {
        this.addText(string, bl);
        this.addEmpty();
    }

    public void addMultiple(String[] stringArray, boolean[] blArray) {
        if (null != stringArray && 0 != stringArray.length) {
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                boolean bl2 = false;
                if (null != blArray) {
                    bl2 = blArray[i];
                }
                if (null == (string = string.replace('\n', ' ')) || 0 == string.length()) continue;
                bl = true;
                this.addText(string, bl2);
            }
            if (bl) {
                this.addEmpty();
            }
        }
    }

    public void addMultiple(StringArray stringArray, BooleanArray booleanArray) {
        if (null != stringArray && !stringArray.isEmpty()) {
            boolean bl = false;
            int n = stringArray.size();
            for (int i = 0; i < n; ++i) {
                String string = stringArray.get(i);
                boolean bl2 = false;
                if (null != booleanArray) {
                    bl2 = booleanArray.get(i);
                }
                if (null == string || 0 == string.length()) continue;
                bl = true;
                this.addText(string, bl2);
            }
            if (bl) {
                this.addEmpty();
            }
        }
    }

    public static boolean _add(StringArray stringArray, BooleanArray booleanArray, String[] stringArray2, boolean[] blArray) {
        boolean bl = false;
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray2[i];
            if (null == string || 0 == string.length() || stringArray.contains(string)) continue;
            bl = true;
            stringArray.add(string);
            if (null == booleanArray) continue;
            booleanArray.add(blArray[i]);
        }
        return bl;
    }

    public LineBreakMeasurer getMeasurer(FontRenderContext fontRenderContext, Font font, Font font2) {
        AttributedString attributedString = this.getAttributedString(font, font2);
        return new LineBreakMeasurer(attributedString.getIterator(), this, fontRenderContext);
    }

    private AttributedString getAttributedString(Font font, Font font2) {
        String string = this.getString();
        AttributedString attributedString = new AttributedString(string);
        attributedString.addAttribute(TextAttribute.FONT, font, 0, string.length());
        int n = 0;
        for (int i = 0; i < this.sizes.size(); ++i) {
            int n2 = this.sizes.get(i);
            if (i == 0 && n2 == 0) continue;
            if (i == 0 || this.bolds.get(i)) {
                attributedString.addAttribute(TextAttribute.FONT, font2, n, n + n2);
            }
            n += n2;
        }
        return attributedString;
    }

    @Override
    public int current() {
        return this.current;
    }

    public int currentWord() {
        return this.currentWord;
    }

    @Override
    public int first() {
        this.current = 0;
        return this.current();
    }

    @Override
    public int following(int n) {
        return n;
    }

    public String getString() {
        return this.text.toString();
    }

    @Override
    public CharacterIterator getText() {
        throw new UnsupportedOperationException("getText");
    }

    @Override
    public int last() {
        return this.text.length();
    }

    @Override
    public int next() {
        if (this.currentWord >= this.sizes.size()) {
            return -1;
        }
        this.current += this.sizes.get(this.currentWord++);
        return this.current;
    }

    @Override
    public int next(int n) {
        for (int i = 0; i < n; ++i) {
            this.next();
        }
        return this.current();
    }

    @Override
    public int preceding(int n) {
        return n;
    }

    @Override
    public int previous() {
        if (this.currentWord > 0) {
            return this.current() - this.sizes.get(this.currentWord - 1);
        }
        return -1;
    }

    public void setPosition(int n, int n2) {
        this.current = n;
        this.currentWord = n2;
    }

    @Override
    public void setText(CharacterIterator characterIterator) {
    }
}

