/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.timetable;

import com.adesoft.arrays.IntArray;
import com.adesoft.collections.ListUnique;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class MonthsYears {
    private static final transient Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    private final int[][] monthsByWeekAndDay;
    private final int[][] yearsByWeekAndDay;
    private final int[][] weeksByMonth;
    private final int[][] weeksByYear;
    private final String[] monthNames;
    private final String[] yearNames;
    private final int[] monthYears;
    private final int[] years;

    public MonthsYears(Date[][] dateArray) {
        int n;
        this.monthsByWeekAndDay = new int[dateArray.length][];
        this.yearsByWeekAndDay = new int[dateArray.length][];
        ListUnique listUnique = new ListUnique();
        this.weeksByMonth = MonthsYears.getWeeks(dateArray, "MMMMMMMM yyyy", listUnique);
        this.monthNames = new String[listUnique.size()];
        listUnique.toArray((Object[])this.monthNames);
        IntArray intArray = new IntArray();
        int n2 = -1;
        for (n = 0; n < dateArray.length; ++n) {
            int n3 = dateArray[n].length;
            this.monthsByWeekAndDay[n] = new int[n3];
            this.yearsByWeekAndDay[n] = new int[n3];
            for (int i = 0; i < n3; ++i) {
                calendar.setTime(dateArray[n][i]);
                int n4 = calendar.get(2);
                int n5 = calendar.get(1);
                int n6 = n5 * 100 + n4;
                if (n6 != n2) {
                    intArray.add(n6);
                    n2 = n6;
                }
                this.monthsByWeekAndDay[n][i] = n4;
                this.yearsByWeekAndDay[n][i] = n5;
            }
        }
        this.monthYears = intArray.getValues();
        listUnique = new ListUnique();
        this.weeksByYear = MonthsYears.getWeeks(dateArray, "yyyy", listUnique);
        this.yearNames = new String[listUnique.size()];
        listUnique.toArray((Object[])this.yearNames);
        this.years = new int[listUnique.size()];
        for (n = 0; n < listUnique.size(); ++n) {
            this.years[n] = Integer.parseInt((String)listUnique.get(n));
        }
    }

    public int[] getWeeksByMonths(int[] nArray, int[] nArray2) {
        int n;
        int[] nArray3;
        IntArray intArray = new IntArray();
        for (int i = 0; i < nArray.length; ++i) {
            nArray3 = this.weeksByMonth[nArray[i]];
            for (n = 0; n < nArray3.length; ++n) {
                if (intArray.contains(nArray3[n])) continue;
                intArray.add(nArray3[n]);
            }
        }
        IntArray intArray2 = new IntArray();
        nArray3 = intArray.getValues();
        for (n = 0; n < nArray3.length; ++n) {
            boolean bl = false;
            for (int i = 0; i < nArray2.length && !bl; ++i) {
                int n2 = this.getMonthYear(nArray3[n], nArray2[i]);
                for (int j = 0; j < nArray.length && !bl; ++j) {
                    int n3 = this.monthYears[nArray[j]];
                    if (n3 != n2) continue;
                    bl = true;
                }
            }
            if (!bl) continue;
            intArray2.add(nArray3[n]);
        }
        return intArray2.getValues();
    }

    public int[] getWeeksByYears(int[] nArray, int[] nArray2) {
        int n;
        int[] nArray3;
        IntArray intArray = new IntArray();
        for (int i = 0; i < nArray.length; ++i) {
            nArray3 = this.weeksByYear[nArray[i]];
            for (n = 0; n < nArray3.length; ++n) {
                if (intArray.contains(nArray3[n])) continue;
                intArray.add(nArray3[n]);
            }
        }
        IntArray intArray2 = new IntArray();
        nArray3 = intArray.getValues();
        for (n = 0; n < nArray3.length; ++n) {
            boolean bl = false;
            for (int i = 0; i < nArray2.length && !bl; ++i) {
                int n2 = this.getYear(nArray3[n], nArray2[i]);
                for (int j = 0; j < nArray.length && !bl; ++j) {
                    int n3 = this.years[nArray[j]];
                    if (n3 != n2) continue;
                    bl = true;
                }
            }
            if (!bl) continue;
            intArray2.add(nArray3[n]);
        }
        return intArray2.getValues();
    }

    public String[] getMonthNames() {
        return this.monthNames;
    }

    public int[] getMonthYears() {
        return this.monthYears;
    }

    public int[] getYears() {
        return this.years;
    }

    public int getMonth(int n, int n2) {
        return this.monthsByWeekAndDay[n][n2];
    }

    public int[] getYears(int[] nArray, int[] nArray2) {
        IntArray intArray = new IntArray();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                int n = this.getYear(nArray[i], nArray2[j]);
                if (intArray.contains(n)) continue;
                intArray.add(n);
            }
        }
        return intArray.getValues();
    }

    public int getYear(int n, int n2) {
        return this.yearsByWeekAndDay[n][n2];
    }

    public int[] getMonthsYear(int[] nArray, int[] nArray2) {
        IntArray intArray = new IntArray();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                int n = this.getMonthYear(nArray[i], nArray2[j]);
                if (intArray.contains(n)) continue;
                intArray.add(n);
            }
        }
        return intArray.getValues();
    }

    public int getMonthYear(int n, int n2) {
        return this.yearsByWeekAndDay[n][n2] * 100 + this.monthsByWeekAndDay[n][n2];
    }

    private static int[][] getWeeks(Date[][] dateArray, String string, ListUnique listUnique) {
        int n;
        ArrayList<IntArray> arrayList = new ArrayList<IntArray>();
        IntArray intArray = new IntArray();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        for (n = 0; n < dateArray.length; ++n) {
            for (int i = 0; i < dateArray[n].length; ++i) {
                String string2 = simpleDateFormat.format(dateArray[n][i]);
                if (listUnique.add((Object)string2)) {
                    intArray = new IntArray();
                    arrayList.add(intArray);
                }
                if (intArray.contains(n)) continue;
                intArray.add(n);
            }
        }
        n = arrayList.size();
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < n; ++i) {
            nArrayArray[i] = ((IntArray)arrayList.get(i)).getValues();
        }
        return nArrayArray;
    }

    public int getIndexMonthYear(int n, int n2) {
        int n3 = this.getMonthYear(n, n2);
        int n4 = -1;
        for (int i = 0; i < this.monthYears.length && -1 == n4; ++i) {
            if (this.monthYears[i] != n3) continue;
            n4 = i;
        }
        return n4;
    }

    public int getIndexYear(int n, int n2) {
        int n3 = this.getYear(n, n2);
        int n4 = -1;
        for (int i = 0; i < this.years.length && -1 == n4; ++i) {
            if (this.years[i] != n3) continue;
            n4 = i;
        }
        return n4;
    }
}

