/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.timetable;

import com.adesoft.config.ConfigManager;
import com.adesoft.modules.Modules;
import com.adesoft.properties.ServerProperty;
import com.adesoft.timetable.AbstractLegend;
import com.adesoft.timetable.Axis;
import com.adesoft.timetable.CostsEt;
import com.adesoft.timetable.EtGrid;
import com.adesoft.timetable.Preferences;
import com.adesoft.timetable.TimetableLabels;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.text.DecimalFormat;

public final class MyCosts
extends AbstractLegend {
    private static final long serialVersionUID = 520L;
    private final DecimalFormat format;
    private final TimetableLabels labels;
    private static final int DEFAULT_WIDTH_COST = 40;
    private static final int DEFAULT_HEIGHT_COST = 19;
    private static final int COST_COLOR_DELIMITER = MyCosts.getCostColorDelimiter();
    private static final Color EXPENSIVE_COST_COLOR = MyCosts.getCostColor(ServerProperty.EXPENSIVE_COST_COLOR);
    private static final Color CHEAP_COST_COLOR = MyCosts.getCostColor(ServerProperty.CHEAP_COST_COLOR);
    public boolean legend;
    private CostsEt costsEt;
    private boolean showLoad;

    public MyCosts(Axis axis, TimetableLabels timetableLabels) {
        super(axis);
        this.labels = timetableLabels;
        this.format = new DecimalFormat();
        this.format.setDecimalSeparatorAlwaysShown(false);
    }

    private static int getCostColorDelimiter() {
        try {
            return ConfigManager.getInstance().getIntProperty(ServerProperty.COST_COLOR_DELIMITER);
        }
        catch (Exception exception) {
            return Integer.parseInt(ServerProperty.COST_COLOR_DELIMITER.getDefaultValue());
        }
    }

    private static Color getCostColor(ServerProperty serverProperty) {
        Color.decode(ConfigManager.getInstance().getProperty(ServerProperty.EXPENSIVE_COST_COLOR));
        try {
            return Color.decode(ConfigManager.getInstance().getProperty(serverProperty));
        }
        catch (Exception exception) {
            return Color.decode(serverProperty.getDefaultValue());
        }
    }

    private TimetableLabels getLabels() {
        return this.labels;
    }

    @Override
    public void setData(Graphics2D graphics2D, EtGrid etGrid, Preferences preferences) {
        super.setData(graphics2D, etGrid, preferences);
        this.costsEt = null;
        if (null != etGrid) {
            this.costsEt = etGrid.getCostsEt();
        }
        this.showLoad = false;
        if (null != this.getPreferences()) {
            this.showLoad = this.getPreferences().showLoad();
        }
    }

    public boolean isLegend() {
        return this.legend;
    }

    public void setLegend(boolean bl) {
        this.legend = bl;
    }

    public CostsEt getCostsEt() {
        if (null == this.costsEt && null != this.getPreferences()) {
            int[] nArray = this.getPreferences().getCostsIds();
            this.costsEt = new CostsEt(nArray, new String[nArray.length], this.getNRows(), this.getNColumns());
        }
        return this.costsEt;
    }

    public int getCostsView() {
        return this.getPreferences().getCostsColsRowsView();
    }

    public int getDimSize() {
        return this.getDimSizeFor(this.getAxis());
    }

    public int getDimSizeFor(Axis axis) {
        if (Axis.X == axis) {
            return 19;
        }
        return 40;
    }

    public int getNViews() {
        int n = 0;
        if (null != this.getPreferences()) {
            int n2 = this.getCostsView();
            int n3 = 0;
            if (ConfigManager.getInstance().hasModule(Modules.SITES) && this.getPreferences().isMovingCost()) {
                n3 = 1;
            }
            if (this.getCostsEt().getNbCosts() + n3 > 0) {
                if (1 == (1 & n2)) {
                    n += this.getCostsEt().getNbCosts() + n3;
                }
                if (2 == (2 & n2)) {
                    ++n;
                }
            }
        }
        return n;
    }

    public int getDim() {
        if (null != this.getGrid()) {
            return this.getNViews() * this.getDimSize();
        }
        return 0;
    }

    @Override
    public int getDimWidth() {
        return this.getNViews() * this.getDimSizeFor(Axis.X);
    }

    @Override
    public int getDimHeight() {
        return this.getNViews() * this.getDimSizeFor(Axis.Y);
    }

    private double getComputedCost(int n, int n2, int n3, boolean bl) {
        double d = -1.0;
        if (!this.isLegend()) {
            d = !bl ? (-1 != n ? this.getCostsEt().getCostCol(n, n3) : (-1 != n2 ? this.getCostsEt().getCostRow(n2, n3) : this.getCostsEt().getCost(n3))) : (-1 != n ? this.getCostsEt().getCostCol(n, this.getPreferences().isMovingCost()) : (-1 != n2 ? this.getCostsEt().getCostRow(n2, this.getPreferences().isMovingCost()) : this.getCostsEt().getCost()));
        }
        return d;
    }

    private double getComputedCostMoving(int n, int n2) {
        double d = -1.0;
        if (!this.isLegend()) {
            if (-1 != n) {
                d = this.getCostsEt().getCostsMovingCols()[n];
            } else if (-1 != n2) {
                d = this.getCostsEt().getCostsMovingRows()[n2];
            }
        }
        return d;
    }

    private String getData(int n, int n2, int n3, boolean bl, boolean bl2) {
        if (this.isLegend()) {
            int n4;
            String[] stringArray = this.getCostsEt().getCostsNames();
            int n5 = n4 = bl2 ? 1 : 0;
            if (null != stringArray && stringArray.length + n4 > 0) {
                if (1 == (1 & this.getCostsView()) && n3 < stringArray.length) {
                    return stringArray[n3];
                }
                return this.getLabels().getLabelCumulativeCosts();
            }
            return "";
        }
        double d = this.getComputedCost(n, n2, n3, bl);
        if (-1.0 != d) {
            return this.format.format(d);
        }
        return "";
    }

    private static void drawColsRowsLines(Graphics2D graphics2D, Axis axis, int n, int n2, int n3, boolean bl) {
        block2: {
            block3: {
                if (bl) break block2;
                if (Axis.X != axis) break block3;
                for (int i = 0; i < n3; ++i) {
                    double d = (double)n * (double)(i % n3) / (double)n3;
                    graphics2D.drawLine((int)d, 0, (int)d, n2);
                }
                break block2;
            }
            if (Axis.Y != axis) break block2;
            for (int i = 0; i < n3; ++i) {
                double d = (double)n2 * (double)(i % n3) / (double)n3;
                graphics2D.drawLine(0, (int)d, n, (int)d);
            }
        }
    }

    private static void drawCostsLines(Graphics graphics, Axis axis, int n, int n2, int n3) {
        block8: {
            block10: {
                block9: {
                    if (0 == n) break block8;
                    if (Axis.Y != axis) break block9;
                    for (int i = 0; i < n; ++i) {
                        double d = (double)n2 * (double)(i % n) / (double)n;
                        if (0 == i) {
                            d -= 1.0;
                        }
                        graphics.drawLine((int)d, 0, (int)d, n3);
                    }
                    break block8;
                }
                if (Axis.X != axis) break block10;
                for (int i = 0; i < n; ++i) {
                    double d = (double)n3 * (double)(i % n) / (double)n;
                    if (0 == i) {
                        d -= 1.0;
                    }
                    graphics.drawLine(0, (int)d, n2, (int)d);
                }
                break block8;
            }
            if (Axis.INTERSECT != axis) break block8;
            for (int i = 0; i <= n; ++i) {
                double d = (double)n2 * (double)(i - 1 % n) / (double)n;
                double d2 = (double)n2 * (double)(i + 1 % n) / (double)n;
                double d3 = (double)n2 * (double)(i % n) / (double)n;
                double d4 = (double)n3 * (double)(i - 1 % n) / (double)n;
                double d5 = (double)n3 * (double)(i + 1 % n) / (double)n;
                double d6 = (double)n3 * (double)(i % n) / (double)n;
                if (0 == i) {
                    d6 -= 1.0;
                    d3 -= 1.0;
                } else if (n == i) {
                    d3 = n2 - 1;
                    d6 = n3 - 1;
                }
                graphics.drawLine((int)d, (int)d6, (int)d2, (int)d6);
                graphics.drawLine((int)d3, (int)d4, (int)d3, (int)d5);
            }
        }
    }

    private void fillCostCell(int n, int n2, int n3, boolean bl, Graphics2D graphics2D, double d, double d2, double d3, double d4) {
        double d5;
        Color color = graphics2D.getColor();
        Color color2 = Color.lightGray;
        if (COST_COLOR_DELIMITER >= 0 && (d5 = this.getComputedCost(n, n2, n3, bl)) > -1.0) {
            color2 = d5 >= (double)COST_COLOR_DELIMITER ? EXPENSIVE_COST_COLOR : CHEAP_COST_COLOR;
        }
        graphics2D.setColor(color2);
        graphics2D.fillRect((int)Math.round(d), (int)Math.round(d2), (int)Math.round(d3), (int)Math.round(d4));
        graphics2D.setColor(color);
    }

    private double fillCostCellValue(int n, int n2, Graphics2D graphics2D, double d, double d2, double d3, double d4) {
        Color color = graphics2D.getColor();
        Color color2 = Color.lightGray;
        double d5 = -1.0;
        if (COST_COLOR_DELIMITER >= 0 && (d5 = this.getComputedCostMoving(n, n2)) > -1.0) {
            color2 = d5 >= (double)COST_COLOR_DELIMITER ? EXPENSIVE_COST_COLOR : CHEAP_COST_COLOR;
        }
        graphics2D.setColor(color2);
        graphics2D.fillRect((int)Math.round(d), (int)Math.round(d2), (int)Math.round(d3), (int)Math.round(d4));
        graphics2D.setColor(color);
        return d5;
    }

    @Override
    public void render(Graphics2D graphics2D, int n, int n2) {
        Font font = this.getPreferences().getFontLegend();
        Font font2 = font.deriveFont(1);
        int n3 = this.getNPerPage();
        int n4 = n;
        int n5 = n2;
        if (!this.isLegend()) {
            if (Axis.X == this.getAxis()) {
                --n4;
            } else {
                --n5;
            }
        } else {
            n3 = 1;
        }
        int n6 = 0;
        if (null != this.getPreferences()) {
            n6 = this.getPreferences().getCostsColsRowsView();
        }
        int n7 = 0;
        if (null != this.getCostsEt()) {
            n7 = this.getCostsEt().getNbCosts();
        }
        int n8 = this.getNViews();
        int n9 = 0;
        if (ConfigManager.getInstance().hasModule(Modules.SITES) && this.getPreferences().isMovingCost() && 1 == (1 & n6)) {
            ++n7;
            n9 = 1;
        }
        if (0 != n8) {
            if (Axis.X == this.getAxis()) {
                for (int i = 0; i < n3; ++i) {
                    String string;
                    double d = (double)n4 * (double)(i % (n3 + 1)) / (double)n3;
                    double d2 = (double)n4 * (double)((i + 1) % (n3 + 1)) / (double)n3;
                    if (n9 > 0) {
                        double d3;
                        double d4;
                        double d5 = 0.0;
                        double d6 = d2 - d;
                        double d7 = (double)n5 / (double)n8;
                        string = (d4 = this.fillCostCellValue(i, -1, graphics2D, d, d5 -= 1.0, d6, d3 = d7 - d5)) > -1.0 ? this.format.format(d4) : this.getLabels().getLabelMovingCost();
                        graphics2D.setFont(font);
                        MyCosts.drawText(graphics2D, (int)d, (int)d5, (int)d6, (int)d3, string, string, this, this.getPreferences().getFontLegendColor());
                    }
                    for (int j = n9; j < n8; ++j) {
                        double d8 = (double)n5 * (double)(j % (n8 + 1)) / (double)n8;
                        double d9 = (double)n5 * (double)((j + 1) % (n8 + 1)) / (double)n8;
                        if (0 == j) {
                            d8 -= 1.0;
                        }
                        double d10 = d2 - d;
                        double d11 = d9 - d8;
                        boolean bl = j >= n7 || 1 != (1 & n6);
                        this.fillCostCell(i, -1, j - n9, bl, graphics2D, d, d8, d10, d11);
                        string = this.getData(i, -1, j - n9, bl, this.getPreferences().isMovingCost());
                        graphics2D.setFont(bl ? font2 : font);
                        MyCosts.drawText(graphics2D, (int)d, (int)d8, (int)d10, (int)d11, string, string, this, this.getPreferences().getFontLegendColor());
                    }
                }
                graphics2D.drawRect(0, -1, n4, n5);
                MyCosts.drawColsRowsLines(graphics2D, Axis.X, n4, n5, n3, this.isLegend());
                MyCosts.drawCostsLines(graphics2D, Axis.X, n8, n4, n5);
            } else if (Axis.Y == this.getAxis()) {
                for (int i = 0; i < n3; ++i) {
                    double d;
                    double d12;
                    double d13 = (double)n5 * (double)(i % (n3 + 1)) / (double)n3;
                    double d14 = (double)n5 * (double)((i + 1) % (n3 + 1)) / (double)n3;
                    double d15 = 0.0;
                    double d16 = (double)n4 / (double)n8;
                    double d17 = d14 - d13;
                    String string = (d12 = this.fillCostCellValue(-1, i, graphics2D, d15 -= 1.0, d13, d = d16 - d15, d17)) > -1.0 ? this.format.format(d12) : this.getLabels().getLabelMovingCost();
                    graphics2D.setFont(font);
                    MyCosts.drawText(graphics2D, (int)d15, (int)d13, (int)d, (int)d17, string, string, this, this.getPreferences().getFontLegendColor());
                    for (int j = n9; j < n8; ++j) {
                        d15 = (double)n4 * (double)(j % (n8 + 1)) / (double)n8;
                        d16 = (double)n4 * (double)((j + 1) % (n8 + 1)) / (double)n8;
                        if (0 == j) {
                            d15 -= 1.0;
                        }
                        d = d16 - d15;
                        d17 = d14 - d13;
                        boolean bl = j >= n7 || 1 != (1 & n6);
                        this.fillCostCell(-1, i, j - n9, bl, graphics2D, d15, d13, d, d17);
                        string = this.getData(-1, i, j - n9, bl, this.getPreferences().isMovingCost());
                        graphics2D.setFont(bl ? font2 : font);
                        MyCosts.drawText(graphics2D, (int)d15, (int)d13, (int)d, (int)d17, string, string, this, this.getPreferences().getFontLegendColor());
                    }
                }
                graphics2D.drawRect(-1, 0, n4, n5);
                MyCosts.drawColsRowsLines(graphics2D, Axis.Y, n4, n5, n3, this.isLegend());
                MyCosts.drawCostsLines(graphics2D, Axis.Y, n8, n4, n5);
            } else if (Axis.INTERSECT == this.getAxis()) {
                ++n5;
                for (int i = 0; i < n8; ++i) {
                    int n10 = i;
                    double d = (double)n5 * (double)(n10 % (n8 + 1)) / (double)n8;
                    double d18 = (double)n5 * (double)((n10 + 1) % (n8 + 1)) / (double)n8;
                    double d19 = (double)n4 * (double)(n10 % (n8 + 1)) / (double)n8;
                    double d20 = (double)n4 * (double)((n10 + 1) % (n8 + 1)) / (double)n8;
                    if (0 == n10) {
                        d19 -= 1.0;
                        d -= 1.0;
                    }
                    double d21 = d20 - d19;
                    double d22 = d18 - d;
                    boolean bl = n10 >= n7 || 1 != (1 & n6);
                    this.fillCostCell(-1, -1, n10, bl, graphics2D, d19, d, d21, d22);
                    String string = this.getData(-1, -1, n10, bl, this.getPreferences().isMovingCost());
                    graphics2D.setFont(bl ? font2 : font);
                    MyCosts.drawText(graphics2D, (int)d19, (int)d, (int)d21, (int)d22, string, string, this, this.getPreferences().getFontLegendColor());
                }
                MyCosts.drawCostsLines(graphics2D, Axis.INTERSECT, n8, n4, n5);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.showLoad && (Axis.Y == this.getAxis() || Axis.INTERSECT == this.getAxis())) {
            return new Dimension(0, 0);
        }
        if (this.isLegend()) {
            return this.getParent().getSize();
        }
        Dimension dimension = new Dimension(0, 0);
        if (null != this.getParent()) {
            dimension = this.getParent().getSize();
        }
        int n = dimension.width;
        int n2 = dimension.height;
        if (Axis.X == this.getAxis()) {
            return new Dimension(n, this.getDim());
        }
        if (Axis.Y == this.getAxis()) {
            return new Dimension(this.getDim(), n2);
        }
        return new Dimension(this.getDimWidth(), this.getDimHeight());
    }
}

