/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.timetable;

import com.adesoft.timetable.AbstractLegend;
import com.adesoft.timetable.Axis;
import com.adesoft.timetable.EtGrid;
import com.adesoft.timetable.Header;
import com.adesoft.timetable.HeaderDay;
import com.adesoft.timetable.HeaderWeek;
import com.adesoft.timetable.PainterHisto;
import com.adesoft.timetable.Preferences;
import com.adesoft.timetable.TimetableLabels;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashSet;

public final class MyLegend
extends AbstractLegend {
    private static final long serialVersionUID = 520L;
    private static final int DEFAULT_WIDTH_LEGEND = 50;
    private static final int DEFAULT_HEIGHT_LEGEND = 19;
    private int step;
    private boolean drawSlotInMiddle;
    private int boldStep = 0;
    private boolean acceptBoldToEachStep = false;
    private HashSet<Integer> boldCoords = new HashSet();
    private int highlightSlot = -1;
    private int highlightRow = -1;
    private int loadMaximum = -1;
    private int[] labelsMaxSize;
    private final TimetableLabels labels;

    public MyLegend(Axis axis, TimetableLabels timetableLabels) {
        super(axis);
        this.labels = timetableLabels;
    }

    private TimetableLabels getLabels() {
        return this.labels;
    }

    public void clearHighlight() {
        this.highlightSlot = -1;
        this.highlightRow = -1;
    }

    private boolean isRow(Header header, int n) {
        Header header2 = header.getRoot();
        Header header3 = header2.getLeaf(n);
        return header.isFatherOf(header3);
    }

    public int drawHeader(Graphics2D graphics2D, int n, int n2, Header header, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        int n10;
        int n11 = this.getNPerPage();
        int n12 = header.getSize();
        if (n7 == 0) {
            this.clearBooldCoords();
        }
        boolean bl = false;
        if (n7 == 1 && this.getPreferences().isDisplay(0x20000000)) {
            n10 = header.getSizeRecursive(this, this.getAxis(), this.getPreferences());
            this.setBoldStep(n10);
            if (n10 > 1 || n10 == 1 && this.acceptBoldToEachStep()) {
                bl = true;
            }
        }
        n10 = 0;
        for (n9 = 0; n9 < n12; ++n9) {
            n10 += this.drawHeader(graphics2D, n + n10, n2 + (header.isVisible() ? 1 : 0), header.getSonAt(n9), n3, n4, n5, n6, n7 + 1, n9);
        }
        if (null == header.getFather()) {
            return -1;
        }
        n9 = header.getLeafCount();
        if (0 == n9) {
            n9 = 1;
        }
        int n13 = n9;
        if (n + n9 > 0 && n < n11) {
            int n14;
            double d;
            double d2;
            double d3;
            double d4;
            int n15 = n;
            if (n15 < 0) {
                n9 += n15;
                n15 = 0;
            }
            if (n15 + n9 > n11) {
                n9 = n11 - n15;
            }
            double d5 = n5;
            double d6 = n6;
            if (Axis.X == this.getAxis()) {
                d4 = d5 * (double)n15 / (double)n3;
                d3 = d6 * (double)n2 / (double)n4;
                d2 = d6 / (double)n4;
                d = d5 * (double)n9 / (double)n3;
            } else {
                if (null != this.getPreferences() && this.getPreferences().isDisplay(65536)) {
                    d4 = 0.0;
                    for (n14 = 0; n14 < n2; n14 += 1) {
                        d4 += (double)this.labelsMaxSize[n14];
                    }
                    d = this.labelsMaxSize[n2];
                } else {
                    d4 = d5 * (double)n2 / (double)n4;
                    d = d5 / (double)n4;
                }
                d3 = d6 * (double)n15 / (double)n3;
                d2 = d6 * (double)n9 / (double)n3;
            }
            n14 = -1 != this.highlightRow && !header.hasNoSiblingNode() && this.isRow(header, this.highlightRow) ? 1 : 0;
            String string = this.getTitle(graphics2D, header, d);
            String string2 = this.getTitle(graphics2D, header, 2.147483647E9);
            MyLegend.drawRecAndText(graphics2D, (int)d4, (int)d3, (int)(d4 + d) - (int)d4, (int)(d3 + d2) - (int)d3, string, string2, n14 != 0, this, this.getPreferences().getFontLegendColor(), bl);
            if ((n8 + 1) % n11 != 0 && bl && this.getAxis() == Axis.X) {
                this.addBoldCoord((int)d4);
                if (d4 != 0.0) {
                    graphics2D.fillRect((int)d4, 0, 2, n6);
                }
            }
            if (n8 % n11 != 0 && bl && this.getAxis() == Axis.Y) {
                this.addBoldCoord((int)d3);
                if (d3 != 0.0) {
                    graphics2D.fillRect(0, (int)d3, n5, 2);
                }
            }
        }
        return n13;
    }

    private String getTitle(Graphics2D graphics2D, Header header, double d) {
        if (header instanceof HeaderWeek ? this.getPreferences().isDisplay(0x200000) : header instanceof HeaderDay && this.getPreferences().isDisplay(8192)) {
            return " " + header.getTitle(graphics2D.getFontMetrics(), d) + " ";
        }
        return " " + header.getTitle() + " ";
    }

    @Override
    public int getDimWidth() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDimHeight() {
        throw new UnsupportedOperationException();
    }

    private int getNeededWidth() {
        int n = 0;
        int n2 = this.getMaxSizeTable().length;
        for (int i = 0; i < n2; ++i) {
            n += this.getMaxSize(i);
        }
        return n;
    }

    private int getMaxSize(int n) {
        return this.getMaxSizeTable()[n];
    }

    private int[] getMaxSizeTable() {
        return this.labelsMaxSize;
    }

    private void fillHeaderSonsMaxSize(Graphics2D graphics2D) {
        if (null == this.getRoot()) {
            this.labelsMaxSize = new int[0];
        } else {
            this.labelsMaxSize = new int[this.getRoot().getHeight() - 1];
            this.fillHeaderSonsMaxSize(graphics2D, this.getRoot(), this.labelsMaxSize, -1);
        }
    }

    private void fillHeaderSonsMaxSize(Graphics2D graphics2D, Header header, int[] nArray, int n) {
        if (null != header) {
            int n2;
            if (null != header.getFather()) {
                n2 = this.getWidth(graphics2D, this.getTitle(graphics2D, header, 2.147483647E9));
                nArray[n] = Math.max(nArray[n], n2);
            }
            for (n2 = 0; n2 < header.getSize(); ++n2) {
                Header header2 = header.getSonAt(n2);
                this.fillHeaderSonsMaxSize(graphics2D, header2, nArray, n + 1);
            }
        }
    }

    public int getDim(Graphics2D graphics2D, int n) {
        Preferences preferences = this.getPreferences();
        int n2 = 0;
        if (null != this.getRoot()) {
            if (Axis.X == this.getAxis()) {
                n2 = 19 * (this.getRoot().getHeight() - 1);
                if (null != preferences && !preferences.isPortrait() && preferences.isDisplay(0x100000)) {
                    n2 += 19;
                }
            } else {
                n2 = null != preferences && preferences.isDisplay(65536) ? (n2 += this.getNeededWidth()) : 50 * (this.getRoot().getHeight() - 1);
                if (null != preferences && preferences.isPortrait() && preferences.isDisplay(0x100000)) {
                    n2 += this.getWidthHoursY(n, graphics2D);
                }
            }
        }
        return n2;
    }

    @Override
    public void setData(Graphics2D graphics2D, EtGrid etGrid, Preferences preferences) {
        super.setData(graphics2D, etGrid, preferences);
        if (this.getAxis() == Axis.Y) {
            this.fillHeaderSonsMaxSize(graphics2D);
        }
        this.highlightSlot = -1;
        this.highlightRow = -1;
    }

    public void setDrawSlotInMiddle(boolean bl) {
        this.drawSlotInMiddle = bl;
    }

    public void setLoadMaximum(int n) {
        this.loadMaximum = n;
    }

    public void setStep(int n) {
        this.step = n;
    }

    public void setBoldStep(int n) {
        this.boldStep = n;
    }

    public void setAcceptToEachStep(boolean bl) {
        this.acceptBoldToEachStep = bl;
    }

    public int getBoldStep() {
        return this.boldStep;
    }

    public boolean acceptBoldToEachStep() {
        return this.acceptBoldToEachStep;
    }

    public HashSet<Integer> getBoldCoords() {
        return this.boldCoords;
    }

    public void clearBooldCoords() {
        this.boldCoords.clear();
    }

    public void addBoldCoord(int n) {
        if (n > 0) {
            this.boldCoords.add(n);
        }
    }

    public void highlight(int n, int n2) {
        this.highlightSlot = n;
        this.highlightRow = n2;
    }

    public void highlightAndRepaint(int n, int n2) {
        if (this.highlightSlot != n || this.highlightRow != n2) {
            this.highlightSlot = n;
            this.highlightRow = n2;
            this.repaint();
        }
    }

    @Override
    public void render(Graphics2D graphics2D, int n, int n2) {
        int n3;
        int n4;
        block39: {
            boolean bl;
            AffineTransform affineTransform;
            block41: {
                int n5;
                Font font;
                int n6;
                block40: {
                    double d;
                    int n7;
                    TextLayout textLayout;
                    double d2;
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    FontRenderContext fontRenderContext;
                    String[] stringArray;
                    AffineTransform affineTransform2;
                    block42: {
                        TextLayout textLayout2;
                        double d3;
                        int n12;
                        Graphics2D graphics2D2 = graphics2D;
                        graphics2D2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
                        n6 = this.getNPerPage();
                        Header header = this.getRoot();
                        n4 = n;
                        n3 = n2;
                        if (Axis.X == this.getAxis()) {
                            --n4;
                        } else {
                            --n3;
                        }
                        affineTransform = graphics2D.getTransform();
                        affineTransform2 = new AffineTransform(affineTransform);
                        graphics2D.setColor(Color.lightGray);
                        graphics2D.fillRect(0, 0, n4, n3);
                        if (null == this.getPreferences() || null == header) break block39;
                        font = this.getPreferences().getFontLegend();
                        n5 = font.getSize();
                        bl = this.getPreferences().isPortrait();
                        if (!this.getPreferences().hideHours() && this.getPreferences().isDisplay(0x100000)) {
                            if (Axis.X == this.getAxis()) {
                                if (!bl) {
                                    n3 -= 19;
                                }
                            } else if (bl) {
                                n4 -= this.getWidthHoursY(n3, graphics2D);
                            }
                        }
                        if (-1 != this.loadMaximum) break block40;
                        if (0 != n6) {
                            graphics2D.setFont(font);
                            this.drawHeader(graphics2D, 0, -1, header, n6, header.getHeight() - 1, n4, n3, 0, 0);
                        }
                        if (this.getPreferences().hideHours() || !this.getPreferences().isDisplay(0x100000) || null == (stringArray = this.getLabels().getSlotNames())) break block41;
                        fontRenderContext = graphics2D.getFontRenderContext();
                        n11 = stringArray.length - 1;
                        n10 = 0;
                        n9 = n11;
                        if (!this.getPreferences().isDisplay(128) && this.getPreferences().getFirstSlot() != -1) {
                            n10 = this.getPreferences().getFirstSlot();
                            n9 = this.getPreferences().getLastSlot();
                            n11 = n9 - n10;
                        }
                        if (Axis.Y != this.getAxis() || !bl) break block42;
                        float f = (float)n3 / (float)(n6 * n11) * (float)this.step;
                        if (f < (float)n5) {
                            font = font.deriveFont(f);
                        }
                        graphics2D.setColor(this.getPreferences().getFontLegendColor());
                        int n13 = this.getWidthHoursY(n3, graphics2D);
                        for (n12 = 0; n12 < n6; ++n12) {
                            double d4 = (double)n3 / (double)n6;
                            d3 = (double)n3 * (double)(n12 % n6) / (double)n6;
                            if (this.getBoldCoords().contains((int)d3)) {
                                graphics2D.fillRect(n4, (int)d3, n13, 2);
                            }
                            graphics2D.drawLine(n4, (int)d3, n4 + n13, (int)d3);
                            graphics2D.setColor(this.getPreferences().getFontLegendColor());
                            for (int i = this.step + n10; i < n9; i += this.step) {
                                double d5 = d3 + d4 * (double)(i - n10) / (double)(n9 - n10);
                                graphics2D.drawLine(n4 + n13 - 5, (int)d5, n4 + n13 - 2, (int)d5);
                                String string = stringArray[i];
                                if (null == string || 0 == string.length()) continue;
                                textLayout2 = new TextLayout(string, font, fontRenderContext);
                                double d6 = textLayout2.getAdvance();
                                textLayout2.draw(graphics2D, (int)((double)(n4 + n13 - 4) - d6), (int)d5 + 3);
                            }
                        }
                        if (this.highlightRow < 0 || this.highlightSlot < 0) break block41;
                        n12 = this.highlightRow;
                        int n14 = this.highlightSlot;
                        String string = stringArray[n14];
                        if (null == string) break block41;
                        d3 = (double)n3 / (double)n6;
                        double d7 = (double)n3 * (double)(n12 % n6) / (double)n6;
                        double d8 = d7 + d3 * (double)(n14 - n10) / (double)n11;
                        if (0 == string.length()) {
                            string = "-";
                        }
                        textLayout2 = new TextLayout(string, font, fontRenderContext);
                        Rectangle2D rectangle2D = textLayout2.getBounds();
                        int n15 = (int)rectangle2D.getHeight();
                        int n16 = (int)textLayout2.getAdvance();
                        graphics2D.setColor(COLOR_HIGHLIGHT);
                        int n17 = (int)(d8 - (double)n15);
                        if (n17 < 2) {
                            n17 = 2;
                        } else if (n17 + n15 + 6 + 1 > n3) {
                            n17 = n3 - n15 - 6 - 1;
                        }
                        graphics2D.fillRect(n4 + 1, n17, n13 - 1, n15 + 6);
                        graphics2D.setColor(Color.black);
                        graphics2D.drawLine(n4 + n13 - 5, (int)d8, n4 + n13 - 2, (int)d8);
                        textLayout2.draw(graphics2D, n4 + n13 - 4 - n16, n17 + n15 + 3);
                        break block41;
                    }
                    if (Axis.X != this.getAxis() || bl) break block41;
                    for (n8 = 0; n8 < n6; ++n8) {
                        double d9 = (double)n4 / (double)n6;
                        d2 = (double)n4 * (double)(n8 % n6) / (double)n6;
                        if (this.getBoldCoords().contains((int)d2)) {
                            graphics2D.fillRect((int)d2, n3, 2, n3 + 19);
                        }
                        graphics2D.drawLine((int)d2, n3, (int)d2, n3 + 19);
                        graphics2D.setColor(this.getPreferences().getFontLegendColor());
                        for (int i = n10; i < n9; i += this.step) {
                            String string;
                            double d10 = d2 + d9 * (double)(i - n10) / (double)(n9 - n10);
                            if (this.drawSlotInMiddle) {
                                d10 += d9 / (double)n11 / 2.0;
                            }
                            if (null != (string = stringArray[i]) && 0 != string.length()) {
                                double d11;
                                graphics2D.drawLine((int)d10, n3 + 12, (int)d10, n3 + 19);
                                textLayout = new TextLayout(string, font, fontRenderContext);
                                n7 = 1;
                                if (!this.drawSlotInMiddle) {
                                    for (int j = i + 1; j < stringArray.length && (null == stringArray[j] || 0 == stringArray[j].length()); ++j) {
                                        ++n7;
                                    }
                                }
                                if ((d = (double)textLayout.getAdvance()) > (d11 = d9 * (double)this.step * (double)n7 / (double)n11 - 4.0)) {
                                    double d12 = d11 / d;
                                    if (!(d11 > 10.0) || !(d12 > 0.0) || !(d * d12 > 10.0)) continue;
                                    if (this.drawSlotInMiddle) {
                                        d10 -= d * d12 / 2.0;
                                    }
                                    graphics2D.scale(d12, 1.0);
                                    textLayout.draw(graphics2D, (int)((d10 + 2.0) / d12), n3 + 11);
                                    graphics2D.setTransform(affineTransform2);
                                    continue;
                                }
                                if (this.drawSlotInMiddle) {
                                    d10 -= d / 2.0;
                                }
                                textLayout.draw(graphics2D, (int)d10 + 2, n3 + 11);
                                continue;
                            }
                            graphics2D.drawLine((int)d10, n3 + 16, (int)d10, n3 + 19);
                        }
                    }
                    if (this.highlightRow < 0 || this.highlightSlot < 0 || this.drawSlotInMiddle && this.highlightSlot >= n11) break block41;
                    n8 = this.highlightRow;
                    int n18 = this.highlightSlot;
                    String string = stringArray[n18];
                    if (null == string) break block41;
                    d2 = (double)n4 / (double)n6;
                    double d13 = (double)n4 * (double)(n8 % n6) / (double)n6;
                    double d14 = d13 + d2 * (double)(n18 - n10) / (double)n11;
                    if (this.drawSlotInMiddle) {
                        d14 += d2 / (double)n11 / 2.0;
                    }
                    if (0 == string.length()) {
                        string = " ";
                    }
                    textLayout = new TextLayout(string, font, fontRenderContext);
                    n7 = (int)textLayout.getAdvance();
                    d = d14;
                    if (this.drawSlotInMiddle) {
                        d -= (double)(n7 / 2);
                    }
                    if (d + (double)n7 + 5.0 + 1.0 > (double)n4) {
                        d = n4 - n7 - 5 - 1;
                    }
                    graphics2D.setColor(COLOR_HIGHLIGHT);
                    graphics2D.fillRect((int)d, n3 + 1, n7 + 5, 18);
                    graphics2D.setColor(Color.black);
                    graphics2D.drawLine((int)d14, n3 + 12, (int)d14, n3 + 19);
                    textLayout.draw(graphics2D, (int)(d + 2.0), n3 + 11);
                    break block41;
                }
                if (0 != this.loadMaximum) {
                    graphics2D.setFont(font);
                    FontMetrics fontMetrics = graphics2D.getFontMetrics();
                    for (int i = 0; i < n6; ++i) {
                        int n19;
                        graphics2D.setColor(this.getPreferences().getFontLegendColor());
                        for (int j = n19 = PainterHisto.getStep(this.loadMaximum, n3); j <= this.loadMaximum; j += n19) {
                            double d = n3 * (this.loadMaximum - j) / this.loadMaximum;
                            graphics2D.drawLine(n4 - 5, (int)d, n4, (int)d);
                            String string = Integer.toString(j);
                            if (null == string || 0 == string.length()) continue;
                            int n20 = fontMetrics.stringWidth(string);
                            graphics2D.drawString(string, n4 - 7 - n20, (int)d + n5);
                        }
                    }
                }
            }
            if (!this.getPreferences().hideHours() && this.getPreferences().isDisplay(0x100000)) {
                if (Axis.X == this.getAxis()) {
                    if (!bl) {
                        n3 += 19;
                    }
                } else if (bl) {
                    n4 += this.getWidthHoursY(n3, graphics2D);
                }
            }
            graphics2D.setTransform(affineTransform);
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(0, 0, n4, n3);
    }

    private int getWidthHoursY(int n, Graphics2D graphics2D) {
        Font font;
        int n2;
        float f;
        int n3 = this.getNPerPage();
        String[] stringArray = this.getLabels().getSlotNames();
        if (null == stringArray) {
            return 0;
        }
        double d = 0.0;
        int n4 = stringArray.length - 1;
        if (!this.getPreferences().isDisplay(128) && this.getPreferences().getFirstSlot() != -1) {
            n4 = this.getPreferences().getLastSlot() - this.getPreferences().getFirstSlot();
        }
        if ((f = (float)n / (float)(n3 * n4) * (float)this.step) < (float)(n2 = (font = this.getPreferences().getFontLegend()).getSize())) {
            font = font.deriveFont(f);
        }
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        for (int i = this.step; i < n4; i += this.step) {
            TextLayout textLayout;
            double d2;
            String string = stringArray[i];
            if (null == string || 0 == string.length() || !((d2 = (double)(textLayout = new TextLayout(string, font, fontRenderContext)).getAdvance()) > d)) continue;
            d = d2;
        }
        return (int)d + 10;
    }

    @Override
    public Dimension getPreferredSize() {
        Graphics2D graphics2D = (Graphics2D)new BufferedImage(1, 1, 1).getGraphics();
        Dimension dimension = new Dimension(0, 0);
        if (null != this.getParent()) {
            dimension = this.getParent().getSize();
        }
        int n = dimension.width;
        int n2 = dimension.height;
        Dimension dimension2 = Axis.X == this.getAxis() ? new Dimension(n, this.getDim(graphics2D, n)) : new Dimension(this.getDim(graphics2D, n2), n2);
        return dimension2;
    }
}

