/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.timetable;

import com.adesoft.log.Category;
import com.adesoft.timetable.CaseEt;
import com.adesoft.timetable.Column;
import com.adesoft.timetable.ColumnInfo;
import com.adesoft.timetable.TempEvent;
import java.util.Collection;

public class NonEmptyColumn
implements Column {
    private static final Category LOG = Category.getInstance((String)"com.adesoft.timetable.NonEmptyColumn");
    private static int nextId;
    private final int id;
    private final ColumnInfo info;
    private final TempEvent[] xmlEvents;
    private int mode;
    private int nbSlots;
    private CaseEt[] table;
    private boolean[] timeframe;
    private boolean used = true;
    private int[] usedQuantity;
    private int maxQuantity;

    public NonEmptyColumn(ColumnInfo columnInfo, TempEvent[] tempEventArray, int n, int n2) {
        this.info = columnInfo;
        this.nbSlots = n2;
        this.mode = n;
        this.id = nextId++;
        this.xmlEvents = tempEventArray;
        this.timeframe = new boolean[0];
    }

    @Override
    public TempEvent[] getXmlEvents() {
        return this.xmlEvents;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof NonEmptyColumn) {
            return ((NonEmptyColumn)object).id == this.id;
        }
        return false;
    }

    public ColumnInfo getInfo() {
        return this.info;
    }

    @Override
    public int getFirstYear() {
        return this.getInfo().getFirstYear();
    }

    @Override
    public int getFirstMonthYear() {
        return this.getInfo().getFirstMonthYear();
    }

    @Override
    public int[] getWeeks() {
        return this.getInfo().getWeeks();
    }

    @Override
    public int getFirstWeek() {
        return this.getInfo().getFirstWeek();
    }

    @Override
    public String getWeekName() {
        return this.getInfo().getWeekNames();
    }

    @Override
    public int getFirstDay() {
        return this.getInfo().getFirstDay();
    }

    @Override
    public int[] getDays() {
        return this.getInfo().getDays();
    }

    @Override
    public String getDayName() {
        return this.getInfo().getDayNames();
    }

    @Override
    public int[] getEntityOids() {
        return this.getInfo().getEntities();
    }

    @Override
    public int[] getEntityIds() {
        return this.getInfo().getEntityIds();
    }

    @Override
    public String getEntityName() {
        return this.getInfo().getEntityNames();
    }

    @Override
    public boolean contains(int n) {
        for (int i = 0; i < this.xmlEvents.length; ++i) {
            if (n != this.xmlEvents[i].getOid()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CaseEt getFirstEvent(int n) {
        if (null == this.table || n < 0 || n >= this.table.length) {
            return null;
        }
        return this.table[n];
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public int getNbEvents() {
        return this.xmlEvents.length;
    }

    @Override
    public int getNbSlots() {
        return this.nbSlots;
    }

    @Override
    public void reorganize() {
        int n = this.xmlEvents.length;
        if (n > 0) {
            this.table = new CaseEt[this.nbSlots];
            for (int i = 0; i < n; ++i) {
                TempEvent tempEvent = this.xmlEvents[i];
                int n2 = tempEvent.getSlot();
                int n3 = n2 + tempEvent.getDuration();
                boolean bl = false;
                try {
                    if (n3 <= this.nbSlots) {
                        for (int j = n2; j < n3; ++j) {
                            this.table[j] = new CaseEt(tempEvent, n2, this.table[j]);
                        }
                    } else {
                        bl = true;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    bl = true;
                }
                if (!bl) continue;
                LOG.error((Object)("Event " + tempEvent.getOid() + " is out of slots (" + n3 + " > nbSlots[" + this.nbSlots + "])"));
            }
        }
    }

    @Override
    public final void update() {
        CaseEt.setSize(this.table);
    }

    @Override
    public boolean[] getTimeframe() {
        return this.timeframe;
    }

    @Override
    public void setTimeframe(boolean[] blArray) {
        this.timeframe = blArray;
    }

    @Override
    public void setUsed(boolean bl) {
        this.used = bl;
    }

    @Override
    public boolean isUsed() {
        return this.used;
    }

    @Override
    public void setOccupationInfo(int[] nArray, int n) {
        this.usedQuantity = nArray;
        this.maxQuantity = n;
    }

    @Override
    public int[] getUsedQuantity() {
        return this.usedQuantity;
    }

    @Override
    public int getMaxQuantity() {
        return this.maxQuantity;
    }

    @Override
    public void addEventsTo(Collection collection) {
        if (null != this.table) {
            for (int i = this.table.length - 1; i >= 0; --i) {
                for (CaseEt caseEt = this.getFirstEvent(i); null != caseEt; caseEt = caseEt.next()) {
                    if (null == caseEt.getShape()) continue;
                    collection.add(caseEt);
                }
            }
        }
    }

    @Override
    public CaseEt[] getTable() {
        return this.table;
    }
}

