/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.timetable;

import com.adesoft.arrays.BooleanArray;
import com.adesoft.arrays.IntArray;
import com.adesoft.arrays.StringArray;
import com.adesoft.beans.EventsRectangles;
import com.adesoft.collections.ListUnique;
import com.adesoft.collections.MyHashTable;
import com.adesoft.config.ConfigManager;
import com.adesoft.log.Category;
import com.adesoft.misc.Util;
import com.adesoft.properties.ServerProperty;
import com.adesoft.struct.Field;
import com.adesoft.timetable.Axis;
import com.adesoft.timetable.AxisCategory;
import com.adesoft.timetable.CaseEt;
import com.adesoft.timetable.Column;
import com.adesoft.timetable.ColumnIterator;
import com.adesoft.timetable.EtData;
import com.adesoft.timetable.EtGrid;
import com.adesoft.timetable.EventGrouper;
import com.adesoft.timetable.EventsGroup;
import com.adesoft.timetable.Labels;
import com.adesoft.timetable.Preferences;
import com.adesoft.timetable.Selection;
import com.adesoft.timetable.TempEvent;
import com.adesoft.timetable.TextLayoutInfo;
import com.adesoft.timetable.TimetableLabels;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;

public class PainterEx {
    private static final Category LOG = Category.getInstance((String)"com.adesoft.timetable.PainterEx");
    private static final boolean zoomXY = PainterEx.useZoomXY();
    private static final float[] dash = new float[]{2.0f};
    private static final BasicStroke dashed = new BasicStroke(1.0f, 1, 1, 10.0f, dash, 0.0f);
    private static final Color colorOutOfSelectedPeriods = new Color(220, 220, 220);
    private final TimetableLabels labels;
    private final Preferences pref;
    private final int maxZoom;
    private final boolean groupByGroups;
    private EtGrid etGrid;
    private Selection selectionList;
    private Font plainFont;
    private Font boldFont;
    private double width;
    private double height;
    private final ImageObserver observer;
    private final Image lockPos;
    private final Image lockRes;
    private final Image notUsable;
    private final Image workflow;
    private final Image notes;
    private final Image upEvent;
    private final Image downEvent;
    private final Image leftEvent;
    private final Image rightEvent;
    private final Image exclamation;
    private final Image link;
    private Rectangle selectionRectangle;
    private EventsGroup[] columnsPos;

    PainterEx(ImageObserver imageObserver, Preferences preferences, EtGrid etGrid, Image[] imageArray, TimetableLabels timetableLabels) {
        this.labels = timetableLabels;
        this.pref = preferences;
        this.etGrid = etGrid;
        this.observer = imageObserver;
        if (null != imageArray) {
            this.lockPos = imageArray[0];
            this.lockRes = imageArray[1];
            this.notUsable = imageArray[2];
            this.workflow = imageArray[3];
            this.notes = imageArray[4];
            this.upEvent = imageArray[5];
            this.downEvent = imageArray[6];
            this.leftEvent = imageArray[7];
            this.rightEvent = imageArray[8];
            this.exclamation = imageArray[9];
            this.link = imageArray[10];
        } else {
            this.lockPos = null;
            this.lockRes = null;
            this.notUsable = null;
            this.workflow = null;
            this.notes = null;
            this.upEvent = null;
            this.downEvent = null;
            this.leftEvent = null;
            this.rightEvent = null;
            this.exclamation = null;
            this.link = null;
        }
        this.maxZoom = ConfigManager.getInstance().getIntProperty(ServerProperty.ZOOM_MAX_LEVEL);
        this.groupByGroups = this.getPreferences().isGroupByGroup();
    }

    private static boolean useZoomXY() {
        try {
            return ConfigManager.getInstance().getBooleanProperty(ServerProperty.ZOOM_XY);
        }
        catch (Exception exception) {
            return Boolean.valueOf(ServerProperty.ZOOM_XY.getDefaultValue());
        }
    }

    private TimetableLabels getLabels() {
        return this.labels;
    }

    public void setRectangleSelection(Rectangle rectangle) {
        this.selectionRectangle = rectangle;
    }

    public Selection getSelectionList() {
        if (null == this.selectionList) {
            this.selectionList = new Selection();
        }
        return this.selectionList;
    }

    private final void addLabels(Labels labels, EventsGroup eventsGroup, int n, Field field, boolean bl) {
        if (this.pref.isDisplay(field)) {
            if (!bl) {
                CaseEt caseEt = eventsGroup.getFirstCell();
                labels.addMultiple(caseEt.getLabels(n, field), caseEt.getBolds(field));
            } else {
                CaseEt[] caseEtArray = eventsGroup.getCells();
                StringArray stringArray = new StringArray();
                BooleanArray booleanArray = new BooleanArray();
                for (int i = 0; i < caseEtArray.length; ++i) {
                    Labels._add(stringArray, booleanArray, caseEtArray[i].getLabels(n, field), caseEtArray[i].getBolds(field));
                }
                labels.addMultiple(stringArray, booleanArray);
            }
        }
    }

    private final void addLabels(Labels labels, EventsGroup eventsGroup, boolean bl, boolean bl2) {
        if (!bl) {
            Object[] objectArray;
            CaseEt caseEt = eventsGroup.getFirstCell();
            String string = "";
            boolean bl3 = false;
            String[] stringArray = caseEt.getLabels(bl2);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (null == string2 || !string2.contains("[url")) continue;
                stringArray[i] = string2.substring(string2.indexOf("]") + 1, string2.lastIndexOf("["));
            }
            boolean[] blArray = caseEt.getBolds(bl2);
            boolean bl4 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!"".equals(string)) {
                    string = string + "   ";
                }
                if (null == stringArray[i]) {
                    if (!"".equals(string.trim())) {
                        objectArray = new String[1];
                        objectArray[0] = string.trim();
                        boolean[] blArray2 = new boolean[]{bl3};
                        labels.addMultiple((String[])objectArray, blArray2);
                        string = "";
                        bl3 = false;
                    } else if (bl4) {
                        labels.addEmpty();
                    }
                    bl4 = true;
                    continue;
                }
                string = string + stringArray[i];
                bl3 |= blArray[i];
                bl4 = false;
            }
            if (!"".equals(string.trim())) {
                String[] stringArray2 = new String[]{string.trim()};
                objectArray = new boolean[]{bl3};
                labels.addMultiple(stringArray2, (boolean[])objectArray);
            }
        } else {
            CaseEt[] caseEtArray = eventsGroup.getCells();
            StringArray stringArray = new StringArray();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < caseEtArray.length; ++i) {
                Object[] objectArray;
                String string = "";
                boolean bl5 = false;
                String[] stringArray3 = caseEtArray[i].getLabels(bl2);
                boolean[] blArray = caseEtArray[i].getBolds(bl2);
                for (int j = 0; j < stringArray3.length; ++j) {
                    if (!"".equals(string)) {
                        string = string + "   ";
                    }
                    if (null == stringArray3[j]) {
                        if ("".equals(string.trim())) continue;
                        objectArray = new String[1];
                        objectArray[0] = string.trim();
                        boolean[] blArray3 = new boolean[]{bl5};
                        labels.addMultiple((String[])objectArray, blArray3);
                        string = "";
                        bl5 = false;
                        continue;
                    }
                    if (arrayList.contains(stringArray3[j])) continue;
                    string = string + stringArray3[j];
                    bl5 |= blArray[j];
                    arrayList.add(stringArray3[j]);
                }
                if ("".equals(string.trim())) continue;
                String[] stringArray4 = new String[]{string.trim()};
                objectArray = new boolean[]{bl5};
                labels.addMultiple(stringArray4, (boolean[])objectArray);
            }
            labels.addMultiple(stringArray, null);
        }
    }

    private final void addLabels(Labels labels, CaseEt caseEt, boolean bl) {
        if (!bl) {
            labels.addMultiple(caseEt.getLabels(true), null);
        } else {
            StringArray stringArray = new StringArray();
            for (CaseEt caseEt2 = caseEt; null != caseEt2; caseEt2 = caseEt2.next()) {
                String[] stringArray2 = caseEt2.getLabels(true);
                String string = "";
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (!"".equals(string)) {
                        string = string + "   ";
                    }
                    if (null == stringArray2[i]) {
                        if ("".equals(string.trim())) continue;
                        String[] stringArray3 = new String[]{string};
                        labels.addMultiple(stringArray3, null);
                        string = "";
                        continue;
                    }
                    string = string + stringArray2[i];
                }
                if ("".equals(string.trim())) continue;
                String[] stringArray4 = new String[]{string};
                Labels._add(stringArray, null, stringArray4, null);
            }
            labels.addMultiple(stringArray, null);
        }
    }

    private void drawBackground(Graphics2D graphics2D) {
        graphics2D.setColor(Color.white);
        Rectangle rectangle = graphics2D.getClipBounds();
        if (null != rectangle) {
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            graphics2D.fillRect(0, 0, (int)this.width, (int)this.height);
        }
    }

    private void drawCompatibility(Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        double d;
        double d2;
        EtGrid etGrid = this.getEtGrid();
        if (null == etGrid) {
            return;
        }
        EtData etData = etGrid.getTimetable(n);
        Column column = etData.getColumn(n2);
        int n5 = 0;
        int n6 = column.getNbSlots();
        int n7 = column.getNbSlots();
        if (!this.pref.isDisplay(128) && this.pref.getFirstSlot() != -1) {
            n5 = this.pref.getFirstSlot();
            n6 = this.pref.getLastSlot();
            n7 = n6 - n5;
        }
        double d3 = this.height * (double)(n % n4) / (double)n4;
        double d4 = this.width * (double)n2 / (double)n3;
        double d5 = 0.0;
        double d6 = 0.0;
        if (this.pref.isPortrait()) {
            d2 = this.width / (double)n3;
            d = this.height / (double)n7 / (double)n4;
            d5 = d4;
        } else {
            d2 = this.width / (double)n7 / (double)n3;
            d = this.height / (double)n4;
            d6 = d3;
        }
        try {
            boolean bl3 = !this.pref.isDisplay(256);
            Color color = bl3 ? Color.darkGray : Color.black;
            boolean[] blArray = column.getTimeframe();
            for (int i = n5; i < n6; ++i) {
                boolean bl4 = blArray[i];
                if ((!bl4 || !bl) && (bl4 || !bl2)) continue;
                if (this.pref.isPortrait()) {
                    d6 = d3 + this.height * (double)i / (double)n7 / (double)n4 - this.height * (double)n5 / (double)n7 / (double)n4;
                    if (d6 < d3) {
                        d6 = d3;
                    }
                } else {
                    d5 = d4 + this.width * (double)i / (double)n7 / (double)n3 - this.width * (double)n5 / (double)n7 / (double)n3;
                    if (d5 < d4) {
                        d5 = d4;
                    }
                }
                PainterEx.drawScatter(graphics2D, (int)d5, (int)d6, (int)(d5 + d2) - (int)d5, (int)(d6 + d) - (int)d6, color, false);
            }
        }
        catch (Exception exception) {
            LOG.error((Object)exception);
        }
    }

    private ArrayList groupEvents(EtGrid etGrid, int n, int n2, int n3, int n4) {
        ArrayList<EventsGroup> arrayList;
        block27: {
            int n5;
            EventsGroup eventsGroup;
            int n6;
            boolean bl;
            int n7;
            EventsGroup eventsGroup2;
            Column column;
            int n8;
            int n9;
            EventGrouper eventGrouper;
            block26: {
                boolean bl2;
                arrayList = new ArrayList<EventsGroup>();
                boolean bl3 = bl2 = this.getPreferences().getZoom() < this.maxZoom;
                if (bl2) break block26;
                if (!this.groupByGroups) {
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            Column column2 = etGrid.getTimetable(i).getColumn(j);
                            column2.addEventsTo(arrayList);
                        }
                    }
                } else {
                    Column column3;
                    int n10;
                    int n11;
                    EventGrouper eventGrouper2;
                    ColumnIterator columnIterator = new ColumnIterator();
                    ArrayList arrayList2 = new ArrayList();
                    boolean bl4 = this.getPreferences().isPortrait();
                    boolean bl5 = Axis.X == this.getPreferences().getAxis(AxisCategory.ENTITY);
                    EventGrouper eventGrouper3 = eventGrouper2 = bl4 ? EventGrouper.PORTRAIT : EventGrouper.LANDSCAPE;
                    if (bl5) {
                        for (n11 = 0; n11 < n; ++n11) {
                            for (n10 = 0; n10 < n2; ++n10) {
                                column3 = etGrid.getTimetable(n10).getColumn(n11);
                                columnIterator.reset(column3);
                                eventGrouper2.groupEvents(arrayList2, columnIterator, n3, n4);
                            }
                        }
                    } else {
                        for (n11 = 0; n11 < n2; ++n11) {
                            for (n10 = 0; n10 < n; ++n10) {
                                column3 = etGrid.getTimetable(n11).getColumn(n10);
                                columnIterator.reset(column3);
                                eventGrouper2.groupEvents(arrayList2, columnIterator, n3, n4);
                            }
                        }
                    }
                    eventGrouper2 = !bl5 ? EventGrouper.LANDSCAPE : EventGrouper.PORTRAIT;
                    EventsGroup[] eventsGroupArray = new EventsGroup[arrayList2.size()];
                    arrayList2.toArray(eventsGroupArray);
                    int n12 = eventsGroupArray.length;
                    for (n10 = 0; n10 < n12; ++n10) {
                        EventsGroup eventsGroup3 = eventsGroupArray[n10];
                        if (null == eventsGroup3) continue;
                        int n13 = eventsGroup3.getGroupOid();
                        boolean bl6 = eventsGroup3.isRequest();
                        boolean bl7 = true;
                        for (int i = n10 + 1; i < n12 && bl7; ++i) {
                            int n14;
                            EventsGroup eventsGroup4 = eventsGroupArray[i];
                            if (null == eventsGroup4 || n13 != eventsGroup4.getGroupOid() || bl6 != eventsGroup4.isRequest() || 1 != ((n14 = eventGrouper2.getPrimaryNextToStatus(eventsGroup3.getShape(), eventsGroup4.getShape())) & 1)) continue;
                            if (2 == (n14 & 2)) {
                                eventsGroup3.add(eventsGroup4);
                                eventsGroupArray[i] = null;
                                continue;
                            }
                            bl7 = false;
                        }
                        arrayList.add(eventsGroup3);
                    }
                }
                break block27;
            }
            ColumnIterator columnIterator = new ColumnIterator();
            ArrayList arrayList3 = new ArrayList();
            boolean bl8 = this.getPreferences().isPortrait();
            boolean bl9 = Axis.X == this.getPreferences().getAxis(AxisCategory.ENTITY);
            EventGrouper eventGrouper4 = eventGrouper = bl8 ? EventGrouper.PORTRAIT : EventGrouper.LANDSCAPE;
            if (bl9) {
                for (n9 = 0; n9 < n; ++n9) {
                    for (n8 = 0; n8 < n2; ++n8) {
                        column = etGrid.getTimetable(n8).getColumn(n9);
                        columnIterator.reset(column);
                        eventGrouper.groupEvents(arrayList3, columnIterator, n3, n4);
                    }
                }
            } else {
                for (n9 = 0; n9 < n2; ++n9) {
                    for (n8 = 0; n8 < n; ++n8) {
                        column = etGrid.getTimetable(n9).getColumn(n8);
                        columnIterator.reset(column);
                        eventGrouper.groupEvents(arrayList3, columnIterator, n3, n4);
                    }
                }
            }
            eventGrouper = bl9 ? EventGrouper.LANDSCAPE : EventGrouper.PORTRAIT;
            EventsGroup[] eventsGroupArray = new EventsGroup[arrayList3.size()];
            arrayList3.toArray(eventsGroupArray);
            if (zoomXY) {
                Arrays.sort(eventsGroupArray, eventGrouper.getPrimaryComparator());
            }
            int n15 = eventsGroupArray.length;
            for (n8 = 0; n8 < n15; ++n8) {
                eventsGroup2 = eventsGroupArray[n8];
                if (null == eventsGroup2) continue;
                n7 = eventsGroup2.getGroupOid();
                bl = true;
                for (n6 = n8 + 1; n6 < n15 && bl; ++n6) {
                    eventsGroup = eventsGroupArray[n6];
                    if (null == eventsGroup || n7 != eventsGroup.getGroupOid() || 1 != ((n5 = eventGrouper.getPrimaryNextToStatus(eventsGroup2.getShape(), eventsGroup.getShape())) & 1)) continue;
                    if (2 == (n5 & 2)) {
                        eventsGroup2.add(eventsGroup);
                        eventsGroupArray[n6] = null;
                        continue;
                    }
                    bl = false;
                }
                arrayList.add(eventsGroup2);
            }
            if (!zoomXY) break block27;
            eventsGroupArray = new EventsGroup[arrayList.size()];
            arrayList.toArray(eventsGroupArray);
            Arrays.sort(eventsGroupArray, eventGrouper.getSecondaryComparator());
            arrayList.clear();
            n15 = eventsGroupArray.length;
            for (n8 = 0; n8 < n15; ++n8) {
                eventsGroup2 = eventsGroupArray[n8];
                if (null == eventsGroup2) continue;
                n7 = eventsGroup2.getGroupOid();
                bl = true;
                for (n6 = n8 + 1; n6 < n15 && bl; ++n6) {
                    eventsGroup = eventsGroupArray[n6];
                    if (null == eventsGroup || n7 != eventsGroup.getGroupOid() || 1 != ((n5 = eventGrouper.getSecondaryNextToStatus(eventsGroup2.getShape(), eventsGroup.getShape())) & 1)) continue;
                    if (2 == (n5 & 2)) {
                        eventsGroup2.add(eventsGroup);
                        eventsGroupArray[n6] = null;
                        continue;
                    }
                    bl = false;
                }
                arrayList.add(eventsGroup2);
            }
        }
        return arrayList;
    }

    private void drawData(Graphics2D graphics2D, int n, int n2, boolean bl) {
        EtGrid etGrid = this.getEtGrid();
        if (null == etGrid || 0 == n || 0 == n2) {
            this.getSelectionList().clear();
            return;
        }
        if (this.pref.isDisplay(128)) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    this.drawOccupation(graphics2D, i, j, n, n2);
                }
            }
            return;
        }
        ColumnIterator columnIterator = new ColumnIterator();
        int n3 = etGrid.getTimetable(0).getColumn(0).getNbSlots();
        int n4 = 0;
        int n5 = n3;
        if (!this.pref.isDisplay(128) && this.pref.getFirstSlot() != -1) {
            n4 = this.pref.getFirstSlot();
            n5 = this.pref.getLastSlot();
            n3 = n5 - n4;
        }
        for (int i = 0; i < n2; ++i) {
            EtData etData = etGrid.getTimetable(i);
            for (int j = 0; j < n; ++j) {
                Column column = etData.getColumn(j);
                columnIterator.reset(column);
                int n6 = 0;
                while (columnIterator.hasNext()) {
                    CaseEt caseEt = (CaseEt)columnIterator.next();
                    if (caseEt.getStart() >= n4 && caseEt.getStart() <= n5 || caseEt.getStart() + caseEt.getDuration() >= n4 && caseEt.getStart() + caseEt.getDuration() <= n5 || caseEt.getStart() <= n4 && caseEt.getStart() + caseEt.getDuration() >= n5) {
                        this.setEventBounds(graphics2D, caseEt, j, i, n, n2, n4, n3, n6);
                    }
                    ++n6;
                }
            }
        }
        ArrayList arrayList = this.groupEvents(etGrid, n, n2, n4, n5);
        this.drawGroups(arrayList, graphics2D, bl);
    }

    private void drawEvent(Graphics2D graphics2D, Rectangle rectangle, Color color, Labels labels, LineBreakMeasurer lineBreakMeasurer, boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3;
        Object object;
        int n4;
        int n5;
        boolean bl3 = this.pref.isDisplay(256);
        graphics2D.setColor(bl3 ? Color.white : color);
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (bl2) {
            this.drawRequestHatch(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setColor(bl3 ? Color.black : this.pref.getFontTextColor());
        if (null == labels) {
            return;
        }
        int n6 = rectangle.x;
        int n7 = rectangle.y;
        int n8 = rectangle.width;
        int n9 = rectangle.height;
        boolean bl4 = 2 == this.pref.getOrientation();
        boolean bl5 = 1 == this.pref.getOrientation() || bl4 && n9 > n8;
        int n10 = this.pref.getVerticalPadding() + this.pref.getVerticalInterline();
        int n11 = this.pref.getVerticalInterline();
        double d = 0.0;
        if (graphics2D.getStroke() instanceof BasicStroke) {
            d = ((BasicStroke)graphics2D.getStroke()).getLineWidth();
        }
        double d2 = (double)(n11 < 4 ? (bl ? 3 : 4) : n11) * d;
        double d3 = 8.0 * d;
        double d4 = bl5 ? (double)n9 : (double)n8;
        int n12 = Math.max(n8, n9);
        int n13 = 0;
        int n14 = 0;
        int n15 = n11 + this.getPreferences().getFontText().getSize();
        StringArray stringArray = labels.getLabels();
        if (this.pref.isDisplay(0x1000000)) {
            labels = this.recalculateLayouts(graphics2D, labels, lineBreakMeasurer, d4, d3);
            stringArray = labels.getLabels();
            lineBreakMeasurer.setPosition(0);
        }
        if (d4 >= d3) {
            n5 = stringArray.size() - 1;
            for (n4 = 0; n4 < n5 && !((double)(n13 += null == (object = stringArray.get(n4)) ? n10 : n15) > (double)n12 - d2); ++n4) {
                if (null == object) continue;
                n14 = n4 + 1;
            }
        }
        n5 = bl5 && bl4 ? 1 : 0;
        n4 = stringArray.size();
        object = new TextLayoutInfo[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = labels.next();
            if ((n3 < n14 || n5 != 0) && n2 != lineBreakMeasurer.getPosition()) {
                try {
                    TextLayout textLayout = lineBreakMeasurer.nextLayout((float)(d4 - d3), n2, false);
                    object[n3] = new TextLayoutInfo(textLayout);
                    if (n5 != 0 && object[n3].getWidth() > (double)n8 - d3) {
                        n5 = 0;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LOG.error((Object)illegalArgumentException);
                }
            }
            if (n2 < 0) continue;
            lineBreakMeasurer.setPosition(n2);
        }
        if (n14 <= 0) {
            return;
        }
        if (n5 != 0) {
            bl5 = false;
        }
        n12 = bl5 ? n8 : n9;
        n13 = 0;
        n14 = 0;
        n3 = 0;
        n2 = 0;
        for (n = 0; n < n4; ++n) {
            String string = stringArray.get(n);
            if (null == string) {
                n13 += n10;
                if (n2 != 0) {
                    n13 += n15;
                }
                n2 = 1;
            } else {
                n13 += n15;
                n2 = 0;
            }
            if (n13 > n12 - n11) break;
            if (null == string) continue;
            n3 = n13;
            n14 = n + 1;
        }
        if (n14 <= 0) {
            return;
        }
        n3 -= n11;
        n = this.getPreferences().getAlignement();
        if (bl5) {
            double d5 = (double)n6 + 4.0 * d + (double)((n8 - n3 + n15) / 2);
            int n16 = n7 + n9;
            double d6 = this.getHeight();
            AffineTransform affineTransform = graphics2D.getTransform();
            AffineTransform affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.translate(0.0, d6);
            affineTransform2.rotate(-1.5707963267948966);
            for (int i = 0; i < n14; ++i) {
                TextLayoutInfo textLayoutInfo = object[i];
                if (null != textLayoutInfo) {
                    double d7;
                    TextLayout textLayout = textLayoutInfo.getLayout();
                    double d8 = textLayoutInfo.getWidth();
                    switch (n) {
                        case 0: {
                            d7 = d6 - (double)n16;
                            break;
                        }
                        case 2: {
                            d7 = d6 - ((double)(n16 - n9) + d8 + 4.0 * d);
                            break;
                        }
                        default: {
                            d7 = d6 - ((double)n16 - ((double)n9 - d8) / 2.0);
                        }
                    }
                    graphics2D.setTransform(affineTransform2);
                    textLayout.draw(graphics2D, (float)d7, (float)d5);
                    graphics2D.setTransform(affineTransform);
                    d5 += (double)n15;
                    continue;
                }
                d5 += (double)n10;
            }
        } else {
            double d9 = (double)n7 + d2 + (double)((n9 - n3 + n15) / 2);
            for (int i = 0; i < n14; ++i) {
                TextLayoutInfo textLayoutInfo = object[i];
                if (null != textLayoutInfo) {
                    double d10;
                    TextLayout textLayout = textLayoutInfo.getLayout();
                    double d11 = textLayoutInfo.getWidth();
                    switch (n) {
                        case 0: {
                            d10 = 3.0 * d + (double)n6;
                            break;
                        }
                        case 2: {
                            d10 = (double)n6 - d11 + (double)n8 - 1.0;
                            break;
                        }
                        default: {
                            d10 = (double)n6 + ((double)n8 - d11) / 2.0;
                        }
                    }
                    if (null == textLayout) continue;
                    textLayout.draw(graphics2D, (float)d10, (float)d9);
                    continue;
                }
                d9 += (double)n15;
                d9 += (double)n10;
            }
        }
    }

    private void drawRequestHatch(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5 = 5;
        if (!graphics2D.getColor().equals(Color.LIGHT_GRAY)) {
            graphics2D.setColor(Color.LIGHT_GRAY);
        } else {
            graphics2D.setColor(Color.WHITE);
        }
        for (int i = n5; i < n3 + n4; i += 2 * n5) {
            Polygon polygon = new Polygon();
            boolean bl = true;
            if (i < n3) {
                polygon.addPoint(n + i, n2);
            } else {
                polygon.addPoint(n + n3, n2 + i - n3);
                bl = false;
            }
            boolean bl2 = false;
            if (i + n5 < n3) {
                polygon.addPoint(n + i + n5, n2);
            } else if (i + n5 < n3 + n4) {
                if (bl) {
                    polygon.addPoint(n + n3, n2);
                }
                polygon.addPoint(n + n3, n2 + i + n5 - n3);
            } else {
                polygon.addPoint(n + n3, n2 + n4);
                bl2 = true;
            }
            boolean bl3 = true;
            if (!bl2) {
                if (i + n5 < n4) {
                    bl3 = false;
                    polygon.addPoint(n, n2 + i + n5);
                } else {
                    polygon.addPoint(n + i + n5 - n4, n2 + n4);
                }
            }
            if (i < n4) {
                if (bl3) {
                    polygon.addPoint(n, n2 + n4);
                }
                polygon.addPoint(n, n2 + i);
            } else {
                polygon.addPoint(n + i - n4, n2 + n4);
            }
            graphics2D.fillPolygon(polygon);
        }
    }

    private Labels recalculateLayouts(Graphics2D graphics2D, Labels labels, LineBreakMeasurer lineBreakMeasurer, double d, double d2) {
        int n;
        int n2;
        int n3;
        MyHashTable myHashTable = new MyHashTable();
        StringArray stringArray = labels.getLabels();
        for (int i = 0; i < stringArray.size(); ++i) {
            n3 = labels.next();
            if (n3 != lineBreakMeasurer.getPosition()) {
                try {
                    n2 = lineBreakMeasurer.getPosition();
                    if (d >= d2) {
                        lineBreakMeasurer.nextLayout((float)(d - d2), n3, false);
                        int n4 = lineBreakMeasurer.getPosition();
                        n = n4 - n2;
                        String string = stringArray.get(i);
                        if (string.length() > n) {
                            StringArray stringArray2 = new StringArray();
                            this.getLabelsLines(stringArray2, string, n);
                            myHashTable.put(i, (Object)stringArray2);
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LOG.error((Object)illegalArgumentException);
                }
            }
            if (n3 < 0) continue;
            lineBreakMeasurer.setPosition(n3);
        }
        Labels labels2 = new Labels();
        stringArray = labels.getLabels();
        n3 = 0;
        for (n2 = 0; n2 < stringArray.size(); ++n2) {
            if (null == myHashTable.get(n2)) {
                if (null != stringArray.get(n2)) {
                    labels2.addSingle(stringArray.get(n2), false);
                    n3 = 0;
                    continue;
                }
                if (n3 != 0) {
                    labels2.addEmpty();
                }
                n3 = 1;
                continue;
            }
            StringArray stringArray3 = (StringArray)myHashTable.get(n2);
            for (n = 0; n < stringArray3.size(); ++n) {
                labels2.addSingle(stringArray3.get(n), false);
                n3 = 0;
            }
        }
        return labels2;
    }

    private void getLabelsLines(StringArray stringArray, String string, int n) {
        if (string.length() < n) {
            stringArray.add(string);
        } else {
            String string2 = string.substring(0, n);
            int n2 = string2.lastIndexOf(" ");
            if (-1 != n2) {
                String string3 = string2.substring(0, n2 + 1);
                stringArray.add(string3);
                this.getLabelsLines(stringArray, string.substring(n2 + 1), n);
            } else {
                int n3 = string.indexOf(" ");
                if (-1 != n3) {
                    String string4 = string.substring(0, n3);
                    int n4 = this.getNbSpaceIntoLabel(string4, string);
                    stringArray.add(string.substring(0, n3 + n4));
                    this.getLabelsLines(stringArray, string.substring(n3 + n4), n);
                } else {
                    stringArray.add(string);
                }
            }
        }
    }

    private int getNbSpaceIntoLabel(String string, String string2) {
        int n = 0;
        for (int i = string.length(); i < string2.length() && string2.charAt(i) == ' '; ++i) {
            ++n;
        }
        return n;
    }

    private void drawGroups(List list, Graphics2D graphics2D, boolean bl) {
        boolean bl2 = this.getPreferences().getZoom() < this.maxZoom;
        Rectangle rectangle = graphics2D.getClipBounds();
        if (null != rectangle) {
            rectangle.grow(1, 1);
        }
        EtGrid etGrid = this.getEtGrid();
        String[] stringArray = etGrid.getCostNames();
        HashSet<EventsGroup> hashSet = new HashSet<EventsGroup>();
        int n = list.size();
        this.columnsPos = new EventsGroup[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            EventsGroup eventsGroup;
            this.columnsPos[i] = eventsGroup = (EventsGroup)list.get(i);
            Rectangle rectangle2 = eventsGroup.getShape();
            if (null != rectangle && !rectangle2.intersects(rectangle)) continue;
            LineBreakMeasurer lineBreakMeasurer = null;
            Labels labels = null;
            if (rectangle2.width > 10 || rectangle2.height > 10) {
                n2 = !bl2 ? -1 : eventsGroup.getGroupMode();
                labels = this.generateLabels(eventsGroup, n2, stringArray);
                if (!labels.isEmpty()) {
                    lineBreakMeasurer = labels.getMeasurer(graphics2D.getFontRenderContext(), this.plainFont, this.boldFont);
                } else {
                    labels = null;
                }
            }
            this.drawEvent(graphics2D, rectangle2, eventsGroup.getColor(), labels, lineBreakMeasurer, bl, eventsGroup.isRequest());
            this.drawIcons(graphics2D, rectangle2, eventsGroup.getFirstCell().getEvent());
            if (null == this.getSelectionList()) continue;
            n2 = 0;
            if (this.getSelectionList().containsAllEvents(eventsGroup)) {
                n2 = 1;
            } else if (this.getSelectionList().isGroupSelectedInMoreOids(eventsGroup)) {
                this.getSelectionList().add(eventsGroup);
                n2 = 1;
            }
            if (n2 == 0) continue;
            hashSet.add(eventsGroup);
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(rectangle2.x + 1, rectangle2.y + 1, rectangle2.width - 2, rectangle2.height - 2);
        }
        this.getSelectionList().retainAll(hashSet);
    }

    private void drawFrame(Graphics2D graphics2D, int n, int n2) {
        int n3;
        int n4;
        boolean bl = this.pref.isDisplay(2048);
        boolean bl2 = this.pref.isDisplay(1024);
        boolean bl3 = this.pref.isWeekBeforeDay();
        boolean bl4 = bl3 && 1 == this.pref.getPeriodStyle();
        boolean bl5 = bl3 && 2 == this.pref.getPeriodStyle();
        Axis axis = this.pref.getAxis(AxisCategory.WEEK);
        if (bl || bl2) {
            for (n4 = 0; n4 < n2; ++n4) {
                for (n3 = 0; n3 < n; ++n3) {
                    this.drawCompatibility(graphics2D, n4, n3, n, n2, bl, bl2);
                }
            }
        }
        n4 = 1;
        if (null != this.getEtGrid() && this.pref.isDisplay(16384)) {
            n4 = this.getEtGrid().getGranularity();
            n4 = n4 > 15 ? 1 : 30 / n4;
        }
        graphics2D.setColor(Color.black);
        n3 = -1;
        int n5 = -1;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n6;
                int n7;
                Column column = this.getEtGrid().getTimetable(j).getColumn(i);
                int n8 = column.getFirstMonthYear();
                int n9 = column.getFirstYear();
                double d = this.width * (double)i / (double)n;
                double d2 = this.width / (double)n;
                double d3 = this.height * (double)j / (double)n2;
                double d4 = this.height / (double)n2;
                int n10 = (int)(d + d2) - (int)d;
                int n11 = (int)(d3 + d4) - (int)d3;
                if (!column.isUsed()) {
                    Color color = graphics2D.getColor();
                    graphics2D.setColor(colorOutOfSelectedPeriods);
                    if (axis == Axis.X) {
                        graphics2D.fillRect((int)d + 1, (int)d3, n10, n11);
                    } else {
                        graphics2D.fillRect((int)d, (int)d3 + 1, n10, n11);
                    }
                    graphics2D.setColor(color);
                }
                if (bl4 && n3 != n8 && -1 != n3 || bl5 && n5 != n9 && -1 != n5) {
                    if (axis == Axis.X) {
                        if (0 == j) {
                            graphics2D.drawLine((int)d, 0, (int)d, (int)this.height);
                        }
                    } else if (0 == i) {
                        graphics2D.drawLine(0, (int)d3, (int)this.width, (int)d3);
                    }
                    n3 = n8;
                    n5 = n9;
                } else if (!bl4 && !bl5) {
                    graphics2D.drawRect((int)d, (int)d3, n10, n11);
                }
                n3 = n8;
                n5 = n9;
                if (!this.pref.isDisplay(16384)) continue;
                int n12 = this.getEtGrid().getTimetable(j).getColumn(i).getNbSlots();
                if (!this.pref.isDisplay(128) && this.pref.getFirstSlot() != -1) {
                    n12 = this.pref.getLastSlot() - this.pref.getFirstSlot();
                }
                if (this.pref.isPortrait()) {
                    for (n7 = 0; n7 < n12; n7 += n4) {
                        n6 = (int)(d3 + d4 * (double)n7 / (double)n12);
                        graphics2D.drawLine((int)d, n6, (int)d + n10, n6);
                    }
                    continue;
                }
                for (n7 = 0; n7 < n12; n7 += n4) {
                    n6 = (int)(d + d2 * (double)n7 / (double)n12);
                    graphics2D.drawLine(n6, (int)d3, n6, (int)d3 + n11);
                }
            }
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(0, 0, (int)this.width, (int)this.height);
    }

    private void drawIcons(Graphics graphics, Rectangle rectangle, TempEvent tempEvent) {
        Date date;
        int n;
        if (!tempEvent.isUsable() && null != this.notUsable) {
            if (this.notUsable.getWidth(this.observer) <= rectangle.width - 2 && this.notUsable.getHeight(this.observer) <= rectangle.height - 2) {
                graphics.drawImage(this.notUsable, rectangle.x + 3, rectangle.y + 3, this.observer);
            }
        } else {
            n = 0;
            if (tempEvent.isPositionLock() && null != this.lockPos && this.lockPos.getWidth(this.observer) <= rectangle.width - 2 && this.lockPos.getHeight(this.observer) <= rectangle.height - 2) {
                n = this.lockPos.getWidth(this.observer) + 2;
                graphics.drawImage(this.lockPos, rectangle.x + 3, rectangle.y + 3, this.observer);
            }
            if (tempEvent.isResourceLock() && null != this.lockPos && n + this.lockPos.getWidth(this.observer) <= rectangle.width - 2 && this.lockPos.getHeight(this.observer) <= rectangle.height - 2) {
                graphics.drawImage(this.lockPos, rectangle.x + 3 + n, rectangle.y + 3, this.observer);
            }
            if (tempEvent.isUnactiveKeepResourceLock() && null != this.lockPos && 2 * n + this.lockPos.getWidth(this.observer) <= rectangle.width - 2 && this.lockPos.getHeight(this.observer) <= rectangle.height - 2) {
                graphics.drawImage(this.lockRes, rectangle.x + 3 + 2 * n, rectangle.y + 3, this.observer);
            }
        }
        n = 0;
        int n2 = 0;
        int n3 = 0;
        if (null != this.exclamation && null != (date = tempEvent.getLastUpdate())) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
            calendar.setTime(new Date());
            calendar.add(5, -this.pref.getNbDaysLogs());
            Date date2 = calendar.getTime();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            if (date.after(date2)) {
                int n4 = this.exclamation.getWidth(this.observer);
                int n5 = this.exclamation.getHeight(this.observer);
                if (n4 <= rectangle.width - 2 && n5 <= rectangle.height - 2) {
                    graphics.drawImage(this.exclamation, rectangle.x + 2, rectangle.y + rectangle.height - n5 - 2, this.observer);
                    n2 = n4 + 2;
                }
            }
        }
        if (!this.pref.isDisplay(128) && this.pref.getFirstSlot() != -1) {
            if (this.pref.isPortrait()) {
                if (tempEvent.getSlot() < this.pref.getFirstSlot()) {
                    int n6 = this.upEvent.getWidth(this.observer);
                    int n7 = this.upEvent.getHeight(this.observer);
                    if (n6 <= rectangle.width - 2 && n7 <= rectangle.height - 2) {
                        graphics.drawImage(this.upEvent, rectangle.x + rectangle.width - n6 - 2, rectangle.y + 2, this.observer);
                        n3 = n6 + 2;
                    }
                }
                if (tempEvent.getSlot() + tempEvent.getDuration() > this.pref.getLastSlot()) {
                    int n8 = this.downEvent.getWidth(this.observer);
                    int n9 = this.downEvent.getHeight(this.observer);
                    if (n8 <= rectangle.width - 2 && n9 <= rectangle.height - 2) {
                        graphics.drawImage(this.downEvent, rectangle.x + rectangle.width - n8 - 2, rectangle.y + rectangle.height - n9 - 2, this.observer);
                        n = n8 + 2;
                    }
                }
            } else {
                if (tempEvent.getSlot() < this.pref.getFirstSlot()) {
                    int n10 = this.leftEvent.getWidth(this.observer);
                    int n11 = this.leftEvent.getHeight(this.observer);
                    if (n2 + n10 <= rectangle.width - 2 && n11 <= rectangle.height - 2) {
                        graphics.drawImage(this.leftEvent, rectangle.x + 2 + n2, rectangle.y + rectangle.height - n11 - 2, this.observer);
                    }
                }
                if (tempEvent.getSlot() + tempEvent.getDuration() > this.pref.getLastSlot()) {
                    int n12 = this.rightEvent.getWidth(this.observer);
                    int n13 = this.rightEvent.getHeight(this.observer);
                    if (n12 <= rectangle.width - 2 && n13 <= rectangle.height - 2) {
                        graphics.drawImage(this.rightEvent, rectangle.x + rectangle.width - n12 - 2, rectangle.y + rectangle.height - n13 - 2, this.observer);
                        n = n12 + 2;
                    }
                }
            }
        }
        if ((tempEvent.isNote() || tempEvent.hasEventNote()) && null != this.notes) {
            int n14 = this.notes.getWidth(this.observer);
            int n15 = this.notes.getHeight(this.observer);
            if (n14 <= rectangle.width - 2 && n15 <= rectangle.height - 2) {
                graphics.drawImage(this.notes, rectangle.x + rectangle.width - n14 - n - 2, rectangle.y + rectangle.height - n15 - 2, this.observer);
            }
        }
        if (tempEvent.hasWorkflowPending() && null != this.workflow) {
            int n16 = this.workflow.getWidth(this.observer);
            int n17 = this.workflow.getHeight(this.observer);
            if (n16 <= rectangle.width - 2 && n17 <= rectangle.height - 2) {
                graphics.drawImage(this.workflow, rectangle.x + rectangle.width - n16 - 2 - n3, rectangle.y + 3, this.observer);
                n3 += n16 + 2;
            }
        }
        if (tempEvent.hasStrictLink() && null != this.link) {
            int n18 = this.link.getWidth(this.observer);
            int n19 = this.link.getHeight(this.observer);
            if (n18 <= rectangle.width - 2 && n19 <= rectangle.height - 2) {
                graphics.drawImage(this.link, rectangle.x + rectangle.width - n18 - 2 - n3, rectangle.y + 3, this.observer);
            }
        }
        graphics.setPaintMode();
    }

    private void drawOccupation(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        EtData etData = this.getEtGrid().getTimetable(n);
        Column column = etData.getColumn(n2);
        int n5 = column.getMaxQuantity();
        int[] nArray = column.getUsedQuantity();
        double d = this.height * (double)(n % n4) / (double)n4;
        double d2 = this.width * (double)n2 / (double)n3;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (this.pref.isPortrait()) {
            d5 = this.width / (double)n3;
            d3 = d2;
        } else {
            d6 = this.height / (double)n4;
            d4 = d;
        }
        int n6 = column.getNbSlots();
        int n7 = 0;
        while (n7 < n6) {
            int n8;
            int n9 = -1;
            int n10 = null == nArray ? 0 : nArray[n7];
            for (CaseEt caseEt = column.getFirstEvent(n7); caseEt != null; caseEt = caseEt.next()) {
                n8 = caseEt.getDuration() - (n7 - caseEt.getStart());
                if (n8 >= n9 && -1 != n9) continue;
                n9 = n8;
            }
            if (n9 > 0) {
                Object object;
                int n11 = n7 + n9;
                block2: for (n8 = n7 + 1; n8 < n11; ++n8) {
                    for (object = column.getFirstEvent(n8); object != null; object = ((CaseEt)object).next()) {
                        if (((CaseEt)object).getStart() != n8) continue;
                        n9 = n8 - n7;
                        n8 = n11;
                        continue block2;
                    }
                }
                if (this.pref.isPortrait()) {
                    d4 = d + this.height * (double)n7 / (double)n6 / (double)n4;
                    d6 = this.height * (double)n9 / (double)n6 / (double)n4;
                } else {
                    d3 = d2 + this.width * (double)n7 / (double)n6 / (double)n3;
                    d5 = this.width * (double)n9 / (double)n6 / (double)n3;
                }
                Rectangle rectangle = new Rectangle((int)d3, (int)d4, (int)(d3 + d5) - (int)d3, (int)(d4 + d6) - (int)d4);
                object = n10 <= n5 ? new Color(255, 255 - 255 * n10 / n5, 20) : Color.lightGray;
                Labels labels = new Labels();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(n10);
                stringBuffer.append('/');
                stringBuffer.append(n5);
                labels.addSingle(stringBuffer.toString(), false);
                this.addLabelsOccupation(labels, column.getFirstEvent(n7), true);
                this.oldDrawEvent(graphics2D, rectangle, labels, (Color)object);
                n7 += n9;
                continue;
            }
            ++n7;
        }
    }

    public static final void drawScatter(Graphics graphics, int n, int n2, int n3, int n4, Color color, boolean bl) {
        graphics.setColor(color);
        int n5 = bl ? 4 : 5;
        int n6 = (n + n2) % n5;
        int n7 = n3 + n4 - 1 + n6;
        if (bl) {
            --n3;
        }
        for (int i = n5; i <= n7; i += n5) {
            int n8 = i > n4 + n6 ? i - n4 - n6 : 0;
            int n9 = i > n4 + n6 ? n4 : i - n6;
            int n10 = i > n3 + n6 ? n3 : i - n6;
            int n11 = i > n3 + n6 ? i - n3 - n6 : 0;
            graphics.drawLine(n + n8, n2 + n9, n + n10, n2 + n11);
            if (!bl) continue;
            graphics.drawLine(n + n8 + 1, n2 + n9, n + n10 + 1, n2 + n11);
        }
    }

    public EventsRectangles getAllBounds(int n, int n2) {
        EventsGroup[] eventsGroupArray = this.columnsPos;
        if (null != eventsGroupArray && eventsGroupArray.length > 0) {
            IntArray intArray = new IntArray();
            IntArray intArray2 = new IntArray();
            IntArray intArray3 = new IntArray();
            ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
            for (int i = 0; i < eventsGroupArray.length; ++i) {
                EventsGroup eventsGroup = eventsGroupArray[i];
                CaseEt[] caseEtArray = eventsGroup.getCells();
                if (null == caseEtArray) continue;
                for (int j = 0; j < caseEtArray.length; ++j) {
                    CaseEt caseEt = caseEtArray[j];
                    if (caseEt.isLunch()) continue;
                    Rectangle rectangle = caseEt.getShape();
                    Rectangle rectangle2 = new Rectangle((int)rectangle.getX() + n, (int)rectangle.getY() + n2, (int)rectangle.getWidth(), (int)rectangle.getHeight());
                    arrayList.add(rectangle2);
                    intArray.add(caseEt.getId());
                    intArray2.add(-1);
                    intArray3.add(-1);
                }
            }
            Rectangle[] rectangleArray = new Rectangle[arrayList.size()];
            arrayList.toArray(rectangleArray);
            return new EventsRectangles(rectangleArray, intArray.getValues(), intArray2.getValues(), intArray3.getValues());
        }
        return null;
    }

    public List getAllBounds(EventsGroup eventsGroup, int n, int n2, int n3, int n4) {
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        int n5 = this.columnsPos.length;
        int[] nArray = eventsGroup.getEventsOids();
        for (int i = 0; i < n5; ++i) {
            if (null == this.columnsPos[i]) continue;
            CaseEt[] caseEtArray = this.columnsPos[i].getCells();
            for (int j = 0; j < caseEtArray.length; ++j) {
                if (!Util.paramContained((int)caseEtArray[j].getEventOid(), (int[])nArray)) continue;
                arrayList.add(caseEtArray[j].getShape());
            }
        }
        return arrayList;
    }

    protected EtGrid getEtGrid() {
        return this.etGrid;
    }

    public Rectangle getEventBoundsAt(Point point) {
        EventsGroup[] eventsGroupArray = this.columnsPos;
        if (null != eventsGroupArray) {
            for (int i = 0; i < eventsGroupArray.length; ++i) {
                CaseEt[] caseEtArray;
                if (null == eventsGroupArray[i] || null == (caseEtArray = eventsGroupArray[i].getCells())) continue;
                int n = caseEtArray.length;
                for (int j = 0; j < n; ++j) {
                    if (!caseEtArray[j].getShape().contains(point)) continue;
                    return caseEtArray[j].getShape();
                }
            }
        }
        return null;
    }

    public CaseEt getEventAt2(Point point) {
        EventsGroup[] eventsGroupArray = this.columnsPos;
        if (null != eventsGroupArray) {
            for (int i = 0; i < eventsGroupArray.length; ++i) {
                CaseEt[] caseEtArray = eventsGroupArray[i].getCells();
                int n = caseEtArray.length;
                for (int j = 0; j < n; ++j) {
                    if (!caseEtArray[j].getShape().contains(point)) continue;
                    return caseEtArray[j];
                }
            }
        }
        return null;
    }

    private void setEventBounds(Graphics2D graphics2D, CaseEt caseEt, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5 = this.height * (double)(n2 % n4) / (double)n4;
        double d6 = this.width * (double)n / (double)n3;
        if (!this.getPreferences().hideHours()) {
            int n8 = caseEt.getStart();
            int n9 = caseEt.getDuration();
            if (n8 < n5) {
                n9 -= n5 - n8;
            }
            int n10 = caseEt.getSize();
            int n11 = caseEt.getPos();
            if (this.pref.isPortrait()) {
                double d7 = n6 * n4;
                double d8 = n10 * n3;
                d4 = d6 + this.width * (double)n11 / d8;
                d3 = this.width / d8;
                d2 = d5 + this.height * (double)n8 / d7 - this.height * (double)n5 / d7;
                d = this.height * (double)n9 / d7;
                if (d2 < d5) {
                    d2 = d5;
                }
                if (d2 + d > d5 + this.height / (double)n4) {
                    d = this.height / (double)n4 - d2 + d5;
                }
            } else {
                double d9 = n10 * n4;
                double d10 = n6 * n3;
                d4 = d6 + this.width * (double)n8 / d10 - this.width * (double)n5 / d10;
                d3 = this.width * (double)n9 / d10;
                d2 = d5 + this.height * (double)n11 / d9;
                d = this.height / d9;
                if (d4 < d6) {
                    d4 = d6;
                }
                if (d4 + d3 > d6 + this.width / (double)n3) {
                    d3 = this.width / (double)n3 - d4 + d6;
                }
            }
        } else {
            Column column = this.getEtGrid().getTimetable(n2).getColumn(n);
            if (this.pref.isPortrait()) {
                double d11 = column.getNbEvents() * n4;
                d4 = d6;
                d3 = this.width / (double)n3;
                d2 = d5 + this.height * (double)n7 / d11;
                d = this.height / d11;
            } else {
                double d12 = column.getNbEvents() * n3;
                d4 = d6 + this.width * (double)n7 / d12;
                d3 = this.width / d12;
                d2 = d5;
                d = this.height / (double)n4;
            }
        }
        if (null == caseEt.getShape()) {
            Rectangle rectangle = new Rectangle((int)d4, (int)d2, (int)(d4 + d3) - (int)d4, (int)(d2 + d) - (int)d2);
            caseEt.setShape(rectangle);
        } else {
            caseEt.getShape().setBounds((int)d4, (int)d2, (int)(d4 + d3) - (int)d4, (int)(d2 + d) - (int)d2);
        }
    }

    public double getHeight() {
        return this.height;
    }

    private void addLabelsOccupation(Labels labels, CaseEt caseEt, boolean bl) {
        if (caseEt.isLunch()) {
            labels.addSingle(this.getLabels().getLabelLunch(), false);
        } else {
            this.addLabels(labels, caseEt, bl);
        }
    }

    private Labels generateLabels(EventsGroup eventsGroup, int n, String[] stringArray) {
        Labels labels = new Labels();
        int n2 = eventsGroup.size();
        if (1 == n2 && eventsGroup.getCell(0).isLunch()) {
            labels.addSingle(this.getLabels().getLabelLunch(), false);
        } else {
            int n3;
            Object object;
            boolean bl = n2 > 1;
            String string = this.getLabels().getLabelFieldSeparator();
            if (2 == n) {
                if (this.pref.isDisplay(Field.NAME)) {
                    if (1 == eventsGroup.size() || !eventsGroup.getFirstCell().getEvent().isRootFolder()) {
                        object = eventsGroup.getFirstCell().getEvent().getFolderName();
                        if (null != object && 0 != ((String)object).length()) {
                            labels.addSingle((String)object, false);
                        } else {
                            this.addLabels(labels, eventsGroup, 9, Field.NAME, bl);
                        }
                    } else {
                        object = new ListUnique();
                        int n4 = eventsGroup.size();
                        for (int i = 0; i < n4; ++i) {
                            CaseEt caseEt = eventsGroup.getCell(i);
                            String string2 = caseEt.getEvent().getFolderName();
                            if (null == string2 || 0 == string2.length()) {
                                String[] stringArray2 = caseEt.getLabels(9, Field.NAME);
                                for (int j = 0; j < stringArray2.length; ++j) {
                                    object.add((Object)stringArray2[j]);
                                }
                                continue;
                            }
                            object.add((Object)string2);
                        }
                        StringBuffer stringBuffer = new StringBuffer();
                        for (n3 = 0; n3 < object.size(); ++n3) {
                            if (0 != stringBuffer.length()) {
                                stringBuffer.append(", ");
                            }
                            stringBuffer.append(object.get(n3));
                        }
                        labels.addSingle(stringBuffer.toString(), false);
                    }
                }
                this.addLabels(labels, eventsGroup, bl, false);
            } else {
                this.addLabels(labels, eventsGroup, bl, true);
            }
            if (1 == (this.pref.getCostsCellsView() & 1)) {
                String[] stringArray3;
                object = eventsGroup.getCosts();
                int n5 = object != null ? ((Object)object).length : 0;
                n3 = 0;
                if (this.pref.isMovingCost()) {
                    n3 = 1;
                    stringArray3 = new String[n5 + 1];
                    double d = eventsGroup.getMovingCost();
                    stringArray3[0] = d == (double)((int)d) ? this.getLabels().getLabelMovingCost() + string + Integer.toString((int)d) : stringArray[0] + string + Double.toString(d);
                } else {
                    stringArray3 = new String[n5];
                }
                if (null != stringArray && object != null && ((Object)object).length > 0) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray3[i + n3] = object[i] == (double)((int)object[i]) ? stringArray[i] + string + Integer.toString((int)object[i]) : stringArray[i] + string + Double.toString((double)object[i]);
                    }
                }
                if (labels != null) {
                    labels.addMultiple(stringArray3, null);
                }
            }
            if (2 == (this.pref.getCostsCellsView() & 2)) {
                double d = eventsGroup.getTotalCost(this.pref.isMovingCost());
                if (d == (double)((int)d)) {
                    labels.addSingle(this.getLabels().getLabelCumulativeCosts() + string + Integer.toString((int)d), false);
                } else {
                    labels.addSingle(this.getLabels().getLabelCumulativeCosts() + string + d, false);
                }
            }
        }
        return labels;
    }

    public Preferences getPreferences() {
        return this.pref;
    }

    public double getWidth() {
        return this.width;
    }

    /*
     * WARNING - void declaration
     */
    private void oldDrawEvent(Graphics2D graphics2D, Rectangle rectangle, Labels labels, Color color) {
        String string;
        int n;
        int n2;
        float f;
        Object object2;
        StringArray stringArray = labels.getLabels();
        boolean bl = this.pref.isDisplay(256);
        graphics2D.setColor(bl ? Color.white : color);
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setColor(bl ? Color.black : this.pref.getFontTextColor());
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        boolean bl2 = 2 == this.pref.getOrientation();
        boolean bl3 = 1 == this.pref.getOrientation() || bl2 && n6 > n5;
        int n7 = Math.max(n5, n6);
        int n8 = this.getPreferences().getFontText().getSize();
        int n9 = n8 + 2;
        int n10 = 0;
        int n11 = stringArray.size() - 1;
        int n12 = 0;
        for (int i = 0; i < n11 && (n10 += null == (object2 = stringArray.get(i)) ? n9 / 2 : n9) <= n7 - 2; ++i) {
            if (null == object2) continue;
            n12 = i + 1;
        }
        n11 = n12;
        if (n11 <= 0) {
            return;
        }
        float f2 = f = bl3 ? (float)(n6 - 6) : (float)(n5 - 6);
        if ((double)f <= 0.0) {
            return;
        }
        object2 = graphics2D.getFontRenderContext();
        LineBreakMeasurer lineBreakMeasurer = labels.getMeasurer((FontRenderContext)object2, this.plainFont, this.boldFont);
        ArrayList<TextLayoutInfo> arrayList = new ArrayList<TextLayoutInfo>(n11);
        for (n2 = 0; n2 < n11 && -1 != (n = labels.next()); ++n2) {
            if (n == lineBreakMeasurer.getPosition()) {
                arrayList.add(null);
            } else {
                try {
                    arrayList.add(new TextLayoutInfo(lineBreakMeasurer.nextLayout(f, n, false)));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    arrayList.add(null);
                }
            }
            lineBreakMeasurer.setPosition(n);
        }
        if (bl3 && bl2) {
            n2 = 1;
            for (TextLayoutInfo n13 : arrayList) {
                if (null == n13 || !(n13.getWidth() > (double)(n5 - 4))) continue;
                n2 = 0;
                break;
            }
            if (n2 != 0) {
                bl3 = false;
                f = n5 - 4;
            }
        }
        n7 = bl3 ? n5 : n6;
        n10 = 0;
        n11 = arrayList.size();
        n12 = 0;
        n2 = 0;
        for (n = 0; n < n11 && (n10 += null == (string = stringArray.get(n)) ? n9 / 2 : n9) <= n7 - 2; ++n) {
            if (null == string) continue;
            n2 = n10;
            n12 = n + 1;
        }
        n11 = n12;
        if (n11 <= 0) {
            return;
        }
        n = this.getPreferences().getAlignement();
        if (bl3) {
            int n13 = n3 + 4 + (n5 - n2) / 2 + n9 / 2;
            int n14 = n4 + n6 - 2;
            double d = this.getHeight();
            AffineTransform affineTransform = graphics2D.getTransform();
            AffineTransform affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.translate(0.0, d);
            affineTransform2.rotate(-1.5707963267948966);
            for (int i = 0; i < n11; ++i) {
                TextLayoutInfo textLayoutInfo = (TextLayoutInfo)arrayList.get(i);
                if (null != textLayoutInfo) {
                    void var25_33;
                    float f3;
                    TextLayout textLayout = textLayoutInfo.getLayout();
                    double d2 = textLayoutInfo.getWidth();
                    switch (n) {
                        case 0: {
                            f3 = (float)(d - (double)n14);
                            break;
                        }
                        case 2: {
                            f3 = (float)(d - ((double)(n14 - n6) + d2 + 4.0));
                            break;
                        }
                        default: {
                            f3 = (float)(d - ((double)n14 - ((double)f - d2) / 2.0));
                        }
                    }
                    graphics2D.setTransform(affineTransform2);
                    textLayout.draw(graphics2D, f3, (float)var25_33);
                    graphics2D.setTransform(affineTransform);
                    var25_33 += n9;
                    continue;
                }
                var25_33 += n9 / 2;
            }
        } else {
            int n15 = n4 + 4 + (n6 - n2 + n9) / 2;
            for (int i = 0; i < n11; ++i) {
                TextLayoutInfo textLayoutInfo = (TextLayoutInfo)arrayList.get(i);
                if (null != textLayoutInfo) {
                    void var25_35;
                    float f4;
                    TextLayout textLayout = textLayoutInfo.getLayout();
                    double d = textLayoutInfo.getWidth();
                    switch (n) {
                        case 0: {
                            f4 = 3 + n3;
                            break;
                        }
                        case 2: {
                            f4 = (float)((double)n3 - d + (double)n5 - 1.0);
                            break;
                        }
                        default: {
                            f4 = (float)((double)(3 + n3) + ((double)f - d) / 2.0);
                        }
                    }
                    textLayout.draw(graphics2D, f4, (float)var25_35);
                    var25_35 += n9;
                    continue;
                }
                var25_35 += n9 / 2;
            }
        }
    }

    public void renderPage(Graphics graphics, Dimension dimension, int n, int n2, boolean bl, int n3, HashSet<Integer> hashSet, int n4, HashSet<Integer> hashSet2, int n5, int n6) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.width = dimension.width - 1;
        this.height = dimension.height - 1;
        this.plainFont = this.getPreferences().getFontText();
        this.boldFont = this.plainFont.deriveFont(1, (float)this.plainFont.getSize() * 1.00001f);
        if (!bl) {
            this.drawBackground(graphics2D);
        }
        this.drawFrame(graphics2D, n, n2);
        this.drawData(graphics2D, n, n2, bl);
        this.drawSelectionZone(this.selectionRectangle, graphics2D);
        if (this.getPreferences().isDisplay(0x20000000)) {
            this.drawBoldLines(graphics2D, (int)this.width, (int)this.height, n3, hashSet, n4, hashSet2, n5, n6);
        }
    }

    public void setEtGrid(EtGrid etGrid) {
        this.etGrid = etGrid;
    }

    public void setSelectionList(Selection selection) {
        this.selectionList = selection;
    }

    private void drawSelectionZone(Rectangle rectangle, Graphics2D graphics2D) {
        if (null != rectangle) {
            Rectangle rectangle2 = graphics2D.getClipBounds();
            if (null != rectangle2) {
                rectangle2.grow(10, 10);
            }
            if (null == rectangle2 || rectangle.intersects(rectangle2)) {
                Color color = graphics2D.getColor();
                graphics2D.setColor(Color.red);
                graphics2D.setStroke(dashed);
                graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics2D.setColor(color);
            }
        }
    }

    private void drawBoldLines(Graphics2D graphics2D, int n, int n2, int n3, HashSet<Integer> hashSet, int n4, HashSet<Integer> hashSet2, int n5, int n6) {
        for (int n7 : hashSet) {
            graphics2D.fillRect(n7, -n3, 2, n2 + n3 + n6);
        }
        for (int n7 : hashSet2) {
            graphics2D.fillRect(-n4, n7, n + n4 + n5, 2);
        }
    }

    public EventsGroup getGroupAt(Point point) {
        EventsGroup[] eventsGroupArray = this.columnsPos;
        if (null != eventsGroupArray) {
            for (int i = 0; i < eventsGroupArray.length; ++i) {
                CaseEt[] caseEtArray = eventsGroupArray[i].getCells();
                int n = caseEtArray.length;
                for (int j = 0; j < n; ++j) {
                    if (!caseEtArray[j].getShape().contains(point)) continue;
                    return eventsGroupArray[i];
                }
            }
        }
        return null;
    }

    public EventsGroup[] getAllObjects() {
        EventsGroup[] eventsGroupArray = null;
        ArrayList<EventsGroup> arrayList = new ArrayList<EventsGroup>();
        EventsGroup[] eventsGroupArray2 = this.columnsPos;
        if (null != eventsGroupArray2) {
            for (int i = 0; i < eventsGroupArray2.length; ++i) {
                if (null == eventsGroupArray2[i]) continue;
                arrayList.add(eventsGroupArray2[i]);
            }
        }
        if (arrayList.size() > 0) {
            eventsGroupArray = new EventsGroup[arrayList.size()];
            arrayList.toArray(eventsGroupArray);
        }
        return eventsGroupArray;
    }

    public EventsGroup[] getObjectsIn(Rectangle rectangle) {
        HashSet<EventsGroup> hashSet = new HashSet<EventsGroup>();
        EventsGroup[] eventsGroupArray = this.columnsPos;
        if (null != eventsGroupArray) {
            for (int i = 0; i < eventsGroupArray.length; ++i) {
                Rectangle rectangle2 = eventsGroupArray[i].getShape();
                if (!rectangle2.intersects(rectangle)) continue;
                hashSet.add(eventsGroupArray[i]);
            }
        }
        EventsGroup[] eventsGroupArray2 = new EventsGroup[hashSet.size()];
        hashSet.toArray(eventsGroupArray2);
        return eventsGroupArray2;
    }

    public EventsGroup getEventsAt(Point point) {
        EventsGroup[] eventsGroupArray = this.columnsPos;
        if (null != eventsGroupArray) {
            for (int i = 0; i < eventsGroupArray.length; ++i) {
                if (!eventsGroupArray[i].getShape().contains(point)) continue;
                return eventsGroupArray[i];
            }
        }
        return null;
    }

    public EventsGroup getGroupFor(CaseEt caseEt) {
        EventsGroup[] eventsGroupArray = this.columnsPos;
        if (null != eventsGroupArray) {
            for (int i = 0; i < eventsGroupArray.length; ++i) {
                if (!eventsGroupArray[i].contains(caseEt)) continue;
                return eventsGroupArray[i];
            }
        }
        return null;
    }
}

