/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.timetable;

import com.adesoft.collections.MyHashTable;
import com.adesoft.log.Category;
import com.adesoft.timetable.EtGrid;
import com.adesoft.timetable.HistoData;
import com.adesoft.timetable.Preferences;
import com.adesoft.timetable.TextLayoutInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;

public final class PainterHisto {
    private static final Category LOG = Category.getInstance((String)"com.adesoft.timetable.PainterHisto");
    private static final Color backgroundColor = Color.white;
    private static final Color lineHColor = new Color(147, 173, 173);
    private static final Color lineVColor = new Color(187, 213, 213);
    private static final Color lineDayColor = new Color(97, 123, 123);
    private static final Color frameColor = Color.black;
    private static final Color solidColor = new Color(98, 86, 158);
    private static final Color textOverColor = Color.black;
    private static final Color textUnderColor = Color.white;
    private static final Color solidBWColor = new Color(230, 230, 230);
    private static final Color averageColor = new Color(236, 11, 11);
    private static final int[] steps = new int[]{1, 2, 5, 10, 20, 25, 50, 100, 200, 500, 1000, 5000, 10000, 50000, 100000};
    private final Preferences pref;
    private final HistoData histo;
    private final int nbSlots;
    private double width;
    private double height;

    PainterHisto(Preferences preferences, EtGrid etGrid, HistoData histoData) {
        this.histo = histoData;
        this.pref = preferences;
        this.nbSlots = etGrid.getNbSlots();
    }

    private void drawBackground(Graphics graphics) {
        graphics.setColor(backgroundColor);
        graphics.fillRect(1, 1, (int)this.width, (int)this.height);
    }

    private void drawColumn(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int[] nArray = this.getHisto().getColumn(n);
        if (null == nArray) {
            return;
        }
        int n5 = this.getHisto().getMaximum();
        boolean bl = this.getPreferences().isDisplay(256);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n6 = fontMetrics.getHeight();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = this.getPreferences().getFontText();
        MyHashTable myHashTable = new MyHashTable();
        if (!this.getPreferences().isPortrait()) {
            int n7 = n3 - n2;
            if (n7 == n4) {
                n -= n2;
            } else {
                n7 = n4;
            }
            double d = this.width * (double)n / (double)n7;
            for (int i = 0; i < this.nbSlots; ++i) {
                double d2;
                TextLayoutInfo textLayoutInfo;
                int n8 = nArray[i];
                if (0 == n8) continue;
                double d3 = d + this.width * (double)i / (double)n7 / (double)this.nbSlots;
                double d4 = this.height - this.height * (double)n8 / (double)n5;
                double d5 = this.width / (double)n7 / (double)this.nbSlots;
                double d6 = this.height * (double)n8 / (double)n5;
                graphics2D.setColor(bl ? solidBWColor : solidColor);
                graphics2D.fillRect((int)d3, (int)d4, (int)(d3 + d5) - (int)d3, (int)(d4 + d6) - (int)d4);
                if (d5 > 3.0) {
                    graphics2D.setColor(bl ? Color.black : frameColor);
                    graphics2D.drawRect((int)d3, (int)d4, (int)(d3 + d5) - (int)d3, (int)(d4 + d6) - (int)d4);
                }
                if (null == (textLayoutInfo = (TextLayoutInfo)myHashTable.get(n8))) {
                    try {
                        String string = Integer.toString(n8);
                        textLayoutInfo = new TextLayoutInfo(new TextLayout(string, font, fontRenderContext));
                        myHashTable.put(n8, (Object)textLayoutInfo);
                    }
                    catch (Exception exception) {
                        LOG.error((Object)exception);
                    }
                }
                if (null == textLayoutInfo || !((d2 = textLayoutInfo.getWidth()) <= d5)) continue;
                if ((double)n6 < d6) {
                    graphics2D.setColor(bl ? Color.black : textUnderColor);
                    textLayoutInfo.getLayout().draw(graphics2D, (float)(d3 + (d5 - d2) / 2.0), (float)((double)n6 + d4));
                    continue;
                }
                graphics2D.setColor(bl ? Color.black : textOverColor);
                textLayoutInfo.getLayout().draw(graphics2D, (float)(d3 + (d5 - d2) / 2.0), (float)(d4 - 2.0));
            }
        }
    }

    private void drawData(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        HistoData histoData = this.getHisto();
        if (null != histoData && 0 != n3 && 0 != n6) {
            for (int i = n4; i < n5; ++i) {
                for (int j = n; j < n2; ++j) {
                    this.drawColumn(graphics2D, j, n, n2, n3);
                }
            }
            this.drawAverageLine(graphics2D, histoData.getAverage(), histoData.getMaximum());
        }
    }

    private void drawAverageLine(Graphics2D graphics2D, int n, int n2) {
        if (n > -1 && n < n2) {
            Color color = graphics2D.getColor();
            boolean bl = this.getPreferences().isDisplay(256);
            graphics2D.setColor(bl ? Color.black : averageColor);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Font font = this.getPreferences().getFontText();
            String string = Integer.toString(n);
            TextLayoutInfo textLayoutInfo = new TextLayoutInfo(new TextLayout(string, font, fontRenderContext));
            if (!this.getPreferences().isPortrait()) {
                double d = this.height - this.height * (double)n / (double)n2;
                graphics2D.drawLine(0, (int)d, (int)this.width, (int)d);
                textLayoutInfo.getLayout().draw(graphics2D, (float)(this.width - (textLayoutInfo.getWidth() + 2.0)), (float)(d - 2.0));
            } else {
                double d = this.width - this.width * (double)n / (double)n2;
                graphics2D.drawLine((int)d, 0, (int)d, (int)this.height);
                textLayoutInfo.getLayout().draw(graphics2D, (float)(d - 2.0), (float)(this.height - (textLayoutInfo.getWidth() + 2.0)));
            }
            graphics2D.setColor(color);
        }
    }

    private void drawFrame(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = this.getPreferences().isDisplay(256);
        if (!this.getPreferences().isPortrait()) {
            double d;
            int n7;
            int n8;
            int n9;
            int n10 = n2 - n;
            if (0 != n10) {
                if (n10 == n3) {
                    n9 = 0;
                    n8 = n10;
                } else {
                    n9 = n;
                    n8 = n2;
                    n10 = n3;
                }
                for (n7 = n9; n7 <= n8; ++n7) {
                    d = this.width * (double)n7 / (double)n10;
                    graphics2D.setColor(bl ? Color.black : lineDayColor);
                    graphics2D.drawLine((int)d, 0, (int)d, (int)this.height);
                    graphics2D.setColor(bl ? Color.black : lineVColor);
                    for (int i = 1; i <= this.nbSlots; ++i) {
                        double d2 = d + ((double)i - 0.5) * (this.width / (double)n10 / (double)this.nbSlots);
                        graphics2D.drawLine((int)d2, 0, (int)d2, (int)this.height);
                    }
                }
            }
            if (null != this.getHisto()) {
                graphics2D.setColor(bl ? Color.black : lineHColor);
                n9 = this.getHisto().getMaximum();
                n8 = PainterHisto.getStep(n9, this.height);
                for (n7 = 0; n7 < n9; n7 += n8) {
                    d = this.height * (double)(n9 - n7) / (double)n9;
                    graphics2D.drawLine(0, (int)d, (int)this.width, (int)d);
                }
            }
        } else {
            double d;
            int n11;
            int n12;
            int n13;
            int n14 = n5 - n4;
            if (0 != n14) {
                if (n14 == n6) {
                    n13 = 0;
                    n12 = n14;
                } else {
                    n13 = n4;
                    n12 = n5;
                    n14 = n6;
                }
                for (n11 = n13; n11 <= n12; ++n11) {
                    d = this.height * (double)n11 / (double)n14;
                    graphics2D.setColor(bl ? Color.black : lineDayColor);
                    graphics2D.drawLine(0, (int)d, (int)this.width, (int)d);
                    graphics2D.setColor(bl ? Color.black : lineVColor);
                    for (int i = 1; i <= this.nbSlots; ++i) {
                        double d3 = d + ((double)i - 0.5) * (this.height / (double)n14 / (double)this.nbSlots);
                        graphics2D.drawLine(0, (int)d3, (int)this.width, (int)d3);
                    }
                }
            }
            if (null != this.getHisto()) {
                graphics2D.setColor(bl ? Color.black : lineHColor);
                n13 = this.getHisto().getMaximum();
                n12 = PainterHisto.getStep(n13, this.width);
                for (n11 = 0; n11 < n13; n11 += n12) {
                    d = this.width * (double)(n13 - n11) / (double)n13;
                    graphics2D.drawLine((int)d, 0, (int)d, (int)this.height);
                }
            }
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(0, 0, (int)this.width, (int)this.height);
    }

    public double getHeight() {
        return this.height;
    }

    private final HistoData getHisto() {
        return this.histo;
    }

    private Preferences getPreferences() {
        return this.pref;
    }

    public static int getStep(int n, double d) {
        for (int n2 : steps) {
            if (!(d * (double)n2 / (double)n > 15.0)) continue;
            return n2 > n ? n : n2;
        }
        return n;
    }

    public double getWidth() {
        return this.width;
    }

    public void renderPage(Graphics graphics, Dimension dimension, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.width = dimension.width - 1;
        this.height = dimension.height - 1;
        if (!bl) {
            this.drawBackground(graphics2D);
        }
        this.drawFrame(graphics2D, n, n2, n3, n4, n5, n6);
        this.drawData(graphics2D, n, n2, n3, n4, n5, n6);
    }
}

