/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.timetable;

import com.adesoft.timetable.EtGrid;
import com.adesoft.timetable.PainterEx;
import com.adesoft.timetable.PainterHisto;
import com.adesoft.timetable.Preferences;
import com.adesoft.timetable.Selection;
import com.adesoft.timetable.TimetableLabels;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.util.HashSet;

public class PainterTimetable {
    private final ImageObserver _observer;
    private final Preferences _preferences;
    private EtGrid _grids;
    private final Image[] _images;
    private final TimetableLabels _labels;
    private Rectangle _selectionRectangle;
    private Selection _selectionList;
    private PainterEx _painterEx;
    private PainterHisto _painterHisto;

    public PainterTimetable(ImageObserver imageObserver, Preferences preferences, EtGrid etGrid, Image[] imageArray, TimetableLabels timetableLabels) {
        this._observer = imageObserver;
        this._preferences = preferences;
        this._grids = etGrid;
        this._images = imageArray;
        this._labels = timetableLabels;
    }

    public Preferences getPreferences() {
        return this._preferences;
    }

    protected ImageObserver getObserver() {
        return this._observer;
    }

    public EtGrid getGrid() {
        return this._grids;
    }

    protected void setGrid(EtGrid etGrid) {
        this._grids = etGrid;
    }

    protected TimetableLabels getLabels() {
        return this._labels;
    }

    protected Image[] getImages() {
        return this._images;
    }

    public int getNColumns() {
        return null != this.getGrid() ? this.getGrid().getNbColumns() : 0;
    }

    public int getNRows() {
        return null != this.getGrid() ? this.getGrid().getVSize() : 0;
    }

    public void setSelection(Rectangle rectangle, Selection selection) {
        this._selectionRectangle = rectangle;
        this._selectionList = selection;
    }

    public Rectangle2D paint(Dimension dimension, Graphics graphics, boolean bl, int n, HashSet<Integer> hashSet, int n2, HashSet<Integer> hashSet2, int n3, int n4) {
        if (null == this.getGrid()) {
            int n5 = (int)dimension.getWidth();
            int n6 = (int)dimension.getHeight();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, n5 - 1, n6 - 1);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, n5 - 1, n6 - 1);
            return new Rectangle2D.Double(0.0, 0.0, n5, n6);
        }
        if (this.getPreferences().isDisplay(0x10000000)) {
            int n7 = (int)dimension.getWidth();
            int n8 = (int)dimension.getHeight();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, n7 - 1, n8 - 1);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, n7 - 1, n8 - 1);
            return new Rectangle2D.Double(0.0, 0.0, n7, n8);
        }
        if (this.getPreferences().showLoad()) {
            return this.paintHisto(dimension, graphics, bl);
        }
        return this.paintEt(dimension, graphics, bl, n, hashSet, n2, hashSet2, n3, n4);
    }

    private Rectangle2D paintEt(Dimension dimension, Graphics graphics, boolean bl, int n, HashSet<Integer> hashSet, int n2, HashSet<Integer> hashSet2, int n3, int n4) {
        this._painterEx = new PainterEx(this.getObserver(), this.getPreferences(), this.getGrid(), this.getImages(), this.getLabels());
        if (null != this._selectionList) {
            this._painterEx.setRectangleSelection(this._selectionRectangle);
        }
        this._painterEx.setEtGrid(this.getGrid());
        if (null != this._selectionList) {
            this._painterEx.setSelectionList(this._selectionList);
        }
        int n5 = this.getNColumns();
        int n6 = this.getNRows();
        this._painterEx.renderPage(graphics, dimension, n5, n6, bl, n, hashSet, n2, hashSet2, n3, n4);
        return new Rectangle2D.Double(0.0, 0.0, this._painterEx.getWidth(), this._painterEx.getHeight());
    }

    private Rectangle2D paintHisto(Dimension dimension, Graphics graphics, boolean bl) {
        this._painterHisto = new PainterHisto(this.getPreferences(), this.getGrid(), this.getGrid().getHistoData());
        int n = this.getNColumns();
        int n2 = this.getNRows();
        this._painterHisto.renderPage(graphics, dimension, 0, n, n, 0, n2, n2, bl);
        return new Rectangle2D.Double(0.0, 0.0, this._painterHisto.getWidth(), this._painterHisto.getHeight());
    }

    public PainterEx getPainterEx() {
        return this._painterEx;
    }
}

