/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.timetable;

import com.adesoft.beans.settings.DisplaySettings;
import com.adesoft.config.ConfigManager;
import com.adesoft.log.Category;
import com.adesoft.properties.ServerProperty;
import com.adesoft.struct.Field;
import com.adesoft.struct.PatternFields;
import com.adesoft.struct.configurations.Configuration;
import com.adesoft.struct.configurations.ConfigurationIO;
import com.adesoft.timetable.Axis;
import com.adesoft.timetable.AxisCategory;
import com.adesoft.timetable.Coder;
import java.awt.Color;
import java.awt.Font;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public final class Preferences
extends ConfigurationIO
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 520L;
    private static final Category LOG = Category.getInstance((String)"com.adesoft.timetable.Preferences");
    public static final String DISPLAY_MODE = "DisplayMode";
    public static final String DISPLAY_TYPES = "DisplayTypes";
    public static final String TYPE = "Type";
    public static final String DISPLAY_FIELDS = "DisplayFields";
    public static final String FIELD = "Field";
    public static final String EVENTS_COLORS = "EventsColors";
    public static final String EVENT_COLORS = "ColorType";
    public static final String ORIENTATION = "Orientation";
    public static final String ALIGNEMENT = "Alignement";
    public static final String MAX_ROW = "MaxRow";
    public static final String MAX_COL = "MaxCol";
    public static final String SHOW_LOAD = "ShowLoad";
    public static final String GROUP_BY_GROUP = "GroupByGroup";
    public static final String AVERAGE = "Average";
    public static final String FONT_NAME = "FontName";
    public static final String FONT_STYLE = "FontStyle";
    public static final String FONT_SIZE = "FontSize";
    public static final String FONT_LEGEND_NAME = "FontLegendName";
    public static final String FONT_LEGEND_STYLE = "FontLegendStyle";
    public static final String FONT_LEGEND_SIZE = "FontLegendSize";
    public static final String LEGEND_FIELD = "LegendField";
    public static final String X_AXIS = "XAxis";
    public static final String Y_AXIS = "YAxis";
    public static final String Z_AXIS = "ZAxis";
    public static final String X_PREV_AXIS = "XPrevAxis";
    public static final String Y_PREV_AXIS = "YPrevAxis";
    public static final String Z_PREV_AXIS = "ZPrevAxis";
    public static final String FONT_COLOR = "FontColor";
    public static final String FONT_LEGEND_COLOR = "FontLegendColor";
    public static final String ZOOM = "Zoom";
    public static final String COSTS_IDS = "CostsIds";
    public static final String MOVING_COST = "MovingCost";
    public static final String COSTS_CELLS_VIEW = "CostsCellsView";
    public static final String COSTS_COLS_ROWS_VIEW = "CostsColsRowsView";
    public static final String PERIOD_STYLE = "PeriodStyle";
    public static final String GROUP_STATE = "groupState";
    public static final String COLOR_STUDENT = "ColorStudent";
    public static final String COLOR_TEACHER = "ColorTeacher";
    public static final String COLOR_CLASSROOM = "ColorClassroom";
    public static final String COLOR_RESOURCE = "ColorResource";
    public static final String COLOR_CATEGORY5 = "ColorCategory5";
    public static final String COLOR_CATEGORY6 = "ColorCategory6";
    public static final String COLOR_CATEGORY7 = "ColorCategory7";
    public static final String COLOR_CATEGORY8 = "ColorCategory8";
    public static final String VERTICAL_PADDING = "VerticalPadding";
    public static final String VERTICAL_INTERLINE = "VerticalInterline";
    public static final String FIRST_SLOT = "FirstSlot";
    public static final String LAST_SLOT = "LastSlot";
    public static final String NB_DAYS_LOGS = "NbDaysLogs";
    public static final int DISPLAY_OCCUPATION = 128;
    public static final int DISPLAY_NOCOLOR = 256;
    public static final int DISPLAY_NOTAVAILABLE = 1024;
    public static final int DISPLAY_AVAILABLE = 2048;
    public static final int DISPLAY_DATES = 8192;
    public static final int DISPLAY_SLOTGRID = 16384;
    public static final int DISPLAY_LEGEND_UNTRUNCATED = 65536;
    public static final int DISPLAY_HIDEHOURS = 262144;
    public static final int DISPLAY_COURSEID = 524288;
    public static final int DISPLAY_LEGENDHOURS = 0x100000;
    public static final int DISPLAY_WEEKDATES = 0x200000;
    public static final int DISPLAY_MEMBERS = 0x400000;
    public static final int DISPLAY_LIMITED = 0x800000;
    public static final int DISPLAY_LINE_UNTRUNCATED = 0x1000000;
    public static final int DISPLAY_WORKLOADZOOM = 0x2000000;
    public static final int DISPLAY_WORKLOADSLIDE = 0x4000000;
    public static final int DISPLAY_REQUESTS = 0x8000000;
    public static final int DISPLAY_TABLE = 0x10000000;
    public static final int DISPLAY_SEPARATIONS = 0x20000000;
    public static final int DISPLAY_SETUPTIMES = 0x40000000;
    public static final int DEFAULT_DISPLAY = 26289152;
    public static final boolean[] DEFAULT_GROUP_STATE = new boolean[]{false, false, false, false};
    public static final String[] DEFAULT_EVENTS_COLOR = new String[]{null, "COURSENAME,PARTICIPANTS_CATEGORY1", "COURSENAME,PARTICIPANTS_CATEGORY2", "COURSENAME,PARTICIPANTS_CATEGORY3", "COURSENAME,PARTICIPANTS_CATEGORY4", "COURSENAME,PARTICIPANTS_CATEGORY5", "COURSENAME,PARTICIPANTS_CATEGORY6", "COURSENAME,PARTICIPANTS_CATEGORY7", "COURSENAME,PARTICIPANTS_CATEGORY8"};
    public static final Field DEFAULT_LEGEND_FIELD = Field.NAME;
    public static final int TEXT_HORIZONTAL = 0;
    public static final int TEXT_VERTICAL = 1;
    public static final int TEXT_AUTO = 2;
    public static final int TEXT_LEFT = 0;
    public static final int TEXT_CENTER = 1;
    public static final int TEXT_RIGHT = 2;
    public static final int COST_NONE = 0;
    public static final int COST_DETAILED = 1;
    public static final int COST_CUMULATIVE = 2;
    public static final int WEEK = 0;
    public static final int MONTH = 1;
    public static final int YEAR = 2;
    private List xAxis;
    private List yAxis;
    private int firstSlot;
    private int lastSlot;
    private int nbDaysLogs;
    private Font fontText;
    private Color fontTextColor;
    private Font fontLegend;
    private Color fontLegendColor;
    private int displayMode;
    private ArrayList displayFields;
    private Field legendField;
    private int orientation;
    private int alignement;
    private int zoom;
    private int periodStyle;
    private boolean[] categoryGroupState;
    private String[] eventColorsTypes;
    private int[] costsIds;
    private boolean movingCost;
    private int costsCellsView;
    private int costsColsRowsView;
    private int verticalPadding;
    private int verticalInterline;
    private boolean isPortrait;
    private boolean showLoad;
    private List previousXAxis;
    private List previousYAxis;
    private int average;
    private boolean groupByGroup;

    public Preferences() {
        this.setDefaultValues();
        this.refreshPortraitFlag();
    }

    public Preferences(DisplaySettings displaySettings) {
        this.parseSettings(displaySettings, true);
        this.refreshPortraitFlag();
    }

    public Preferences(Configuration configuration) {
        this.parseConfiguration(configuration);
        this.refreshPortraitFlag();
    }

    public Preferences(Configuration configuration, int n) {
        this.parseConfiguration(configuration, n);
        this.refreshPortraitFlag();
    }

    private Preferences(Preferences preferences) {
        this.fontText = preferences.fontText;
        this.fontTextColor = preferences.fontTextColor;
        this.fontLegend = preferences.fontLegend;
        this.fontLegendColor = preferences.fontLegendColor;
        this.showLoad = preferences.showLoad;
        this.groupByGroup = preferences.groupByGroup;
        this.displayMode = preferences.displayMode;
        if (0 == (this.displayMode & 0x800080) && this.showLoad) {
            this.displayMode |= 0x800000;
        }
        this.displayFields = preferences.displayFields;
        this.legendField = preferences.legendField;
        this.average = preferences.average;
        this.orientation = preferences.orientation;
        this.alignement = preferences.alignement;
        this.zoom = preferences.zoom;
        this.periodStyle = preferences.periodStyle;
        this.costsIds = preferences.costsIds;
        this.categoryGroupState = preferences.categoryGroupState;
        this.eventColorsTypes = preferences.eventColorsTypes;
        this.xAxis = new ArrayList(preferences.xAxis);
        this.yAxis = new ArrayList(preferences.yAxis);
        this.verticalPadding = preferences.verticalPadding;
        this.verticalInterline = preferences.verticalPadding;
        this.firstSlot = preferences.firstSlot;
        this.lastSlot = preferences.lastSlot;
        this.nbDaysLogs = preferences.nbDaysLogs;
        this.isPortrait = preferences.isPortrait;
    }

    public Object clone() {
        return new Preferences(this);
    }

    public int getAlignement() {
        return this.alignement;
    }

    public int getAverage() {
        return this.average;
    }

    public int getZoom() {
        return this.zoom;
    }

    public int getPeriodStyle() {
        return this.periodStyle;
    }

    public int[] getCostsIds() {
        return this.costsIds;
    }

    public int getCostsCellsView() {
        return this.costsCellsView;
    }

    public int getCostsColsRowsView() {
        return this.costsColsRowsView;
    }

    public Axis getAxis(AxisCategory axisCategory) {
        int n = this.yAxis.size();
        for (int i = 0; i < n; ++i) {
            if (axisCategory != this.yAxis.get(i)) continue;
            return Axis.Y;
        }
        return Axis.X;
    }

    public void setFirstSlot(int n) {
        this.firstSlot = n;
    }

    public void setLastSlot(int n) {
        this.lastSlot = n;
    }

    public void setNbDaysLogs(int n) {
        this.nbDaysLogs = n;
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public ArrayList getDisplayFields() {
        if (null == this.displayFields) {
            this.displayFields = this.getDefaultFields();
        }
        return this.displayFields;
    }

    public Field getLegendField() {
        return this.legendField;
    }

    public Font getFontText() {
        return this.fontText;
    }

    public Font getFontLegend() {
        return this.fontLegend;
    }

    public Color getFontTextColor() {
        return this.fontTextColor;
    }

    public Color getFontLegendColor() {
        return this.fontLegendColor;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public AxisCategory[] getUngroupedXAxis() {
        if (null == this.xAxis) {
            return null;
        }
        ArrayList<AxisCategory> arrayList = new ArrayList<AxisCategory>();
        for (int i = 0; i < this.xAxis.size(); ++i) {
            AxisCategory axisCategory = (AxisCategory)this.xAxis.get(i);
            if (this.isGroupedCategory(axisCategory)) continue;
            arrayList.add(axisCategory);
        }
        AxisCategory[] axisCategoryArray = new AxisCategory[arrayList.size()];
        arrayList.toArray(axisCategoryArray);
        return axisCategoryArray;
    }

    public AxisCategory[] getVisibleXAxis() {
        if (null == this.xAxis) {
            return null;
        }
        ArrayList<AxisCategory> arrayList = new ArrayList<AxisCategory>();
        for (int i = 0; i < this.xAxis.size(); ++i) {
            AxisCategory axisCategory = (AxisCategory)this.xAxis.get(i);
            if (this.isGroupedCategory(axisCategory) && !axisCategory.equals(AxisCategory.HOUR)) continue;
            arrayList.add(axisCategory);
        }
        AxisCategory[] axisCategoryArray = new AxisCategory[arrayList.size()];
        arrayList.toArray(axisCategoryArray);
        return axisCategoryArray;
    }

    public AxisCategory[] getXAxis() {
        if (null == this.xAxis) {
            return null;
        }
        AxisCategory[] axisCategoryArray = new AxisCategory[this.xAxis.size()];
        this.xAxis.toArray(axisCategoryArray);
        return axisCategoryArray;
    }

    public AxisCategory[] getUngroupedYAxis() {
        if (null == this.yAxis) {
            return null;
        }
        ArrayList<AxisCategory> arrayList = new ArrayList<AxisCategory>();
        for (int i = 0; i < this.yAxis.size(); ++i) {
            AxisCategory axisCategory = (AxisCategory)this.yAxis.get(i);
            if (this.isGroupedCategory(axisCategory)) continue;
            arrayList.add(axisCategory);
        }
        AxisCategory[] axisCategoryArray = new AxisCategory[arrayList.size()];
        arrayList.toArray(axisCategoryArray);
        return axisCategoryArray;
    }

    public AxisCategory[] getVisibleYAxis() {
        if (null == this.yAxis) {
            return null;
        }
        ArrayList<AxisCategory> arrayList = new ArrayList<AxisCategory>();
        for (int i = 0; i < this.yAxis.size(); ++i) {
            AxisCategory axisCategory = (AxisCategory)this.yAxis.get(i);
            if (this.isGroupedCategory(axisCategory) && !axisCategory.equals(AxisCategory.HOUR)) continue;
            arrayList.add(axisCategory);
        }
        AxisCategory[] axisCategoryArray = new AxisCategory[arrayList.size()];
        arrayList.toArray(axisCategoryArray);
        return axisCategoryArray;
    }

    public AxisCategory[] getYAxis() {
        if (null == this.yAxis) {
            return null;
        }
        AxisCategory[] axisCategoryArray = new AxisCategory[this.yAxis.size()];
        this.yAxis.toArray(axisCategoryArray);
        return axisCategoryArray;
    }

    public boolean hideHours() {
        return this.isDisplay(262144);
    }

    public boolean isDisplay(Field field) {
        for (PatternFields patternFields : this.displayFields) {
            if (!patternFields.getFields().contains(field)) continue;
            return true;
        }
        return false;
    }

    public boolean isDisplay(int n) {
        return 0 != (this.displayMode & n);
    }

    public static boolean isDisplay(int n, int n2) {
        return 0 != (n & n2);
    }

    public boolean isPortrait() {
        return this.isPortrait;
    }

    private void refreshPortraitFlag() {
        int n = this.yAxis.size();
        for (int i = 0; i < n; ++i) {
            if (AxisCategory.HOUR != this.yAxis.get(i)) continue;
            this.isPortrait = true;
            return;
        }
        this.isPortrait = false;
    }

    public void setAlignement(int n) {
        this.alignement = n;
    }

    public void setZoom(int n) {
        this.zoom = n;
    }

    public void setPeriodStyle(int n) {
        this.periodStyle = n;
    }

    public void setCostsIds(int[] nArray) {
        this.costsIds = nArray;
    }

    public void setCostsCellsView(int n) {
        this.costsCellsView = n;
    }

    public void setCostsCellsView(int n, boolean bl) {
        if (bl) {
            if (n != (this.costsCellsView & n)) {
                this.costsCellsView += n;
            }
        } else if (n == (this.costsCellsView & n)) {
            this.costsCellsView -= n;
        }
    }

    public void setCostsColsRowsView(int n) {
        this.costsColsRowsView = n;
    }

    public void setCostsColsRowsView(int n, boolean bl) {
        if (bl) {
            if (n != (this.costsColsRowsView & n)) {
                this.costsColsRowsView += n;
            }
        } else if (n == (this.costsColsRowsView & n)) {
            this.costsColsRowsView -= n;
        }
    }

    public void setAxis(Axis axis, List list) {
        if (axis == Axis.X) {
            this.xAxis = list;
        } else if (axis == Axis.Y) {
            this.yAxis = list;
        }
        this.refreshPortraitFlag();
    }

    public void setAxis(AxisCategory axisCategory, Axis axis, int n) {
        this.xAxis.remove(axisCategory);
        this.yAxis.remove(axisCategory);
        if (axis == Axis.X) {
            if (n < this.xAxis.size()) {
                this.xAxis.add(n, axisCategory);
            } else {
                this.xAxis.add(axisCategory);
            }
        } else if (axis == Axis.Y) {
            if (n < this.yAxis.size()) {
                this.yAxis.add(n, axisCategory);
            } else {
                this.yAxis.add(axisCategory);
            }
        }
        if (AxisCategory.HOUR == axisCategory) {
            this.isPortrait = Axis.Y == axis;
        }
    }

    public int getMaxZoom() {
        return ConfigManager.getInstance().getIntProperty(ServerProperty.ZOOM_MAX_LEVEL);
    }

    @Override
    public void setDefaultValues() {
        this.setDefaultValues(-1);
    }

    public void setDefaultValues(int n) {
        this.displayMode = 26289152;
        this.displayFields = this.getDefaultFields();
        this.legendField = DEFAULT_LEGEND_FIELD;
        this.categoryGroupState = DEFAULT_GROUP_STATE;
        this.eventColorsTypes = (String[])DEFAULT_EVENTS_COLOR.clone();
        this.fontText = new Font("sansserif", 0, 11);
        this.fontTextColor = Color.black;
        this.fontLegend = new Font("sansserif", 0, 11);
        this.fontLegendColor = Color.black;
        this.showLoad = false;
        this.groupByGroup = true;
        this.average = 50;
        this.orientation = 0;
        this.alignement = 1;
        this.zoom = this.getMaxZoom();
        this.periodStyle = 0;
        this.costsIds = new int[0];
        this.movingCost = false;
        this.costsCellsView = 0;
        this.costsColsRowsView = 0;
        this.xAxis = Preferences.getDefaultXAxis();
        this.yAxis = Preferences.getDefaultYAxis();
        this.verticalPadding = 2;
        this.verticalInterline = 3;
        if (n == -1) {
            this.firstSlot = -1;
            this.lastSlot = -1;
        } else {
            this.firstSlot = 0;
            this.lastSlot = n;
        }
        this.nbDaysLogs = 0;
        this.refreshPortraitFlag();
    }

    private static final List getDefaultXAxis() {
        ArrayList<AxisCategory> arrayList = new ArrayList<AxisCategory>();
        arrayList.add(AxisCategory.WEEK);
        arrayList.add(AxisCategory.DAY);
        arrayList.add(AxisCategory.ENTITY);
        return arrayList;
    }

    private static final List getDefaultYAxis() {
        ArrayList<AxisCategory> arrayList = new ArrayList<AxisCategory>();
        arrayList.add(AxisCategory.HOUR);
        return arrayList;
    }

    @Override
    public Element getXml() {
        String[] stringArray;
        PatternFields patternFields2;
        Element element = new Element("preferences");
        Element element2 = new Element(DISPLAY_TYPES);
        for (PatternFields patternFields2 : this.displayFields) {
            stringArray = new Element(DISPLAY_FIELDS);
            stringArray.addAttribute(TYPE, patternFields2.getType());
            for (Object object : patternFields2.getFields()) {
                Element element3 = new Element(FIELD);
                if (null != object) {
                    element3.addAttribute("name", ((Field)object).getName());
                } else {
                    element3.addAttribute("name", "charReturn");
                }
                stringArray.addChild(element3);
            }
            element2.addChild((Element)stringArray);
        }
        element.addChild(element2);
        patternFields2 = new Element(EVENTS_COLORS);
        stringArray = this.getEventColorsTypes();
        for (int i = 1; i < 9; ++i) {
            Object object;
            object = new Element(EVENT_COLORS);
            object.addAttribute("entityType", i);
            object.addAttribute("colorTypes", stringArray[i]);
            patternFields2.addChild((Element)object);
        }
        element.addChild((Element)patternFields2);
        element.addAttribute(DISPLAY_MODE, this.getDisplayMode());
        element.addAttribute(ORIENTATION, this.getOrientation());
        element.addAttribute(ALIGNEMENT, this.getAlignement());
        element.addAttribute(ZOOM, this.getZoom());
        element.addAttribute(PERIOD_STYLE, this.getPeriodStyle());
        element.addAttribute(SHOW_LOAD, this.showLoad);
        element.addAttribute(GROUP_BY_GROUP, this.groupByGroup);
        element.addAttribute(AVERAGE, this.average);
        element.addAttribute(COSTS_IDS, Coder.encodeInts(this.costsIds));
        element.addAttribute(MOVING_COST, this.isMovingCost());
        element.addAttribute(COSTS_CELLS_VIEW, this.getCostsCellsView());
        element.addAttribute(COSTS_COLS_ROWS_VIEW, this.getCostsColsRowsView());
        element.addAttribute(GROUP_STATE, Coder.encodeBooleans(this.getCategoryGroupState()));
        element.addAttribute(FIRST_SLOT, this.getFirstSlot());
        element.addAttribute(LAST_SLOT, this.getLastSlot());
        element.addAttribute(NB_DAYS_LOGS, this.getNbDaysLogs());
        element.addAttribute(LEGEND_FIELD, this.legendField.getName());
        element.addAttribute(FONT_NAME, this.getFontText().getName());
        element.addAttribute(FONT_STYLE, this.getFontText().getStyle());
        element.addAttribute(FONT_SIZE, this.getFontText().getSize());
        element.addAttribute(FONT_COLOR, this.getFontTextColor().getRGB());
        element.addAttribute(FONT_LEGEND_NAME, this.getFontLegend().getName());
        element.addAttribute(FONT_LEGEND_STYLE, this.getFontLegend().getStyle());
        element.addAttribute(FONT_LEGEND_SIZE, this.getFontLegend().getSize());
        element.addAttribute(FONT_LEGEND_COLOR, this.getFontLegendColor().getRGB());
        element.addAttribute(X_AXIS, AxisCategory.encodeStrings(this.xAxis));
        element.addAttribute(Y_AXIS, AxisCategory.encodeStrings(this.yAxis));
        element.addAttribute(VERTICAL_INTERLINE, this.verticalInterline);
        element.addAttribute(VERTICAL_PADDING, this.verticalPadding);
        return element;
    }

    public void parseXml(Element element) {
        int n;
        Object object;
        Object object2;
        Object object32;
        Object object42;
        Object object5;
        Object object6;
        this.displayFields = new ArrayList();
        if (null == element.getChild(DISPLAY_TYPES)) {
            object6 = new PatternFields(9);
            object5 = new ArrayList();
            object42 = element.getChild(DISPLAY_FIELDS);
            for (Object object32 : object42.getChildren(FIELD)) {
                try {
                    object2 = object32.getString("name");
                    ((ArrayList)object5).add(Field.getByName((String)object2));
                    ((ArrayList)object5).add(null);
                }
                catch (Throwable throwable) {
                    object = Field.getById(object32.getInt("id"));
                    if (null == object) continue;
                    ((ArrayList)object5).add(object);
                    ((ArrayList)object5).add(null);
                }
            }
            ((PatternFields)object6).setFields((List)object5);
            this.displayFields.add(object6);
        } else {
            object6 = element.getChild(DISPLAY_TYPES);
            for (Object object42 : object6.getChildren(DISPLAY_FIELDS)) {
                int n2 = object42.getInt(TYPE);
                object32 = new PatternFields(n2);
                object2 = object42.getChildrenArray();
                object = new ArrayList();
                for (n = 0; n < ((Element[])object2).length; ++n) {
                    ((ArrayList)object).add(Field.getByName(object2[n].getString("name")));
                }
                ((PatternFields)object32).setFields((List)object);
                this.displayFields.add(object32);
            }
        }
        object6 = element.getChild(EVENTS_COLORS);
        if (null != object6) {
            object5 = object6.getChildren(EVENT_COLORS);
            object42 = new String[9];
            Iterator iterator = object5.iterator();
            while (iterator.hasNext()) {
                object32 = (Element)iterator.next();
                int n3 = object32.getAttribute("entityType").getIntValue();
                object42[n3] = object = object32.getAttribute("colorTypes").getValue();
            }
            this.eventColorsTypes = object42;
        }
        boolean bl = element.getAttribute(SHOW_LOAD).getBooleanValue();
        if (null != element.getAttribute(GROUP_BY_GROUP)) {
            this.groupByGroup = element.getAttribute(GROUP_BY_GROUP).getBooleanValue();
        }
        this.displayMode = element.getAttribute(DISPLAY_MODE).getIntValue();
        if (0 == (this.displayMode & 0x800080) && !bl) {
            this.displayMode |= 0x800000;
            this.firstSlot = -1;
            this.lastSlot = -1;
        } else if (null != element.getAttribute(FIRST_SLOT) && null != element.getAttribute(LAST_SLOT)) {
            this.firstSlot = element.getAttribute(FIRST_SLOT).getIntValue();
            this.lastSlot = element.getAttribute(LAST_SLOT).getIntValue();
        }
        this.orientation = element.getAttribute(ORIENTATION).getIntValue();
        this.alignement = element.getAttribute(ALIGNEMENT).getIntValue();
        this.zoom = element.getAttribute(ZOOM).getIntValue();
        this.periodStyle = element.getAttribute(PERIOD_STYLE).getIntValue();
        if (null != element.getAttribute(AVERAGE)) {
            this.average = element.getAttribute(AVERAGE).getIntValue();
        }
        try {
            this.nbDaysLogs = element.hasAttribute(NB_DAYS_LOGS) ? element.getInt(NB_DAYS_LOGS) : 0;
        }
        catch (NullPointerException nullPointerException) {
            this.nbDaysLogs = 0;
        }
        this.costsIds = Coder.decodeInts(element.getAttribute(COSTS_IDS).getValue());
        this.movingCost = element.getBoolean(MOVING_COST, false);
        this.costsCellsView = element.getAttribute(COSTS_CELLS_VIEW).getIntValue();
        this.costsColsRowsView = element.getAttribute(COSTS_COLS_ROWS_VIEW).getIntValue();
        if (null != element.getAttribute(GROUP_STATE)) {
            this.categoryGroupState = Coder.decodeBooleans(element.getAttribute(GROUP_STATE).getValue());
        }
        try {
            this.legendField = Field.getByName(element.getString(LEGEND_FIELD));
        }
        catch (Throwable throwable) {
            this.legendField = Field.getById(element.getInt(LEGEND_FIELD));
        }
        object42 = element.getString(FONT_NAME);
        int n4 = element.getInt(FONT_STYLE);
        int n5 = element.getInt(FONT_SIZE);
        int n6 = element.getInt(FONT_COLOR);
        this.fontText = new Font((String)object42, n4, n5);
        this.fontTextColor = new Color(n6);
        object = element.getString(FONT_LEGEND_NAME, (String)object42);
        n = element.getInt(FONT_LEGEND_STYLE, n4);
        int n7 = element.getInt(FONT_LEGEND_SIZE, n5);
        int n8 = element.getInt(FONT_LEGEND_COLOR, n6);
        this.fontLegend = new Font((String)object, n, n7);
        this.fontLegendColor = new Color(n8);
        this.setShowLoad(bl);
        this.xAxis = AxisCategory.decodeStrings(element.getAttribute(X_AXIS).getValue());
        this.yAxis = AxisCategory.decodeStrings(element.getAttribute(Y_AXIS).getValue());
        this.verticalPadding = element.getInt(VERTICAL_PADDING, 2);
        this.verticalInterline = element.getInt(VERTICAL_INTERLINE, 3);
        this.refreshPortraitFlag();
    }

    public void setDisplayMode(int n) {
        this.displayMode = -1 != n ? n : 26289152;
    }

    public void setDisplayMode(int n, boolean bl) {
        this.displayMode = bl ? (this.displayMode |= n) : (this.displayMode &= ~n);
    }

    public void setDisplayFields(ArrayList arrayList) {
        this.displayFields = arrayList;
    }

    public void setLegendField(Field field) {
        this.legendField = field;
    }

    public void setFontText(Font font) {
        if (null != font) {
            this.fontText = font;
        }
    }

    public void setFontLegend(Font font) {
        if (null != font) {
            this.fontLegend = font;
        }
    }

    public void setFontTextColor(Color color) {
        if (null != color) {
            this.fontTextColor = color;
        }
    }

    public void setFontLegendColor(Color color) {
        if (null != color) {
            this.fontLegendColor = color;
        }
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public void setShowLoad(boolean bl) {
        if (bl != this.showLoad) {
            this.showLoad = bl;
            if (bl) {
                this.previousXAxis = this.xAxis;
                this.previousYAxis = this.yAxis;
                this.xAxis = new ArrayList();
                this.xAxis.add(AxisCategory.WEEK);
                this.xAxis.add(AxisCategory.DAY);
                this.xAxis.add(AxisCategory.HOUR);
                this.yAxis = new ArrayList();
                this.yAxis.add(AxisCategory.ENTITY);
            } else {
                this.xAxis = null != this.previousXAxis ? this.previousXAxis : Preferences.getDefaultXAxis();
                this.yAxis = null != this.previousYAxis ? this.previousYAxis : Preferences.getDefaultYAxis();
                this.previousXAxis = null;
                this.previousYAxis = null;
            }
            this.refreshPortraitFlag();
        }
    }

    public void setAverage(int n) {
        this.average = n;
    }

    public boolean showLoad() {
        return this.showLoad;
    }

    public boolean isGroupByGroup() {
        return this.groupByGroup;
    }

    public void setGroupByGroup(boolean bl) {
        this.groupByGroup = bl;
    }

    public void swapAxis() {
        List list = this.xAxis;
        this.xAxis = this.yAxis;
        this.yAxis = list;
        this.isPortrait = !this.isPortrait;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("FONT : " + this.getFontText() + '\n');
        stringBuffer.append("DISPLAY MODE : " + this.getDisplayMode() + '\n');
        stringBuffer.append("SLOTS : ");
        return stringBuffer.toString();
    }

    public AxisCategory[] getAxis(Axis axis) {
        if (Axis.Y == axis) {
            return this.getYAxis();
        }
        return this.getXAxis();
    }

    public int getAxisPosition(AxisCategory axisCategory) {
        int n = -1;
        Axis axis = this.getAxis(axisCategory);
        AxisCategory[] axisCategoryArray = this.getAxis(axis);
        if (null != axisCategoryArray) {
            for (int i = 0; i < axisCategoryArray.length && -1 == n; ++i) {
                if (axisCategoryArray[i] != axisCategory) continue;
                n = i;
            }
        }
        return n;
    }

    public boolean isWeekBeforeDay() {
        int n;
        int n2;
        Axis axis;
        Axis axis2 = this.getAxis(AxisCategory.WEEK);
        return axis2 == (axis = this.getAxis(AxisCategory.DAY)) && (n2 = this.getAxisPosition(AxisCategory.WEEK)) < (n = this.getAxisPosition(AxisCategory.DAY));
    }

    public AxisCategory[] getGroupedCategories() {
        ArrayList<AxisCategory> arrayList = new ArrayList<AxisCategory>();
        boolean[] blArray = this.getCategoryGroupState();
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            arrayList.add(AxisCategory.getCategoryByIndex(i));
        }
        AxisCategory[] axisCategoryArray = new AxisCategory[arrayList.size()];
        arrayList.toArray(axisCategoryArray);
        return axisCategoryArray;
    }

    public void setGroupedCategory(AxisCategory axisCategory, boolean bl) {
        this.categoryGroupState[axisCategory.getIndex()] = bl;
    }

    public boolean hasGroupedCategory() {
        boolean[] blArray = this.getCategoryGroupState();
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isGroupedCategory(AxisCategory axisCategory) {
        return this.getCategoryGroupState()[axisCategory.getIndex()];
    }

    private boolean[] getCategoryGroupState() {
        if (null == this.categoryGroupState) {
            this.categoryGroupState = DEFAULT_GROUP_STATE;
        }
        return this.categoryGroupState;
    }

    public String[] getEventColorsTypes() {
        if (null == this.eventColorsTypes) {
            this.eventColorsTypes = (String[])DEFAULT_EVENTS_COLOR.clone();
        }
        return this.eventColorsTypes;
    }

    public String getEventColorsTypes(int n) {
        if (null == this.eventColorsTypes) {
            this.eventColorsTypes = (String[])DEFAULT_EVENTS_COLOR.clone();
        }
        return this.eventColorsTypes[n];
    }

    public void setEventColorsTypes(int n, String string) {
        this.eventColorsTypes[n] = string;
    }

    public void parseConfiguration(Configuration configuration) {
        this.parseConfiguration(configuration, -1);
    }

    public void parseConfiguration(Configuration configuration, int n) {
        if (null == configuration) {
            this.setDefaultValues(n);
        } else {
            String string = configuration.getBuffer();
            if (0 == string.length()) {
                this.setDefaultValues(n);
            } else {
                try {
                    Document document = new SAXBuilder().build((Reader)new StringReader(string));
                    Element element = document.getRootElement();
                    this.parseXml(element);
                }
                catch (Throwable throwable) {
                    this.parseBuffer(string);
                }
            }
        }
    }

    private void parseBuffer(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("=");
            if (-1 == n) continue;
            try {
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                hashMap.put(string3, string4);
            }
            catch (Throwable throwable) {
                LOG.error((Object)throwable);
            }
        }
        this.displayMode = Integer.parseInt(this.getValue(hashMap, DISPLAY_MODE, "26289152"));
        this.orientation = Integer.parseInt(this.getValue(hashMap, ORIENTATION, "0"));
        this.alignement = Integer.parseInt(this.getValue(hashMap, ALIGNEMENT, "1"));
        this.zoom = Integer.parseInt(this.getValue(hashMap, ZOOM, "" + this.getMaxZoom()));
        this.periodStyle = Integer.parseInt(this.getValue(hashMap, PERIOD_STYLE, "0"));
        boolean bl = Boolean.valueOf(this.getValue(hashMap, SHOW_LOAD, "false"));
        this.groupByGroup = Boolean.valueOf(this.getValue(hashMap, GROUP_BY_GROUP, "true"));
        this.legendField = Field.getById(Integer.parseInt(this.getValue(hashMap, LEGEND_FIELD, String.valueOf(DEFAULT_LEGEND_FIELD.getId()))));
        this.costsIds = Coder.decodeInts(this.getValue(hashMap, COSTS_IDS, ""));
        this.movingCost = Boolean.parseBoolean(this.getValue(hashMap, MOVING_COST, "false"));
        this.costsCellsView = Integer.parseInt(this.getValue(hashMap, COSTS_CELLS_VIEW, "0"));
        this.costsColsRowsView = Integer.parseInt(this.getValue(hashMap, COSTS_COLS_ROWS_VIEW, "0"));
        String string5 = this.getValue(hashMap, FONT_NAME, "sansserif");
        int n = Integer.parseInt(this.getValue(hashMap, FONT_STYLE, "0"));
        int n2 = Integer.parseInt(this.getValue(hashMap, FONT_SIZE, "11"));
        String string6 = this.getValue(hashMap, FONT_COLOR, "" + Color.black);
        int n3 = Integer.parseInt(this.getValue(hashMap, FONT_COLOR, "" + Color.black.getRGB()));
        this.fontText = new Font(string5, n, n2);
        this.fontTextColor = Color.getColor(string6, n3);
        this.fontLegend = this.fontText;
        this.fontLegendColor = this.fontTextColor;
        List list = Preferences.getDefaultXAxis();
        List list2 = Preferences.getDefaultYAxis();
        this.setShowLoad(bl);
        this.xAxis = AxisCategory.decodeStrings(this.getValue(hashMap, X_AXIS, AxisCategory.encodeStrings(list)));
        this.yAxis = AxisCategory.decodeStrings(this.getValue(hashMap, Y_AXIS, AxisCategory.encodeStrings(list2)));
        this.previousXAxis = AxisCategory.decodeStrings(this.getValue(hashMap, X_PREV_AXIS, AxisCategory.encodeStrings(list)));
        this.previousYAxis = AxisCategory.decodeStrings(this.getValue(hashMap, Y_PREV_AXIS, AxisCategory.encodeStrings(list2)));
        this.eventColorsTypes = new String[DEFAULT_EVENTS_COLOR.length];
        this.eventColorsTypes[1] = Preferences.convertColors(this.getValue(hashMap, COLOR_STUDENT, DEFAULT_EVENTS_COLOR[1]));
        this.eventColorsTypes[2] = Preferences.convertColors(this.getValue(hashMap, COLOR_TEACHER, DEFAULT_EVENTS_COLOR[2]));
        this.eventColorsTypes[3] = Preferences.convertColors(this.getValue(hashMap, COLOR_CLASSROOM, DEFAULT_EVENTS_COLOR[3]));
        this.eventColorsTypes[4] = Preferences.convertColors(this.getValue(hashMap, COLOR_RESOURCE, DEFAULT_EVENTS_COLOR[4]));
        this.eventColorsTypes[5] = Preferences.convertColors(this.getValue(hashMap, COLOR_CATEGORY5, DEFAULT_EVENTS_COLOR[5]));
        this.eventColorsTypes[6] = Preferences.convertColors(this.getValue(hashMap, COLOR_CATEGORY6, DEFAULT_EVENTS_COLOR[6]));
        this.eventColorsTypes[7] = Preferences.convertColors(this.getValue(hashMap, COLOR_CATEGORY7, DEFAULT_EVENTS_COLOR[7]));
        this.eventColorsTypes[8] = Preferences.convertColors(this.getValue(hashMap, COLOR_CATEGORY8, DEFAULT_EVENTS_COLOR[8]));
        this.verticalPadding = 2;
        this.verticalInterline = 3;
    }

    public void parseSettings(DisplaySettings displaySettings, boolean bl) {
        if (bl) {
            this.setDefaultValues();
        }
        if (null != displaySettings) {
            if (-1 != displaySettings.getDisplayMode()) {
                int n = displaySettings.getDisplayMode();
                if (0 == (n & 0x800080) && !displaySettings.isShowLoad()) {
                    n |= 0x800000;
                }
                this.setDisplayMode(n);
            }
            this.setFirstSlot(displaySettings.getFirstSlot());
            this.setLastSlot(displaySettings.getLastSlot());
            this.setNbDaysLogs(displaySettings.getNbDaysLogs());
            if (null != displaySettings.getXAxis()) {
                this.setAxis(Axis.X, displaySettings.getXAxis());
            }
            if (null != displaySettings.getYAxis()) {
                this.setAxis(Axis.Y, displaySettings.getYAxis());
            }
            if (-1 != displaySettings.getAlignement()) {
                this.setAlignement(displaySettings.getAlignement());
            }
            if (-1 != displaySettings.getOrientation()) {
                this.setOrientation(displaySettings.getOrientation());
            }
            if (null != displaySettings.getFontText()) {
                this.setFontText(displaySettings.getFontText());
            }
            if (null != displaySettings.getFontColorText()) {
                this.setFontTextColor(Color.decode(displaySettings.getFontColorText()));
            }
            if (null != displaySettings.getFontLegend()) {
                this.setFontLegend(displaySettings.getFontLegend());
            }
            if (null != displaySettings.getFontColorLegend()) {
                this.setFontLegendColor(Color.decode(displaySettings.getFontColorLegend()));
            }
            if (displaySettings.isShowLoadSet()) {
                this.setShowLoad(displaySettings.isShowLoad());
            }
            if (-1 != displaySettings.getPeriodStyle()) {
                this.setPeriodStyle(displaySettings.getPeriodStyle());
            }
            if (-1 != displaySettings.getZoom()) {
                this.setZoom(displaySettings.getZoom());
            }
            if (null != displaySettings.getCostIds()) {
                this.setCostsIds(displaySettings.getCostIds());
            }
            if (null != displaySettings.isMovingCost()) {
                this.setMovingCost(displaySettings.isMovingCost());
            }
            if (-1 != displaySettings.getCostsCellsView()) {
                this.setCostsCellsView(displaySettings.getCostsCellsView());
            }
            if (-1 != displaySettings.getCostsColsRowsView()) {
                this.setCostsColsRowsView(displaySettings.getCostsColsRowsView());
            }
            if (-1 != displaySettings.getPadding()) {
                this.setVerticalPadding(displaySettings.getPadding());
            }
            if (-1 != displaySettings.getInterline()) {
                this.setVerticalInterline(displaySettings.getInterline());
            }
            if (-1 != displaySettings.getAverage()) {
                this.setAverage(displaySettings.getAverage());
            }
            this.setGroupByGroup(displaySettings.isGroupByGroup());
            if (null != displaySettings.getDisplayFields()) {
                ArrayList arrayList = displaySettings.getDisplayFields();
                this.setDisplayFields(arrayList);
            }
            if (null != displaySettings.getLegendField()) {
                this.setLegendField(Field.getByName(displaySettings.getLegendField()));
            }
            if (displaySettings.isCategoryGroupStateSet(0)) {
                boolean bl2 = displaySettings.getCategoryGroupState(0);
                this.setGroupedCategory(AxisCategory.HOUR, bl2);
                if (bl2) {
                    this.displayMode |= 0x40000;
                }
            }
            if (displaySettings.isCategoryGroupStateSet(1)) {
                this.setGroupedCategory(AxisCategory.DAY, displaySettings.getCategoryGroupState(1));
            }
            if (displaySettings.isCategoryGroupStateSet(2)) {
                this.setGroupedCategory(AxisCategory.WEEK, displaySettings.getCategoryGroupState(2));
            }
            if (displaySettings.isCategoryGroupStateSet(3)) {
                this.setGroupedCategory(AxisCategory.ENTITY, displaySettings.getCategoryGroupState(3));
            }
            if (0 < displaySettings.getEventColorsTypes(1).length()) {
                this.setEventColorsTypes(1, displaySettings.getEventColorsTypes(1));
            }
            if (0 < displaySettings.getEventColorsTypes(2).length()) {
                this.setEventColorsTypes(2, displaySettings.getEventColorsTypes(2));
            }
            if (0 < displaySettings.getEventColorsTypes(3).length()) {
                this.setEventColorsTypes(3, displaySettings.getEventColorsTypes(3));
            }
            if (0 < displaySettings.getEventColorsTypes(4).length()) {
                this.setEventColorsTypes(4, displaySettings.getEventColorsTypes(4));
            }
            if (0 < displaySettings.getEventColorsTypes(5).length()) {
                this.setEventColorsTypes(5, displaySettings.getEventColorsTypes(5));
            }
            if (0 < displaySettings.getEventColorsTypes(6).length()) {
                this.setEventColorsTypes(6, displaySettings.getEventColorsTypes(6));
            }
            if (0 < displaySettings.getEventColorsTypes(7).length()) {
                this.setEventColorsTypes(7, displaySettings.getEventColorsTypes(7));
            }
            if (0 < displaySettings.getEventColorsTypes(8).length()) {
                this.setEventColorsTypes(8, displaySettings.getEventColorsTypes(8));
            }
        }
    }

    private static final String convertColors(String string) {
        return string.replaceAll("activity", "COURSENAME").replaceAll("trainer", "TEACHERS").replaceAll("student", "STUDENTS").replaceAll("room", "CLASSROOMS").replaceAll("resource", "RESOURCES").replaceAll("category5", "PARTICIPANTS_CATEGORY5").replaceAll("category6", "PARTICIPANTS_CATEGORY6").replaceAll("category7", "PARTICIPANTS_CATEGORY7").replaceAll("category8", "PARTICIPANTS_CATEGORY8");
    }

    private String getValue(HashMap hashMap, String string) {
        return (String)hashMap.get(string);
    }

    private String getValue(HashMap hashMap, String string, String string2) {
        String string3 = this.getValue(hashMap, string);
        if (null == string3) {
            return string2;
        }
        return string3;
    }

    private ArrayList getDefaultFields() {
        ArrayList<PatternFields> arrayList = new ArrayList<PatternFields>();
        PatternFields patternFields = new PatternFields(9);
        patternFields.getFields().add(Field.NAME);
        patternFields.getFields().add(null);
        arrayList.add(patternFields);
        int n = ConfigManager.getInstance().getIntProperty(ServerProperty.NB_CATEGORIES);
        if (n >= 1) {
            patternFields = new PatternFields(1);
            patternFields.getFields().add(Field.NAME);
            patternFields.getFields().add(null);
            arrayList.add(patternFields);
        }
        if (n >= 2) {
            patternFields = new PatternFields(2);
            patternFields.getFields().add(Field.NAME);
            patternFields.getFields().add(null);
            arrayList.add(patternFields);
        }
        if (n >= 3) {
            patternFields = new PatternFields(3);
            patternFields.getFields().add(Field.NAME);
            patternFields.getFields().add(null);
            arrayList.add(patternFields);
        }
        if (n >= 4) {
            patternFields = new PatternFields(4);
            patternFields.getFields().add(Field.NAME);
            patternFields.getFields().add(null);
            arrayList.add(patternFields);
        }
        if (n >= 5) {
            patternFields = new PatternFields(5);
            patternFields.getFields().add(Field.NAME);
            patternFields.getFields().add(null);
            arrayList.add(patternFields);
        }
        if (n >= 6) {
            patternFields = new PatternFields(6);
            patternFields.getFields().add(Field.NAME);
            patternFields.getFields().add(null);
            arrayList.add(patternFields);
        }
        if (n >= 7) {
            patternFields = new PatternFields(7);
            patternFields.getFields().add(Field.NAME);
            patternFields.getFields().add(null);
            arrayList.add(patternFields);
        }
        if (n >= 8) {
            patternFields = new PatternFields(8);
            patternFields.getFields().add(Field.NAME);
            patternFields.getFields().add(null);
            arrayList.add(patternFields);
        }
        patternFields = new PatternFields(9);
        patternFields.getFields().add(Field.EVENT_TIME);
        arrayList.add(patternFields);
        return arrayList;
    }

    public int getVerticalPadding() {
        return this.verticalPadding;
    }

    public int getVerticalInterline() {
        return this.verticalInterline;
    }

    public void setVerticalPadding(int n) {
        this.verticalPadding = n;
    }

    public void setVerticalInterline(int n) {
        this.verticalInterline = n;
    }

    public int getFirstSlot() {
        return this.firstSlot;
    }

    public int getLastSlot() {
        return this.lastSlot;
    }

    public int getNbDaysLogs() {
        return this.nbDaysLogs;
    }

    public boolean isMovingCost() {
        return this.movingCost;
    }

    public void setMovingCost(boolean bl) {
        this.movingCost = bl;
    }
}

