/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.timetable;

import com.adesoft.collections.IntSet;
import com.adesoft.collections.ListUnique;
import com.adesoft.timetable.CaseEt;
import com.adesoft.timetable.EventsGroup;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class Selection
implements Cloneable {
    private final ListUnique list = new ListUnique();
    private int[] allEventOids;
    private int[] moreSelectedOids;

    public Selection() {
    }

    private Selection(List list) {
        this();
        if (null != list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.add((EventsGroup)iterator.next());
            }
        }
    }

    public Object clone() {
        ListUnique listUnique = this.getList();
        Selection selection = new Selection((List)listUnique);
        selection.moreSelectedOids = this.moreSelectedOids;
        return selection;
    }

    private ListUnique getList() {
        return this.list;
    }

    public int size() {
        return this.getList().size();
    }

    public Iterator iterator() {
        return this.getList().iterator();
    }

    public void setMoreSelectedOids(int[] nArray) {
        this.moreSelectedOids = nArray;
        if (null != this.moreSelectedOids) {
            Arrays.sort(this.moreSelectedOids);
        }
    }

    public boolean isGroupSelectedInMoreOids(EventsGroup eventsGroup) {
        if (null != this.moreSelectedOids) {
            int n = eventsGroup.size();
            for (int i = 0; i < n; ++i) {
                CaseEt caseEt = eventsGroup.getCell(i);
                if (Arrays.binarySearch(this.moreSelectedOids, caseEt.getEventOid()) >= 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean add(EventsGroup eventsGroup) {
        this.allEventOids = null;
        if (null != eventsGroup) {
            return this.getList().add((Object)eventsGroup);
        }
        return false;
    }

    public boolean remove(EventsGroup eventsGroup) {
        this.allEventOids = null;
        return this.getList().remove((Object)eventsGroup);
    }

    public EventsGroup get(int n) {
        return (EventsGroup)this.getList().get(n);
    }

    public void clear() {
        this.allEventOids = null;
        this.getList().clear();
        this.moreSelectedOids = null;
    }

    public int[] getEventOids() {
        if (null == this.allEventOids) {
            IntSet intSet = new IntSet();
            int n = this.getList().size();
            for (int i = 0; i < n; ++i) {
                EventsGroup eventsGroup = this.get(i);
                int[] nArray = eventsGroup.getEventsOids();
                for (int j = 0; j < nArray.length; ++j) {
                    intSet.add(nArray[j]);
                }
            }
            this.allEventOids = intSet.getKeys();
            Arrays.sort(this.allEventOids);
        }
        return this.allEventOids;
    }

    public boolean containsAllEvents(EventsGroup eventsGroup) {
        int[] nArray = this.getEventOids();
        int n = eventsGroup.size();
        for (int i = 0; i < n; ++i) {
            CaseEt caseEt = eventsGroup.getCell(i);
            if (Arrays.binarySearch(nArray, caseEt.getEventOid()) >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.getList().isEmpty();
    }

    public boolean contains(EventsGroup eventsGroup) {
        return this.getList().contains((Object)eventsGroup);
    }

    public boolean isAllUsable() {
        for (int i = 0; i < this.getList().size(); ++i) {
            EventsGroup eventsGroup = this.get(i);
            CaseEt[] caseEtArray = eventsGroup.getCells();
            for (int j = 0; j < caseEtArray.length; ++j) {
                if (caseEtArray[j].getEvent().isUsable()) continue;
                return false;
            }
        }
        return true;
    }

    public void addAll(EventsGroup[] eventsGroupArray) {
        if (null != eventsGroupArray) {
            this.allEventOids = null;
            this.getList().addAll((Object[])eventsGroupArray);
        }
    }

    public void retainAll(Collection collection) {
        this.allEventOids = null;
        this.getList().retainAll(collection);
    }
}

