/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.timetable;

import com.adesoft.arrays.BooleanArray;
import com.adesoft.arrays.IntArray;
import com.adesoft.arrays.StringArray;
import com.adesoft.struct.Field;
import com.dautelle.xml.sax.Attributes;
import java.awt.Color;
import java.util.Date;

public final class TempEvent {
    private final int oid;
    private final int groupOid;
    private final int slot;
    private final int duration;
    private final int id;
    private final int activityId;
    private final int session;
    private final int repetition;
    private final boolean isMultipleRepetition;
    private final boolean lunch;
    private final int groupMode;
    private final String folderName;
    private final boolean rootFolder;
    private final int absoluteDay;
    private final boolean usable;
    private final boolean note;
    private final String eventNote;
    private final boolean positionLock;
    private final boolean resourceLock;
    private final boolean unactiveKeepResourceLock;
    private final boolean workflowPending;
    private final boolean workflow;
    private final String workflowSubject;
    private final String workflowMessage;
    private final boolean strictLink;
    private final Color color;
    private final boolean isRequest;
    private final IntArray labelIds;
    private final IntArray labelTypes;
    private final StringArray labelValues;
    private final BooleanArray labelBolds;
    private double[] costs;
    private double movingCost;
    private final Date lastUpdate;

    public TempEvent(Attributes attributes) {
        this.oid = attributes.getInt((CharSequence)"oid");
        this.groupOid = attributes.getInt((CharSequence)"groupOid");
        this.slot = attributes.getInt((CharSequence)"slot");
        this.duration = attributes.getInt((CharSequence)"duration");
        this.id = attributes.getInt((CharSequence)"id");
        this.activityId = attributes.getInt((CharSequence)"courseId");
        this.session = attributes.getInt((CharSequence)"session");
        this.repetition = attributes.getInt((CharSequence)"repetition");
        this.isMultipleRepetition = attributes.getBoolean((CharSequence)"isMultipleRepetition");
        this.lunch = attributes.getBoolean((CharSequence)"isLunch", false);
        this.groupMode = attributes.getInt((CharSequence)"groupMode");
        this.folderName = attributes.getString((CharSequence)"folderName");
        this.rootFolder = attributes.getBoolean((CharSequence)"isRootFolder");
        this.absoluteDay = attributes.getInt((CharSequence)"absoluteDay");
        this.usable = attributes.getBoolean((CharSequence)"isUsable", true);
        this.note = attributes.getBoolean((CharSequence)"hasNote", false);
        this.eventNote = attributes.getString((CharSequence)"eventNote");
        this.isRequest = attributes.getBoolean((CharSequence)"request");
        long l = attributes.getLong((CharSequence)"eventLastUpdate");
        this.lastUpdate = l != -1L ? new Date(l) : null;
        this.positionLock = attributes.getBoolean((CharSequence)"isPositionLock", false);
        this.resourceLock = attributes.getBoolean((CharSequence)"isResourceLock", false);
        this.unactiveKeepResourceLock = attributes.getBoolean((CharSequence)"isUnactiveKeepResourceLock", false);
        this.workflowPending = attributes.getBoolean((CharSequence)"hasWorkflowPending", false);
        this.workflow = attributes.getBoolean((CharSequence)"hasWorkflow", false);
        this.workflowSubject = attributes.getString((CharSequence)"workflowSubject", "");
        this.workflowMessage = attributes.getString((CharSequence)"workflowMessage", "");
        this.strictLink = attributes.getBoolean((CharSequence)"hasStrictLink", false);
        this.color = new Color(attributes.getInt((CharSequence)"color"));
        this.labelIds = new IntArray();
        this.labelTypes = new IntArray();
        this.labelValues = new StringArray();
        this.labelBolds = new BooleanArray();
    }

    public Color getColor() {
        return this.color;
    }

    public int getOid() {
        return this.oid;
    }

    public int getGroupOid() {
        return this.groupOid;
    }

    public int getSlot() {
        return this.slot;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getId() {
        return this.id;
    }

    public int getActivityId() {
        return this.activityId;
    }

    public int getSession() {
        return this.session;
    }

    public int getRepetition() {
        return this.repetition;
    }

    public boolean isMultipleRepetition() {
        return this.isMultipleRepetition;
    }

    public boolean isLunch() {
        return this.lunch;
    }

    public int getAbsoluteDay() {
        return this.absoluteDay;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public int getGroupMode() {
        return this.groupMode;
    }

    public boolean isRootFolder() {
        return this.rootFolder;
    }

    public boolean isUsable() {
        return this.usable;
    }

    public boolean isNote() {
        return this.note;
    }

    public boolean hasEventNote() {
        return !this.eventNote.equalsIgnoreCase("");
    }

    public boolean isPositionLock() {
        return this.positionLock;
    }

    public boolean isResourceLock() {
        return this.resourceLock;
    }

    public boolean isUnactiveKeepResourceLock() {
        return this.unactiveKeepResourceLock;
    }

    public boolean hasWorkflowPending() {
        return this.workflowPending;
    }

    public boolean hasWorkflow() {
        return this.workflow;
    }

    public String getWorkflowSubject() {
        return this.workflowSubject;
    }

    public String getWorkflowMessage() {
        return this.workflowMessage;
    }

    public boolean hasStrictLink() {
        return this.strictLink;
    }

    public boolean isRequest() {
        return this.isRequest;
    }

    public void addLabel(int n, int n2, String string, boolean bl) {
        this.labelIds.add(n);
        this.labelTypes.add(n2);
        this.labelValues.add(string);
        this.labelBolds.add(bl);
    }

    public String[] getLabels(int n, Field field) {
        StringArray stringArray = new StringArray();
        if (null != field) {
            int n2 = field.getId();
            for (int i = 0; i < this.labelIds.size(); ++i) {
                if (n2 != this.labelIds.get(i) || n != this.labelTypes.get(i)) continue;
                stringArray.add(this.labelValues.get(i));
            }
        } else {
            stringArray.add("");
        }
        return stringArray.getValues();
    }

    public boolean[] getBolds(Field field) {
        BooleanArray booleanArray = new BooleanArray();
        int n = field.getId();
        for (int i = 0; i < this.labelIds.size(); ++i) {
            if (n != this.labelIds.get(i)) continue;
            booleanArray.add(this.labelBolds.get(i));
        }
        return booleanArray.getValues();
    }

    public String[] getLabels(boolean bl) {
        if (bl) {
            return this.labelValues.getValues();
        }
        StringArray stringArray = new StringArray();
        for (int i = 0; i < this.labelIds.size(); ++i) {
            if (this.labelIds.get(i) == Field.NAME.getId() && this.labelTypes.get(i) == 9) continue;
            stringArray.add(this.labelValues.get(i));
        }
        return stringArray.getValues();
    }

    public boolean[] getBolds(boolean bl) {
        if (bl) {
            return this.labelBolds.getValues();
        }
        BooleanArray booleanArray = new BooleanArray();
        for (int i = 0; i < this.labelIds.size(); ++i) {
            if (this.labelIds.get(i) == Field.NAME.getId() && this.labelTypes.get(i) == 9) continue;
            booleanArray.add(this.labelBolds.get(i));
        }
        return booleanArray.getValues();
    }

    public void setCosts(double[] dArray) {
        this.costs = dArray;
    }

    public double[] getCosts() {
        return this.costs;
    }

    public double getTotalCost(boolean bl) {
        double d = 0.0;
        if (this.costs != null) {
            for (int i = 0; i < this.costs.length; ++i) {
                d += this.costs[i];
            }
        }
        double d2 = 0.0;
        if (bl) {
            d2 = this.getMovingCost();
        }
        return d + d2;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public double getMovingCost() {
        return this.movingCost;
    }

    public void setMovingCost(double d) {
        this.movingCost = d;
    }
}

