/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.timetable;

import com.adesoft.arrays.StringArray;
import com.adesoft.engine.AbstractXmlReader;
import com.adesoft.timetable.Column;
import com.adesoft.timetable.ColumnInfo;
import com.adesoft.timetable.EmptyColumn;
import com.adesoft.timetable.EtData;
import com.adesoft.timetable.EtGrid;
import com.adesoft.timetable.Header;
import com.adesoft.timetable.HeaderDay;
import com.adesoft.timetable.HeaderEntity;
import com.adesoft.timetable.HeaderWeek;
import com.adesoft.timetable.HistoData;
import com.adesoft.timetable.NonEmptyColumn;
import com.adesoft.timetable.TempEvent;
import com.dautelle.xml.sax.Attributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class XmlReaderTimetable
extends AbstractXmlReader {
    private final StringArray costNames = new StringArray();
    private final ArrayList columns;
    private final List events = new ArrayList();
    private int nbSlots;
    private int granularity;
    private Header hRoot;
    private Header vRoot;
    private Header currentHeader;
    private EtGrid grid;
    private int exploreMode;
    private ColumnInfo columnInfo;
    private int maxQuantity;
    private TempEvent currentEvent;
    private boolean[] avail;
    private int[] occupation;
    private double[] costs;
    private double movingCost;
    private HistoData histoData;
    private boolean[] allAvailable;
    private int currentSlot;

    public XmlReaderTimetable() {
        this.columns = new ArrayList();
    }

    public EtGrid getGrid() {
        if (null == this.grid && null != this.vRoot && null != this.hRoot) {
            Header[] headerArray = this.vRoot.getLeaves();
            Header[] headerArray2 = this.hRoot.getLeaves();
            int n = headerArray2.length;
            int n2 = headerArray.length;
            this.grid = new EtGrid(n2, this.granularity, this.nbSlots, this.costNames.getValues(), this.histoData);
            this.grid.setHRoot(this.hRoot);
            this.grid.setVRoot(this.vRoot);
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                EtData etData = new EtData();
                this.grid.setTimetable(i, etData);
                for (int j = 0; j < n; ++j) {
                    Column column = (Column)this.columns.get(n3++);
                    etData.addColumn(column);
                }
            }
        }
        return this.grid;
    }

    @Override
    protected void sax(CharSequence charSequence, Attributes attributes) throws Exception {
        try {
            if (charSequence.equals("grid")) {
                this.nbSlots = attributes.getInt((CharSequence)"nbSlots");
                this.granularity = attributes.getInt((CharSequence)"granularity");
                this.exploreMode = 11;
            } else if (charSequence.equals("column")) {
                this.columnInfo = new ColumnInfo(attributes);
                this.events.clear();
                this.avail = null;
                this.occupation = null;
            } else if (charSequence.equals("histo")) {
                int n = attributes.getInt((CharSequence)"max");
                int n2 = attributes.getInt((CharSequence)"nbWeeks");
                int n3 = attributes.getInt((CharSequence)"nbDays");
                int n4 = attributes.getInt((CharSequence)"average", -1);
                this.histoData = new HistoData(new int[n2][n3][this.nbSlots], n, n4);
            } else if (charSequence.equals("quantity")) {
                int n = attributes.getInt((CharSequence)"week");
                int n5 = attributes.getInt((CharSequence)"day");
                int n6 = attributes.getInt((CharSequence)"slot");
                int n7 = attributes.getInt((CharSequence)"value");
                this.histoData.setValue(n, n5, n6, n7);
            } else if (charSequence.equals("costname")) {
                this.costNames.add(attributes.getString((CharSequence)"name"));
            } else if (charSequence.equals("label")) {
                int n = attributes.getInt((CharSequence)"id");
                int n8 = attributes.getInt((CharSequence)"type");
                String string = attributes.getString((CharSequence)"value");
                boolean bl = attributes.getBoolean((CharSequence)"isBold", false);
                this.currentEvent.addLabel(n, n8, string, bl);
            } else if (charSequence.equals("jumpLine")) {
                this.currentEvent.addLabel(-1, -1, null, false);
            } else if (charSequence.equals("cost")) {
                if (null == this.costs) {
                    this.currentSlot = 0;
                    this.costs = new double[this.costNames.size()];
                }
                this.costs[this.currentSlot++] = attributes.getDouble((CharSequence)"value");
            } else if (charSequence.equals("movingCost")) {
                this.movingCost = attributes.getDouble((CharSequence)"value");
            } else if (charSequence.equals("header")) {
                Header header;
                String string = attributes.getString((CharSequence)"title");
                boolean bl = attributes.getBoolean((CharSequence)"visible", true);
                String string2 = attributes.getString((CharSequence)"type");
                if (string2.equals("entity")) {
                    int[] nArray = new int[]{attributes.getInt((CharSequence)"entityId")};
                    int[] nArray2 = new int[]{attributes.getInt((CharSequence)"entityCategory")};
                    header = new HeaderEntity(null, nArray, nArray2, string, bl);
                } else {
                    header = string2.equals("week") ? new HeaderWeek(string, bl) : (string2.equals("day") ? new HeaderDay(string, bl) : new Header(string, bl));
                }
                if (null != this.currentHeader) {
                    this.currentHeader.add(header);
                } else if (null == this.hRoot) {
                    this.hRoot = header;
                } else {
                    this.vRoot = header;
                }
                this.currentHeader = header;
            } else if (charSequence.equals("timeframe")) {
                this.avail = new boolean[this.nbSlots];
                Arrays.fill(this.avail, true);
            } else if (charSequence.equals("slot")) {
                this.avail[attributes.getInt((CharSequence)"slot")] = false;
            } else if (charSequence.equals("occupation")) {
                this.occupation = new int[this.nbSlots];
                this.currentSlot = 0;
                this.maxQuantity = attributes.getInt((CharSequence)"max");
            } else if (charSequence.equals("used")) {
                this.occupation[this.currentSlot++] = attributes.getInt((CharSequence)"quantity");
            } else if (charSequence.equals("event")) {
                this.costs = null;
                this.currentEvent = new TempEvent(attributes);
                this.events.add(this.currentEvent);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    protected void endSax(CharSequence charSequence) throws Exception {
        if (charSequence.equals("header")) {
            this.currentHeader = this.currentHeader.getFather();
        } else if (charSequence.equals("event")) {
            if (null != this.costs) {
                this.currentEvent.setCosts(this.costs);
            }
            this.currentEvent.setMovingCost(this.movingCost);
        } else if (charSequence.equals("column")) {
            Column column;
            if (this.events.isEmpty()) {
                column = new EmptyColumn(this.columnInfo, this.exploreMode, this.nbSlots);
            } else {
                TempEvent[] tempEventArray = new TempEvent[this.events.size()];
                this.events.toArray(tempEventArray);
                column = new NonEmptyColumn(this.columnInfo, tempEventArray, this.exploreMode, this.nbSlots);
            }
            column.setUsed(this.columnInfo.isUsed());
            if (null != this.avail) {
                column.setTimeframe(this.avail);
            } else {
                if (null == this.allAvailable) {
                    this.allAvailable = new boolean[this.nbSlots];
                    Arrays.fill(this.allAvailable, true);
                }
                column.setTimeframe(this.allAvailable);
            }
            if (null != this.occupation) {
                column.setOccupationInfo(this.occupation, this.maxQuantity);
            }
            this.columns.add(column);
        }
    }
}

