/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.webcallback;

import com.adesoft.javaengine.InfoConflictGroup;
import com.adesoft.login.IWebClientCallback;
import com.adesoft.misc.HttpUrlParam;
import com.adesoft.misc.HttpUtils;
import com.adesoft.proxy.ListCourseInfo;
import com.adesoft.proxy.ListEntityInfo;
import com.adesoft.proxy.ListEtEventInfo;
import com.adesoft.proxy.ListLinkInfo;
import com.adesoft.server.Identifier;
import com.adesoft.struct.Course;
import com.adesoft.struct.Entity;
import com.adesoft.struct.EtEvent;
import com.adesoft.struct.Project;
import com.adesoft.webcallback.BrowseQuery;
import com.adesoft.webcallback.ChangeSettings;
import com.adesoft.webcallback.Kick;
import com.adesoft.webcallback.NavQuery;
import com.adesoft.webcallback.OpenProject;
import com.adesoft.webcallback.RefreshView;
import com.adesoft.webcallback.ShowAlert;
import com.adesoft.webcallback.ShowConflicts;
import com.adesoft.webcallback.ShowInput;
import com.adesoft.webcallback.ShowMessage;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultWebClientCallback
implements IWebClientCallback {
    private static final long serialVersionUID = 1916812231112597414L;
    private Identifier identifier = null;
    private String callbackUrl = null;
    private Map<Long, StringBuffer> inputMap = new ConcurrentHashMap<Long, StringBuffer>();

    protected HttpUrlParam getHttpCallbackUrl() {
        return new HttpUrlParam(this.callbackUrl, "");
    }

    @Override
    public void notifySettingsChange(int[] nArray, int[] nArray2, String[] stringArray, String[] stringArray2, String[] stringArray3, int n) throws RemoteException {
        ChangeSettings changeSettings = new ChangeSettings(this.identifier.getIdentifierString());
        changeSettings.setYears(nArray);
        changeSettings.setMonths(nArray2);
        changeSettings.setDays(stringArray2);
        changeSettings.setSlots(stringArray3);
        changeSettings.setGranularity(n);
        HttpUtils.post((HttpUrlParam)this.getHttpCallbackUrl(), (Serializable)changeSettings);
    }

    @Override
    public void showMessage(String string) throws RemoteException {
        HttpUtils.post((HttpUrlParam)this.getHttpCallbackUrl(), (Serializable)new ShowMessage(this.identifier.getIdentifierString(), string));
    }

    @Override
    public void kick() throws RemoteException {
        HttpUtils.post((HttpUrlParam)this.getHttpCallbackUrl(), (Serializable)new Kick(this.identifier.getIdentifierString()));
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String string) {
        this.callbackUrl = string;
    }

    @Override
    public void selectEvents(ListEtEventInfo listEtEventInfo) throws RemoteException {
        StringBuffer stringBuffer = new StringBuffer("nav?view=plan");
        EtEvent[] etEventArray = listEtEventInfo.getObjects();
        if (etEventArray.length > 0) {
            stringBuffer.append("&");
            stringBuffer.append("event");
            stringBuffer.append("=");
            int n = etEventArray.length - 1;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(etEventArray[i].getId());
                stringBuffer.append(",");
            }
            stringBuffer.append(etEventArray[etEventArray.length - 1].getId());
        }
        HttpUtils.post((HttpUrlParam)this.getHttpCallbackUrl(), (Serializable)new NavQuery(this.identifier.getIdentifierString(), stringBuffer.toString()));
    }

    @Override
    public void selectActivity(ListCourseInfo listCourseInfo) throws RemoteException {
        StringBuffer stringBuffer = new StringBuffer("nav?view=course");
        Course[] courseArray = listCourseInfo.getObjects();
        if (courseArray.length > 0) {
            stringBuffer.append("&");
            stringBuffer.append("treeData");
            stringBuffer.append("=");
            int n = courseArray.length - 1;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(courseArray[i].getId());
                stringBuffer.append(",");
            }
            stringBuffer.append(courseArray[courseArray.length - 1].getId());
        }
        HttpUtils.post((HttpUrlParam)this.getHttpCallbackUrl(), (Serializable)new NavQuery(this.identifier.getIdentifierString(), stringBuffer.toString()));
    }

    @Override
    public void selectParticipant(ListEntityInfo listEntityInfo) throws RemoteException {
        StringBuffer stringBuffer = new StringBuffer("nav?view=resource");
        Entity[] entityArray = listEntityInfo.getObjects();
        if (entityArray.length > 0) {
            stringBuffer.append("&");
            stringBuffer.append("treeData");
            stringBuffer.append("=");
            int n = entityArray.length - 1;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(entityArray[i].getId());
                stringBuffer.append(",");
            }
            stringBuffer.append(entityArray[entityArray.length - 1].getId());
        }
        HttpUtils.post((HttpUrlParam)this.getHttpCallbackUrl(), (Serializable)new NavQuery(this.identifier.getIdentifierString(), stringBuffer.toString()));
    }

    @Override
    public void selectLink(ListLinkInfo listLinkInfo) throws RemoteException {
        StringBuffer stringBuffer = new StringBuffer("nav?view=link");
        int[] nArray = listLinkInfo.getListLockable().getIds();
        if (nArray.length > 0) {
            stringBuffer.append("&");
            stringBuffer.append("link");
            stringBuffer.append("=");
            int n = nArray.length - 1;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(nArray[i]);
                stringBuffer.append(",");
            }
            stringBuffer.append(nArray[nArray.length - 1]);
        }
        HttpUtils.post((HttpUrlParam)this.getHttpCallbackUrl(), (Serializable)new NavQuery(this.identifier.getIdentifierString(), stringBuffer.toString()));
    }

    @Override
    public void selectPlanning(ListEntityInfo listEntityInfo) throws RemoteException {
        this.selectPlanning(listEntityInfo, null, null);
    }

    @Override
    public void selectPlanning(ListEntityInfo listEntityInfo, int[] nArray, int[] nArray2) throws RemoteException {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer("nav?view=plan");
        Entity[] entityArray = listEntityInfo.getObjects();
        if (entityArray.length > 0) {
            stringBuffer.append("&");
            stringBuffer.append("treeData");
            stringBuffer.append("=");
            n2 = entityArray.length - 1;
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(entityArray[n].getId());
                stringBuffer.append(",");
            }
            stringBuffer.append(entityArray[entityArray.length - 1].getId());
        }
        if (nArray != null && nArray.length > 0) {
            stringBuffer.append("&");
            stringBuffer.append("week");
            stringBuffer.append("=");
            n2 = nArray.length - 1;
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(nArray[n]);
                stringBuffer.append(",");
            }
            stringBuffer.append(nArray[nArray.length - 1]);
        }
        if (nArray2 != null && nArray2.length > 0) {
            stringBuffer.append("&");
            stringBuffer.append("day");
            stringBuffer.append("=");
            n2 = nArray2.length - 1;
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(nArray2[n]);
                stringBuffer.append(",");
            }
            stringBuffer.append(nArray2[nArray2.length - 1]);
        }
        HttpUtils.post((HttpUrlParam)this.getHttpCallbackUrl(), (Serializable)new NavQuery(this.identifier.getIdentifierString(), stringBuffer.toString()));
    }

    @Override
    public void openProject(Project project) throws RemoteException {
        HttpUtils.post((HttpUrlParam)this.getHttpCallbackUrl(), (Serializable)new OpenProject(this.identifier.getIdentifierString(), project.getId(), project.getName()));
    }

    @Override
    public void showAlert(String string) throws RemoteException {
        HttpUtils.post((HttpUrlParam)this.getHttpCallbackUrl(), (Serializable)new ShowAlert(this.identifier.getIdentifierString(), string));
    }

    @Override
    public void refreshActivities() throws RemoteException {
        HttpUtils.post((HttpUrlParam)this.getHttpCallbackUrl(), (Serializable)new RefreshView(this.identifier.getIdentifierString(), "course"));
    }

    @Override
    public void refreshResources() throws RemoteException {
        HttpUtils.post((HttpUrlParam)this.getHttpCallbackUrl(), (Serializable)new RefreshView(this.identifier.getIdentifierString(), "resource"));
    }

    @Override
    public void refreshPlanning() throws RemoteException {
        HttpUtils.post((HttpUrlParam)this.getHttpCallbackUrl(), (Serializable)new RefreshView(this.identifier.getIdentifierString(), "plan"));
    }

    @Override
    public void showConflicts(InfoConflictGroup infoConflictGroup, boolean bl, boolean bl2) throws RemoteException {
        ShowConflicts showConflicts = new ShowConflicts(this.getIdentifier().getIdentifierString(), infoConflictGroup, bl, bl2);
        HttpUrlParam httpUrlParam = new HttpUrlParam(this.callbackUrl, "");
        HttpUtils.post((HttpUrlParam)httpUrlParam, (Serializable)showConflicts);
    }

    @Override
    public void openBrowser(String string, String string2) throws RemoteException {
        HttpUtils.post((HttpUrlParam)this.getHttpCallbackUrl(), (Serializable)new BrowseQuery(this.identifier.getIdentifierString(), string, string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String showInputDialog(String string, int n) throws RemoteException {
        long l = System.currentTimeMillis();
        StringBuffer stringBuffer = new StringBuffer();
        this.inputMap.put(l, stringBuffer);
        HttpUtils.post((HttpUrlParam)this.getHttpCallbackUrl(), (Serializable)new ShowInput(this.identifier.getIdentifierString(), string, l));
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            try {
                long l2 = 1000 * n;
                stringBuffer.wait(l2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.inputMap.remove(l);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInputValue(long l, String string) {
        StringBuffer stringBuffer = this.inputMap.remove(l);
        if (stringBuffer != null) {
            StringBuffer stringBuffer2 = stringBuffer;
            synchronized (stringBuffer2) {
                stringBuffer.append(string);
                stringBuffer.notify();
            }
        }
    }

    @Override
    public void setWebServerUrl(String string) {
        if (string == null) {
            return;
        }
        this.callbackUrl = string;
        this.callbackUrl = !this.callbackUrl.endsWith("/") ? this.callbackUrl + "/ClientCallback" : this.callbackUrl + "ClientCallback";
    }
}

