/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.config;

import com.adesoft.config.ConfigServer;
import com.adesoft.config.RemoteConfig;
import com.adesoft.config.readers.AbstractReader;
import com.adesoft.log.Category;
import com.adesoft.misc.RMIUtil;
import com.adesoft.misc.Util;
import com.adesoft.properties.ServerProperties;
import com.adesoft.properties.ServerProperty;
import com.adesoft.rmi.GlobalRMIFlags;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

public final class ServerLocation {
    private static final Category LOG = Category.getInstance((String)"com.adesoft.config.ServerLocation");
    private static final String SERVER = "Server";
    private static final String RMI_REGISTRY_PORT = "RmiRegistryPort";
    private static final String RMI_NAME = "RmiName";
    private static final String WEB_CALLBACK = "WebCallback";
    private static final String WEB_CALLBACK_URL = "WebCallbackUrl";
    private static final String WEB_CALLBACK_TIMEOUT = "WebCallbackTimeout";
    private static ServerLocation instance;
    private ConfigServer server;
    private RemoteConfig remoteConfig;
    private String[] commandLineArgs;
    private String host;
    private String name;
    private int port;
    private boolean loaded;
    private String basePath = "";
    private boolean webCallback = false;
    private String webCallbackUrl;
    private int webCallbackTimeout = 10;

    private ServerLocation(String string) {
        this.reset();
        this.basePath = string;
    }

    private ServerLocation() {
        this.reset();
    }

    public static synchronized ServerLocation getInstance() {
        if (instance == null) {
            instance = new ServerLocation();
        }
        return instance;
    }

    public static synchronized ServerLocation getInstance(String string) {
        if (instance == null) {
            instance = new ServerLocation(string);
        }
        return instance;
    }

    public void reset() {
        this.server = null;
        this.remoteConfig = null;
        this.host = null;
        this.name = null;
        this.port = 0;
        this.loaded = false;
    }

    public void parseCommandLine(String[] stringArray) {
        this.commandLineArgs = stringArray;
    }

    private File getPropertiesFile(String string) {
        String[] stringArray = new String[]{"Client.properties", "Web.properties", "Spy.properties", "Engine.properties"};
        String string2 = "";
        File file = new File("");
        if (-1 != file.getAbsolutePath().toLowerCase().indexOf("eclipse")) {
            string2 = System.getProperty("user.dir").substring(0, System.getProperty("user.dir").lastIndexOf(File.separator) + 1) + "Web" + File.separator;
        }
        if (string != null && !"".equals(string)) {
            string2 = string + File.separator;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(string2 + stringArray[i]);
            if (!file2.exists()) continue;
            LOG.debug((Object)("Server configuration file: " + file2.getAbsolutePath()));
            return file2;
        }
        LOG.error((Object)("Server configuration file not found in " + string2));
        throw new RuntimeException("Server configuration file not found");
    }

    private synchronized void load() {
        if (!this.loaded) {
            Object object;
            Serializable serializable;
            boolean bl = false;
            try {
                serializable = Class.forName("com.adesoft.serverimpl.MainServerImpl");
                object = ((Class)serializable).getMethod("getInstance", null).invoke(null, null);
                if (object != null) {
                    this.host = ServerProperties.getInstance().get(ServerProperty.SERVER);
                    this.port = ServerProperties.getInstance().getInt(ServerProperty.REGISTRY_PORT);
                    this.name = ServerProperties.getInstance().get(ServerProperty.RMI_NAME);
                    bl = true;
                    this.loaded = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!bl) {
                if (this.commandLineArgs != null && this.commandLineArgs.length != 0) {
                    serializable = new HashMap();
                    Util.parseCommandLine((String[])this.commandLineArgs, serializable);
                    if (serializable.get(SERVER) != null) {
                        this.host = (String)serializable.get(SERVER);
                    }
                    if (serializable.get(RMI_REGISTRY_PORT) != null) {
                        this.port = Integer.parseInt((String)serializable.get(RMI_REGISTRY_PORT));
                    }
                    if (serializable.get(RMI_NAME) != null) {
                        this.name = (String)serializable.get(RMI_NAME);
                    }
                    if (serializable.get(WEB_CALLBACK) != null) {
                        this.webCallback = Boolean.parseBoolean((String)serializable.get(WEB_CALLBACK));
                    }
                    if (this.webCallback) {
                        if (serializable.get(WEB_CALLBACK_URL) != null) {
                            this.webCallbackUrl = (String)serializable.get(WEB_CALLBACK_URL);
                        }
                        if (serializable.get(WEB_CALLBACK_TIMEOUT) != null) {
                            try {
                                this.webCallbackTimeout = Integer.parseInt((String)serializable.get(WEB_CALLBACK_TIMEOUT));
                            }
                            catch (Exception exception) {
                                LOG.error((Object)"Wrong WebCallbackTimeout value, the tiemout is set to 10min.");
                            }
                        }
                    }
                }
                if (this.host != null && this.name != null || this.port > 0) {
                    this.loaded = true;
                } else {
                    serializable = this.getPropertiesFile(this.basePath);
                    try {
                        object = AbstractReader.readPropertiesFile(serializable);
                        this.host = (String)object.get(SERVER);
                        this.port = Integer.parseInt((String)object.get(RMI_REGISTRY_PORT));
                        this.name = (String)object.get(RMI_NAME);
                        if (object.containsKey(WEB_CALLBACK)) {
                            this.webCallback = Boolean.parseBoolean((String)object.get(WEB_CALLBACK));
                        }
                        if (this.webCallback) {
                            if (object.containsKey(WEB_CALLBACK_URL)) {
                                this.webCallbackUrl = (String)object.get(WEB_CALLBACK_URL);
                            }
                            if (object.containsKey(WEB_CALLBACK_TIMEOUT)) {
                                try {
                                    this.webCallbackTimeout = Integer.parseInt((String)object.get(WEB_CALLBACK_TIMEOUT));
                                }
                                catch (Exception exception) {
                                    LOG.error((Object)"Wrong WebCallbackTimeout value, the tiemout is set to 10min.");
                                }
                            }
                        }
                        this.loaded = true;
                    }
                    catch (Throwable throwable) {
                        LOG.error((Object)("Unable to read configuration file : " + throwable));
                    }
                }
            }
        }
    }

    public String getServerName() {
        this.load();
        return this.name;
    }

    public String getServerHost() {
        this.load();
        return this.host;
    }

    public int getServerPort() {
        this.load();
        return this.port;
    }

    ConfigServer getServer() {
        if (this.server == null) {
            LOG.debug((Object)"Connecting to the server");
            String string = this.getServerHost();
            String string2 = this.getServerName();
            int n = this.getServerPort();
            if (string == null || string.equals("")) {
                LOG.debug((Object)"Local mode...");
                GlobalRMIFlags.getInstance().setLocalMode(true);
                try {
                    Class[] classArray = new Class[]{String[].class};
                    Object[] objectArray = new Object[]{this.commandLineArgs};
                    this.server = (ConfigServer)Util.newInstance((String)"com.adesoft.serverimpl.MainServerImpl", (Class[])classArray, (Object[])objectArray);
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    LOG.error((Object)throwable);
                    if (throwable instanceof InvocationTargetException) {
                        throwable2 = ((InvocationTargetException)throwable).getTargetException();
                    }
                    if (throwable2 instanceof RuntimeException) {
                        throw (RuntimeException)throwable2;
                    }
                    if (throwable2.getMessage() == null) {
                        throw new RuntimeException("Unable to create local server.");
                    }
                    throw new RuntimeException("Unable to create local server." + throwable2.getMessage());
                }
            } else {
                LOG.debug((Object)("Client/Server mode... (" + string + ")"));
                this.server = (ConfigServer)RMIUtil.getServer((String)string, (String)string2, (int)n);
            }
            LOG.debug((Object)"Completed");
        }
        return this.server;
    }

    public RemoteConfig getRemoteConfig() {
        if (this.remoteConfig == null) {
            try {
                this.remoteConfig = this.getServer().getRemoteConfig();
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Unable to connect to the server : " + throwable);
            }
        }
        return this.remoteConfig;
    }

    public String getWebCallbackUrl() {
        return this.webCallbackUrl;
    }

    public boolean isWebCallback() {
        return this.webCallback;
    }

    public int getWebCallbackTimeout() {
        return this.webCallbackTimeout;
    }
}

