/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.config.readers;

import com.adesoft.arrays.StringArray;
import com.adesoft.config.readers.AbstractReader;
import com.adesoft.log.Category;
import java.io.File;
import java.util.Locale;

public final class HtmlReader
extends AbstractReader {
    private static final Category LOG = Category.getInstance((String)"com.adesoft.config.readers.HtmlReader");
    private final Locale locale;
    private final String extension;

    public HtmlReader(String string, Locale locale) {
        super(string);
        this.locale = locale;
        this.extension = ".html";
    }

    public HtmlReader(String string, String string2, Locale locale) {
        super(string);
        this.locale = locale;
        this.extension = string2;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getExtension() {
        return this.extension;
    }

    private String findSuffix() {
        StringArray stringArray = new StringArray();
        stringArray.add("_" + this.getLocale().getLanguage() + "_" + this.getLocale().getCountry() + "_" + this.getLocale().getVariant() + this.getExtension());
        stringArray.add("_" + this.getLocale().getLanguage() + "_" + this.getLocale().getCountry() + this.getExtension());
        stringArray.add("_" + this.getLocale().getLanguage() + this.getExtension());
        stringArray.add(this.getExtension());
        stringArray.add("_en" + this.getExtension());
        for (int i = 0; i < stringArray.size(); ++i) {
            String string = this.getDefaultConfigFolder() + this.getName() + stringArray.get(i);
            File file = new File(string);
            if (!file.exists()) continue;
            return stringArray.get(i);
        }
        throw new RuntimeException("Unable to find the template file for Locale : " + this.getLocale());
    }

    public File getFile() {
        File file = null;
        Throwable throwable = null;
        String string = this.findSuffix();
        try {
            File[] fileArray = this.getCustomFiles(this.getName() + string);
            if (!this.isReplaceMode() || !this.isReadCustomFiles() || 0 == fileArray.length) {
                file = this.getDefaultFile(this.getName() + string);
            }
            if (this.isReadCustomFiles()) {
                for (int i = 0; i < fileArray.length; ++i) {
                    file = fileArray[i];
                }
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (null != throwable) {
            throw new RuntimeException("Unable to find the template file for Locale : " + this.getLocale() + ". " + throwable);
        }
        if (null == file) {
            throw new RuntimeException("Unable to find the template file for Locale : " + this.getLocale());
        }
        return file;
    }

    public String read() {
        LOG.debug((Object)("Read template for locale " + this.getLocale()));
        String string = "";
        Throwable throwable = null;
        try {
            String string2 = this.findSuffix();
            File[] fileArray = this.getCustomFiles(this.getName() + string2);
            if (!this.isReplaceMode() || !this.isReadCustomFiles() || 0 == fileArray.length) {
                string = HtmlReader.readFile(this.getDefaultFile(this.getName() + string2));
            }
            if (this.isReadCustomFiles()) {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (this.isReplaceMode()) {
                        string = "";
                    }
                    string = string + HtmlReader.readFile(fileArray[i]);
                }
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (null != throwable) {
            throw new RuntimeException("Unable to find the template file for Locale : " + this.getLocale() + ". " + throwable);
        }
        return string;
    }
}

