/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.config.readers;

import com.adesoft.config.readers.XmlReader;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Element;

public final class ReadersManager {
    private static ReadersManager instance;
    private final Map _readCustomByName = new TreeMap();
    private final Map _replaceModeByName = new TreeMap();

    private ReadersManager() {
        this.load();
    }

    private void load() {
        Element element = new XmlReader("FilesConfiguration", true, true).read();
        Iterator iterator = element.children();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            String string = element2.getString("name");
            boolean bl = element2.getBoolean("readCustom");
            boolean bl2 = element2.getBoolean("replaceMode");
            this._replaceModeByName.put(string, bl2);
            this._readCustomByName.put(string, bl);
        }
    }

    public static synchronized ReadersManager getInstance() {
        if (null == instance) {
            instance = new ReadersManager();
        }
        return instance;
    }

    public boolean isReadCustomFiles(String string) {
        Boolean bl = (Boolean)this._readCustomByName.get(string);
        return null == bl ? true : bl;
    }

    public boolean isReplaceMode(String string) {
        Boolean bl = (Boolean)this._replaceModeByName.get(string);
        return null == bl ? true : bl;
    }
}

