/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.modules;

import com.adesoft.arrays.StringArray;
import com.adesoft.config.ConfigManager;
import com.adesoft.log.Category;
import com.adesoft.modules.Modules;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;

public final class ModulesManager {
    private static final Category LOG = Category.getInstance((String)"com.adesoft.modules.ModulesManager");
    private static final String MODULES_FILE = "Modules";
    private static ModulesManager instance;
    private final Map infoByName = new HashMap();
    private final Map fieldsByName = new HashMap();

    private ModulesManager() {
        this.load();
    }

    private void load() {
        Element element = ConfigManager.getInstance().readXmlFile(MODULES_FILE);
        for (Element element2 : element.getChildren("module")) {
            Element element32;
            String string = element2.getAttributeValue("name");
            StringArray stringArray = new StringArray();
            for (Element element32 : element2.getChildren("field")) {
                stringArray.add(element32.getAttributeValue("name"));
            }
            element32 = stringArray.getValues();
            String string2 = element2.getAttributeValue("info");
            this.infoByName.put(string, string2);
            this.fieldsByName.put(string, element32);
        }
    }

    public static synchronized ModulesManager getInstance() {
        if (null == instance) {
            instance = new ModulesManager();
        }
        return instance;
    }

    public String getInfo(Modules modules) {
        String string = (String)this.infoByName.get(modules.getName());
        if (null == string) {
            LOG.debug((Object)("No information for module : " + modules.getName()));
            return "";
        }
        return string;
    }

    public String[] getFields(Modules modules) {
        String[] stringArray = (String[])this.fieldsByName.get(modules.getName());
        if (null == stringArray) {
            LOG.debug((Object)("No fields for module : " + modules.getName()));
            return new String[0];
        }
        return stringArray;
    }
}

