/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.properties;

import com.adesoft.log.Category;
import com.adesoft.properties.AbstractProperty;
import java.io.File;
import java.io.Serializable;
import java.util.TreeMap;
import java.util.TreeSet;

public final class ClientProperty
extends AbstractProperty
implements Serializable {
    private static final long serialVersionUID = 520L;
    private static final Category LOG = Category.getInstance((String)"com.adesoft.properties.AdeProperties");
    public static final int ROOT_ONLY = 4;
    public static final int EXPERT = 8;
    public static final int XML = 16;
    private static final String[] deleteResource = new String[]{"0", "1", "2", "3"};
    private static final TreeMap indexByName = new TreeMap();
    public static final ClientProperty PRINT_HEADER_SIZE = ClientProperty.CLIENT("PrintHeaderSize", 16, 7);
    public static final ClientProperty PRINT_FOOTER_SIZE = ClientProperty.CLIENT("PrintFooterSize", 16, 7);
    public static final ClientProperty TIMETABLE_VERTICAL_SPACE = ClientProperty.CLIENT("TimetableVerticalSpace", 16, 2);
    public static final ClientProperty TIMETABLE_EMPTY_LINE = ClientProperty.CLIENT("TimetableEmptyLine", 16, 2);
    public static final ClientProperty VISUALIZATION_CONFIGURATION = ClientProperty.CLIENT("VisualizationConfiguration", 24, -1);
    public static final ClientProperty ENGINE_CONFIGURATION = ClientProperty.CLIENT("EngineConfiguration", 24, -1);
    public static final ClientProperty DAY_CONFIGS = ClientProperty.CLIENT("DayConfigs", 16, "");
    public static final ClientProperty WEEK_CONFIGS = ClientProperty.CLIENT("WeekConfigs", 16, "");
    public static final ClientProperty SEARCH_EVENT_OTHER_WEEKS = ClientProperty.CLIENT("SearchEventOtherWeeks", 16, false);
    public static final ClientProperty AUTO_EDIT_CONFIGURATION = ClientProperty.CLIENT("AutoEditConfiguration", 16, true);
    public static final ClientProperty SHOW_LINK_CREATE_TEXT = ClientProperty.CLIENT("ShowLinkCreateText", 16, true);
    public static final ClientProperty TRASH_SMART_FILTER = ClientProperty.CLIENT("TrashSmartFilter", 16, true);
    public static final ClientProperty COLUMNS_ADD_PARTICIPANT = ClientProperty.CLIENT("ColumnsAddParticipant", 24, "");
    public static final ClientProperty COLUMNS_EVENT_RESOURCE_SELECTION = ClientProperty.CLIENT("ColumnsEventResourceSelection", 16, "");
    public static final ClientProperty COLUMNS_WORKFLOW_USERS = ClientProperty.CLIENT("ColumnsWorkflowUsers", 24, "NAME");
    public static final ClientProperty COLUMNS_COURSES_PARTICIPANTS = ClientProperty.CLIENT("ColumnsCoursesParticipants", 24, "COLOR,COURSE_PARTICIPANTS_TITLE,PATH");
    public static final ClientProperty PING_INTERVAL = ClientProperty.CLIENT("PingInterval", 0, 10000);
    public static final ClientProperty CHECK_WORKFLOW = ClientProperty.CLIENT("CheckWorkflow", 0, 60000);
    public static final ClientProperty ENABLE_TOOLBAR = ClientProperty.CLIENT("EnableToolbar", 0, true);
    public static final ClientProperty CONFIRM_ACTIVATE_ACTIVITY = ClientProperty.CLIENT("ConfirmActivateActivity", 16, true);
    public static final ClientProperty CONFIRM_REMOVE_GRANT = ClientProperty.CLIENT("ConfirmRemoveGrant", 16, true);
    public static final ClientProperty CONFIRM_DELETE_USER = ClientProperty.CLIENT("ConfirmDeleteUser", 16, true);
    public static final ClientProperty CONFIRM_DELETE_PROJECT = ClientProperty.CLIENT("ConfirmDeleteProject", 16, true);
    public static final ClientProperty CONFIRM_DELETE_ACTIVITY = ClientProperty.CLIENT("ConfirmDeleteActivity", 16, true);
    public static final ClientProperty CONFIRM_DELETE_COST = ClientProperty.CLIENT("ConfirmDeleteCost", 16, true);
    public static final ClientProperty CONFIRM_DELETE_ACTIVITY_PARTICIPANT = ClientProperty.CLIENT("ConfirmDeleteActivityParticipant", 16, true);
    public static final ClientProperty CONFIRM_DELETE_LINK = ClientProperty.CLIENT("ConfirmDeleteLink", 16, true);
    public static final ClientProperty CONFIRM_UNSCHEDULE_ACTIVITY = ClientProperty.CLIENT("ConfirmUnscheduleActivity", 16, true);
    public static final ClientProperty CONFIRM_UNSCHEDULE_ACTIVITY_DRAG_DROP = ClientProperty.CLIENT("ConfirmUnscheduleActivityDragDrop", 16, true);
    public static final ClientProperty CONFIRM_DELETE_CONFIGURATION = ClientProperty.CLIENT("ConfirmDeleteConfiguration", 16, true);
    public static final ClientProperty CONFIRM_MOVE_RESOURCES = ClientProperty.CLIENT("ConfirmMoveResources", 16, true);
    public static final ClientProperty CONFIRM_MOVE_ACTIVITIES = ClientProperty.CLIENT("ConfirmMoveActivities", 16, true);
    public static final ClientProperty CONFIRM_DELETE_WORKFLOW = ClientProperty.CLIENT("ConfirmDeleteWorkflow", 16, true);
    public static final ClientProperty CONFIRM_DELETE_SETUP_TIME = ClientProperty.CLIENT("ConfirmDeleteSetupTime", 16, true);
    public static final ClientProperty CONFIRM_DELETE_ASSIGNMENT = ClientProperty.CLIENT("ConfirmDeleteAssignment", 16, true);
    public static final ClientProperty CONFIRM_DESACTIVATE_ACTIVITIES = ClientProperty.CLIENT("ConfirmDesactivateActivities", 16, true);
    public static final ClientProperty CONFIRM_RESIZE_ACTIVITY = ClientProperty.CLIENT("ConfirmResizeActivity", 16, true);
    public static final ClientProperty CONFIRM_REMOVE_CHARACTERISTIC = ClientProperty.CLIENT("ConfirmRemoveCharacteristic", 16, true);
    public static final ClientProperty CONFIRM_REMOVE_SITE = ClientProperty.CLIENT("ConfirmRemoveSite", 16, true);
    public static final ClientProperty CONFIRM_REMOVE_SET = ClientProperty.CLIENT("ConfirmRemoveSet", 16, true);
    public static final ClientProperty CONFIRM_MOVE_ACTIVITY = ClientProperty.CLIENT("ConfirmMoveActivity", 16, false);
    public static final ClientProperty CONFIRM_QUIT_CLIENT = ClientProperty.CLIENT("ConfirmQuitClient", 16, true);
    public static final ClientProperty CONFIRM_DELETE_STANDARD_TIMEFRAME = ClientProperty.CLIENT("ConfirmDeleteTimeFrame", 16, true);
    public static final ClientProperty CONFIRM_CHANGE_PROFILE = ClientProperty.CLIENT("ConfirmChangeProfile", 16, true);
    public static final ClientProperty CONFIRM_REMOVE_PARTIAL = ClientProperty.CLIENT("ConfirmRemovePartial", 16, true);
    public static final ClientProperty CONFIRM_MOVE_ADMINS = ClientProperty.CLIENT("ConfirmMoveAdmins", 16, true);
    public static final ClientProperty OPTION_DELETE_PARTICIPANT_STUDENT = ClientProperty.CLIENT("OptionDeleteParticipantStudent", 16, "1", deleteResource);
    public static final ClientProperty OPTION_DELETE_PARTICIPANT_TEACHER = ClientProperty.CLIENT("OptionDeleteParticipantTeacher", 16, "1", deleteResource);
    public static final ClientProperty OPTION_DELETE_PARTICIPANT_CLASSROOM = ClientProperty.CLIENT("OptionDeleteParticipantClassroom", 16, "1", deleteResource);
    public static final ClientProperty OPTION_DELETE_PARTICIPANT_RESOURCE = ClientProperty.CLIENT("OptionDeleteParticipantResource", 16, "1", deleteResource);
    public static final ClientProperty OPTION_DELETE_PARTICIPANT_CATEGORY5 = ClientProperty.CLIENT("OptionDeleteParticipantCategory5", 16, "1", deleteResource);
    public static final ClientProperty OPTION_DELETE_PARTICIPANT_CATEGORY6 = ClientProperty.CLIENT("OptionDeleteParticipantCategory6", 16, "1", deleteResource);
    public static final ClientProperty OPTION_DELETE_PARTICIPANT_CATEGORY7 = ClientProperty.CLIENT("OptionDeleteParticipantCategory7", 16, "1", deleteResource);
    public static final ClientProperty OPTION_DELETE_PARTICIPANT_CATEGORY8 = ClientProperty.CLIENT("OptionDeleteParticipantCategory8", 16, "1", deleteResource);
    public static final ClientProperty ENGINE_SEND_MAIL = ClientProperty.CLIENT("EngineSendMail", 16, null);
    public static final ClientProperty DISPLAY_RATE = ClientProperty.CLIENT("DisplayRate", 24, 500);
    public static final ClientProperty SHOW_CONFLICT_ID = ClientProperty.CLIENT("ShowConflictId", 24, false);
    public static final ClientProperty SHOW_MEMERRORS = ClientProperty.CLIENT("ShowMemErrors", 24, false);
    public static final ClientProperty CACHE_SIZE = ClientProperty.CLIENT("CacheSize", 16, 500);
    public static final ClientProperty COLUMNS_PROJECTS = ClientProperty.CLIENT("ColumnsProjects", 8, "");
    public static final ClientProperty COLUMNS_CONFIGURATIONS = ClientProperty.CLIENT("ColumnsConfigurations", 8, "NAME");
    public static final ClientProperty COLUMNS_DYNAMIC_LIST = ClientProperty.CLIENT("ColumnsDynamicList", 8, "NAME,CATEGORY");
    public static final ClientProperty COLUMNS_COURSES = ClientProperty.CLIENT("ColumnsCourses", 24, "");
    public static final ClientProperty COLUMNS_COURSES_LINKS = ClientProperty.CLIENT("ColumnsCoursesLinks", 24, "");
    public static final ClientProperty COLUMNS_COURSES_PLACED = ClientProperty.CLIENT("ColumnsCoursesPlaced", 24, "");
    public static final ClientProperty COLUMNS_LINKS = ClientProperty.CLIENT("ColumnsLinks", 24, "");
    public static final ClientProperty COLUMNS_RESOURCES = ClientProperty.CLIENT("ColumnsResources", 24, "");
    public static final ClientProperty COLUMNS_TIMETABLE = ClientProperty.CLIENT("ColumnsTimetable", 24, "NAME");
    public static final ClientProperty COLUMNS_PROJECTS_BACKUP = ClientProperty.CLIENT("ColumnsProjectsBackup", 8, "");
    public static final ClientProperty COLUMNS_TRASH = ClientProperty.CLIENT("ColumnsTrash", 24, "");
    public static final ClientProperty COLUMNS_SETUP_TIME = ClientProperty.CLIENT("ColumnsSetupTime", 24, "");
    public static final ClientProperty COLUMNS_ASSIGNMENT = ClientProperty.CLIENT("ColumnsAssignment", 24, "");
    public static final ClientProperty COLUMNS_RESOURCES_EDIT = ClientProperty.CLIENT("ColumnsResourcesEdit", 24, "");
    public static final ClientProperty COLUMNS_LOGS = ClientProperty.CLIENT("ColumnsLogs", 24, "LOG_DATE,LOG_ACTION,LOG_USER");
    public static final ClientProperty COLUMNS_RECEIVED_MESSAGES = ClientProperty.CLIENT("ColumnsReceivedMessages", 24, "");
    public static final ClientProperty COLUMNS_SENT_MESSAGES = ClientProperty.CLIENT("ColumnsSentMessages", 24, "");
    public static final ClientProperty FEED_SIZE = ClientProperty.CLIENT("FeedSize", 16, 100);
    public static final ClientProperty HOME = ClientProperty.CLIENT("Home", 16, "C:" + File.separator);
    public static final ClientProperty LAST_PROJECT = ClientProperty.CLIENT("LastProject", 8, -1);
    public static final ClientProperty MAX_SELECTION_SIZE = ClientProperty.CLIENT("MaxSelectionSize", 16, 500);
    public static final ClientProperty MAX_ACTIVITY_SELECTION_SIZE = ClientProperty.CLIENT("MaxActivitySelectionSize", 16, 100);
    public static final ClientProperty OUTLOOK_STYLE = ClientProperty.CLIENT("OutlookStyle", 0, true);
    public static final ClientProperty RESOURCES_EDITOR_STATE = ClientProperty.CLIENT("ResourcesEditorState", 8, 5);
    public static final ClientProperty SHOW_ALL_DAYS = ClientProperty.CLIENT("ShowAllDays", 16, false);
    public static final ClientProperty SHOW_ALL_WEEKS = ClientProperty.CLIENT("ShowAllWeeks", 16, false);
    public static final ClientProperty SHOW_CONFLICT_BOX = ClientProperty.CLIENT("ShowConflictBox", 16, true);
    public static final ClientProperty SHOW_COURSEPLACED_EXTENDED = ClientProperty.CLIENT("ShowCoursePlacedExtendedSelection", 16, true);
    public static final ClientProperty TRASH_FILTERED = ClientProperty.CLIENT("TrashFiltered", 16, true);
    public static final ClientProperty TRASH_SIZE = ClientProperty.CLIENT("TrashSize", 16, 100);
    public static final ClientProperty TRASH_UNION = ClientProperty.CLIENT("TrashUnion", 16, true);
    public static final ClientProperty VISUAL_EFFECTS = ClientProperty.CLIENT("VisualEffects", 16, true);
    public static final ClientProperty TEMP = ClientProperty.CLIENT("Temp", 8, "Temp");
    public static final ClientProperty REMOVE_LOCK_BYCLICK = ClientProperty.CLIENT("EnableDisabledLockByClick", 16, true);
    public static final ClientProperty PRINT_HEADER_ENABLED = ClientProperty.CLIENT("PrintHeaderEnabled", 24, true);
    public static final ClientProperty PRINT_HEADER_LEFT = ClientProperty.CLIENT("PrintHeaderLeft", 24, "");
    public static final ClientProperty PRINT_HEADER_CENTER = ClientProperty.CLIENT("PrintHeaderCenter", 24, "$n");
    public static final ClientProperty PRINT_HEADER_RIGHT = ClientProperty.CLIENT("PrintHeaderRight", 24, "$d");
    public static final ClientProperty PRINT_FOOTER_ENABLED = ClientProperty.CLIENT("PrintFooterEnabled", 24, true);
    public static final ClientProperty PRINT_FOOTER_LEFT = ClientProperty.CLIENT("PrintFooterLeft", 24, "$f");
    public static final ClientProperty PRINT_FOOTER_CENTER = ClientProperty.CLIENT("PrintFooterCenter", 24, "");
    public static final ClientProperty PRINT_FOOTER_RIGHT = ClientProperty.CLIENT("PrintFooterRight", 24, "$p/$P");
    public static final ClientProperty SHOW_ENGINE_ADVANCED_PANEL = ClientProperty.CLIENT("ShowEngineAdvancedPanel", 16, false);
    public static final ClientProperty FORCE_MOVE_ASK = ClientProperty.CLIENT("ForceMoveAsk", 24, 0);
    public static final ClientProperty FORCE_MOVE_DELAY_SERVER = ClientProperty.CLIENT("ForceMoveDelayServer", 24, 15);
    public static final ClientProperty SMART_EXTRACT_EVENT = ClientProperty.CLIENT("SmartExtractEvent", 16, true);
    public static final ClientProperty COPY_MAIL_TO_SENDER = ClientProperty.CLIENT("CopyMailToSender", 16, false);
    public static final ClientProperty LOGS_NB_RECORDS = ClientProperty.CLIENT("LogsNbRecords", 16, 5);
    public static final ClientProperty RESOURCE_SELECTION = ClientProperty.CLIENT("ResourceSelection", 8, "");
    public static final ClientProperty COURSE_SELECTION = ClientProperty.CLIENT("CourseSelection", 8, "");
    public static final ClientProperty COURSE_FOLDER_SELECTION = ClientProperty.CLIENT("CourseFolderSelection", 8, "");
    public static final ClientProperty TIMETABLE_SELECTION = ClientProperty.CLIENT("TimetableSelection", 8, "");
    public static final ClientProperty RESOURCE_SEARCH_SELECTION = ClientProperty.CLIENT("ResourceSearchSelection", 8, "");
    public static final ClientProperty ACTIVITY_SEARCH_SELECTION = ClientProperty.CLIENT("ActivitySearchSelection", 8, "");
    public static final ClientProperty LINK_SEARCH_SELECTION = ClientProperty.CLIENT("LinkSearchSelection", 8, "");
    public static final ClientProperty USER_SEARCH_SELECTION = ClientProperty.CLIENT("UserSearchSelection", 8, "");
    public static final ClientProperty RESOURCE_FILTER_SELECTION = ClientProperty.CLIENT("ResourceFilterSelection", 8, "");
    public static final ClientProperty ACTIVITY_FILTER_SELECTION = ClientProperty.CLIENT("ActivityFilterSelection", 8, "");
    public static final ClientProperty LINK_FILTER_SELECTION = ClientProperty.CLIENT("LinkFilterSelection", 8, "");
    public static final ClientProperty DISPLAY_CONFIGURATION_SELECTION = ClientProperty.CLIENT("DisplayConfigurationSelection", 8, "");
    public static final ClientProperty ENGINE_SELECTION = ClientProperty.CLIENT("EngineSelection", 8, "");
    public static final ClientProperty DYNAMIC_LIST_SELECTION = ClientProperty.CLIENT("DynamicListSelection", 8, "");
    public static final ClientProperty RESOURCES_FILTERS = ClientProperty.CLIENT("ResourcesFilters", 8, "-1");
    public static final ClientProperty ACTIVITIES_FILTERS = ClientProperty.CLIENT("ActivitiesFilters", 8, "-1");
    public static final ClientProperty LINKS_FILTERS = ClientProperty.CLIENT("LinksFilters", 8, "-1");
    public static final ClientProperty JAVA_PARAM = ClientProperty.CLIENT("JavaParam", 8, "");
    private final Class _cType;
    private final int _iParameter;
    private final String[] choices;

    private ClientProperty(String string, Class clazz, int n, String string2, String[] stringArray) {
        super(string, string2);
        this._cType = clazz;
        this._iParameter = n;
        this.choices = stringArray;
        indexByName.put(string, this);
    }

    public String[] getChoices() {
        return this.choices;
    }

    public static TreeSet getClientProperties() {
        TreeSet<ClientProperty> treeSet = new TreeSet<ClientProperty>();
        for (ClientProperty clientProperty : indexByName.values()) {
            treeSet.add(clientProperty);
        }
        return treeSet;
    }

    public static ClientProperty getClientPropertyByName(String string) {
        ClientProperty clientProperty = (ClientProperty)indexByName.get(string);
        if (null == clientProperty) {
            LOG.debug((Object)("Unknown Client Property : " + string));
            return null;
        }
        return clientProperty;
    }

    public Class getType() {
        return this._cType;
    }

    public boolean isExpert() {
        return 0 != (this._iParameter & 8);
    }

    public boolean isRootOnly() {
        return 0 != (this._iParameter & 4);
    }

    public boolean isXml() {
        return 0 != (this._iParameter & 0x10);
    }

    public boolean isChoice() {
        return null != this.choices;
    }

    private static ClientProperty CLIENT(String string, int n, boolean bl) {
        return new ClientProperty(string, Boolean.class, n, bl ? "true" : "false", null);
    }

    private static ClientProperty CLIENT(String string, int n, int n2) {
        return new ClientProperty(string, Integer.class, n, Integer.toString(n2), null);
    }

    private static ClientProperty CLIENT(String string, int n, String string2) {
        return new ClientProperty(string, String.class, n, string2, null);
    }

    private static ClientProperty CLIENT(String string, int n, String string2, String[] stringArray) {
        return new ClientProperty(string, String.class, n, string2, stringArray);
    }
}

