/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.properties;

import com.adesoft.log.Category;
import com.adesoft.misc.Util;
import com.adesoft.properties.AbstractProperty;
import com.adesoft.properties.ServerProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public final class ServerProperties {
    private static final Category LOG = Category.getInstance((String)"com.adesoft.properties.ServerProperties");
    private static final ServerProperties instance = new ServerProperties();
    private final HashMap _properties = new HashMap();

    private ServerProperties() {
    }

    public static ServerProperties getInstance() {
        return instance;
    }

    public void clear() {
        this._properties.clear();
    }

    public String get(ServerProperty serverProperty) {
        Object v = this._properties.get(serverProperty);
        return null != v ? (String)v : serverProperty.getDefaultValue();
    }

    public int getInt(ServerProperty serverProperty) {
        return Integer.parseInt(this.get(serverProperty));
    }

    public boolean getBoolean(ServerProperty serverProperty) {
        return Boolean.valueOf(this.get(serverProperty));
    }

    public String[] getStringArray(ServerProperty serverProperty) {
        String[] stringArray = null;
        String string = this.get(serverProperty);
        if (null != string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                arrayList.add(string2.trim());
            }
            if (arrayList.size() > 0) {
                stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
            }
        }
        return stringArray;
    }

    public int[] getIntArray(ServerProperty serverProperty) {
        int[] nArray = null;
        String[] stringArray = this.getStringArray(serverProperty);
        if (null != stringArray && stringArray.length > 0) {
            nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = Integer.decode(stringArray[i]);
            }
        }
        return nArray;
    }

    public void putCommandLine(String[] stringArray, boolean bl) {
        HashMap hashMap = new HashMap();
        Util.parseCommandLine((String[])stringArray, hashMap);
        this.putProperties(hashMap, bl);
    }

    public void put(String string, Object object, boolean bl) {
        ServerProperty serverProperty = ServerProperty.getByName(string);
        if (null != serverProperty && (bl || !this._properties.containsKey(serverProperty))) {
            this._properties.put(serverProperty, object);
        }
    }

    public void putProperties(Map map, boolean bl) {
        this.putProperties(map, bl, false);
    }

    public void putProperties(Map map, boolean bl, boolean bl2) {
        String string;
        Object object;
        if (bl2) {
            Collection collection = ServerProperty.getAllProperties();
            Iterator object2 = collection.iterator();
            while (object2.hasNext()) {
                object = (ServerProperty)object2.next();
                string = ((AbstractProperty)object).getName();
                if (map.containsKey(string)) continue;
                LOG.error((Object)("The following server property is missing : " + string));
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            object = (String)entry.getKey();
            string = entry.getValue();
            this.put((String)object, string, bl);
        }
    }
}

