/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.properties;

import com.adesoft.log.Category;
import com.adesoft.properties.AbstractProperty;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeMap;

public final class ServerProperty
extends AbstractProperty
implements Serializable {
    private static final long serialVersionUID = 520L;
    private static final Category LOG = Category.getInstance((String)"com.adesoft.properties.ServerProperty");
    private static final TreeMap indexByName = new TreeMap();
    public static final ServerProperty PASSWORD_MAX_TRY_ROOT = ServerProperty.SERVER("PasswordMaxTryRoot", -1, "SECURITY", "Maximum number of times the root password can be mistyped. After that, the root user is deactivated so that nobody can logon as root. If the value is -1, there is no limit.");
    public static final ServerProperty PASSWORD_MAX_TRY = ServerProperty.SERVER("PasswordMaxTry", -1, "SECURITY", "Maximum number of times a password other than root's can be mistyped. After that, the login is deactivated. If the value is -1, there is no limit.");
    public static final ServerProperty ENCRYPT = ServerProperty.SERVER("Encrypt", "0123456789", "SECURITY", "Private key used to encrypt passwords in the database. Beware if you change this value, the existing passwords will have to be cleared out manually from the database");
    public static final ServerProperty PASSWORD_MINIMUM_SIZE = ServerProperty.SERVER("PasswordMinimumSize", -1, "SECURITY", "Minimum size for a password. When a user is created it has an empty password but when a password is changed we require this minimum size. -1 if no minimum size");
    public static final ServerProperty PASSWORD_CHECK_OLD = ServerProperty.SERVER("PasswordCheckOld", false, "SECURITY", "When a user changes password, we can compare the new one to the last two passwords to ensure that the new password is more secure.");
    public static final ServerProperty PASSWORD_DELEGATE = ServerProperty.SERVER("PasswordDelegate", false, "SECURITY", "The password of a user can be checked externally. This is the java class that does the delegation. ");
    public static final ServerProperty PASSWORD_DELEGATE_NAME = ServerProperty.SERVER("PasswordDelegateName", "", "SECURITY", "This is the java class that does the delegation.");
    public static final ServerProperty WEB_SSO = ServerProperty.SERVER("WebSso", false, "SECURITY", "Single-Sign-On on the Web can be activated, except the Web jsp");
    public static final ServerProperty WEB_SSO_JSP = ServerProperty.SERVER("WebSsoJsp", false, "SECURITY", "Single-Sign-On on the Web jsp can be activated");
    public static final ServerProperty WEB_URL_CAS = ServerProperty.SERVER("WebUrlCas", "", "SECURITY", "CAS validate Url");
    public static final ServerProperty DEFAULT_WEB_USER = ServerProperty.SERVER("DefaultWebUser", "", "SECURITY", "When Single-Sign-On is activated, a default user can be given to users that are not created in ADE");
    public static final ServerProperty SSO_ADFS_FIRST_NAME_FIELD = ServerProperty.SERVER("SsoAdfsFistNameField", "", "SECURITY", "Field name retrieved from ADFS that represents the user's first name");
    public static final ServerProperty SSO_ADFS_LAST_NAME_FIELD = ServerProperty.SERVER("SsoAdfsLastNameField", "NAME", "SECURITY", "Field name retrieved from ADFS that represents the user's last name");
    public static final ServerProperty SSO_ADFS_EMAIL_FIELD = ServerProperty.SERVER("SsoAdfsEmailField", "EMAIL_ADDRESS", "SECURITY", "Field name retrieved from ADFS that represents the user's email address");
    public static final ServerProperty SSO_ADFS_GROUPS_FIELD = ServerProperty.SERVER("SsoAdfsGroupsField", "GROUP", "SECURITY", "Field name retrieved from ADFS that represents the user's groups");
    public static final ServerProperty SSO_ADFS_UPDATE_GROUPS = ServerProperty.SERVER("SsoAdfsUpdateGroups", false, "SECURITY", "true to update user's groups");
    public static final ServerProperty SSO_ADFS_FIRST_NAME_BEFORE_LAST_NAME = ServerProperty.SERVER("SsoAdfsFistNameBeforeLastName", true, "SECURITY", "true if the first name should be before the last name");
    public static final ServerProperty NT_AUTO_LOGON = ServerProperty.SERVER("NtAutoLogon", false, "SECURITY", "On NT, we can try to logon automatically with current Nt user as the ade's login.");
    public static final ServerProperty SIGN_JSP = ServerProperty.SERVER("SignJsp", "", "SECURITY", "Signature of the Allowed.xml file");
    public static final ServerProperty SIGN_MODULES = ServerProperty.SERVER("SignModules", "", "SECURITY", "Signature of the Modules.xml file");
    public static final ServerProperty SIGN_KEY = ServerProperty.SERVER("SignKey", "", "SECURITY", "Public key to test file signatures");
    public static final ServerProperty CRYPT_KEY = ServerProperty.SERVER("CryptKey", "afcjctckkyvv", "SECURITY", "key of the url encryption");
    public static final ServerProperty DATABASE_CONNECT_TRY_COUNT = ServerProperty.SERVER("DatabaseConnectTryCount", 15, "DATABASE", "Number of times we try to connect to the database when setting up a new connection.");
    public static final ServerProperty MAX_IN_CLAUSE = ServerProperty.SERVER("MaxInClause", 253, "DATABASE", "When multiple SQL DELETE or UPDATE are made on the same table with different ids, ADE will try to group the request in a single request using IN clause. With 'MaxInClause', we can specify how many ids can be in the clause.");
    public static final ServerProperty SQL_CONNECTIONS = ServerProperty.SERVER("SqlConnections", -1, "DATABASE", "Maximum number of concurent connections that will be opened to the database. If -1, then we use 'ClientUsers' as the value for backward compatibility");
    public static final ServerProperty USEDATABASE = ServerProperty.SERVER("UseDatabase", "true", "DATABASE", "All database access can be deactivated. Projects are only stored in memory and are lost if the server is stopped.");
    public static final ServerProperty JDBC_DRIVER = ServerProperty.SERVER("JdbcDriver", "sun.jdbc.odbc.JdbcOdbcDriver", "DATABASE", "JDBC driver name for database connections.");
    public static final ServerProperty JDBC_SOURCE = ServerProperty.SERVER("JdbcSource", "jdbc:odbc:AdeSql", "DATABASE", "JDBC source name for database connections.");
    public static final ServerProperty MAX_BATCH_SIZE = ServerProperty.SERVER("MaxBatchSize", -1, "DATABASE", "Maximum number of SQL commands sent in one batch. If a transaction needs more commands, multiple batch are used. -1 for no limit");
    public static final ServerProperty COMPOSITE_LIMIT = ServerProperty.SERVER("CompositeLimit", 1000, "DATABASE", "Maximum size of a single SQL query");
    public static final ServerProperty SQL_DATE_FORMAT = ServerProperty.SERVER("SqlDateFormat", "guess", "DATABASE", "Date format for the database: guess = try to find the right format depending on the database driver, standard = force standard SQL date format : '{d '2000-08-04'}', nonstandard = force non-standard date format : 2000-08-04 00:00:00.0', Most of the time 'guess' value will be ok.");
    public static final ServerProperty TRANSACTION_CAPACITY = ServerProperty.SERVER("TransactionMaxCapacity", 1000, "DATABASE", "When SQL requests are added to a transaction in memory (before sending them to the database), the transaction object can become very heavy. So we might want to swap it to disk until the request is sent. This is the maximum capacity of a transaction in memory.");
    public static final ServerProperty PASSWORD = ServerProperty.SERVER("Password", null, "DATABASE", "JDBC connection password");
    public static final ServerProperty USER = ServerProperty.SERVER("User", "", "DATABASE", "JDBC connection user");
    public static final ServerProperty LOGSWITHDATA = ServerProperty.SERVER("LogsWithData", false, "DATABASE", "activate the field data of the logs");
    public static final ServerProperty EXTRACTOR_JDBC_DRIVER = ServerProperty.SERVER("ExtractorJdbcDriver", null, "DATABASE", "JDBC driver name for extractor database connections.");
    public static final ServerProperty EXTRACTOR_JDBC_SOURCE = ServerProperty.SERVER("ExtractorJdbcSource", null, "DATABASE", "JDBC source name for extractor database connections.");
    public static final ServerProperty EXTRACTOR_PASSWORD = ServerProperty.SERVER("ExtractorPassword", null, "DATABASE", "Extractor JDBC connection password");
    public static final ServerProperty EXTRACTOR_USER = ServerProperty.SERVER("ExtractorUser", null, "DATABASE", "Extractor JDBC connection user");
    public static final ServerProperty EXTRACTOR_TYPE = ServerProperty.SERVER("ExtractorType", "leaf", "DATABASE", "Extract the event entities detailed or grouped ?");
    public static final ServerProperty EXTRACTOR_MEMBERS = ServerProperty.SERVER("ExtractorMembers", true, "EXTRACTOR", "Extract the event entities with or without the members");
    public static final ServerProperty RESOURCES_MAXITER = ServerProperty.SERVER("ResourceMaxIter", Integer.MAX_VALUE, "COMPUTING", "Maximum number of iter to Find a valid resources to an event");
    public static final ServerProperty SKIP_COUNTERS = ServerProperty.SERVER("SkipCounters", false, "COMPUTING", "Skip all processing relating to counters");
    public static final ServerProperty SKIP_COUNTERS_MOVING = ServerProperty.SERVER("SkipCountersMoving", false, "COMPUTING", "Skip all processing relating to counters moving");
    public static final ServerProperty DAY_FORMAT = ServerProperty.SERVER("DayFormat", "dd/MM/yyyy", "PLANNING", "Days date format in the planning view");
    public static final ServerProperty WEEK_FORMAT = ServerProperty.SERVER("WeekFormat", "dd/MM", "PLANNING", "Weeks date format in the planning view");
    public static final ServerProperty GROUP_BY_GROUP = ServerProperty.SERVER("GroupByGroup", true, "PLANNING", "Try to group activities with same participants");
    public static final ServerProperty ZOOM_MAX_LEVEL = ServerProperty.SERVER("ZoomMaxLevel", 10, "PLANNING", "Maximum level of zoom");
    public static final ServerProperty PRINTABLEWIDTH = ServerProperty.SERVER("PrintableWidth", 640, "PLANNING", "Width of the timetable print view on the web");
    public static final ServerProperty PRINTABLEHEIGHT = ServerProperty.SERVER("PrintableHeight", 480, "PLANNING", "Height of the timetable print view on the web");
    public static final ServerProperty PRINTPDFTHIN = ServerProperty.SERVER("PrintPDFThin", 2, "PLANNING", "Thin of the PDF on the GWT Web Client");
    public static final ServerProperty DEFAULT_CONFIGURATION_NAME = ServerProperty.SERVER("DefaultConfigurationName", "Web", "PLANNING", "Name of the default configuration on the web");
    public static final ServerProperty WEB_ZOOM_VALUES = ServerProperty.SERVER("WebZoomValues", "Web", "PLANNING", "Zoom of the planning display");
    public static final ServerProperty DIRECTBOOKING = ServerProperty.SERVER("DirectBooking", "Web", "PLANNING", "Do we allow to book on free available slots ?");
    public static final ServerProperty EXPENSIVE_COST_COLOR = ServerProperty.SERVER("ExpensiveCostColor", "0xF9D194", "PLANNING", "Color to display expensive costs");
    public static final ServerProperty CHEAP_COST_COLOR = ServerProperty.SERVER("CheapCostColor", "0x99FF99", "PLANNING", "Color to display cheap costs");
    public static final ServerProperty COST_COLOR_DELIMITER = ServerProperty.SERVER("CostColorDelimiter", -1, "PLANNING", "Delimiter to determine if a cost is expensive or cheap");
    public static final ServerProperty NO_DURATION_IN_COST = ServerProperty.SERVER("NoDurationInCost", "", "PLANNING", "The Duration is not applied  in costs that have specific name");
    public static final ServerProperty QUICK_DISPLAY_MEMBERS = ServerProperty.SERVER("QuickDisplayMembers", "false", "PLANNING", "Search for all members methodically");
    public static final ServerProperty ZOOM_XY = ServerProperty.SERVER("ZoomXY", false, "PLANNING", "The Zoom use the two dimensions X and Y to groups courses instead one");
    public static final ServerProperty COMPLIANT_TIMEZONE = ServerProperty.SERVER("CompliantTimezone", false, "PLANNING", "The slots on the planning are shifted to follow the timezone of the client");
    public static final ServerProperty ACTIVATE_ZOOM = ServerProperty.SERVER("ActivateZoom", true, "PLANNING", "activate the zoom functionnality on the web planning triggered with the wheel mouse");
    public static final ServerProperty SERVER = ServerProperty.SERVER("Server", null, "NETWORK", "IP address of the server");
    public static final ServerProperty WEB_SERVER = ServerProperty.SERVER("WebServer", "http://127.0.0.1:8080/jsp/", "NETWORK", "Path to the web server");
    public static final ServerProperty SMTP_SERVER = ServerProperty.SERVER("SmtpServer", "", "NETWORK", "Address of the SMTP server used to send mails.");
    public static final ServerProperty ENCODING_CHARSET = ServerProperty.SERVER("encodingCharset", "utf-8", "NETWORK", "Encoding charset for emails.");
    public static final ServerProperty URL_MAIL = ServerProperty.SERVER("UrlMail", "custom/modules/plannings/direct_planning.jsp", "NETWORK", "Name used as the sender when a mail is sent");
    public static final ServerProperty REGISTRY_PORT = ServerProperty.SERVER("RmiRegistryPort", 1099, "NETWORK", "Port of the RMI registry used by the server. One registry with multiple names can be used or multiple registry with one name, ...");
    public static final ServerProperty RMI_SERVER_PORT = ServerProperty.SERVER("RmiServerPort", -1, "NETWORK", "Port of the RMI server. When walue is -1, the server port is set to RmiRegistryPort 2303. So the default is 3402");
    public static final ServerProperty RMI_NAME = ServerProperty.SERVER("RmiName", "ade", "NETWORK", "RMI name of the main ADE Server");
    public static final ServerProperty MAIL_SENDER = ServerProperty.SERVER("MailSender", "Ade", "NETWORK", "Address of the sender of alert mails");
    public static final ServerProperty MAIL_CC = ServerProperty.SERVER("MailCc", "standard", "NETWORK", "mode of cc email sending");
    public static final ServerProperty MAIL_SORT_EVENTS = ServerProperty.SERVER("MailSortEvents", 1, "NETWORK", "Sort type for notify by mail");
    public static final ServerProperty DAYLIGHT_OFFSET = ServerProperty.SERVER("DaylightOffset", 1, "NETWORK", "Offset of daylight saving time in hours");
    public static final ServerProperty WEBCLIENT_INACTIVITY = ServerProperty.SERVER("WebClientInactivity", 900000, "NETWORK", "Duration between each web client check for inactivity");
    public static final ServerProperty RENEW_WEB_SESSION = ServerProperty.SERVER("RenewWebSession", false, "NETWORK", "Renew the web session cookie before authenticating a user");
    public static final ServerProperty MODULE_LIST = ServerProperty.SERVER("ModuleList", "", "LICENCE", "Optional modules permitted.");
    public static final ServerProperty ACTIVATED_MODULE_LIST = ServerProperty.SERVER("ActivatedModuleList", "all", "LICENCE", "Modules taken from ModuleList that are really activated.");
    public static final ServerProperty RESOURCES_PER_PROJECT = ServerProperty.SERVER("ResourcesPerProject", "", "LICENCE", "Max number of resources per project.");
    public static final ServerProperty CLIENTUSERS = ServerProperty.SERVER("ClientUsers", 0, "LICENCE", "Maximum number of client concurent connection accepted.");
    public static final ServerProperty CUSTOMERNAME = ServerProperty.SERVER("CustomerName", null, "LICENCE", "Customer name");
    public static final ServerProperty ENDDATE = ServerProperty.SERVER("EndDate", null, "LICENCE", "End date of the demo version");
    public static final ServerProperty KEY1 = ServerProperty.SERVER("Key1", null, "LICENCE", "Hardware footprint taken from the pc's configuration");
    public static final ServerProperty KEY2 = ServerProperty.SERVER("Key2", null, "LICENCE", "Protection key");
    public static final ServerProperty STARTDATE = ServerProperty.SERVER("StartDate", null, "LICENCE", "Start date of the demo version");
    public static final ServerProperty SERIAL = ServerProperty.SERVER("Serial", null, "LICENCE", "Serial number of the Ade");
    public static final ServerProperty VERSION = ServerProperty.SERVER("Version", null, "LICENCE", "Ade version. Used by the Key generation process.");
    public static final ServerProperty NB_CATEGORIES = ServerProperty.SERVER("NbCategories", 4, "LICENCE", "Number of base categories from 1 to 8");
    public static final ServerProperty LOG_TTL = ServerProperty.SERVER("LogTtl", 7, "DEBUG", "Each time an action is made in ADE, a log entry is added to the database. Log entries are removed after 'LogTtl' number of days.");
    public static final ServerProperty TRACE_LOCKS = ServerProperty.SERVER("TraceLocks", false, "DEBUG", "Produce debug information each time a lock is set or unset");
    public static final ServerProperty TRACE_TIMEOUTS = ServerProperty.SERVER("TraceTimeouts", false, "DEBUG", "Produce debug information each time a timeout occurs");
    public static final ServerProperty VERIFY_ALL_EVENTS = ServerProperty.SERVER("VerifyAllEvents", false, "DEBUG", "Verify all events at project loading. Produce debug information for events that are not ok.");
    public static final ServerProperty VERIFY_COUNTERS = ServerProperty.SERVER("VerifyCounters", false, "DEBUG", "Self verify counters very often and correct them if needed.Produce debug information if a problem occur.");
    public static final ServerProperty VERIFY_COUNTERSMOVING = ServerProperty.SERVER("VerifyCountersMoving", false, "DEBUG", "Self verify countersMoving very often and correct them if needed.Produce debug information if a problem occur.");
    public static final ServerProperty TRIGGERS_DEBUG = ServerProperty.SERVER("TriggersDebug", false, "DEBUG", "Debug trigger use. The triggers file is reloaded each time a trigger is used");
    public static final ServerProperty LOGFILE = ServerProperty.SERVER("LogFile", true, "DEBUG", "Do we use a file for logging or only the console ?");
    public static final ServerProperty LOGMODE = ServerProperty.SERVER("LogMode", "exception", "DEBUG", "Log modes : security, exception, debug, info, none");
    public static final ServerProperty DEBUG_SEND_MAIL = ServerProperty.SERVER("DebugSendMail", false, "DEBUG", "Do we need a verbose send mail debug ?");
    public static final ServerProperty CLIENTUSERSNONROOT = ServerProperty.SERVER("ClientUsersNonRoot", "-1", "DEBUG", "Maximum number of non root client concurent connection accepted. -1 means no limit. Whatever the limit is, we cannot overcome CLIENTUSERS");
    public static final ServerProperty CHECK_CONSUMER = ServerProperty.SERVER("CheckConsumer", false, "DEBUG", "Verify the good placement of the events if the check consumer or the capacity of an entity is modified");
    public static final ServerProperty PROJECT_BACKUP_DIR = ServerProperty.SERVER("ProjectBackupDir", "C:" + File.separator + "AdeBackups" + File.separator, "BACKUP", "Directory to backup projects");
    public static final ServerProperty PROJECT_BACKUP_NB_ROLLS = ServerProperty.SERVER("ProjectBackupNbRolls", 3, "BACKUP", "Nb backups to roll over");
    public static final ServerProperty ENGINE_HOST = ServerProperty.SERVER("EngineHost", "", "OPTIMIZER", "IP address of the Optimizer");
    public static final ServerProperty ENGINE_PORT = ServerProperty.SERVER("EnginePort", 12345, "OPTIMIZER", "IP port of the Optimizer");
    public static final ServerProperty ENGINE_OPTIMIZATION_HEURISTICS = ServerProperty.SERVER("EngineOptimizationHeuristics", "", "OPTIMIZER", "Optimization heuristics : all in a buffer like Name=Value;Name=Value");
    public static final ServerProperty RANDOMIZE_COSTS = ServerProperty.SERVER("RandomizeCosts", true, "OPTIMIZER", "Do we use a random factor for the room engine ?");
    public static final ServerProperty AFFECT_ALWAYS_BEST_COSTS = ServerProperty.SERVER("AffectAlwaysBestCosts", false, "OPTIMIZER", "Do we affect resource that has best cost instead of try to reuse the same resource ?");
    public static final ServerProperty ENGINE_DARA_HEURISTIC = ServerProperty.SERVER("EngineDaraHeuristic", "0", "OPTIMIZER", "Advanced Scheduling");
    public static final ServerProperty ENGINE_REALLOCATION_HEURISTIC = ServerProperty.SERVER("EngineReallocationHeuristic", "0", "OPTIMIZER", "Advanced Scheduling");
    public static final ServerProperty ENGINE_SEND_NAME = ServerProperty.SERVER("EngineSendName", false, "OPTIMIZER", "Send Name info to the engine ?");
    public static final ServerProperty INFOSSTAGES = ServerProperty.SERVER("InfosStages", "GLOBAL_WEB_ADMINISTRATOR,GLOBAL_WEB_POWERUSER", "REGISTER", "");
    public static final ServerProperty INFOSINTERVENANTS = ServerProperty.SERVER("InfosIntervenants", "GLOBAL_WEB_ADMINISTRATOR,GLOBAL_WEB_POWERUSER", "REGISTER", "");
    public static final ServerProperty REGISTER = ServerProperty.SERVER("Register", "GLOBAL_WEB_ADMINISTRATOR,GLOBAL_WEB_POWERUSER", "REGISTER", "");
    public static final ServerProperty ABSOLUTEREGISTER = ServerProperty.SERVER("AbsoluteRegister", "GGLOBAL_WEB_ADMINISTRATOR", "REGISTER", "");
    public static final ServerProperty ATTESTATIONEDIT = ServerProperty.SERVER("AttestationEdit", "GLOBAL_WEB_ADMINISTRATOR,GLOBAL_WEB_POWERUSER", "REGISTER", "");
    public static final ServerProperty ATTEND = ServerProperty.SERVER("Attend", "GLOBAL_WEB_ADMINISTRATOR,GLOBAL_WEB_POWERUSER", "REGISTER", "");
    public static final ServerProperty INVOICE = ServerProperty.SERVER("Invoice", "GLOBAL_WEB_ADMINISTRATOR,GLOBAL_WEB_POWERUSER", "REGISTER", "");
    public static final ServerProperty REPLACE = ServerProperty.SERVER("Replace", "GLOBAL_WEB_ADMINISTRATOR,GLOBAL_WEB_POWERUSER", "REGISTER", "");
    public static final ServerProperty NOTE = ServerProperty.SERVER("Note", "GLOBAL_WEB_ADMINISTRATOR,GLOBAL_WEB_POWERUSER", "REGISTER", "");
    public static final ServerProperty MAILSUBJECT = ServerProperty.SERVER("MailSubject", "Convocation", "REGISTER", "Subjet of the mails send by the register");
    public static final ServerProperty MAILSENDER = ServerProperty.SERVER("MailSender", "ade@adesoft.com", "REGISTER", "Sender of the mails send by the register");
    public static final ServerProperty TRAINEESINFOS = ServerProperty.SERVER("TraineesInfos", "name,code,email,manager,address1,telephone", "REGISTER", "Information for the convocation excel file");
    public static final ServerProperty STAGESINFOS = ServerProperty.SERVER("StagesInfos", "name,code,email,manager,fax,telephone", "REGISTER", "Information for the convocation excel file");
    public static final ServerProperty INSTRUCTORSINFOS = ServerProperty.SERVER("InstructorsInfos", "name,code,email,manager,address1,telephone", "REGISTER", "Information for the convocation excel file");
    public static final ServerProperty ROOMSINFOS = ServerProperty.SERVER("RoomsInfos", "name,code,email,manager,address1,telephone,type", "REGISTER", "Information for the convocation excel file");
    public static final ServerProperty FATHERINFOS = ServerProperty.SERVER("FatherInfos", "name,code,email,manager,address1,telephone", "REGISTER", "Information for the convocation excel file");
    public static final ServerProperty TRAINEECHARACTERISTICS = ServerProperty.SERVER("TraineeCharacteristics", "", "REGISTER", "");
    public static final ServerProperty WEB_MAX_SELECTION_SIZE = ServerProperty.SERVER("WebMaxSelectionSize", "200", "REGISTER", "Maximum size of the selection in the tree in the web");
    public static final ServerProperty WEB_MAX_SELECTION_SIZE_PLANNING = ServerProperty.SERVER("WebMaxSelectionSizePlanning", "100", "REGISTER", "Maximum size of the selection in the tree in the web for display tab");
    public static final ServerProperty WEB_MAX_DISPLAY_ACTIVITIES_LINKS = ServerProperty.SERVER("WebMaxDisplayActivitiesLinks", "35", "REGISTER", "Maximum number of activities draw on the graph of links");
    public static final ServerProperty WEB_MAX_SELECTION_WIZARD = ServerProperty.SERVER("WebMaxSelectionWizard", "35", "REGISTER", "Maximum number of the selection in the tree to make a direct creation on the planning");
    public static final ServerProperty RESULTSEARCHMAXEVENTS = ServerProperty.SERVER("ResultSearchMaxEvents", "10000", "REGISTER", "Maximum size of events search in filterActivity planning in the web");
    public static final ServerProperty UNLOAD_AT_DISCONNECT = ServerProperty.SERVER("UnloadAtDisconnect", false, "MEMORY", "By default, when a nobody uses a project, it is not unloaded from memory. Instead we let a thread clean it after a few hours. This can be changed to unload a project each time it has no connection.");
    public static final ServerProperty PROJECT_TTL = ServerProperty.SERVER("ProjectTtl", 43200000, "MEMORY", "Time to live of a project in ms. If a project is unused after this period, it is unloaded from the memory");
    public static final ServerProperty MAX_GRIDS = ServerProperty.SERVER("MaxGrids", 1000, "MEMORY", "Maximum number of customized grids in memory at once.");
    public static final ServerProperty TEMP = ServerProperty.SERVER("Temp", "temp", "MISC", "Directory where to put temporary files");
    public static final ServerProperty SMART_RENAME_ACTIVITIES = ServerProperty.SERVER("SmartRenameActivities", false, "MISC", "Smart renaming system");
    public static final ServerProperty FILTER_MARKER = ServerProperty.SERVER("FilterMarker", "$", "MISC", "Marker used in filters for a dynamic value");
    public static final ServerProperty URL_POSTFIX = ServerProperty.SERVER("UrlPostfix", "", "MISC", "Postfix for HTTP urls");
    public static final ServerProperty URL_PREFIX = ServerProperty.SERVER("UrlPrefix", "", "MISC", "Prefix for HTTP urls");
    public static final ServerProperty MAX_SHUTDOWN_WAIT = ServerProperty.SERVER("MaxShutdownWait", 120000, "MISC", "Maximum duration to shutdown the server");
    public static final ServerProperty RENAME_COPIES = ServerProperty.SERVER("RenameCopies", false, "MISC", "Do we add ' (2)' to the name of copied activity or resource");
    public static final ServerProperty WEB_CONFIRM_LOGOUT = ServerProperty.SERVER("WebConfirmLogout", true, "MISC", "Do we confirm each time we close a GWT Client window ?");
    public static final ServerProperty ACTIVATE_DIRECT_SAVE_LAST_PROJECT = ServerProperty.SERVER("ActivateDirectSaveLastProject", false, "MISC", "Activate saving the last project on the Direct Planning");
    public static final ServerProperty MAX_SEARCH_RESOURCE_SIZE = ServerProperty.SERVER("MaxSearchResourceSize", -1, "MISC", "The maximum number of results by the search field in the Add Participants Panel. Upside this number, the tree doesn't open.");
    public static final ServerProperty EVENT_ACCESS = ServerProperty.SERVER("EventAccess", "use", "SECURITY", "event access rights for web booking");
    public static final ServerProperty RESERVATION_WORKFLOW_ASSOCIATE = ServerProperty.SERVER("ReservationWorkflowAssociate", "each", "BOOKING", "make one or several request choices for several workflow resources");
    public static final ServerProperty WORKFLOW_COMMENT_RESERVATION = ServerProperty.SERVER("WorkflowCommentReservation", "activity", "RESERVATION", "Describe the utility of the comment in the booking when a workflow is sent");
    public static final ServerProperty RESERVATION_WIZARD_MODE = ServerProperty.SERVER("ReservationWizardMode", "events", "RESERVATION", "Mode of creation of activities with the reservation wizard");
    public static final ServerProperty CHECK_WORKFLOW = ServerProperty.SERVER("CheckWorkflow", 60000, "WORKFLOW", "Duration beetween each checking of workflow messages");
    public static final ServerProperty PARTIAL_WORKFLOW_REJECTION = ServerProperty.SERVER("PartialWorkflowRejection", false, "WORKFLOW", "Can reject partial workflow");
    public static final ServerProperty WORKFLOW_COPY_BY_MAIL = ServerProperty.SERVER("WorkflowCopyByMail", false, "WORKFLOW", "By default, a workflow is copy by mail");
    public static final ServerProperty WORKFLOW_OWNER = ServerProperty.SERVER("WorkflowOwner", "standard", "WORKFLOW", "Define who is the owner of a workflow request");
    public static final ServerProperty WORKFLOW_DISPLAY_SENDER_MAIL = ServerProperty.SERVER("WorkflowDisplaySenderMail", false, "WORKFLOW", "Display the sender email address instead of its login");
    public static final ServerProperty WORKFLOW_SHOW_FILTER_STATUS = ServerProperty.SERVER("WorkflowShowFilterStatus", true, "WORKFLOW", "Visible state of status workflow filter");
    public static final ServerProperty WORKFLOW_SHOW_FILTER_STARTSCHEDULE = ServerProperty.SERVER("WorkflowShowFilterStartSchedule", true, "WORKFLOW", "Visible state of startSchedule workflow filter");
    public static final ServerProperty WORKFLOW_DISPLAY_SENT_DEFAULT = ServerProperty.SERVER("WorkflowDisplaySentByDefault", true, "WORKFLOW", "Display the sent messages by default");
    public static final ServerProperty WEB_API_TIME_SESSION = ServerProperty.SERVER("WebApiTimeSession", 10, "WEB-API", "timeout of the web api session");
    public static final ServerProperty TIMEZONE = ServerProperty.SERVER("TimeZone", "Europe/Paris", "ICAL", "ID of the timezone of the ICalendar client");
    public static final ServerProperty TIMEZONE_GAP = ServerProperty.SERVER("TimeZoneGap", "GMT+1:00", "ICAL", "Gap of the Timezone from the greenwitch timezone");
    public static final ServerProperty CAL_VERSION = ServerProperty.SERVER("CalVersion", 1, "ICAL", "Version of the ical export");
    public static final ServerProperty CAL_CRYPT_URL = ServerProperty.SERVER("CalCryptedUrl", "false", "ICAL", "crypt the ical url");
    public static final ServerProperty CAL_MAX_CONCURRENT_THREADS = ServerProperty.SERVER("CalMaxConcurrentThreads", -1, "ICAL", "Maximum number of concurrent threads");
    public static final ServerProperty CAL_MAX_WAITING_THREADS = ServerProperty.SERVER("CalMaxWaitingThreads", 50, "ICAL", "Maximum number of waiting threads");
    public static final ServerProperty CAL_MAX_SELECTION_SIZE = ServerProperty.SERVER("CalMaxSelectionSize", -1, "ICAL", "Maximum number of resources alloweded in an ICal request");
    public static final ServerProperty CAL_SQL_DATE_FORMAT = ServerProperty.SERVER("CalSQLDateFormat", -1, "ICAL", "ICal SQL Mode : format of the date in the getWeeks SQL Request");
    public static final ServerProperty LOG_ACTIONS = ServerProperty.SERVER("LogActions", "all,!CREATE_API_IDENTIFIER,!KICK_USER,!LOG_ON,!LOG_OFF,!SHUTDOWN,!PROJECT_LOADED,!PROJECT_LOADING,!PROJECT_UNLOADED,!PROJECT_UNLOADING,!PROJECT_OPENED,!PROJECT_CLOSE", "Logs", "List of actions logged in the database");
    public static final ServerProperty LOG_USERS = ServerProperty.SERVER("LogUsers", "all", "Logs", "List of users who logging actions");
    public static final ServerProperty RSS_DEFAULT_LOGIN = ServerProperty.SERVER("RssDefaultLogin", "", "Logs", "Default user used by rss servlet to connect to ADE Server");
    public static final ServerProperty RSS_DEFAULT_PASSWORD = ServerProperty.SERVER("RssDefaultPassword", "", "Logs", "Password of the default user used by rss servlet to connect to ADE Server");
    public static final ServerProperty RSS_DEFAULT_SYNDICATION_DAYS = ServerProperty.SERVER("RssDefaultSyndicationDays", 15, "Logs", "Default number of days of the syndication on the planning");
    public static final ServerProperty RSS_DEFAULT_UPDATED_SINCE = ServerProperty.SERVER("RssDefaultUpdatedSince", 7, "Logs", "Default number of days since last updated events");
    public static final ServerProperty RSS_WEB_LINK = ServerProperty.SERVER("RssWebLink", "http://www.adesoft.com", "Logs", "Link present in the header of the RSS feed (by default, commercial web site of ADESOFT)");
    public static final ServerProperty RSS_DATE_FORMAT = ServerProperty.SERVER("RssDateFormat", "dd/MM/yyyy", "Logs", "Date format of the scheduled events in RSS Feed");
    private final String description;
    private final String category;

    private static ServerProperty SERVER(String string, boolean bl, String string2, String string3) {
        return new ServerProperty(string, bl ? "true" : "false", string2, string3);
    }

    private static ServerProperty SERVER(String string, int n, String string2, String string3) {
        return new ServerProperty(string, Integer.toString(n), string2, string3);
    }

    private static ServerProperty SERVER(String string, String string2, String string3, String string4) {
        return new ServerProperty(string, string2, string3, string4);
    }

    private ServerProperty(String string, String string2, String string3, String string4) {
        super(string, string2);
        this.description = string4;
        this.category = string3;
        indexByName.put(string, this);
    }

    public String getDescription() {
        return this.description;
    }

    public String getCategory() {
        return this.category;
    }

    public static ServerProperty getByName(String string) {
        ServerProperty serverProperty = (ServerProperty)indexByName.get(string);
        if (null == serverProperty) {
            LOG.debug((Object)("Unknown Server Property : " + string));
            return null;
        }
        return serverProperty;
    }

    public static Collection getAllProperties() {
        return Collections.unmodifiableCollection(indexByName.values());
    }
}

