/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.config;

import com.adesoft.collections.EmptyMap;
import com.adesoft.config.ConfigServer;
import com.adesoft.config.RemoteConfig;
import com.adesoft.config.ServerLocation;
import com.adesoft.config.readers.HtmlReader;
import com.adesoft.config.readers.KeywordsReader;
import com.adesoft.config.readers.PropertiesReader;
import com.adesoft.config.readers.SQLReader;
import com.adesoft.config.readers.TextReader;
import com.adesoft.config.readers.XmlReader;
import com.adesoft.log.Category;
import com.adesoft.misc.Util;
import com.adesoft.modules.Modules;
import com.adesoft.properties.ServerProperties;
import com.adesoft.properties.ServerProperty;
import com.adesoft.rmi.MyRMI;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jdom.Element;

public final class ConfigManager
implements RemoteConfig {
    private static final Category LOG = Category.getInstance((String)"com.adesoft.config.ConfigManager");
    private static final int MAX_TRY = 3;
    private static ConfigManager instance = new ConfigManager();
    private final Map cache = Boolean.getBoolean("com.adesoft.debug") ? new EmptyMap() : new HashMap();
    private RemoteConfig remote;
    private boolean serverSide = false;
    private HashSet modules;
    private String basePath = "";

    private ConfigManager() {
    }

    public static ConfigManager getInstance() {
        return instance;
    }

    public static ConfigManager getInstance(String string) {
        instance.setBasePath(string);
        return instance;
    }

    public void setBasePath(String string) {
        if (null != string) {
            this.basePath = string;
        }
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void resetCache() {
        this.cache.clear();
    }

    public ConfigServer getServer() {
        return ServerLocation.getInstance(this.basePath).getServer();
    }

    private synchronized RemoteConfig getRemote() {
        if (null == this.remote) {
            this.remote = ServerLocation.getInstance(this.basePath).getRemoteConfig();
        }
        return this.remote;
    }

    private synchronized void clearRemote() {
        ServerLocation.getInstance(this.basePath).reset();
        this.remote = null;
        this.cache.clear();
    }

    private synchronized boolean isServerSide() {
        return this.serverSide;
    }

    public synchronized void setServerSide() {
        this.serverSide = true;
    }

    public synchronized void export() throws RemoteException {
        MyRMI.exportObject((Remote)this);
    }

    @Override
    public TreeMap<String, String> readProperties(String string) {
        if (this.isServerSide()) {
            PropertiesReader propertiesReader = new PropertiesReader(string);
            return propertiesReader.read();
        }
        TreeMap treeMap = (TreeMap)this.cache.get(string);
        if (null != treeMap) {
            return treeMap;
        }
        for (int i = 0; i < 3; ++i) {
            try {
                TreeMap treeMap2 = this.getRemote().readProperties(string);
                this.cache.put(string, treeMap2);
                return treeMap2;
            }
            catch (RemoteException remoteException) {
                LOG.error((Object)remoteException);
                this.clearRemote();
                continue;
            }
        }
        LOG.error((Object)"Impossible to connect to server.");
        return new TreeMap<String, String>();
    }

    @Override
    public String readTextFile(String string) {
        if (this.isServerSide()) {
            TextReader textReader = new TextReader(string);
            return textReader.read();
        }
        String string2 = (String)this.cache.get(string);
        if (null != string2) {
            return string2;
        }
        for (int i = 0; i < 3; ++i) {
            try {
                String string3 = this.getRemote().readTextFile(string);
                this.cache.put(string, string3);
                return string3;
            }
            catch (RemoteException remoteException) {
                LOG.error((Object)remoteException);
                this.clearRemote();
                continue;
            }
        }
        LOG.error((Object)"Impossible to connect to server.");
        return "";
    }

    @Override
    public TreeMap readKeywords(String string, Locale locale) {
        if (this.isServerSide()) {
            KeywordsReader keywordsReader = new KeywordsReader(string, locale);
            return keywordsReader.read();
        }
        TreeMap treeMap = (TreeMap)this.cache.get(string + locale);
        if (null != treeMap) {
            return treeMap;
        }
        for (int i = 0; i < 3; ++i) {
            try {
                TreeMap treeMap2 = this.getRemote().readKeywords(string, locale);
                this.cache.put(string + locale, treeMap2);
                return treeMap2;
            }
            catch (RemoteException remoteException) {
                LOG.error((Object)remoteException);
                this.clearRemote();
                continue;
            }
        }
        LOG.error((Object)"Impossible to connect to server.");
        return new TreeMap();
    }

    @Override
    public TreeMap<String, String> readCustomKeywords(String string, Locale locale) {
        if (this.isServerSide()) {
            KeywordsReader keywordsReader = new KeywordsReader(string, locale, false, false);
            return keywordsReader.readCustom();
        }
        for (int i = 0; i < 3; ++i) {
            try {
                TreeMap treeMap = this.getRemote().readCustomKeywords(string, locale);
                return treeMap;
            }
            catch (RemoteException remoteException) {
                LOG.error((Object)remoteException);
                this.clearRemote();
                continue;
            }
        }
        LOG.error((Object)"Impossible to connect to server.");
        return new TreeMap<String, String>();
    }

    @Override
    public void writeCustomKeywords(TreeMap<String, String> treeMap, String string, Locale locale) throws Exception {
        if (this.isServerSide()) {
            KeywordsReader keywordsReader = new KeywordsReader(string, locale, false, false);
            keywordsReader.writeCustom(treeMap);
        } else {
            for (int i = 0; i < 3; ++i) {
                try {
                    this.getRemote().writeCustomKeywords(treeMap, string, locale);
                    TreeMap treeMap2 = this.getRemote().readKeywords(string, locale);
                    this.cache.put(string + locale, treeMap2);
                    continue;
                }
                catch (RemoteException remoteException) {
                    LOG.error((Object)remoteException);
                    LOG.error((Object)"Impossible to connect to server.");
                    this.clearRemote();
                }
            }
        }
    }

    @Override
    public String[] readSqlQueries(String string) {
        if (this.isServerSide()) {
            SQLReader sQLReader = new SQLReader(string);
            return sQLReader.read();
        }
        String[] stringArray = (String[])this.cache.get(string);
        if (null != stringArray) {
            return stringArray;
        }
        for (int i = 0; i < 3; ++i) {
            try {
                String[] stringArray2 = this.getRemote().readSqlQueries(string);
                this.cache.put(string, stringArray2);
                return stringArray2;
            }
            catch (RemoteException remoteException) {
                LOG.error((Object)remoteException);
                this.clearRemote();
                continue;
            }
        }
        LOG.error((Object)"Impossible to connect to server.");
        return new String[0];
    }

    @Override
    public Element readXmlFile(String string) {
        Element element = (Element)this.cache.get(string);
        if (null != element) {
            return element;
        }
        if (this.isServerSide()) {
            XmlReader xmlReader = new XmlReader(string);
            Element element2 = xmlReader.read();
            this.cache.put(string, element2);
            return element2;
        }
        for (int i = 0; i < 3; ++i) {
            try {
                Element element3 = this.getRemote().readXmlFile(string);
                this.cache.put(string, element3);
                return element3;
            }
            catch (RemoteException remoteException) {
                LOG.error((Object)remoteException);
                this.clearRemote();
                continue;
            }
        }
        LOG.error((Object)"Impossible to connect to server.");
        return null;
    }

    @Override
    public String readHtmlFile(String string, Locale locale) {
        if (this.isServerSide()) {
            HtmlReader htmlReader = new HtmlReader(string, locale);
            return htmlReader.read();
        }
        String string2 = (String)this.cache.get(string + locale);
        if (null != string2) {
            return string2;
        }
        for (int i = 0; i < 3; ++i) {
            try {
                String string3 = this.getRemote().readHtmlFile(string, locale);
                this.cache.put(string + locale, string3);
                return string3;
            }
            catch (RemoteException remoteException) {
                LOG.error((Object)remoteException);
                this.clearRemote();
                continue;
            }
        }
        LOG.error((Object)"Impossible to connect to server.");
        return "";
    }

    @Override
    public String getProperty(ServerProperty serverProperty) {
        if (this.isServerSide()) {
            return ServerProperties.getInstance().get(serverProperty);
        }
        String string = (String)this.cache.get(serverProperty);
        if (null != string) {
            return string;
        }
        for (int i = 0; i < 3; ++i) {
            try {
                String string2 = this.getRemote().getProperty(serverProperty);
                this.cache.put(serverProperty, string2);
                return string2;
            }
            catch (RemoteException remoteException) {
                LOG.error((Object)remoteException);
                this.clearRemote();
                continue;
            }
        }
        LOG.error((Object)"Impossible to connect to server.");
        return null;
    }

    @Override
    public boolean hasModule(Modules modules) {
        return this.hasModule(modules.getName());
    }

    public boolean hasModule(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.hasModule(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasModule(String string) {
        if (null == this.modules) {
            Modules[] modulesArray = this.getModules();
            this.modules = new HashSet();
            for (int i = 0; i < modulesArray.length; ++i) {
                this.modules.add(modulesArray[i].getName());
            }
        }
        return this.modules.contains(string);
    }

    private final Set _getModules(ServerProperty serverProperty) {
        HashSet<Modules> hashSet = new HashSet<Modules>();
        String string = ServerProperties.getInstance().get(serverProperty);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",; ");
        while (stringTokenizer.hasMoreTokens()) {
            Modules modules;
            String string2 = stringTokenizer.nextToken().toLowerCase();
            boolean bl = true;
            if (string2.startsWith("!")) {
                bl = false;
                string2 = string2.substring(1);
            }
            if (null == (modules = Modules.getByName(string2))) continue;
            if (Modules.ALL == modules) {
                Util.addAll(hashSet, (Object[])Modules.getAllModules());
                hashSet.remove(Modules.ALL);
                continue;
            }
            if (bl) {
                hashSet.add(modules);
                continue;
            }
            hashSet.remove(modules);
        }
        return hashSet;
    }

    @Override
    public Modules[] getModules() {
        if (this.isServerSide()) {
            Set set = this._getModules(ServerProperty.MODULE_LIST);
            Set set2 = this._getModules(ServerProperty.ACTIVATED_MODULE_LIST);
            set2.retainAll(set);
            Modules[] modulesArray = new Modules[set2.size()];
            set2.toArray(modulesArray);
            return modulesArray;
        }
        for (int i = 0; i < 3; ++i) {
            try {
                return this.getRemote().getModules();
            }
            catch (RemoteException remoteException) {
                LOG.error((Object)remoteException);
                this.clearRemote();
                continue;
            }
        }
        LOG.error((Object)"Impossible to connect to server.");
        return new Modules[0];
    }

    @Override
    public List<String> getLanguages() {
        if (this.isServerSide()) {
            KeywordsReader keywordsReader = new KeywordsReader();
            return keywordsReader.getLanguages();
        }
        for (int i = 0; i < 3; ++i) {
            try {
                List<String> list = this.getRemote().getLanguages();
                return list;
            }
            catch (RemoteException remoteException) {
                LOG.error((Object)remoteException);
                this.clearRemote();
                continue;
            }
        }
        LOG.error((Object)"Impossible to connect to server.");
        return new ArrayList<String>();
    }

    public int getIntProperty(ServerProperty serverProperty) {
        return Integer.parseInt(this.getProperty(serverProperty).trim());
    }

    public boolean getBooleanProperty(ServerProperty serverProperty) {
        return "true".equalsIgnoreCase(this.getProperty(serverProperty).trim());
    }

    public synchronized void reset() {
        this.modules = null;
        this.remote = null;
        ServerLocation.getInstance(this.basePath).reset();
    }
}

