/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.config.readers;

import com.adesoft.config.ConfigManager;
import com.adesoft.config.readers.ReadersManager;
import com.adesoft.config.readers.XmlReader;
import com.adesoft.fastxml.XmlWriter;
import com.adesoft.log.Category;
import com.adesoft.properties.ServerProperty;
import com.adesoft.tokenparser.ConstAction;
import com.adesoft.tokenparser.ReplaceAction;
import com.adesoft.tokenparser.TokenParser;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.security.AccessController;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Element;
import sun.security.action.GetPropertyAction;

public abstract class AbstractReader {
    private static final Category LOG = Category.getInstance((String)"com.adesoft.config.readers.AbstractReader");
    protected static final String CONFIG = "Config";
    protected static final String DEFAULT = "default";
    protected static final String CUSTOM = "Custom";
    protected static final String TEMPLATE_FILE = "template";
    protected static final char TOKEN_DELIMITER = '@';
    private static final String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    private final String root;
    private final String name;
    private final boolean readCustomFiles;
    private final boolean replaceMode;

    protected AbstractReader(String string, boolean bl, boolean bl2) {
        String string2 = "..";
        File file = new File("");
        if (-1 != file.getAbsolutePath().indexOf("eclipse")) {
            string2 = System.getProperty("user.dir").substring(0, System.getProperty("user.dir").lastIndexOf(File.separator) + 1);
        }
        this.name = string;
        this.root = new File(string2).getAbsolutePath();
        this.replaceMode = bl;
        this.readCustomFiles = bl2;
    }

    protected AbstractReader(String string) {
        this(string, ReadersManager.getInstance().isReplaceMode(string), ReadersManager.getInstance().isReadCustomFiles(string));
    }

    protected String getName() {
        return this.name;
    }

    protected boolean isReadCustomFiles() {
        return this.readCustomFiles;
    }

    protected boolean isReplaceMode() {
        return this.replaceMode;
    }

    protected String getConfigFolder() {
        return this.root + File.separator + CONFIG + File.separator;
    }

    protected String getDefaultConfigFolder() {
        return this.root + File.separator + CONFIG + File.separator + DEFAULT + File.separator;
    }

    private static final byte[] parseHex(String string) {
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        for (int i = 0; i < n; i += 2) {
            byArray[n2++] = (byte)Integer.parseInt(string.substring(i, i + 2), 16);
        }
        return byArray;
    }

    protected final boolean verifySignature(Element element, String string, String string2) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XmlWriter xmlWriter = new XmlWriter((OutputStream)byteArrayOutputStream, true);
            xmlWriter.outputXML(element);
            xmlWriter.close();
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(AbstractReader.parseHex(string));
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            Signature signature = Signature.getInstance("SHA1withDSA");
            signature.initVerify(publicKey);
            signature.update(byteArrayOutputStream.toByteArray());
            return signature.verify(AbstractReader.parseHex(string2));
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Impossible to verify file signature : " + throwable);
        }
    }

    protected static String readFile(File file) {
        return AbstractReader.readFile(file, "ISO8859-1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String readFile(File file, String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            BufferedReader bufferedReader = null;
            try {
                String string2;
                FileInputStream fileInputStream = new FileInputStream(file);
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, string));
                while (null != (string2 = bufferedReader.readLine())) {
                    stringBuffer.append(string2).append(lineSeparator);
                }
            }
            finally {
                if (null != bufferedReader) {
                    bufferedReader.close();
                }
            }
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unable to read the file : " + file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TreeMap readPropertiesFileWithTemplate(File file, String string) throws IOException {
        String string2 = AbstractReader.readFile(file, string);
        XmlReader xmlReader = new XmlReader(TEMPLATE_FILE);
        Element element = xmlReader.read();
        TreeMap treeMap = AbstractReader.readTokens(element);
        string2 = AbstractReader.replace(string2, treeMap);
        TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
        BufferedReader bufferedReader = null;
        try {
            String string3;
            bufferedReader = new BufferedReader(new StringReader(string2));
            while (null != (string3 = bufferedReader.readLine())) {
                int n;
                if ((string3 = AbstractReader.removeLeadingSpaces(string3)).startsWith("#") || -1 == (n = string3.indexOf(61))) continue;
                String string4 = string3.substring(0, n).trim();
                String string5 = string3.substring(1 + n);
                string5 = AbstractReader.loadConvert(string5);
                treeMap2.put(string4, string5);
            }
        }
        finally {
            if (null != bufferedReader) {
                bufferedReader.close();
            }
        }
        return treeMap2;
    }

    protected static TreeMap cleanMap(TreeMap treeMap) {
        TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        LOG.debug((Object)" - Verify all the keywords...");
        for (Map.Entry iterator2 : treeMap.entrySet()) {
            String string = (String)iterator2.getKey();
            String string2 = (String)iterator2.getValue();
            try {
                String string3 = AbstractReader.convert(treeMap, string2, 0);
                if (null == string3) {
                    arrayList2.add(string);
                }
                if (treeMap2.containsKey(string)) {
                    arrayList.add(string);
                }
                treeMap2.put(string, string3);
            }
            catch (Throwable throwable) {
                LOG.debug((Object)(" - Invalid : " + string + '=' + string2));
            }
        }
        if (!arrayList.isEmpty()) {
            LOG.debug((Object)"Dumping Keywords duplicated :");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                LOG.debug(iterator.next());
            }
            LOG.debug((Object)"Dumping finished");
        }
        if (!arrayList2.isEmpty()) {
            LOG.debug((Object)"Dumping Keywords with no value :");
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                LOG.debug(iterator.next());
            }
            LOG.debug((Object)"Dumping finished");
        }
        LOG.debug((Object)"Done");
        return treeMap2;
    }

    private static String convert(TreeMap treeMap, String string, int n) {
        if (string.indexOf(36) < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(20);
        StringBuffer stringBuffer2 = new StringBuffer(100);
        boolean bl = false;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if ('$' == c) {
                if (bl) {
                    if (n < 100) {
                        stringBuffer2.append(AbstractReader.convert(treeMap, (String)treeMap.get(stringBuffer.toString()), n + 1));
                    } else {
                        stringBuffer2.append("ERROR (" + string + ")");
                    }
                    bl = false;
                    continue;
                }
                stringBuffer.setLength(0);
                bl = true;
                continue;
            }
            if (bl) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer2.append(c);
        }
        if (bl) {
            stringBuffer2.append('$');
            stringBuffer2.append(stringBuffer);
        }
        return stringBuffer2.toString();
    }

    private static String removeLeadingSpaces(String string) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && string.charAt(n) == ' '; ++n) {
        }
        return n > 0 ? string.substring(n, n2) : string;
    }

    private static String loadConvert(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if ((n3 = string.charAt(n2++)) == 92) {
                if ((n3 = string.charAt(n2++)) == 117) {
                    int n4 = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        n3 = string.charAt(n2++);
                        switch (n3) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                n4 = (n4 << 4) + n3 - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                n4 = (n4 << 4) + 10 + n3 - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                n4 = (n4 << 4) + 10 + n3 - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    stringBuffer.append((char)n4);
                    continue;
                }
                if (n3 == 116) {
                    n3 = 9;
                } else if (n3 == 114) {
                    n3 = 13;
                } else if (n3 == 110) {
                    n3 = 10;
                } else if (n3 == 102) {
                    n3 = 12;
                }
                stringBuffer.append((char)n3);
                continue;
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    protected File getDefaultFile(String string) {
        File file = new File(this.getDefaultConfigFolder() + string);
        return file;
    }

    protected File[] getCustomFiles(String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = new File(this.getConfigFolder()).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string2 = fileArray[i].getName();
            if (!string2.startsWith(CUSTOM) || !string2.endsWith(string)) continue;
            arrayList.add(fileArray[i]);
        }
        File[] fileArray2 = new File[arrayList.size()];
        arrayList.toArray(fileArray2);
        return fileArray2;
    }

    /*
     * WARNING - void declaration
     */
    protected static String replace(String string, TreeMap treeMap) {
        void var4_7;
        TokenParser tokenParser = new TokenParser('@');
        for (Map.Entry object2 : treeMap.entrySet()) {
            String string2 = (String)object2.getKey();
            String string3 = (String)object2.getValue();
            tokenParser.register(string2, (ReplaceAction)new ConstAction(string3));
        }
        try {
            String string4 = tokenParser.parse(string);
        }
        catch (Throwable throwable) {
            LOG.error((Object)("Unable to parse the template : " + throwable));
            String string5 = string;
        }
        return var4_7;
    }

    protected static void addTokens(Element element, TreeMap treeMap) {
        Iterator iterator = element.children();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            treeMap.put(element2.getString("name"), element2.getString("with"));
        }
    }

    protected static TreeMap readTokens(Element element) {
        TreeMap treeMap = new TreeMap();
        Iterator iterator = element.children();
        block0: while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            String string = element2.getString("name");
            ServerProperty serverProperty = ServerProperty.getByName(string);
            if (null == serverProperty) {
                LOG.error((Object)("Unknown server property : " + string));
                continue;
            }
            Element element3 = element2.getChild(DEFAULT);
            if (null != element3) {
                AbstractReader.addTokens(element3, treeMap);
            }
            String string2 = ConfigManager.getInstance().getProperty(serverProperty);
            for (Element element4 : element2.getChildren("customized")) {
                String string3 = element4.getString("value");
                if (!string3.equals(string2)) continue;
                AbstractReader.addTokens(element4, treeMap);
                continue block0;
            }
        }
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TreeMap readPropertiesFile(File file) throws IOException {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        BufferedReader bufferedReader = null;
        try {
            String string;
            FileInputStream fileInputStream = new FileInputStream(file);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "ISO8859-1"));
            while (null != (string = bufferedReader.readLine())) {
                int n;
                if ((string = AbstractReader.removeLeadingSpaces(string)).startsWith("#") || -1 == (n = string.indexOf(61))) continue;
                String string2 = string.substring(0, n).trim();
                String string3 = string.substring(1 + n);
                string3 = AbstractReader.loadConvert(string3);
                treeMap.put(string2, string3);
            }
        }
        finally {
            if (null != bufferedReader) {
                bufferedReader.close();
            }
        }
        return treeMap;
    }
}

