/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.config.readers;

import com.adesoft.arrays.StringArray;
import com.adesoft.config.readers.AbstractReader;
import com.adesoft.log.Category;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public final class KeywordsReader
extends AbstractReader {
    private static final Category LOG = Category.getInstance((String)"com.adesoft.config.readers.KeywordsReader");
    private static final String EXTENSION = ".properties";
    private static final String KEYWORDS = "Keywords_";
    private static final HashMap<String, String> charsetMap = new HashMap();
    private final Locale locale;

    public KeywordsReader() {
        super(null, true, true);
        this.locale = null;
    }

    public KeywordsReader(String string, Locale locale) {
        super(string);
        this.locale = locale;
    }

    public KeywordsReader(String string, Locale locale, boolean bl, boolean bl2) {
        super(string, bl, bl2);
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    private String findSuffix() {
        StringArray stringArray = new StringArray();
        stringArray.add("_" + this.getLocale().getLanguage() + "_" + this.getLocale().getCountry() + "_" + this.getLocale().getVariant() + EXTENSION);
        stringArray.add("_" + this.getLocale().getLanguage() + "_" + this.getLocale().getCountry() + EXTENSION);
        stringArray.add("_" + this.getLocale().getLanguage() + EXTENSION);
        stringArray.add(EXTENSION);
        stringArray.add("_en.properties");
        for (int i = 0; i < stringArray.size(); ++i) {
            String string = this.getDefaultConfigFolder() + this.getName() + stringArray.get(i);
            File file = new File(string);
            if (!file.exists()) continue;
            return stringArray.get(i);
        }
        throw new RuntimeException("Unable to find the keywords file for Locale : " + this.getLocale());
    }

    private String getCharset() {
        String string = charsetMap.get(this.getLocale().getLanguage());
        return string != null ? string : Charset.defaultCharset().name();
    }

    public TreeMap read() {
        File[] fileArray;
        long l = System.currentTimeMillis();
        LOG.debug((Object)("Read keywords for locale " + this.getLocale()));
        TreeMap treeMap = new TreeMap();
        String string = this.findSuffix();
        Throwable throwable = null;
        try {
            fileArray = this.getCustomFiles(this.getName() + string);
            String string2 = this.getCharset();
            if (!this.isReplaceMode() || !this.isReadCustomFiles() || 0 == fileArray.length) {
                treeMap.putAll(KeywordsReader.readPropertiesFileWithTemplate(this.getDefaultFile(this.getName() + string), string2));
            }
            if (this.isReadCustomFiles()) {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (this.isReplaceMode()) {
                        treeMap.clear();
                    }
                    treeMap.putAll(KeywordsReader.readPropertiesFileWithTemplate(fileArray[i], string2));
                }
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (null != throwable) {
            throw new RuntimeException("Unable to find the keywords file for Locale : " + this.getLocale() + ". " + throwable);
        }
        fileArray = KeywordsReader.cleanMap(treeMap);
        long l2 = System.currentTimeMillis();
        LOG.debug((Object)(" - Done in " + (l2 - l) + "ms"));
        return fileArray;
    }

    public TreeMap<String, String> readCustom() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        String string = this.findSuffix();
        Throwable throwable = null;
        try {
            File[] fileArray = this.getCustomFiles(this.getName() + string);
            String string2 = this.getCharset();
            for (int i = 0; i < fileArray.length; ++i) {
                treeMap.putAll(KeywordsReader.readPropertiesFileWithTemplate(fileArray[i], string2));
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (null != throwable) {
            throw new RuntimeException("Unable to find the CustomKeywords file for Locale : " + this.getLocale() + ". " + throwable);
        }
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCustom(TreeMap<String, String> treeMap) throws IOException {
        String string = this.findSuffix();
        File[] fileArray = this.getCustomFiles(this.getName() + string);
        File file = null;
        file = fileArray.length > 0 ? fileArray[0] : new File(this.getConfigFolder() + File.separator + "Custom" + this.getName() + string);
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedWriter bufferedWriter = null;){
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            for (Map.Entry<String, String> entry : treeMap.entrySet()) {
                String string2 = entry.getKey() + "=" + entry.getValue();
                stringBuilder.append(string2);
                stringBuilder.append("\n");
            }
            bufferedWriter.write(stringBuilder.toString());
        }
    }

    public List<String> getLanguages() {
        ArrayList<String> arrayList = new ArrayList<String>();
        File[] fileArray = new File(this.getDefaultConfigFolder()).listFiles();
        if (null != fileArray) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string = fileArray[i].getName();
                if (!string.startsWith(KEYWORDS) || !string.endsWith(EXTENSION)) continue;
                int n = string.lastIndexOf(EXTENSION);
                String string2 = string.substring(9, n);
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    static {
        charsetMap.put("ar", "ISO-8859-6");
        charsetMap.put("be", "ISO-8859-5");
        charsetMap.put("bg", "ISO-8859-5");
        charsetMap.put("ca", "ISO-8859-1");
        charsetMap.put("cs", "ISO-8859-2");
        charsetMap.put("da", "ISO-8859-1");
        charsetMap.put("de", "ISO-8859-1");
        charsetMap.put("el", "ISO-8859-7");
        charsetMap.put("en", "ISO-8859-1");
        charsetMap.put("es", "ISO-8859-1");
        charsetMap.put("et", "ISO-8859-1");
        charsetMap.put("fi", "ISO-8859-1");
        charsetMap.put("fr", "ISO-8859-1");
        charsetMap.put("he", "ISO-8859-8");
        charsetMap.put("hr", "ISO-8859-2");
        charsetMap.put("hu", "ISO-8859-2");
        charsetMap.put("is", "ISO-8859-1");
        charsetMap.put("it", "ISO-8859-1");
        charsetMap.put("iw", "ISO-8859-8");
        charsetMap.put("ja", "Shift_JIS");
        charsetMap.put("ko", "EUC-KR");
        charsetMap.put("lt", "ISO-8859-2");
        charsetMap.put("lv", "ISO-8859-2");
        charsetMap.put("mk", "ISO-8859-5");
        charsetMap.put("nl", "ISO-8859-1");
        charsetMap.put("no", "ISO-8859-1");
        charsetMap.put("pl", "ISO-8859-2");
        charsetMap.put("pt", "ISO-8859-1");
        charsetMap.put("ro", "ISO-8859-2");
        charsetMap.put("ru", "ISO-8859-5");
        charsetMap.put("sh", "ISO-8859-5");
        charsetMap.put("sk", "ISO-8859-2");
        charsetMap.put("sl", "ISO-8859-2");
        charsetMap.put("sq", "ISO-8859-2");
        charsetMap.put("sr", "ISO-8859-5");
        charsetMap.put("sv", "ISO-8859-1");
        charsetMap.put("tr", "ISO-8859-9");
        charsetMap.put("uk", "ISO-8859-5");
        charsetMap.put("zh", "GB2312");
        charsetMap.put("zh_TW", "Big5");
    }
}

