/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.fastxml;

import java.io.IOException;
import java.io.OutputStream;

public final class BytesOutputStream
extends OutputStream {
    private static final int DEFAULT_INITIAL_BUFFER_SIZE = 8192;
    private byte[] buffer;
    private int index;
    private boolean closed;

    public BytesOutputStream() {
        this(8192);
    }

    public BytesOutputStream(int n) {
        this.buffer = new byte[n];
    }

    @Override
    public void write(int n) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        this.ensureCanAdd(1);
        this.buffer[this.index++] = (byte)n;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n + n2 > byArray.length || n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        this.ensureCanAdd(n2);
        System.arraycopy(byArray, n, this.buffer, this.index, n2);
        this.index += n2;
    }

    private void ensureCanAdd(int n) {
        if (this.index + n > this.buffer.length) {
            byte[] byArray = new byte[2 * this.buffer.length + n];
            System.arraycopy(this.buffer, 0, byArray, 0, this.index);
            this.buffer = byArray;
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.index];
        System.arraycopy(this.buffer, 0, byArray, 0, this.index);
        return byArray;
    }

    public int length() {
        return this.index;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buffer, 0, this.index);
    }

    public void reset() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        this.index = 0;
    }
}

