/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.fastxml;

import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

final class FastPrintWriter {
    private static final char[] radix = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private char[] digits = new char[12];
    private int count;
    private final char[] chars;
    private final Writer out;
    private IOException error;
    private String lineSeparator;

    public FastPrintWriter(Writer writer) {
        this(writer, 4096);
    }

    public FastPrintWriter(Writer writer, int n) {
        this.chars = new char[n];
        this.count = 0;
        this.out = writer;
        this.lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    }

    public void close() throws IOException {
        try {
            this.flush();
            this.out.flush();
            this.out.close();
        }
        catch (IOException iOException) {
            this.error = iOException;
            throw iOException;
        }
    }

    public void flush() {
        if (this.count > 0) {
            try {
                if (null == this.error) {
                    this.out.write(this.chars, 0, this.count);
                }
            }
            catch (IOException iOException) {
                this.error = iOException;
            }
            finally {
                this.count = 0;
            }
        }
    }

    public IOException getError() {
        return this.error;
    }

    public void print(char c) {
        if (this.count >= this.chars.length) {
            this.flush();
        }
        this.chars[this.count++] = c;
    }

    public void print(char c, int n) {
        if (this.count + n > this.chars.length) {
            this.flush();
        }
        for (int i = 0; i < n; ++i) {
            this.chars[this.count++] = c;
        }
    }

    public void print(int n) {
        if (n < 0) {
            this.print('-');
            n = -n;
        }
        if (n < 10) {
            this.print(radix[n]);
        } else {
            char[] cArray = this.chars;
            int n2 = 12;
            do {
                this.digits[--n2] = radix[n % 10];
            } while (0 != (n /= 10));
            if (this.count + (12 - n2) > cArray.length) {
                this.flush();
            }
            for (int i = n2; i < 12; ++i) {
                cArray[this.count++] = this.digits[i];
            }
        }
    }

    public void print(String string) {
        int n = string.length();
        if (this.count + n > this.chars.length) {
            this.flush();
        }
        string.getChars(0, n, this.chars, this.count);
        this.count += n;
    }

    public void print(double d) {
        this.print(Double.toString(d));
    }

    public void print(long l) {
        this.print(Long.toString(l));
    }

    public void print(boolean bl) {
        if (bl) {
            if (this.count + 4 > this.chars.length) {
                this.flush();
            }
            this.chars[this.count++] = 116;
            this.chars[this.count++] = 114;
            this.chars[this.count++] = 117;
            this.chars[this.count++] = 101;
        } else {
            if (this.count + 5 > this.chars.length) {
                this.flush();
            }
            this.chars[this.count++] = 102;
            this.chars[this.count++] = 97;
            this.chars[this.count++] = 108;
            this.chars[this.count++] = 115;
            this.chars[this.count++] = 101;
        }
    }

    public void newLine() {
        this.print(this.lineSeparator);
    }

    public void println(char c) {
        this.print(c);
        this.print(this.lineSeparator);
    }

    public void println(String string) {
        this.print(string);
        this.print(this.lineSeparator);
    }

    public void println(int n) {
        this.print(n);
        this.print(this.lineSeparator);
    }

    public void println(double d) {
        this.print(d);
        this.print(this.lineSeparator);
    }

    public void println(long l) {
        this.print(l);
        this.print(this.lineSeparator);
    }

    public void println(boolean bl) {
        this.print(bl);
        this.print(this.lineSeparator);
    }
}

