/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.fastxml;

import com.adesoft.fastxml.FastPrintWriter;
import com.dautelle.util.Utf8StreamWriter;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Element;

public class XmlWriter {
    private final FastPrintWriter out;
    private final boolean compact;
    private boolean cdata;
    private boolean needToClose;
    private boolean quickClose;
    private int level;

    public XmlWriter(OutputStream outputStream) {
        this(outputStream, false);
    }

    public XmlWriter(OutputStream outputStream, int n, boolean bl) {
        this(new Utf8StreamWriter(n).setOutputStream(outputStream), bl);
    }

    public XmlWriter(OutputStream outputStream, boolean bl) {
        this(new Utf8StreamWriter().setOutputStream(outputStream), bl);
    }

    public XmlWriter(Writer writer, boolean bl) {
        this(writer, bl, true);
    }

    public XmlWriter(Writer writer, boolean bl, String string) {
        this(writer, 20480, bl, true, string);
    }

    public XmlWriter(Writer writer, boolean bl, boolean bl2) {
        this(writer, 20480, bl, bl2, "UTF-8");
    }

    public XmlWriter(Writer writer, int n, boolean bl, boolean bl2, String string) {
        this.out = new FastPrintWriter(writer, n);
        this.needToClose = false;
        this.quickClose = false;
        this.compact = bl;
        if (bl2) {
            this.out.print("<?xml version=\"1.0\" encoding=\"" + string + "\"?>");
            if (!this.compact) {
                this.out.newLine();
            }
        }
    }

    public void createElement(String string) {
        if (this.needToClose) {
            this.out.print('>');
            if (!this.compact) {
                this.out.newLine();
            }
        }
        if (!this.compact) {
            this.out.print('\t', this.level);
        }
        this.out.print('<');
        this.out.print(string);
        this.cdata = false;
        this.needToClose = true;
        this.quickClose = true;
        ++this.level;
    }

    public void endElement(String string) {
        --this.level;
        if (this.cdata) {
            this.out.print("</");
            this.out.print(string);
            this.out.print('>');
        } else if (this.quickClose) {
            this.out.print("/>");
        } else {
            if (!this.compact) {
                this.out.print('\t', this.level);
            }
            this.out.print("</");
            this.out.print(string);
            this.out.print('>');
        }
        if (!this.compact) {
            this.out.newLine();
        }
        this.cdata = false;
        this.quickClose = false;
        this.needToClose = false;
    }

    public void addCDATA(String string) {
        this.out.print(">");
        this.convertString(string);
        this.cdata = true;
    }

    public void addCDATA(int n) {
        this.out.print(">");
        this.out.print(n);
        this.cdata = true;
    }

    private final void convertString(String string) {
        int n = string.length();
        block11: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    this.out.print("&lt;");
                    continue block11;
                }
                case '>': {
                    this.out.print("&gt;");
                    continue block11;
                }
                case '\"': {
                    this.out.print("&quot;");
                    continue block11;
                }
                case '\'': {
                    this.out.print("&apos;");
                    continue block11;
                }
                case '&': {
                    this.out.print("&amp;");
                    continue block11;
                }
                case '\n': {
                    this.out.print("&#10;");
                    continue block11;
                }
                case '\t': {
                    this.out.print("&#9;");
                    continue block11;
                }
                case '\r': {
                    this.out.print("&#13;");
                    continue block11;
                }
                case '\f': {
                    this.out.print("&#13;");
                    continue block11;
                }
                default: {
                    if (c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff') {
                        this.out.print(c);
                        continue block11;
                    }
                    this.out.print("_");
                }
            }
        }
    }

    public void addAttribute(String string, String string2) {
        this.out.print(' ');
        this.out.print(string);
        this.out.print("=\"");
        this.convertString(string2);
        this.out.print('\"');
    }

    public void addAttribute(String string, int n) {
        this.out.print(' ');
        this.out.print(string);
        this.out.print("=\"");
        this.out.print(n);
        this.out.print('\"');
    }

    public void addAttribute(String string, byte[] byArray) {
        this.out.print(' ');
        this.out.print(string);
        this.out.print("=\"");
        this.out.print(XmlWriter.toString(byArray));
        this.out.print('\"');
    }

    public void addAttribute(String string, int[] nArray) {
        this.out.print(' ');
        this.out.print(string);
        this.out.print("=\"");
        this.out.print(XmlWriter.toString(nArray));
        this.out.print('\"');
    }

    public void addAttribute(String string, double[] dArray) {
        this.out.print(' ');
        this.out.print(string);
        this.out.print("=\"");
        this.out.print(XmlWriter.toString(dArray));
        this.out.print('\"');
    }

    public void addAttribute(String string, long l) {
        this.out.print(' ');
        this.out.print(string);
        this.out.print("=\"");
        this.out.print(l);
        this.out.print('\"');
    }

    public void addAttribute(String string, boolean bl) {
        this.out.print(' ');
        this.out.print(string);
        this.out.print("=\"");
        this.out.print(bl);
        this.out.print('\"');
    }

    public void addAttribute(String string, double d) {
        this.out.print(' ');
        this.out.print(string);
        this.out.print("=\"");
        this.out.print(d);
        this.out.print('\"');
    }

    public void flush() {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.flush();
        this.out.close();
    }

    public void writeComment(Map map) {
        this.out.println("<!--");
        if (null != map) {
            for (Map.Entry entry : map.entrySet()) {
                this.out.print("    ");
                this.out.print((String)entry.getKey());
                this.out.print(": ");
                this.out.println((String)entry.getValue());
            }
        }
        this.out.println("-->");
    }

    public void writeDtd(String string) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        while (-1 != (n = bufferedInputStream.read())) {
            this.out.print((char)n);
        }
    }

    private static final String toString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            if (0 != i) {
                stringBuffer.append(',');
            }
            stringBuffer.append(byArray[i]);
        }
        return stringBuffer.toString();
    }

    private static final String toString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if (0 != i) {
                stringBuffer.append(',');
            }
            stringBuffer.append(nArray[i]);
        }
        return stringBuffer.toString();
    }

    private static final String toString(double[] dArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < dArray.length; ++i) {
            if (0 != i) {
                stringBuffer.append(',');
            }
            stringBuffer.append(dArray[i]);
        }
        return stringBuffer.toString();
    }

    public final void outputXML(Element element) {
        Object object;
        Object object2;
        this.createElement(element.getName());
        List list = element.getAttributes();
        if (!list.isEmpty()) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (Attribute)object2.next();
                this.addAttribute(((Attribute)object).getName(), ((Attribute)object).getValue());
            }
        }
        if (null != (object2 = element.getContent())) {
            object = object2.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                if (e instanceof Element) {
                    this.outputXML((Element)e);
                    continue;
                }
                if (!(e instanceof CDATA)) continue;
                this.addCDATA(((CDATA)e).getText());
                break;
            }
        }
        this.endElement(element.getName());
    }

    public IOException getError() {
        return this.out.getError();
    }

    public static void main(String[] stringArray) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("C:/test.txt");
            XmlWriter xmlWriter = new XmlWriter(fileOutputStream, false);
            xmlWriter.createElement("TOTO");
            xmlWriter.addAttribute("titi", "hello<>");
            xmlWriter.addAttribute("tutu", "test");
            xmlWriter.endElement("TOTO");
            xmlWriter.createElement("TOTO");
            xmlWriter.endElement("TOTO");
            xmlWriter.createElement("TEST1");
            xmlWriter.createElement("TEST2");
            xmlWriter.createElement("TEST3");
            xmlWriter.addAttribute("tutu", "true");
            xmlWriter.endElement("TEST3");
            xmlWriter.endElement("TEST2");
            xmlWriter.endElement("TEST1");
            xmlWriter.createElement("TEST1");
            xmlWriter.createElement("TEST2");
            xmlWriter.createElement("TEST3");
            xmlWriter.endElement("TEST3");
            xmlWriter.endElement("TEST2");
            xmlWriter.endElement("TEST1");
            xmlWriter.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

