/*
 * Decompiled with CFR 0.152.
 */
package com.dautelle.util;

import com.dautelle.util.FastMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public final class CachedMap
implements Map {
    private final FastMap _backingFastMap;
    private final Map _backingMap;
    private final FastMap _keysMap;
    private final int _mask;
    private final Object[] _keys;
    private final Object[] _values;

    public CachedMap() {
        this(256, new FastMap());
    }

    public CachedMap(int n) {
        this(n, new FastMap(n));
    }

    public CachedMap(int n, Map map) {
        int n2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this._keys = new Object[n2];
        this._values = new Object[n2];
        this._mask = n2 - 1;
        if (map instanceof FastMap) {
            this._backingFastMap = (FastMap)map;
            this._backingMap = this._backingFastMap;
            this._keysMap = null;
        } else {
            this._backingFastMap = null;
            this._backingMap = map;
            this._keysMap = new FastMap(map.size());
            for (Object k : map.keySet()) {
                this._keysMap.put(k, k);
            }
        }
    }

    public int getCacheSize() {
        return this._keys.length;
    }

    public Map getBackingMap() {
        return this._backingFastMap != null ? this._backingFastMap : this._backingMap;
    }

    public void flush() {
        for (int i = 0; i < this._keys.length; ++i) {
            this._keys[i] = null;
            this._values[i] = null;
        }
        if (this._keysMap != null) {
            for (Object k : this._backingMap.keySet()) {
                this._keysMap.put(k, k);
            }
        }
    }

    public Object get(Object object) {
        int n = object.hashCode() & this._mask;
        return object.equals(this._keys[n]) ? this._values[n] : this.getCacheMissed(object, n);
    }

    private Object getCacheMissed(Object object, int n) {
        if (this._backingFastMap != null) {
            Map.Entry entry = this._backingFastMap.getEntry(object);
            if (entry != null) {
                this._keys[n] = entry.getKey();
                Object v = entry.getValue();
                this._values[n] = v;
                return v;
            }
            return null;
        }
        Object object2 = this._keysMap.get(object);
        if (object2 != null) {
            this._keys[n] = object2;
            Object v = this._backingMap.get(object);
            this._values[n] = v;
            return v;
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        int n = object.hashCode() & this._mask;
        if (object.equals(this._keys[n])) {
            this._values[n] = object2;
        } else if (this._keysMap != null) {
            this._keysMap.put(object, object);
        }
        return this._backingMap.put(object, object2);
    }

    public Object remove(Object object) {
        int n = object.hashCode() & this._mask;
        if (object.equals(this._keys[n])) {
            this._keys[n] = null;
        }
        if (this._keysMap != null) {
            this._keysMap.remove(object);
        }
        return this._backingMap.remove(object);
    }

    @Override
    public boolean containsKey(Object object) {
        int n = object.hashCode() & this._mask;
        if (object.equals(this._keys[n])) {
            return true;
        }
        return this._backingMap.containsKey(object);
    }

    @Override
    public int size() {
        return this._backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this._backingMap.isEmpty();
    }

    @Override
    public boolean containsValue(Object object) {
        return this._backingMap.containsValue(object);
    }

    public void putAll(Map map) {
        this._backingMap.putAll(map);
        this.flush();
    }

    @Override
    public void clear() {
        this._backingMap.clear();
        this.flush();
    }

    public Set keySet() {
        return Collections.unmodifiableSet(this._backingMap.keySet());
    }

    public Collection values() {
        return Collections.unmodifiableCollection(this._backingMap.values());
    }

    public Set entrySet() {
        return Collections.unmodifiableSet(this._backingMap.entrySet());
    }

    @Override
    public boolean equals(Object object) {
        return this._backingMap.equals(object);
    }

    @Override
    public int hashCode() {
        return this._backingMap.hashCode();
    }
}

