/*
 * Decompiled with CFR 0.152.
 */
package com.dautelle.util;

import com.dautelle.util.TypeFormat;
import com.dautelle.util.Union;
import com.dautelle.util.Utf8StreamReader;
import com.dautelle.util.Utf8StreamWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class Struct {
    private static final ThreadLocal OUTER = new ThreadLocal();
    private ByteBuffer _byteBuffer;
    private int _bitsUsed;
    private int _alignment;
    private int _bitIndex;
    private boolean _resetIndex = this instanceof Union;
    private final Struct _outer;
    private int _outerOffset;

    public Struct() {
        this(null);
    }

    public Struct(ByteBuffer byteBuffer) {
        this._byteBuffer = byteBuffer;
        this._outer = (Struct)OUTER.get();
    }

    public final int size() {
        int n = this._bitsUsed + 7 >> 3;
        return n % this._alignment == 0 ? n : n + this._alignment - n % this._alignment;
    }

    public final ByteBuffer byteBuffer() {
        return this._byteBuffer != null ? this._byteBuffer : this.newBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ByteBuffer newBuffer() {
        if (this._byteBuffer == null) {
            int n;
            int n2 = n = this.isPacked() ? this.size() + 7 : this.size();
            if (this._outer == null) {
                this._byteBuffer = ByteBuffer.allocate(n);
                this._byteBuffer.order(this.byteOrder());
            } else {
                ByteBuffer byteBuffer;
                ByteBuffer byteBuffer2 = byteBuffer = this._outer.byteBuffer();
                synchronized (byteBuffer2) {
                    byteBuffer.position(this._outerOffset);
                    ByteBuffer byteBuffer3 = byteBuffer.slice();
                    byteBuffer3.limit(n);
                    this._byteBuffer = byteBuffer3;
                }
                this._byteBuffer.order(this._outer.byteOrder());
            }
        }
        return this._byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Struct copy(Struct struct, Struct struct2) {
        if (struct.getClass().isInstance(struct2)) {
            ByteBuffer byteBuffer = struct.byteBuffer();
            ByteBuffer byteBuffer2 = struct2.byteBuffer();
            ByteBuffer byteBuffer3 = byteBuffer;
            synchronized (byteBuffer3) {
                ByteBuffer byteBuffer4 = byteBuffer2;
                synchronized (byteBuffer4) {
                    byteBuffer.position(0);
                    byteBuffer2.position(0);
                    byteBuffer.put(byteBuffer2);
                }
            }
            return struct2;
        }
        throw new IllegalArgumentException("Instance of " + struct.getClass() + " expected, found instance of " + struct2.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Struct)) {
            return false;
        }
        if (this.getClass() == object.getClass()) {
            ByteBuffer byteBuffer = this.byteBuffer();
            ByteBuffer byteBuffer2 = ((Struct)object).byteBuffer();
            ByteBuffer byteBuffer3 = byteBuffer;
            synchronized (byteBuffer3) {
                ByteBuffer byteBuffer4 = byteBuffer2;
                synchronized (byteBuffer4) {
                    byteBuffer.position(0);
                    byteBuffer2.position(0);
                    return byteBuffer.equals(byteBuffer2);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int hashCode() {
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2 = byteBuffer = this.byteBuffer();
        synchronized (byteBuffer2) {
            byteBuffer.position(0);
            return byteBuffer.hashCode();
        }
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer(3 * this.size());
        int n = this.size();
        ByteBuffer byteBuffer = this.byteBuffer();
        for (int i = 0; i < n; ++i) {
            int n2 = byteBuffer.get(i) & 0xFF;
            if (n2 < 16) {
                stringBuffer.append('0');
            }
            TypeFormat.format(n2, 16, stringBuffer);
            if ((i & 0xF) == 15) {
                stringBuffer.append('\n');
                continue;
            }
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public ByteOrder byteOrder() {
        if (this._outer != null) {
            return this._outer.byteOrder();
        }
        return ByteOrder.BIG_ENDIAN;
    }

    public boolean isPacked() {
        if (this._outer != null) {
            return this._outer.isPacked();
        }
        return false;
    }

    public class Float64
    extends Member {
        public Float64() {
            super(8, 8);
        }

        public void set(double d) {
            Struct.this.byteBuffer().putDouble(this.offset(), d);
        }

        public double get() {
            return Struct.this.byteBuffer().getDouble(this.offset());
        }
    }

    public class Float32
    extends Member {
        public Float32() {
            super(4, 4);
        }

        public void set(float f) {
            Struct.this.byteBuffer().putFloat(this.offset(), f);
        }

        public float get() {
            return Struct.this.byteBuffer().getFloat(this.offset());
        }
    }

    public class Signed64
    extends Member {
        private final long _mask;
        private final int _shift;
        private final int _signShift;

        public Signed64() {
            this(64);
        }

        public Signed64(int n) {
            this.updateIndexes(8, n, 64);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 64 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = n == 64 ? -1L : (1L << n) - 1L << this._shift;
            this._signShift = 64 - this._shift - n;
        }

        public long get() {
            if (this._mask == -1L) {
                return Struct.this.byteBuffer().getLong(this.offset());
            }
            long l = Struct.this.byteBuffer().getLong(this.offset());
            l &= this._mask;
            l <<= this._signShift;
            return l >>= this._signShift + this._shift;
        }

        public void set(long l) {
            if (this._mask == -1L) {
                Struct.this.byteBuffer().putLong(this.offset(), l);
            } else {
                l <<= this._shift;
                long l2 = Struct.this.byteBuffer().getLong(this.offset()) & (this._mask ^ 0xFFFFFFFFFFFFFFFFL);
                Struct.this.byteBuffer().putLong(this.offset(), l2 | (l &= this._mask));
            }
        }
    }

    public class Unsigned32
    extends Member {
        private final int _shift;
        private final long _mask;

        public Unsigned32() {
            this(32);
        }

        public Unsigned32(int n) {
            this.updateIndexes(4, n, 32);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 32 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = n == 32 ? 0xFFFFFFFFL : (1L << n) - 1L << this._shift;
        }

        public long get() {
            int n = Struct.this.byteBuffer().getInt(this.offset());
            return ((long)n & this._mask) >>> this._shift;
        }

        public void set(long l) {
            if (this._mask == -1L) {
                Struct.this.byteBuffer().putInt(this.offset(), (int)l);
            } else {
                l <<= this._shift;
                int n = Struct.this.byteBuffer().getInt(this.offset()) & ~((int)this._mask);
                Struct.this.byteBuffer().putInt(this.offset(), (int)((long)n | (l &= this._mask)));
            }
        }
    }

    public class Signed32
    extends Member {
        private final int _mask;
        private final int _shift;
        private final int _signShift;

        public Signed32() {
            this(32);
        }

        public Signed32(int n) {
            this.updateIndexes(4, n, 32);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 32 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = n == 32 ? -1 : (1 << n) - 1 << this._shift;
            this._signShift = 32 - this._shift - n;
        }

        public int get() {
            if (this._mask == -1) {
                return Struct.this.byteBuffer().getInt(this.offset());
            }
            int n = Struct.this.byteBuffer().getInt(this.offset());
            n &= this._mask;
            n <<= this._signShift;
            return n >>= this._signShift + this._shift;
        }

        public void set(int n) {
            if (this._mask == -1) {
                Struct.this.byteBuffer().putInt(this.offset(), n);
            } else {
                n <<= this._shift;
                int n2 = Struct.this.byteBuffer().getInt(this.offset()) & ~this._mask;
                Struct.this.byteBuffer().putInt(this.offset(), n2 | (n &= this._mask));
            }
        }
    }

    public class Unsigned16
    extends Member {
        private final int _shift;
        private final int _mask;

        public Unsigned16() {
            this(16);
        }

        public Unsigned16(int n) {
            this.updateIndexes(2, n, 16);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 16 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = (1 << n) - 1 << this._shift;
        }

        public int get() {
            short s = Struct.this.byteBuffer().getShort(this.offset());
            return (s & this._mask) >>> this._shift;
        }

        public void set(int n) {
            if (this._mask == 65535) {
                Struct.this.byteBuffer().putShort(this.offset(), (short)n);
            } else {
                n <<= this._shift;
                int n2 = Struct.this.byteBuffer().getShort(this.offset()) & ~this._mask;
                Struct.this.byteBuffer().putShort(this.offset(), (short)(n2 | (n &= this._mask)));
            }
        }
    }

    public class Signed16
    extends Member {
        private final int _mask;
        private final int _shift;
        private final int _signShift;

        public Signed16() {
            this(16);
        }

        public Signed16(int n) {
            this.updateIndexes(2, n, 16);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 16 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = (1 << n) - 1 << this._shift;
            this._signShift = 32 - this._shift - n;
        }

        public short get() {
            if (this._mask == 65535) {
                return Struct.this.byteBuffer().getShort(this.offset());
            }
            int n = Struct.this.byteBuffer().getShort(this.offset());
            n &= this._mask;
            n <<= this._signShift;
            return (short)(n >>= this._signShift + this._shift);
        }

        public void set(short s) {
            if (this._mask == 65535) {
                Struct.this.byteBuffer().putShort(this.offset(), s);
            } else {
                s = (short)(s << this._shift);
                s = (short)(s & this._mask);
                int n = Struct.this.byteBuffer().getShort(this.offset()) & ~this._mask;
                Struct.this.byteBuffer().putShort(this.offset(), (short)(n | s));
            }
        }
    }

    public class Unsigned8
    extends Member {
        private final int _shift;
        private final int _mask;

        public Unsigned8() {
            this(8);
        }

        public Unsigned8(int n) {
            this.updateIndexes(1, n, 8);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 8 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = (1 << n) - 1 << this._shift;
        }

        public short get() {
            byte by = Struct.this.byteBuffer().get(this.offset());
            return (short)((by & this._mask) >>> this._shift);
        }

        public void set(short s) {
            if (this._mask == 255) {
                Struct.this.byteBuffer().put(this.offset(), (byte)s);
            } else {
                s = (short)(s << this._shift);
                s = (short)(s & this._mask);
                int n = Struct.this.byteBuffer().get(this.offset()) & ~this._mask;
                Struct.this.byteBuffer().put(this.offset(), (byte)(n | s));
            }
        }
    }

    public class Signed8
    extends Member {
        private final int _mask;
        private final int _shift;
        private final int _signShift;

        public Signed8() {
            this(8);
        }

        public Signed8(int n) {
            this.updateIndexes(1, n, 8);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 8 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = (1 << n) - 1 << this._shift;
            this._signShift = 32 - this._shift - n;
        }

        public byte get() {
            if (this._mask == 255) {
                return Struct.this.byteBuffer().get(this.offset());
            }
            int n = Struct.this.byteBuffer().get(this.offset());
            n &= this._mask;
            n <<= this._signShift;
            return (byte)(n >>= this._signShift + this._shift);
        }

        public void set(byte by) {
            if (this._mask == 255) {
                Struct.this.byteBuffer().put(this.offset(), by);
            } else {
                by = (byte)(by << this._shift);
                by = (byte)(by & this._mask);
                int n = Struct.this.byteBuffer().get(this.offset()) & ~this._mask;
                Struct.this.byteBuffer().put(this.offset(), (byte)(n | by));
            }
        }
    }

    public class Bool
    extends Member {
        private final int _mask;

        public Bool() {
            this(8);
        }

        public Bool(int n) {
            this.updateIndexes(1, n, 8);
            int n2 = this.offset() << 3;
            int n3 = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 8 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = (1 << n) - 1 << n3;
        }

        public boolean get() {
            return (Struct.this.byteBuffer().get(this.offset()) & this._mask) != 0;
        }

        public void set(boolean bl) {
            if (this._mask == 255) {
                Struct.this.byteBuffer().put(this.offset(), (byte)(bl ? this._mask : 0));
            } else {
                byte by = Struct.this.byteBuffer().get(this.offset());
                if (bl) {
                    Struct.this.byteBuffer().put(this.offset(), (byte)(by | this._mask));
                } else {
                    Struct.this.byteBuffer().put(this.offset(), (byte)(by & ~this._mask));
                }
            }
        }
    }

    public class UTF8String
    extends Member {
        private final Utf8StreamWriter _writer;
        private final Utf8StreamReader _reader;
        private final char[] _charBuffer;

        public UTF8String(int n) {
            super(1, n);
            final int n2 = this.offset() + n;
            this._writer = new Utf8StreamWriter(n);
            this._writer.setOutputStream(new OutputStream(){

                @Override
                public void write(int n) {
                    ByteBuffer byteBuffer = Struct.this.byteBuffer();
                    if (byteBuffer.position() < n2) {
                        byteBuffer.put((byte)n);
                    }
                }
            });
            this._reader = new Utf8StreamReader(n);
            this._reader.setInputStream(new InputStream(){

                @Override
                public int read() {
                    byte by;
                    ByteBuffer byteBuffer = Struct.this.byteBuffer();
                    if (byteBuffer.position() < n2 && (by = byteBuffer.get()) != 0) {
                        return by;
                    }
                    return -1;
                }
            });
            this._charBuffer = new char[n];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(String string) {
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2 = byteBuffer = Struct.this.byteBuffer();
            synchronized (byteBuffer2) {
                try {
                    byteBuffer.position(this.offset());
                    this._writer.write(string);
                    this._writer.write(0);
                    this._writer.flush();
                }
                catch (IOException iOException) {
                    throw new Error(iOException);
                }
            }
        }

        public String get() {
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2 = byteBuffer = Struct.this.byteBuffer();
            synchronized (byteBuffer2) {
                try {
                    byteBuffer.position(this.offset());
                    int n = this._reader.read(this._charBuffer);
                    return n > 0 ? new String(this._charBuffer, 0, n) : "";
                }
                catch (IOException iOException) {
                    throw new Error(iOException);
                }
            }
        }
    }

    public final class ArrayMember
    extends Member {
        private final Object _array;

        public ArrayMember(Class clazz, int n) {
            this(clazz, new int[]{n});
        }

        public ArrayMember(Class clazz, int[] nArray) {
            if (Struct.this._resetIndex) {
                Struct.this._bitIndex = 0;
                Struct.this._resetIndex = false;
                this._array = this.newArray(clazz, nArray);
                Struct.this._resetIndex = true;
            } else {
                this._array = this.newArray(clazz, nArray);
            }
        }

        private Object newArray(Class clazz, int[] nArray) {
            Object object = Array.newInstance(clazz, nArray);
            int n = nArray[0];
            if (nArray.length == 1) {
                for (int i = 0; i < n; ++i) {
                    Object object2 = this.newInstance(clazz);
                    Array.set(object, i, object2);
                }
            } else {
                int n2;
                int[] nArray2 = new int[nArray.length - 1];
                for (n2 = 1; n2 < nArray.length; ++n2) {
                    nArray2[n2 - 1] = nArray[n2];
                }
                for (n2 = 0; n2 < n; ++n2) {
                    Array.set(object, n2, this.newArray(clazz, nArray2));
                }
            }
            return object;
        }

        public Object get() {
            return this._array;
        }
    }

    public final class StructMember
    extends Member {
        private final Struct _struct;

        public StructMember(Class clazz) {
            this._struct = (Struct)this.newInstance(clazz);
        }

        public Struct get() {
            return this._struct;
        }
    }

    protected abstract class Member {
        private int _offset;

        Member() {
        }

        protected Member(int n, int n2) {
            int n3 = n2 << 3;
            this.updateIndexes(n, n3, n3);
        }

        public final int offset() {
            return this._offset;
        }

        void updateIndexes(int n, int n2, int n3) {
            if (n2 > n3) {
                throw new IllegalArgumentException("nbrOfBits: " + n2 + " exceeds capacity: " + n3);
            }
            if (Struct.this._resetIndex) {
                Struct.this._bitIndex = 0;
            }
            n = Struct.this.isPacked() ? 1 : n;
            this._offset = Struct.this._bitIndex / (n << 3) * n;
            int n4 = Struct.this._bitIndex - (this._offset << 3);
            if (n3 < n4 + n2 || n2 == 0) {
                this._offset += n;
                Struct.this._bitIndex = (this._offset << 3) + n2;
            } else {
                Struct.this._bitIndex = Struct.this._bitIndex + n2;
            }
            if (Struct.this._bitsUsed < Struct.this._bitIndex) {
                Struct.this._bitsUsed = Struct.this._bitIndex;
            }
            if (Struct.this._alignment < n) {
                Struct.this._alignment = n;
            }
        }

        Object newInstance(Class clazz) {
            try {
                if (Member.class.isAssignableFrom(clazz)) {
                    Constructor<?>[] constructorArray = clazz.getConstructors();
                    for (int i = 0; i < constructorArray.length; ++i) {
                        Class<?>[] classArray = constructorArray[i].getParameterTypes();
                        if (classArray.length != 1 || !Struct.class.isAssignableFrom(classArray[0])) continue;
                        return constructorArray[i].newInstance(Struct.this);
                    }
                    throw new NoSuchMethodError(clazz + " has no public default constructor");
                }
                Struct struct = (Struct)OUTER.get();
                OUTER.set(Struct.this);
                Struct struct2 = (Struct)clazz.newInstance();
                OUTER.set(struct);
                int n = struct2.size() << 3;
                this.updateIndexes(struct2._alignment, n, n);
                struct2._outerOffset = Struct.this._bitIndex - n >> 3;
                return struct2;
            }
            catch (InstantiationException instantiationException) {
                throw new InstantiationError(instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalAccessError(illegalAccessException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new Error(invocationTargetException.getMessage());
            }
        }
    }
}

