/*
 * Decompiled with CFR 0.152.
 */
package com.dautelle.xml;

import com.dautelle.util.Utf8StreamWriter;
import com.dautelle.xml.CharData;
import com.dautelle.xml.Representable;
import com.dautelle.xml.XmlElement;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;

public class ObjectWriter {
    private final ArrayList _prefixes = new ArrayList();
    private final ArrayList _packages = new ArrayList();
    private String _indent = "  ";
    private boolean _isProlog = true;
    private final XmlElement[] _stack = new XmlElement[64];
    private final Utf8StreamWriter _utf8StreamWriter = new Utf8StreamWriter(2048);
    private StringBuffer _tmpBuff = new StringBuffer();

    public ObjectWriter() {
        this._stack[0] = new XmlElement();
        for (int i = 1; i < this._stack.length; ++i) {
            this._stack[i] = new XmlElement();
            this._stack[i]._parent = this._stack[i - 1];
        }
        this._prefixes.add("");
        this._packages.add("");
    }

    public void setNamespace(String string, String string2) {
        int n;
        if (string2.equals("pkg")) {
            throw new IllegalArgumentException("Prefix \"pkg\" is reserved for local namespace declarations");
        }
        for (n = 0; n < this._packages.size(); ++n) {
            if (!string2.equals(this._packages.get(n))) continue;
            this._packages.remove(n);
            this._prefixes.remove(n);
            break;
        }
        for (n = 0; n < this._prefixes.size(); ++n) {
            if (!string.equals(this._prefixes.get(n))) continue;
            this._packages.set(n, string2);
            return;
        }
        this._prefixes.add(string);
        this._packages.add(string2);
    }

    public void setIndent(String string) {
        this._indent = string;
    }

    public void setProlog(boolean bl) {
        this._isProlog = bl;
    }

    public void write(Representable representable, File file) throws IOException {
        this.write(representable, new FileOutputStream(file));
    }

    public void write(Representable representable, OutputStream outputStream) throws IOException {
        this._utf8StreamWriter.setOutputStream(outputStream);
        if (this._isProlog) {
            this._utf8StreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this._utf8StreamWriter.write('\n');
        }
        this.writeElement(representable, this._utf8StreamWriter, 0);
        this._utf8StreamWriter.close();
    }

    public void write(Representable representable, Writer writer) throws IOException {
        if (this._isProlog) {
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-16\"?>");
            writer.write(10);
        }
        this.writeElement(representable, writer, 0);
        writer.close();
    }

    private void writeElement(Representable representable, Writer writer, int n) throws IOException {
        int n2;
        String string;
        Object object;
        if (representable instanceof CharData) {
            writer.write(this.escapeSpecialCharacters(representable.toString()));
            return;
        }
        if (n > 0) {
            writer.write(10);
            for (int i = 0; i < n; ++i) {
                writer.write(this._indent);
            }
        }
        XmlElement xmlElement = this._stack[n];
        xmlElement._factoryClass = representable.getClass();
        representable.toXml(xmlElement);
        String string2 = null;
        String string3 = "";
        String string4 = xmlElement._factoryClass.getName();
        for (int i = 0; i < this._packages.size(); ++i) {
            String string5 = (String)this._packages.get(i);
            if (string5.length() < string3.length() || !string4.startsWith(string5)) continue;
            string2 = (String)this._prefixes.get(i);
            string3 = string5;
        }
        if (string2 == null) {
            string2 = "pkg";
            string3 = xmlElement._factoryClass.getPackage().getName();
        }
        String string6 = string3.length() != 0 ? (string2.length() != 0 ? string2 + ":" + string4.substring(string3.length() + 1) : string4.substring(string3.length() + 1)) : (string2.length() != 0 ? string2 + ":" + string4 : string4);
        writer.write(60);
        writer.write(string6);
        if (n == 0) {
            for (int i = 0; i < this._prefixes.size(); ++i) {
                object = (String)this._prefixes.get(i);
                string = (String)this._packages.get(i);
                if (((String)object).length() == 0) {
                    if (string.length() == 0) continue;
                    writer.write(" xmlns=\"java:");
                    writer.write(string);
                    writer.write(34);
                    continue;
                }
                writer.write(" xmlns:");
                writer.write((String)object);
                writer.write("=\"java:");
                writer.write(string);
                writer.write(34);
            }
        }
        if (string2.equals("pkg")) {
            writer.write(" xmlns:pkg=\"java:");
            writer.write(string3);
            writer.write(34);
        }
        for (n2 = 0; n2 < xmlElement._attributeNames.size(); ++n2) {
            object = xmlElement._attributeNames.get(n2).toString();
            string = xmlElement._attributeValues.get(n2).toString();
            writer.write(32);
            writer.write((String)object);
            writer.write("=\"");
            writer.write(this.escapeSpecialCharacters(string));
            writer.write(34);
        }
        if (xmlElement.isEmpty()) {
            writer.write("/>");
        } else {
            writer.write(">");
            for (n2 = 0; n2 < xmlElement._content.size(); ++n2) {
                object = (Representable)xmlElement._content.get(n2);
                this.writeElement((Representable)object, writer, n + 1);
            }
            writer.write(10);
            for (n2 = 0; n2 < n; ++n2) {
                writer.write(this._indent);
            }
            writer.write("</");
            writer.write(string6);
            writer.write(62);
        }
        xmlElement.reset();
    }

    private String escapeSpecialCharacters(String string) {
        this._tmpBuff.setLength(0);
        boolean bl = false;
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    this._tmpBuff.append("&lt;");
                    bl = true;
                    continue block7;
                }
                case '>': {
                    this._tmpBuff.append("&gt;");
                    bl = true;
                    continue block7;
                }
                case '\'': {
                    this._tmpBuff.append("&apos;");
                    bl = true;
                    continue block7;
                }
                case '\"': {
                    this._tmpBuff.append("&quot;");
                    bl = true;
                    continue block7;
                }
                case '&': {
                    this._tmpBuff.append("&amp;");
                    bl = true;
                    continue block7;
                }
                default: {
                    if (c >= ' ') {
                        this._tmpBuff.append(c);
                        continue block7;
                    }
                    this._tmpBuff.append("&#" + Integer.toString(c) + ";");
                    bl = true;
                }
            }
        }
        if (!bl) {
            return string;
        }
        return this._tmpBuff.toString();
    }
}

