/*
 * Decompiled with CFR 0.152.
 */
package com.dautelle.xml;

import com.dautelle.util.Enum;
import com.dautelle.util.TypeFormat;
import com.dautelle.xml.ConstructorException;
import com.dautelle.xml.Representable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public final class XmlElement
extends AbstractList {
    final ArrayList _attributeNames = new ArrayList();
    final ArrayList _attributeValues = new ArrayList();
    final ArrayList _content = new ArrayList();
    Class _factoryClass;
    XmlElement _parent;
    private StringBuffer[] _pool = new StringBuffer[0];
    private int _poolIndex;

    XmlElement() {
    }

    public StringBuffer newAttribute(CharSequence charSequence) {
        StringBuffer stringBuffer = this.newStringBuffer();
        stringBuffer.setLength(0);
        this._attributeNames.add(charSequence);
        this._attributeValues.add(stringBuffer);
        return stringBuffer;
    }

    public void setAttribute(CharSequence charSequence, CharSequence charSequence2) {
        this._attributeNames.add(charSequence);
        this._attributeValues.add(charSequence2);
    }

    public void setAttribute(String string, Enum enum_) {
        if (enum_.getName() != null) {
            this.setAttribute((CharSequence)string, enum_.getName());
        } else {
            TypeFormat.format(enum_.longValue(), this.newAttribute(string));
        }
    }

    public void setAttribute(String string, boolean bl) {
        TypeFormat.format(bl, this.newAttribute(string));
    }

    public void setAttribute(String string, int n) {
        TypeFormat.format(n, this.newAttribute(string));
    }

    public void setAttribute(String string, long l) {
        TypeFormat.format(l, this.newAttribute(string));
    }

    public void setAttribute(String string, float f) {
        TypeFormat.format(f, this.newAttribute(string));
    }

    public void setAttribute(String string, double d) {
        TypeFormat.format(d, this.newAttribute(string));
    }

    public void setFactoryClass(Class clazz) {
        this._factoryClass = clazz;
    }

    public XmlElement getParent() {
        return this._parent;
    }

    public Iterator attributeNames() {
        return this._attributeNames.iterator();
    }

    public boolean isAttribute(CharSequence charSequence) {
        return this.getAttribute(charSequence) != null;
    }

    public CharSequence getAttribute(CharSequence charSequence) {
        for (int i = 0; i < this._attributeNames.size(); ++i) {
            if (!this._attributeNames.get(i).equals(charSequence)) continue;
            return (CharSequence)this._attributeValues.get(i);
        }
        return null;
    }

    public String getAttribute(String string, String string2) {
        CharSequence charSequence = this.getAttribute(string);
        return charSequence != null ? charSequence.toString() : string2;
    }

    public Enum getAttribute(String string, Enum enum_) {
        CharSequence charSequence = this.getAttribute(string);
        if (charSequence != null && charSequence.length() > 0) {
            if (!Character.isDigit(charSequence.charAt(0))) {
                return Enum.valueOf(charSequence, enum_.getClass());
            }
            return Enum.valueOf(TypeFormat.parseLong(charSequence), enum_.getClass());
        }
        return enum_;
    }

    public boolean getAttribute(String string, boolean bl) {
        CharSequence charSequence = this.getAttribute(string);
        return charSequence != null ? TypeFormat.parseBoolean(charSequence) : bl;
    }

    public int getAttribute(String string, int n) {
        CharSequence charSequence = this.getAttribute(string);
        return charSequence != null ? TypeFormat.parseInt(charSequence) : n;
    }

    public long getAttribute(String string, long l) {
        CharSequence charSequence = this.getAttribute(string);
        return charSequence != null ? TypeFormat.parseLong(charSequence) : l;
    }

    public float getAttribute(String string, float f) {
        CharSequence charSequence = this.getAttribute(string);
        return charSequence != null ? (float)TypeFormat.parseDouble(charSequence) : f;
    }

    public double getAttribute(String string, double d) {
        CharSequence charSequence = this.getAttribute(string);
        return charSequence != null ? TypeFormat.parseDouble(charSequence) : d;
    }

    public Class getFactoryClass() {
        return this._factoryClass;
    }

    public Object newInstance() throws ConstructorException {
        try {
            return this._factoryClass.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ConstructorException(this._factoryClass + " default constructor inaccessible");
        }
        catch (InstantiationException instantiationException) {
            throw new ConstructorException(this._factoryClass + " default constructor  instantiation exception (" + instantiationException + ")");
        }
    }

    public void add(Representable representable) {
        this._content.add(representable);
    }

    public boolean addAll(Representable[] representableArray) {
        for (int i = 0; i < representableArray.length; ++i) {
            this.add(representableArray[i]);
        }
        return representableArray.length != 0;
    }

    @Override
    public Object get(int n) {
        return this._content.get(n);
    }

    @Override
    public Object set(int n, Object object) {
        if (object instanceof Representable) {
            return this._content.set(n, object);
        }
        throw new ClassCastException("Object parameter is not Representable");
    }

    @Override
    public void add(int n, Object object) {
        if (!(object instanceof Representable)) {
            throw new ClassCastException("Object parameter is not Representable");
        }
        this._content.add(n, object);
    }

    @Override
    public Object remove(int n) {
        return this._content.remove(n);
    }

    @Override
    public int size() {
        return this._content.size();
    }

    @Override
    public boolean isEmpty() {
        return this._content.isEmpty();
    }

    void reset() {
        for (int i = 0; i < this._poolIndex; ++i) {
            this._pool[i].setLength(0);
        }
        this._poolIndex = 0;
        this._attributeNames.clear();
        this._attributeValues.clear();
        this._content.clear();
        this._poolIndex = 0;
        this._factoryClass = null;
    }

    private StringBuffer newStringBuffer() {
        return this._poolIndex < this._pool.length ? this._pool[this._poolIndex++] : this.newStringBuffer2();
    }

    private StringBuffer newStringBuffer2() {
        StringBuffer[] stringBufferArray = new StringBuffer[4 + this._pool.length * 2];
        System.arraycopy(this._pool, 0, stringBufferArray, 0, this._pool.length);
        for (int i = this._pool.length; i < stringBufferArray.length; ++i) {
            stringBufferArray[i] = new StringBuffer();
        }
        this._pool = stringBufferArray;
        return this._pool[this._poolIndex++];
    }
}

