/*
 * Decompiled with CFR 0.152.
 */
package com.dautelle.xml.sax;

import com.dautelle.util.TypeFormat;
import com.dautelle.util.Utf8StreamReader;
import com.dautelle.xml.sax.AttributesImpl;
import com.dautelle.xml.sax.CharSequenceImpl;
import com.dautelle.xml.sax.ContentHandler;
import com.dautelle.xml.sax.DefaultHandler;
import com.dautelle.xml.sax.Namespace;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;

public final class RealtimeParser {
    private static DefaultHandler DEFAULT_HANDLER = new DefaultHandler();
    private ContentHandler _contentHandler;
    private ErrorHandler _errorHandler;
    private volatile InputSource _input;
    private int _lineNumber;
    private int _columnOffset;
    private final char[] _chars;
    private final Utf8StreamReader _defaultReader;
    private int _index;
    private char[] _data;
    private int _length;
    private CharSequenceImpl[] _pool;
    private int _poolIndex;
    private Number _capacityPropertyValue;
    final AttributesImpl _attributes = new AttributesImpl();
    private final Namespace _namespace = new Namespace();
    private final LocatorImpl _locator = new LocatorImpl();
    private InputSource _systemIdInput = new InputSource();
    private int _lineLength;
    private CharSequenceImpl _elemQName;
    private CharSequenceImpl _elemPrefix;
    private CharSequenceImpl _attrQName;
    private CharSequenceImpl _attrPrefix;
    private CharSequenceImpl _attrValue;
    private CharSequenceImpl _num = new CharSequenceImpl();
    private static final int CHAR_DATA = 16;
    private static final int MARKUP = 32;
    private static final int COMMENT = 48;
    private static final int PI = 64;
    private static final int CDATA = 80;
    private static final int START_TAG = 96;
    private static final int END_TAG = 112;
    private static final int EMPTY_TAG = 128;
    private static final int ESCAPE = 144;
    private static final int READ_ELEM_NAME = 1;
    private static final int ELEM_NAME_READ = 2;
    private static final int READ_ATTR_NAME = 3;
    private static final int ATTR_NAME_READ = 4;
    private static final int EQUAL_READ = 5;
    private static final int READ_ATTR_VALUE_SIMPLE_QUOTE = 6;
    private static final int READ_ATTR_VALUE_DOUBLE_QUOTE = 7;
    private static final String CAPACITY_PROPERTY_KEY = "http://jade.dautelle/sax/properties/capacity";
    private EntityResolver _entityResolver;
    private DTDHandler _dtdHandler;

    public RealtimeParser() {
        this._chars = new char[2048];
        this._defaultReader = new Utf8StreamReader(this._chars.length);
        this._pool = new CharSequenceImpl[256];
        for (int i = 0; i < this._pool.length; ++i) {
            this._pool[i] = new CharSequenceImpl();
        }
        this._capacityPropertyValue = new Integer(2048);
        this.allocateDataBuffer();
        this.setContentHandler(DEFAULT_HANDLER);
        this.setErrorHandler(DEFAULT_HANDLER);
    }

    public void setContentHandler(ContentHandler contentHandler) {
        if (contentHandler == null) {
            throw new NullPointerException();
        }
        this._contentHandler = contentHandler;
        this._namespace.setContentHandler(contentHandler);
    }

    public ContentHandler getContentHandler() {
        return this._contentHandler == DEFAULT_HANDLER ? null : this._contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new NullPointerException();
        }
        this._errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this._errorHandler == DEFAULT_HANDLER ? null : this._errorHandler;
    }

    public void parse(String string) throws IOException, SAXException {
        this._systemIdInput.setSystemId(string);
        this.parse(this._systemIdInput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource inputSource) throws IOException, SAXException {
        Reader reader = inputSource.getCharacterStream();
        if (reader == null) {
            String string;
            InputStream inputStream = inputSource.getByteStream();
            if (inputStream == null) {
                string = inputSource.getSystemId();
                if (string == null) {
                    throw new IOException("Input Source Unknown");
                }
                try {
                    URL uRL = new URL(string);
                    inputStream = uRL.openStream();
                }
                catch (MalformedURLException malformedURLException) {
                    inputStream = new FileInputStream(string);
                }
            }
            if ((string = inputSource.getEncoding()) == null || string.equalsIgnoreCase("UTF-8")) {
                this._defaultReader.setInputStream(inputStream);
                reader = this._defaultReader;
            } else {
                reader = new InputStreamReader(inputStream, string);
            }
        }
        if (this._input != null) {
            throw new IllegalStateException("Currently parsing");
        }
        this._input = inputSource;
        this._lineNumber = 1;
        this._columnOffset = 1;
        this._contentHandler.setDocumentLocator(this._locator);
        try {
            this._contentHandler.startDocument();
            this.parseContent(reader);
        }
        finally {
            this._contentHandler.endDocument();
            reader.close();
            this._index = 0;
            this._length = 0;
            this._attributes.clear();
            this._namespace.reset();
            this._poolIndex = 0;
            this._elemPrefix = null;
            this._attrPrefix = null;
            this._input = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseContent(Reader var1_1) throws IOException, SAXException {
        var2_2 = 0;
        var3_3 = 16;
        var4_4 = 0;
        var5_5 = 0;
        var6_6 = var1_1.read(this._chars, 0, this._chars.length);
        block20: while (this._index < var6_6) {
            var7_7 = this._chars[this._index];
            if (++this._index == var6_6) {
                this._columnOffset += this._index;
                this._index = 0;
                var6_6 = var1_1.read(this._chars, 0, this._chars.length);
                if (this._length + var6_6 >= this._data.length) {
                    var8_8 = new char[this._length + var6_6 + this._data.length];
                    System.arraycopy(this._data, 0, var8_8, 0, this._length);
                    this._data = var8_8;
                }
            }
            if (var7_7 < ' ') {
                if (var7_7 == '\r') {
                    if (this._index < var6_6 && this._chars[this._index] == '\n') continue;
                    var7_7 = '\n';
                }
                if (var7_7 == '\n') {
                    ++this._lineNumber;
                    this._lineLength = this._columnOffset + this._index;
                    this._columnOffset = -this._index;
                } else if (var7_7 != '\t') {
                    this.parseError("Illegal XML character U+" + Integer.toHexString(var7_7));
                }
            }
            this._data[this._length++] = var7_7;
            if (var7_7 == '&' && var3_3 != 48 && var3_3 != 64 && var3_3 != 80 && var3_3 != 144) {
                var4_4 = var3_3;
                var5_5 = this._length;
                var3_3 = 144;
            }
            switch (var3_3) {
                case 16: {
                    if (var7_7 != 60) continue block20;
                    var8_9 = this._length - var2_2 - 1;
                    if (var8_9 > 0) {
                        this._contentHandler.characters(this._data, var2_2, var8_9);
                    }
                    var3_3 = 32;
                    this._length = var2_2;
                    continue block20;
                }
                case 32: {
                    if (this._length - var2_2 == 1) {
                        if (Character.isLetter(var7_7) || var7_7 == '_' || var7_7 == ':') {
                            var3_3 = 97;
                            this._elemQName = this.newChars();
                            this._elemQName.first = var2_2;
                            continue block20;
                        }
                        if (var7_7 == '/') {
                            var3_3 = 113;
                            this._length = var2_2;
                            this._elemQName = this.newChars();
                            this._elemQName.first = var2_2;
                            continue block20;
                        }
                        if (var7_7 == '?') {
                            var3_3 = 64;
                            this._length = var2_2;
                            continue block20;
                        }
                        if (var7_7 == 33) continue block20;
                        this.parseError("Invalid character '" + var7_7 + "'");
                        continue block20;
                    }
                    if (this._length - var2_2 == 3 && this._data[var2_2] == '!' && this._data[var2_2 + 1] == '-' && this._data[var2_2 + 2] == '-') {
                        var3_3 = 48;
                        this._length = var2_2;
                        continue block20;
                    }
                    if (this._length - var2_2 == 8 && this._data[var2_2] == '!' && this._data[var2_2 + 1] == '[' && this._data[var2_2 + 2] == 'C' && this._data[var2_2 + 3] == 'D' && this._data[var2_2 + 4] == 'A' && this._data[var2_2 + 5] == 'T' && this._data[var2_2 + 6] == 'A' && this._data[var2_2 + 7] == '[') {
                        var3_3 = 80;
                        this._length = var2_2;
                        continue block20;
                    }
                    if (var7_7 != 62) continue block20;
                    var3_3 = 16;
                    this._length = var2_2;
                    continue block20;
                }
                case 48: {
                    if (var7_7 != 62 || this._length - var2_2 < 3 || this._data[this._length - 2] != '-' || this._data[this._length - 3] != '-') continue block20;
                    var3_3 = 16;
                    this._length = var2_2;
                    continue block20;
                }
                case 64: {
                    if (var7_7 != 62 || this._length - var2_2 < 2 || this._data[this._length - 2] != '?') continue block20;
                    var3_3 = 16;
                    this._length = var2_2;
                    continue block20;
                }
                case 80: {
                    if (var7_7 != 62 || this._length - var2_2 < 3 || this._data[this._length - 2] != ']' || this._data[this._length - 3] != ']') continue block20;
                    this._contentHandler.characters(this._data, var2_2, this._length - var2_2 - 3);
                    var3_3 = 16;
                    this._length = var2_2;
                    continue block20;
                }
                case 97: {
                    if (var7_7 == '>') {
                        this._elemQName.length = this._length - this._elemQName.first - 1;
                        this._elemQName.data = this._data;
                        this.processElement(var3_3);
                        var3_3 = 16;
                        var2_2 = this._length;
                        continue block20;
                    }
                    if (var7_7 == '/') {
                        this._elemQName.length = this._length - this._elemQName.first - 1;
                        this._elemQName.data = this._data;
                        var3_3 = 128;
                        continue block20;
                    }
                    if (var7_7 == ':' && this._elemPrefix == null) {
                        this._elemPrefix = this.newChars();
                        this._elemPrefix.first = this._elemQName.first;
                        this._elemPrefix.length = this._length - this._elemQName.first - 1;
                        this._elemPrefix.data = this._data;
                        continue block20;
                    }
                    if (var7_7 > 32) continue block20;
                    this._elemQName.length = this._length - this._elemQName.first - 1;
                    this._elemQName.data = this._data;
                    var3_3 = 98;
                    continue block20;
                }
                case 98: {
                    if (var7_7 == '>') {
                        this.processElement(var3_3);
                        var3_3 = 16;
                        var2_2 = this._length;
                        continue block20;
                    }
                    if (var7_7 == '/') {
                        var3_3 = 128;
                        continue block20;
                    }
                    if (var7_7 <= 32) continue block20;
                    this._attrQName = this.newChars();
                    this._attrQName.first = this._length - 1;
                    var3_3 = 99;
                    continue block20;
                }
                case 99: {
                    if (var7_7 <= ' ') {
                        this._attrQName.length = this._length - this._attrQName.first - 1;
                        this._attrQName.data = this._data;
                        var3_3 = 100;
                        continue block20;
                    }
                    if (var7_7 == '=') {
                        this._attrQName.length = this._length - this._attrQName.first - 1;
                        this._attrQName.data = this._data;
                        var3_3 = 101;
                        continue block20;
                    }
                    if (var7_7 != 58 || this._attrPrefix != null) continue block20;
                    this._attrPrefix = this.newChars();
                    this._attrPrefix.first = this._attrQName.first;
                    this._attrPrefix.length = this._length - this._attrQName.first - 1;
                    this._attrPrefix.data = this._data;
                    continue block20;
                }
                case 100: {
                    if (var7_7 == '=') {
                        var3_3 = 101;
                        continue block20;
                    }
                    if (var7_7 <= 32) continue block20;
                    this.parseError("'=' expected");
                    continue block20;
                }
                case 101: {
                    if (var7_7 == '\'') {
                        this._attrValue = this.newChars();
                        this._attrValue.first = this._length;
                        var3_3 = 102;
                        continue block20;
                    }
                    if (var7_7 == '\"') {
                        this._attrValue = this.newChars();
                        this._attrValue.first = this._length;
                        var3_3 = 103;
                        continue block20;
                    }
                    if (var7_7 <= 32) continue block20;
                    this.parseError("Quotes expected");
                    continue block20;
                }
                case 102: {
                    if (var7_7 != 39) continue block20;
                    this._attrValue.length = this._length - this._attrValue.first - 1;
                    this._attrValue.data = this._data;
                    this.processAttribute();
                    var3_3 = 98;
                    continue block20;
                }
                case 103: {
                    if (var7_7 != 34) continue block20;
                    this._attrValue.length = this._length - this._attrValue.first - 1;
                    this._attrValue.data = this._data;
                    this.processAttribute();
                    var3_3 = 98;
                    continue block20;
                }
                case 113: {
                    if (var7_7 == '>') {
                        this._elemQName.length = this._length - this._elemQName.first - 1;
                        this._elemQName.data = this._data;
                        this.processElement(var3_3);
                        var3_3 = 16;
                        var2_2 = this._length;
                        continue block20;
                    }
                    if (var7_7 == ':' && this._elemPrefix == null) {
                        this._elemPrefix = this.newChars();
                        this._elemPrefix.first = this._elemQName.first;
                        this._elemPrefix.length = this._length - this._elemQName.first - 1;
                        this._elemPrefix.data = this._data;
                        continue block20;
                    }
                    if (var7_7 > 32) continue block20;
                    this._elemQName.length = this._length - this._elemQName.first - 1;
                    this._elemQName.data = this._data;
                    var3_3 = 114;
                    continue block20;
                }
                case 114: {
                    if (var7_7 == '>') {
                        this.processElement(var3_3);
                        var3_3 = 16;
                        var2_2 = this._length;
                        continue block20;
                    }
                    if (var7_7 <= 32) continue block20;
                    this.parseError("'>' expected");
                    continue block20;
                }
                case 128: {
                    if (var7_7 == '>') {
                        this.processElement(var3_3);
                        var3_3 = 16;
                        var2_2 = this._length;
                        continue block20;
                    }
                    this.parseError("'>' expected");
                    continue block20;
                }
                case 144: {
                    if (var7_7 != 59) ** GOTO lbl252
                    if (this._length - var5_5 != 3 || this._data[this._length - 3] != 'l' || this._data[this._length - 2] != 't') ** GOTO lbl220
                    this._data[var5_5 - 1] = 60;
                    ** GOTO lbl249
lbl220:
                    // 1 sources

                    if (this._length - var5_5 != 3 || this._data[this._length - 3] != 'g' || this._data[this._length - 2] != 't') ** GOTO lbl223
                    this._data[var5_5 - 1] = 62;
                    ** GOTO lbl249
lbl223:
                    // 1 sources

                    if (this._length - var5_5 != 5 || this._data[this._length - 5] != 'a' || this._data[this._length - 4] != 'p' || this._data[this._length - 3] != 'o' || this._data[this._length - 2] != 's') ** GOTO lbl226
                    this._data[var5_5 - 1] = 39;
                    ** GOTO lbl249
lbl226:
                    // 1 sources

                    if (this._length - var5_5 != 5 || this._data[this._length - 5] != 'q' || this._data[this._length - 4] != 'u' || this._data[this._length - 3] != 'o' || this._data[this._length - 2] != 't') ** GOTO lbl229
                    this._data[var5_5 - 1] = 34;
                    ** GOTO lbl249
lbl229:
                    // 1 sources

                    if (this._length - var5_5 != 4 || this._data[this._length - 4] != 'a' || this._data[this._length - 3] != 'm' || this._data[this._length - 2] != 'p') ** GOTO lbl232
                    this._data[var5_5 - 1] = 38;
                    ** GOTO lbl249
lbl232:
                    // 1 sources

                    if (this._length - var5_5 <= 1 || this._data[var5_5] != '#') ** GOTO lbl248
                    try {
                        if (this._data[var5_5 + 1] != 'x') ** GOTO lbl240
                        this._num.first = var5_5 + 2;
                        this._num.length = this._length - var5_5 - 3;
                        this._num.data = this._data;
                        this._data[var5_5 - 1] = (char)TypeFormat.parseInt(this._num, 16);
                        ** GOTO lbl249
lbl240:
                        // 1 sources

                        this._num.first = var5_5 + 1;
                        this._num.length = this._length - var5_5 - 2;
                        this._num.data = this._data;
                        this._data[var5_5 - 1] = (char)TypeFormat.parseInt(this._num);
                    }
                    catch (NumberFormatException var8_10) {
                        this.parseError("Ill-formed character reference");
                    }
                    ** GOTO lbl249
lbl248:
                    // 1 sources

                    this.parseError("'#' expected");
lbl249:
                    // 9 sources

                    var3_3 = var4_4;
                    this._length = var5_5;
                    continue block20;
lbl252:
                    // 1 sources

                    if (var7_7 > 32) continue block20;
                    this.parseError("';' expected");
                    continue block20;
                }
            }
            throw new InternalError("State unknown: " + var3_3);
        }
    }

    private void processAttribute() throws SAXException {
        if (this._attrPrefix == null) {
            if (RealtimeParser.isXmlns(this._attrQName)) {
                this._namespace.map(CharSequenceImpl.EMPTY, this._attrValue);
            } else {
                this._attributes.add(CharSequenceImpl.EMPTY, this._attrQName, this._attrQName, this._attrValue);
            }
        } else {
            CharSequenceImpl charSequenceImpl = this.newChars();
            charSequenceImpl.first = this._attrQName.first + this._attrPrefix.length + 1;
            charSequenceImpl.length = this._attrQName.length - this._attrPrefix.length - 1;
            charSequenceImpl.data = this._attrQName.data;
            if (RealtimeParser.isXmlns(this._attrPrefix)) {
                this._namespace.map(charSequenceImpl, this._attrValue);
            } else {
                CharSequenceImpl charSequenceImpl2 = this._namespace.getUri(this._attrPrefix);
                if (charSequenceImpl2 != null) {
                    this._attributes.add(charSequenceImpl2, charSequenceImpl, this._attrQName, this._attrValue);
                } else {
                    this.parseError("Namespace " + this._attrPrefix + " undefined");
                }
            }
            this._attrPrefix = null;
        }
    }

    private void processElement(int n) throws SAXException {
        CharSequenceImpl charSequenceImpl;
        CharSequenceImpl charSequenceImpl2;
        if (this._elemPrefix != null) {
            charSequenceImpl2 = this.newChars();
            charSequenceImpl2.first = this._elemQName.first + this._elemPrefix.length + 1;
            charSequenceImpl2.length = this._elemQName.length - this._elemPrefix.length - 1;
            charSequenceImpl2.data = this._elemQName.data;
            charSequenceImpl = this._namespace.getUri(this._elemPrefix);
            if (charSequenceImpl == null) {
                this.parseError("Namespace " + this._elemPrefix + " undefined");
            }
            this._elemPrefix = null;
        } else {
            charSequenceImpl2 = this._elemQName;
            charSequenceImpl = this._namespace.getDefault();
        }
        if ((n & 0xF0) == 96) {
            this._namespace.push(this._elemQName);
            this._contentHandler.startElement(charSequenceImpl, charSequenceImpl2, this._elemQName, this._attributes);
            this._attributes.clear();
        } else {
            CharSequenceImpl charSequenceImpl3;
            if ((n & 0xF0) == 112) {
                charSequenceImpl3 = this._namespace.pop();
                if (!this._elemQName.equals(charSequenceImpl3)) {
                    this.parseError("Expected end tag for " + charSequenceImpl3);
                }
            } else if (n == 128) {
                charSequenceImpl3 = this._elemQName;
                this._contentHandler.startElement(charSequenceImpl, charSequenceImpl2, this._elemQName, this._attributes);
                this._attributes.clear();
            } else {
                throw new InternalError("Unexpected state: " + n);
            }
            this._contentHandler.endElement(charSequenceImpl, charSequenceImpl2, this._elemQName);
            this._length = charSequenceImpl3.first;
            while (this._pool[--this._poolIndex] != charSequenceImpl3) {
            }
        }
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException {
        if (string.equals("http://xml.org/sax/features/namespaces")) {
            return true;
        }
        if (string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return true;
        }
        throw new SAXNotRecognizedException("Feature " + string + " not recognized");
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException {
        if (string.equals("http://xml.org/sax/features/validation") || string.equals("http://xml.org/sax/features/namespaces") || string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return;
        }
        throw new SAXNotRecognizedException("Feature " + string + " not recognized");
    }

    public Object getProperty(String string) throws SAXNotRecognizedException {
        if (string.equals(CAPACITY_PROPERTY_KEY)) {
            return this._capacityPropertyValue;
        }
        throw new SAXNotRecognizedException("Property " + string + " not recognized");
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException {
        if (!string.equals(CAPACITY_PROPERTY_KEY)) {
            throw new SAXNotRecognizedException("Property " + string + " not recognized");
        }
        this._capacityPropertyValue = (Number)object;
        this.allocateDataBuffer();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this._entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this._entityResolver;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this._dtdHandler = dTDHandler;
    }

    public DTDHandler getDTDHandler() {
        return this._dtdHandler;
    }

    private void allocateDataBuffer() {
        if (this._input != null) {
            throw new IllegalStateException("Currently parsing");
        }
        int n = this._capacityPropertyValue.intValue();
        this._data = new char[n + this._chars.length];
    }

    private void parseError(String string) throws SAXException {
        string = string + " (L:" + this._lineNumber + ")";
        SAXParseException sAXParseException = new SAXParseException(string, this._locator);
        this._errorHandler.fatalError(sAXParseException);
    }

    private CharSequenceImpl newChars() {
        return this._poolIndex < this._pool.length ? this._pool[this._poolIndex++] : this.newChars2();
    }

    private CharSequenceImpl newChars2() {
        CharSequenceImpl[] charSequenceImplArray = new CharSequenceImpl[this._pool.length * 2];
        System.arraycopy(this._pool, 0, charSequenceImplArray, 0, this._pool.length);
        for (int i = this._pool.length; i < charSequenceImplArray.length; ++i) {
            charSequenceImplArray[i] = new CharSequenceImpl();
        }
        this._pool = charSequenceImplArray;
        return this._pool[this._poolIndex++];
    }

    private static boolean isXmlns(CharSequenceImpl charSequenceImpl) {
        return charSequenceImpl.length == 5 && charSequenceImpl.data[charSequenceImpl.first] == 'x' && charSequenceImpl.data[charSequenceImpl.first + 1] == 'm' && charSequenceImpl.data[charSequenceImpl.first + 2] == 'l' && charSequenceImpl.data[charSequenceImpl.first + 3] == 'n' && charSequenceImpl.data[charSequenceImpl.first + 4] == 's';
    }

    private class LocatorImpl
    implements Locator {
        private LocatorImpl() {
        }

        @Override
        public String getPublicId() {
            return RealtimeParser.this._input.getPublicId();
        }

        @Override
        public String getSystemId() {
            return RealtimeParser.this._input.getPublicId();
        }

        @Override
        public int getLineNumber() {
            int n = RealtimeParser.this._columnOffset + RealtimeParser.this._index;
            return n != 0 ? RealtimeParser.this._lineNumber : RealtimeParser.this._lineNumber - 1;
        }

        @Override
        public int getColumnNumber() {
            int n = RealtimeParser.this._columnOffset + RealtimeParser.this._index;
            return n != 0 ? n : RealtimeParser.this._lineLength;
        }
    }
}

