/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import org.jdom.IllegalDataException;
import org.jdom.Text;
import org.jdom.Verifier;

public class CDATA
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 520L;
    private static final String EMPTY_STRING = "";
    protected String value;

    protected CDATA() {
    }

    public CDATA(String string) {
        this.setText(string);
    }

    public String getText() {
        return this.value;
    }

    public String getTextTrim() {
        return this.getText().trim();
    }

    public String getTextNormalize() {
        return Text.normalizeString(this.getText());
    }

    public CDATA setText(String string) {
        if (string == null) {
            this.value = EMPTY_STRING;
            return this;
        }
        String string2 = Verifier.checkCDATASection(string);
        if (string2 != null) {
            throw new IllegalDataException(string, "CDATA section", string2);
        }
        this.value = string;
        return this;
    }

    public void append(String string) {
        if (string == null) {
            return;
        }
        String string2 = Verifier.checkCDATASection(string);
        if (string2 != null) {
            throw new IllegalDataException(string, "CDATA section", string2);
        }
        this.value = this.value == EMPTY_STRING ? string : this.value + string;
    }

    public void append(CDATA cDATA) {
        if (cDATA == null) {
            return;
        }
        this.value = this.value + cDATA.getText();
    }

    public String toString() {
        return new StringBuffer(64).append("[CDATA: ").append(this.getText()).append("]").toString();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public Object clone() {
        CDATA cDATA = null;
        try {
            cDATA = (CDATA)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        cDATA.value = this.value;
        return cDATA;
    }

    public final boolean equals(Object object) {
        return this == object;
    }
}

