/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.awt.Color;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jdom.Attribute;
import org.jdom.AttributeList;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.ContentList;
import org.jdom.EntityRef;
import org.jdom.IllegalNameException;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;

public final class Element
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 520L;
    private String name;
    private AttributeList attributes = new AttributeList();
    private ContentList content = new ContentList();

    protected Element() {
    }

    public Element(String string) {
        this.setName(string);
    }

    public String getName() {
        return this.name;
    }

    public Element setName(String string) {
        String string2 = Verifier.checkElementName(string);
        if (string2 != null) {
            throw new IllegalNameException(string, "element", string2);
        }
        this.name = string;
        return this;
    }

    public Element setText(String string) {
        this.content.clear();
        if (string != null) {
            this.addContent(new Text(string));
        }
        return this;
    }

    public List getContent() {
        return this.content;
    }

    public List getContent(Filter filter) {
        return this.content.getView(filter);
    }

    public Element setContent(List list) {
        this.content.clearAndSet(list);
        return this;
    }

    public boolean hasChildren() {
        for (int i = 0; i < this.content.size(); ++i) {
            if (!(this.content.get(i) instanceof Element)) continue;
            return true;
        }
        return false;
    }

    public List getChildren() {
        return this.content.getView(new ElementFilter());
    }

    public Iterator children() {
        return this.getChildren().iterator();
    }

    public Element[] getChildrenArray() {
        return this.content.getElements();
    }

    public Element[] getChildrenArray(String string) {
        return this.content.getElements(string);
    }

    public Element setChildren(List list) {
        List list2 = this.content.getView(new ElementFilter());
        int n = list2.size();
        try {
            list2.addAll(list);
        }
        catch (RuntimeException runtimeException) {
            this.removeRange(list2, n, list2.size());
            throw runtimeException;
        }
        this.removeRange(list2, 0, n);
        return this;
    }

    private void removeRange(List list, int n, int n2) {
        ListIterator listIterator = list.listIterator(n);
        for (int i = 0; i < n2 - n; ++i) {
            listIterator.next();
            listIterator.remove();
        }
    }

    public List getChildren(String string) {
        return this.content.getView(new ElementFilter(string));
    }

    public Element getChild(String string) {
        List list = this.content.getView(new ElementFilter(string));
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            return (Element)iterator.next();
        }
        return null;
    }

    public Element addContent(String string) {
        return this.addContent(new Text(string));
    }

    public Element addContent(Text text) {
        this.content.add(text);
        return this;
    }

    public Element addContent(CDATA cDATA) {
        this.content.add(cDATA);
        return this;
    }

    public Element addContent(Element element) {
        this.content.add(element);
        return this;
    }

    public Element addChild(Element element) {
        this.content.add(element);
        return this;
    }

    public Element addContent(ProcessingInstruction processingInstruction) {
        this.content.add(processingInstruction);
        return this;
    }

    public Element addContent(EntityRef entityRef) {
        this.content.add(entityRef);
        return this;
    }

    public Element addContent(Comment comment) {
        this.content.add(comment);
        return this;
    }

    public boolean removeChild(String string) {
        List list = this.content.getView(new ElementFilter(string));
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean removeChildren(String string) {
        boolean bl = false;
        List list = this.content.getView(new ElementFilter(string));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean removeChildren() {
        boolean bl = false;
        List list = this.content.getView(new ElementFilter());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public Attribute getAttribute(String string) {
        return (Attribute)this.attributes.get(string);
    }

    public String getAttributeValue(String string) {
        Attribute attribute = (Attribute)this.attributes.get(string);
        return attribute == null ? null : attribute.getValue();
    }

    public String getAttributeValue(String string, String string2) {
        Attribute attribute = (Attribute)this.attributes.get(string);
        return attribute == null ? string2 : attribute.getValue();
    }

    public Element setAttributes(List list) {
        this.attributes.clearAndSet(list);
        return this;
    }

    public Element setAttribute(String string, String string2) {
        return this.setAttribute(new Attribute(string, string2));
    }

    public Element addAttribute(String string, String string2) {
        return this.setAttribute(new Attribute(string, string2));
    }

    public Element addAttribute(String string, boolean bl) {
        return this.setAttribute(new Attribute(string, bl ? "true" : "false"));
    }

    public Element addAttribute(String string, int n) {
        return this.setAttribute(new Attribute(string, Integer.toString(n)));
    }

    public Element addAttribute(String string, double d) {
        return this.setAttribute(new Attribute(string, Double.toString(d)));
    }

    public Element addAttribute(String string, long l) {
        return this.setAttribute(new Attribute(string, Long.toString(l)));
    }

    public Element addAttribute(String string, Color color) {
        return this.setAttribute(new Attribute(string, color.getRed() + "," + color.getGreen() + "," + color.getBlue()));
    }

    public Element setAttribute(Attribute attribute) {
        this.attributes.add(attribute);
        return this;
    }

    public boolean removeAttribute(String string) {
        return this.attributes.remove(string);
    }

    public boolean removeAttribute(Attribute attribute) {
        return this.attributes.remove(attribute);
    }

    public boolean removeContent(Element element) {
        return this.content.remove(element);
    }

    public boolean removeContent(ProcessingInstruction processingInstruction) {
        return this.content.remove(processingInstruction);
    }

    public boolean removeContent(Comment comment) {
        return this.content.remove(comment);
    }

    public boolean removeContent(CDATA cDATA) {
        return this.content.remove(cDATA);
    }

    public boolean removeContent(Text text) {
        return this.content.remove(text);
    }

    public boolean removeContent(EntityRef entityRef) {
        return this.content.remove(entityRef);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64).append("[Element: <").append(this.getName());
        stringBuffer.append("/>]");
        return stringBuffer.toString();
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public Object clone() {
        Cloneable cloneable;
        Object object;
        Element element = null;
        try {
            element = (Element)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        element.content = new ContentList();
        element.attributes = new AttributeList();
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.size(); ++i) {
                object = this.attributes.get(i);
                cloneable = (Attribute)((Attribute)object).clone();
                element.attributes.add(cloneable);
            }
        }
        if (this.content != null) {
            for (int i = 0; i < this.content.size(); ++i) {
                object = this.content.get(i);
                if (object instanceof Element) {
                    cloneable = (Element)((Element)object).clone();
                    element.content.add(cloneable);
                    continue;
                }
                if (object instanceof Text) {
                    cloneable = (Text)((Text)object).clone();
                    element.content.add(cloneable);
                    continue;
                }
                if (object instanceof Comment) {
                    cloneable = (Comment)((Comment)object).clone();
                    element.content.add(cloneable);
                    continue;
                }
                if (object instanceof CDATA) {
                    cloneable = (CDATA)((CDATA)object).clone();
                    element.content.add(cloneable);
                    continue;
                }
                if (object instanceof ProcessingInstruction) {
                    cloneable = (ProcessingInstruction)((ProcessingInstruction)object).clone();
                    element.content.add(cloneable);
                    continue;
                }
                if (!(object instanceof EntityRef)) continue;
                cloneable = (EntityRef)((EntityRef)object).clone();
                element.content.add(cloneable);
            }
        }
        return element;
    }

    public boolean getBoolean(String string) {
        return ((Attribute)this.attributes.get(string)).getBooleanValue();
    }

    public double getDouble(String string) {
        return ((Attribute)this.attributes.get(string)).getDoubleValue();
    }

    public int getInt(String string) {
        return ((Attribute)this.attributes.get(string)).getIntValue();
    }

    public long getLong(String string) {
        return ((Attribute)this.attributes.get(string)).getLongValue();
    }

    public String getString(String string) {
        return ((Attribute)this.attributes.get(string)).getValue();
    }

    public boolean hasAttribute(String string) {
        return null != this.attributes.get(string);
    }

    public boolean getBoolean(String string, boolean bl) {
        Attribute attribute = (Attribute)this.attributes.get(string);
        return null != attribute ? attribute.getBooleanValue() : bl;
    }

    public double getDouble(String string, double d) {
        Attribute attribute = (Attribute)this.attributes.get(string);
        return null != attribute ? attribute.getDoubleValue() : d;
    }

    public int getInt(String string, int n) {
        Attribute attribute = (Attribute)this.attributes.get(string);
        return null != attribute ? attribute.getIntValue() : n;
    }

    public long getLong(String string, long l) {
        Attribute attribute = (Attribute)this.attributes.get(string);
        return null != attribute ? attribute.getLongValue() : l;
    }

    public String getString(String string, String string2) {
        Attribute attribute = (Attribute)this.attributes.get(string);
        return null != attribute ? attribute.getValue() : string2;
    }
}

