/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import org.jdom.IllegalDataException;
import org.jdom.IllegalNameException;
import org.jdom.Verifier;

public class EntityRef
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 520L;
    protected String name;
    protected String publicID;
    protected String systemID;

    protected EntityRef() {
    }

    public EntityRef(String string) {
        this(string, null, null);
    }

    public EntityRef(String string, String string2) {
        this(string, null, string2);
    }

    public EntityRef(String string, String string2, String string3) {
        this.setName(string);
        this.setPublicID(string2);
        this.setSystemID(string3);
    }

    public Object clone() {
        EntityRef entityRef = null;
        try {
            entityRef = (EntityRef)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return entityRef;
    }

    public final boolean equals(Object object) {
        return object == this;
    }

    public String getName() {
        return this.name;
    }

    public String getPublicID() {
        return this.publicID;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public EntityRef setName(String string) {
        String string2 = Verifier.checkXMLName(string);
        if (string2 != null) {
            throw new IllegalNameException(string, "EntityRef", string2);
        }
        this.name = string;
        return this;
    }

    public EntityRef setPublicID(String string) {
        String string2 = Verifier.checkPublicID(this.publicID);
        if (string2 != null) {
            throw new IllegalDataException(this.publicID, "EntityRef", string2);
        }
        this.publicID = string;
        return this;
    }

    public EntityRef setSystemID(String string) {
        String string2 = Verifier.checkSystemLiteral(this.systemID);
        if (string2 != null) {
            throw new IllegalDataException(this.systemID, "EntityRef", string2);
        }
        this.systemID = string;
        return this;
    }

    public String toString() {
        return new StringBuffer().append("[EntityRef: ").append("&").append(this.name).append(";").append("]").toString();
    }
}

