/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.fastxml;

import com.dautelle.util.FastMap;
import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDAttlist;
import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.TreeMap;

public final class DTDDefault {
    private final Map attributesByElement;

    public DTDDefault(File file) throws IOException {
        this.attributesByElement = DTDDefault.readDefaultAttributes(file);
    }

    public DTDDefault(byte[] byArray) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(new ByteArrayInputStream(byArray));
        this.attributesByElement = DTDDefault.readDefaultAttributes(new BufferedReader(inputStreamReader));
    }

    public Map getValues(CharSequence charSequence) {
        return (Map)this.attributesByElement.get(charSequence);
    }

    public String getDefaultValue(String string, String string2) {
        Map map = (Map)this.attributesByElement.get(string);
        if (null != map) {
            String string3 = (String)map.get(string2);
            return string3;
        }
        return null;
    }

    private static String extractDTD(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        return DTDDefault.extractDTD(bufferedReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String extractDTD(BufferedReader bufferedReader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        try {
            String string;
            while (null != (string = bufferedReader.readLine())) {
                if (bl2) {
                    if (-1 != string.indexOf("]>")) {
                        break;
                    }
                    stringBuffer.append(string);
                    continue;
                }
                if (!bl && -1 != string.indexOf("!DOCTYPE")) {
                    bl = true;
                }
                if (!bl || -1 == string.indexOf("[")) continue;
                bl2 = true;
            }
        }
        finally {
            bufferedReader.close();
        }
        return stringBuffer.toString();
    }

    private static Map readDefaultAttributes(File file) throws IOException {
        String string = DTDDefault.extractDTD(file);
        return DTDDefault.readDefaultAttributes(string);
    }

    private static Map readDefaultAttributes(BufferedReader bufferedReader) throws IOException {
        String string = DTDDefault.extractDTD(bufferedReader);
        return DTDDefault.readDefaultAttributes(string);
    }

    private static Map readDefaultAttributes(String string) throws IOException {
        TreeMap<String, FastMap> treeMap = new TreeMap<String, FastMap>();
        DTDParser dTDParser = new DTDParser((Reader)new StringReader(string));
        DTD dTD = dTDParser.parse();
        Object[] objectArray = dTD.getItems();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof DTDAttlist)) continue;
            DTDAttlist dTDAttlist = (DTDAttlist)objectArray[i];
            DTDAttribute[] dTDAttributeArray = dTDAttlist.getAttribute();
            FastMap fastMap = new FastMap();
            for (int j = 0; j < dTDAttributeArray.length; ++j) {
                if (null == dTDAttributeArray[j].getDefaultValue()) continue;
                fastMap.put(dTDAttributeArray[j].getName(), dTDAttributeArray[j].getDefaultValue());
            }
            treeMap.put(dTDAttlist.getName(), fastMap);
        }
        return treeMap;
    }
}

