/*
 * Decompiled with CFR 0.152.
 */
package com.dautelle.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FastMap
implements Map,
Cloneable,
Serializable {
    private static final long serialVersionUID = 520L;
    private transient EntryImpl[] _entries;
    private transient int _capacity;
    private transient int _mask;
    private transient EntryImpl _poolFirst;
    private transient EntryImpl _mapFirst;
    private transient EntryImpl _mapLast;
    private transient int _size;
    private transient Values _values;
    private transient EntrySet _entrySet;
    private transient KeySet _keySet;

    public FastMap() {
        this.initialize(16);
    }

    public FastMap(Map map) {
        int n = map instanceof FastMap ? ((FastMap)map).capacity() : map.size();
        this.initialize(n);
        this.putAll(map);
    }

    public FastMap(int n) {
        this.initialize(n);
    }

    @Override
    public int size() {
        return this._size;
    }

    public int capacity() {
        return this._capacity;
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0;
    }

    @Override
    public boolean containsKey(Object object) {
        EntryImpl entryImpl = this._entries[FastMap.keyHash(object) & this._mask];
        while (entryImpl != null) {
            if (object.equals(entryImpl._key)) {
                return true;
            }
            entryImpl = entryImpl._next;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        EntryImpl entryImpl = this._mapFirst;
        while (entryImpl != null) {
            if (object.equals(entryImpl._value)) {
                return true;
            }
            entryImpl = entryImpl._after;
        }
        return false;
    }

    public Object get(Object object) {
        EntryImpl entryImpl = this._entries[FastMap.keyHash(object) & this._mask];
        while (entryImpl != null) {
            if (object.equals(entryImpl._key)) {
                return entryImpl._value;
            }
            entryImpl = entryImpl._next;
        }
        return null;
    }

    public Map.Entry getEntry(Object object) {
        EntryImpl entryImpl = this._entries[FastMap.keyHash(object) & this._mask];
        while (entryImpl != null) {
            if (object.equals(entryImpl._key)) {
                return entryImpl;
            }
            entryImpl = entryImpl._next;
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        EntryImpl entryImpl = this._entries[FastMap.keyHash(object) & this._mask];
        while (entryImpl != null) {
            if (object.equals(entryImpl._key)) {
                Object object3 = entryImpl._value;
                entryImpl._value = object2;
                return object3;
            }
            entryImpl = entryImpl._next;
        }
        this.addEntry(object, object2);
        return null;
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.addEntry(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object object) {
        EntryImpl entryImpl = this._entries[FastMap.keyHash(object) & this._mask];
        while (entryImpl != null) {
            if (object.equals(entryImpl._key)) {
                Object object2 = entryImpl._value;
                this.removeEntry(entryImpl);
                return object2;
            }
            entryImpl = entryImpl._next;
        }
        return null;
    }

    @Override
    public void clear() {
        EntryImpl entryImpl = this._mapFirst;
        while (entryImpl != null) {
            entryImpl._key = null;
            entryImpl._value = null;
            entryImpl._before = null;
            entryImpl._next = null;
            if (entryImpl._previous == null) {
                this._entries[entryImpl._index] = null;
            } else {
                entryImpl._previous = null;
            }
            entryImpl = entryImpl._after;
        }
        if (this._mapLast != null) {
            this._mapLast._after = this._poolFirst;
            this._poolFirst = this._mapFirst;
            this._mapFirst = null;
            this._mapLast = null;
            this._size = 0;
            this.sizeChanged();
        }
    }

    public void setCapacity(int n) {
        EntryImpl entryImpl;
        int n2;
        if (n > this._capacity) {
            for (n2 = this._capacity; n2 < n; ++n2) {
                entryImpl = new EntryImpl();
                entryImpl._after = this._poolFirst;
                this._poolFirst = entryImpl;
            }
        } else if (n < this._capacity) {
            for (n2 = n; n2 < this._capacity && this._poolFirst != null; ++n2) {
                entryImpl = this._poolFirst;
                this._poolFirst = entryImpl._after;
                entryImpl._after = null;
            }
        }
        for (n2 = 16; n2 < n; n2 <<= 1) {
        }
        if (this._entries.length != n2) {
            this._entries = new EntryImpl[n2];
            this._mask = n2 - 1;
            entryImpl = this._mapFirst;
            while (entryImpl != null) {
                EntryImpl entryImpl2;
                int n3;
                entryImpl._index = n3 = FastMap.keyHash(entryImpl._key) & this._mask;
                entryImpl._previous = null;
                entryImpl._next = entryImpl2 = this._entries[n3];
                if (entryImpl2 != null) {
                    entryImpl2._previous = entryImpl;
                }
                this._entries[n3] = entryImpl;
                entryImpl = entryImpl._after;
            }
        }
        this._capacity = n;
    }

    public Object clone() {
        try {
            FastMap fastMap = (FastMap)super.clone();
            fastMap.initialize(this._capacity);
            fastMap.putAll((Map)this);
            return fastMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (this.size() == map.size()) {
                EntryImpl entryImpl = this._mapFirst;
                while (entryImpl != null) {
                    if (!map.entrySet().contains(entryImpl)) {
                        return false;
                    }
                    entryImpl = entryImpl._after;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 0;
        EntryImpl entryImpl = this._mapFirst;
        while (entryImpl != null) {
            n += entryImpl.hashCode();
            entryImpl = entryImpl._after;
        }
        return n;
    }

    public String toString() {
        return this.entrySet().toString();
    }

    public Collection values() {
        return this._values;
    }

    public Set entrySet() {
        return this._entrySet;
    }

    public Set keySet() {
        return this._keySet;
    }

    protected void sizeChanged() {
        if (this.size() > this.capacity()) {
            this.setCapacity(this.capacity() * 2);
        }
    }

    private static int keyHash(Object object) {
        int n = object.hashCode();
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n;
    }

    private void addEntry(Object object, Object object2) {
        EntryImpl entryImpl;
        int n;
        EntryImpl entryImpl2 = this._poolFirst;
        if (entryImpl2 != null) {
            this._poolFirst = entryImpl2._after;
            entryImpl2._after = null;
        } else {
            entryImpl2 = new EntryImpl();
        }
        entryImpl2._key = object;
        entryImpl2._value = object2;
        entryImpl2._index = n = FastMap.keyHash(object) & this._mask;
        entryImpl2._next = entryImpl = this._entries[n];
        if (entryImpl != null) {
            entryImpl._previous = entryImpl2;
        }
        this._entries[n] = entryImpl2;
        if (this._mapLast != null) {
            entryImpl2._before = this._mapLast;
            this._mapLast._after = entryImpl2;
        } else {
            this._mapFirst = entryImpl2;
        }
        this._mapLast = entryImpl2;
        ++this._size;
        this.sizeChanged();
    }

    private void removeEntry(EntryImpl entryImpl) {
        EntryImpl entryImpl2 = entryImpl._previous;
        EntryImpl entryImpl3 = entryImpl._next;
        if (entryImpl2 != null) {
            entryImpl2._next = entryImpl3;
            entryImpl._previous = null;
        } else {
            this._entries[entryImpl._index] = entryImpl3;
        }
        if (entryImpl3 != null) {
            entryImpl3._previous = entryImpl2;
            entryImpl._next = null;
        }
        EntryImpl entryImpl4 = entryImpl._before;
        EntryImpl entryImpl5 = entryImpl._after;
        if (entryImpl4 != null) {
            entryImpl4._after = entryImpl5;
            entryImpl._before = null;
        } else {
            this._mapFirst = entryImpl5;
        }
        if (entryImpl5 != null) {
            entryImpl5._before = entryImpl4;
        } else {
            this._mapLast = entryImpl4;
        }
        entryImpl._key = null;
        entryImpl._value = null;
        entryImpl._after = this._poolFirst;
        this._poolFirst = entryImpl;
        --this._size;
        this.sizeChanged();
    }

    private void initialize(int n) {
        int n2;
        for (n2 = 16; n2 < n; n2 <<= 1) {
        }
        this._entries = new EntryImpl[n2];
        this._mask = n2 - 1;
        this._capacity = n;
        this._size = 0;
        this._values = new Values();
        this._entrySet = new EntrySet();
        this._keySet = new KeySet();
        this._poolFirst = null;
        this._mapFirst = null;
        this._mapLast = null;
        for (int i = 0; i < n; ++i) {
            EntryImpl entryImpl = new EntryImpl();
            entryImpl._after = this._poolFirst;
            this._poolFirst = entryImpl;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        this.initialize(n);
        int n2 = objectInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.addEntry(object, object2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this._capacity);
        objectOutputStream.writeInt(this._size);
        int n = 0;
        EntryImpl entryImpl = this._mapFirst;
        while (entryImpl != null) {
            objectOutputStream.writeObject(entryImpl._key);
            objectOutputStream.writeObject(entryImpl._value);
            ++n;
            entryImpl = entryImpl._after;
        }
        if (n != this._size) {
            throw new IOException("FastMap Corrupted");
        }
    }

    private static final class EntryImpl
    implements Map.Entry {
        private Object _key;
        private Object _value;
        public int _index;
        public EntryImpl _previous;
        public EntryImpl _next;
        public EntryImpl _before;
        public EntryImpl _after;

        private EntryImpl() {
        }

        public Object getKey() {
            return this._key;
        }

        public Object getValue() {
            return this._value;
        }

        public Object setValue(Object object) {
            Object object2 = this._value;
            this._value = object;
            return object2;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return this._key.equals(entry.getKey()) && (this._value != null ? this._value.equals(entry.getValue()) : entry.getValue() == null);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this._key.hashCode() ^ (this._value != null ? this._value.hashCode() : 0);
        }

        public String toString() {
            return this._key + "=" + this._value;
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                EntryImpl after;
                EntryImpl before;
                {
                    this.after = FastMap.this._mapFirst;
                }

                @Override
                public void remove() {
                    FastMap.this.removeEntry(this.before);
                }

                @Override
                public boolean hasNext() {
                    return this.after != null;
                }

                public Object next() {
                    this.before = this.after;
                    this.after = this.after._after;
                    return this.before._key;
                }
            };
        }

        @Override
        public int size() {
            return FastMap.this._size;
        }

        @Override
        public boolean contains(Object object) {
            return FastMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return FastMap.this.remove(object) != null;
        }

        @Override
        public void clear() {
            FastMap.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                EntryImpl after;
                EntryImpl before;
                {
                    this.after = FastMap.this._mapFirst;
                }

                @Override
                public void remove() {
                    FastMap.this.removeEntry(this.before);
                }

                @Override
                public boolean hasNext() {
                    return this.after != null;
                }

                public Object next() {
                    this.before = this.after;
                    this.after = this.after._after;
                    return this.before;
                }
            };
        }

        @Override
        public int size() {
            return FastMap.this._size;
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Map.Entry entry2 = FastMap.this.getEntry(entry.getKey());
                return entry.equals(entry2);
            }
            return false;
        }

        @Override
        public boolean remove(Object object) {
            Map.Entry entry;
            EntryImpl entryImpl;
            if (object instanceof Map.Entry && (entryImpl = (EntryImpl)FastMap.this.getEntry((entry = (Map.Entry)object).getKey())) != null && entry.getValue().equals(entryImpl._value)) {
                FastMap.this.removeEntry(entryImpl);
                return true;
            }
            return false;
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                EntryImpl after;
                EntryImpl before;
                {
                    this.after = FastMap.this._mapFirst;
                }

                @Override
                public void remove() {
                    FastMap.this.removeEntry(this.before);
                }

                @Override
                public boolean hasNext() {
                    return this.after != null;
                }

                public Object next() {
                    this.before = this.after;
                    this.after = this.after._after;
                    return this.before._value;
                }
            };
        }

        @Override
        public int size() {
            return FastMap.this._size;
        }

        @Override
        public boolean contains(Object object) {
            return FastMap.this.containsValue(object);
        }

        @Override
        public void clear() {
            FastMap.this.clear();
        }
    }
}

