/*
 * Decompiled with CFR 0.152.
 */
package com.dautelle.util;

public class ReentrantLock {
    private Thread _owner;
    private long _count;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        Thread thread = Thread.currentThread();
        ReentrantLock reentrantLock = this;
        synchronized (reentrantLock) {
            if (thread == this._owner) {
                ++this._count;
            } else {
                try {
                    while (this._owner != null) {
                        this.wait();
                    }
                    this._owner = thread;
                    this._count = 1L;
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock() {
        ReentrantLock reentrantLock = this;
        synchronized (reentrantLock) {
            if (this._owner == null) {
                this.lock();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        ReentrantLock reentrantLock = this;
        synchronized (reentrantLock) {
            if (Thread.currentThread() == this._owner) {
                if (--this._count == 0L) {
                    this._owner = null;
                    this.notifyAll();
                }
            } else {
                throw new IllegalMonitorStateException("Current thread does not hold this lock");
            }
        }
    }

    public Thread getOwner() {
        return this._owner;
    }
}

