/*
 * Decompiled with CFR 0.152.
 */
package com.dautelle.util;

public final class TypeFormat {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final int[] INT_POW_10 = new int[10];
    private static final long[] LONG_POW_10;
    private static final double LOG_10;
    private static final float FLOAT_RELATIVE_ERROR;
    private static final double DOUBLE_RELATIVE_ERROR;
    private static String[] LEADING_ZEROS;
    private static final double[] DOUBLE_POW_10;

    private TypeFormat() {
    }

    public static int indexOf(CharSequence charSequence, CharSequence charSequence2, int n) {
        int n2 = charSequence.length();
        n = Math.max(0, n);
        if (n2 != 0) {
            char c = charSequence.charAt(0);
            int n3 = charSequence2.length() - n2;
            for (int i = n; i <= n3; ++i) {
                if (charSequence2.charAt(i) != c) continue;
                boolean bl = true;
                for (int j = 1; j < n2; ++j) {
                    if (charSequence2.charAt(i + j) == charSequence.charAt(j)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                return i;
            }
            return -1;
        }
        return Math.min(0, n);
    }

    public static boolean parseBoolean(CharSequence charSequence) {
        return !(charSequence.length() != 4 || charSequence.charAt(0) != 't' && charSequence.charAt(0) != 'T' || charSequence.charAt(1) != 'r' && charSequence.charAt(1) != 'R' || charSequence.charAt(2) != 'u' && charSequence.charAt(2) != 'U' || charSequence.charAt(3) != 'e' && charSequence.charAt(3) != 'E');
    }

    public static short parseShort(CharSequence charSequence) {
        return TypeFormat.parseShort(charSequence, 10);
    }

    public static short parseShort(CharSequence charSequence, int n) {
        try {
            boolean bl = charSequence.charAt(0) == '-';
            int n2 = 0;
            int n3 = bl ? Short.MIN_VALUE : -32767;
            int n4 = n3 / n;
            int n5 = charSequence.length();
            int n6 = bl || charSequence.charAt(0) == '+' ? 1 : 0;
            do {
                int n7 = Character.digit(charSequence.charAt(n6), n);
                int n8 = n2 * n;
                if (n7 < 0 || n2 < n4 || n8 < n3 + n7) {
                    throw new NumberFormatException("For input characters: \"" + charSequence.toString() + "\"");
                }
                n2 = n8 - n7;
            } while (++n6 < n5);
            return (short)(bl ? n2 : -n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NumberFormatException("For input characters: \"" + charSequence.toString() + "\"");
        }
    }

    public static int parseInt(CharSequence charSequence) {
        return TypeFormat.parseInt(charSequence, 10);
    }

    public static int parseInt(CharSequence charSequence, int n) {
        try {
            boolean bl = charSequence.charAt(0) == '-';
            int n2 = 0;
            int n3 = bl ? Integer.MIN_VALUE : -2147483647;
            int n4 = n3 / n;
            int n5 = charSequence.length();
            int n6 = bl || charSequence.charAt(0) == '+' ? 1 : 0;
            do {
                int n7 = Character.digit(charSequence.charAt(n6), n);
                int n8 = n2 * n;
                if (n7 < 0 || n2 < n4 || n8 < n3 + n7) {
                    throw new NumberFormatException("For input characters: \"" + charSequence.toString() + "\"");
                }
                n2 = n8 - n7;
            } while (++n6 < n5);
            return bl ? n2 : -n2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NumberFormatException("For input characters: \"" + charSequence.toString() + "\"");
        }
    }

    public static long parseLong(CharSequence charSequence) {
        return TypeFormat.parseLong(charSequence, 10);
    }

    public static long parseLong(CharSequence charSequence, int n) {
        try {
            boolean bl = charSequence.charAt(0) == '-';
            long l = 0L;
            long l2 = bl ? Long.MIN_VALUE : -9223372036854775807L;
            long l3 = l2 / (long)n;
            int n2 = charSequence.length();
            int n3 = bl || charSequence.charAt(0) == '+' ? 1 : 0;
            do {
                int n4 = Character.digit(charSequence.charAt(n3), n);
                long l4 = l * (long)n;
                if (n4 < 0 || l < l3 || l4 < l2 + (long)n4) {
                    throw new NumberFormatException("For input characters: \"" + charSequence.toString() + "\"");
                }
                l = l4 - (long)n4;
            } while (++n3 < n2);
            return bl ? l : -l;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NumberFormatException("For input characters: \"" + charSequence.toString() + "\"");
        }
    }

    public static float parseFloat(CharSequence charSequence) {
        double d = TypeFormat.parseDouble(charSequence);
        if (d >= (double)1.4E-45f && d <= 3.4028234663852886E38) {
            return (float)d;
        }
        throw new NumberFormatException("Float overflow for input characters: \"" + charSequence.toString() + "\"");
    }

    public static double parseDouble(CharSequence charSequence) throws NumberFormatException {
        try {
            char c;
            int n;
            int n2 = charSequence.length();
            double d = 0.0;
            int n3 = 0;
            boolean bl = charSequence.charAt(0) == '-';
            int n4 = n = bl || charSequence.charAt(0) == '+' ? 1 : 0;
            if (charSequence.charAt(n) == 'N' || charSequence.charAt(n) == 'I') {
                if (charSequence.toString().equals("NaN")) {
                    return Double.NaN;
                }
                if (charSequence.subSequence(n, n2).toString().equals("Infinity")) {
                    return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                }
            }
            boolean bl2 = false;
            do {
                if ((c = charSequence.charAt(n)) == '.' && !bl2) {
                    bl2 = true;
                    continue;
                }
                if (c != 'e' && c != 'E') {
                    if (c >= '0' && c <= '9') {
                        d = d * 10.0 + (double)(c - 48);
                        if (!bl2) continue;
                        --n3;
                        continue;
                    }
                    throw new NumberFormatException("For input characters: \"" + charSequence.toString() + "\"");
                }
                break;
            } while (++n < n2);
            double d2 = d = bl ? -d : d;
            if (n < n2) {
                c = charSequence.charAt(++n) == '-' ? (char)'\u0001' : '\u0000';
                n = c != '\u0000' || charSequence.charAt(n) == '+' ? n + 1 : n;
                int n5 = 0;
                do {
                    char c2;
                    if ((c2 = charSequence.charAt(n)) >= '0' && c2 <= '9') {
                        if ((n5 = n5 * 10 + (c2 - 48)) <= 10000000) continue;
                        n5 = 10000000;
                        continue;
                    }
                    throw new NumberFormatException("For input characters: \"" + charSequence.toString() + "\"");
                } while (++n < n2);
                n3 += c != '\u0000' ? -n5 : n5;
            }
            return TypeFormat.multE(d, n3);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NumberFormatException("For input characters: \"" + charSequence.toString() + "\"");
        }
    }

    public static StringBuffer format(boolean bl, StringBuffer stringBuffer) {
        return bl ? stringBuffer.append("true") : stringBuffer.append("false");
    }

    public static StringBuffer format(short s, StringBuffer stringBuffer) {
        return TypeFormat.format((int)s, stringBuffer);
    }

    public static StringBuffer format(short s, int n, StringBuffer stringBuffer) {
        return TypeFormat.format((int)s, n, stringBuffer);
    }

    public static StringBuffer format(int n, StringBuffer stringBuffer) {
        int n2;
        if (n <= 0) {
            if (n == Integer.MIN_VALUE) {
                return stringBuffer.append("-2147483648");
            }
            if (n == 0) {
                return stringBuffer.append('0');
            }
            n = -n;
            stringBuffer.append('-');
        }
        for (n2 = 1; n2 < 10 && n >= INT_POW_10[n2]; ++n2) {
        }
        --n2;
        while (n2 >= 0) {
            int n3 = INT_POW_10[n2];
            int n4 = n / n3;
            n -= n4 * n3;
            stringBuffer.append(DIGITS[n4]);
            --n2;
        }
        return stringBuffer;
    }

    public static StringBuffer format(int n, int n2, StringBuffer stringBuffer) {
        if (n2 == 10) {
            return TypeFormat.format(n, stringBuffer);
        }
        if (n2 < 2 || n2 > 36) {
            throw new IllegalArgumentException("radix: " + n2);
        }
        if (n < 0) {
            stringBuffer.append('-');
        } else {
            n = -n;
        }
        TypeFormat.format2(n, n2, stringBuffer);
        return stringBuffer;
    }

    private static void format2(int n, int n2, StringBuffer stringBuffer) {
        if (n <= -n2) {
            TypeFormat.format2(n / n2, n2, stringBuffer);
            stringBuffer.append(DIGITS[-(n % n2)]);
        } else {
            stringBuffer.append(DIGITS[-n]);
        }
    }

    public static StringBuffer format(long l, StringBuffer stringBuffer) {
        int n;
        if (l <= 0L) {
            if (l == Long.MIN_VALUE) {
                return stringBuffer.append("-9223372036854775808");
            }
            if (l == 0L) {
                return stringBuffer.append('0');
            }
            l = -l;
            stringBuffer.append('-');
        }
        for (n = 1; n < 19 && l >= LONG_POW_10[n]; ++n) {
        }
        --n;
        while (n >= 0) {
            long l2 = LONG_POW_10[n];
            int n2 = (int)(l / l2);
            l -= (long)n2 * l2;
            stringBuffer.append(DIGITS[n2]);
            --n;
        }
        return stringBuffer;
    }

    public static StringBuffer format(long l, int n, StringBuffer stringBuffer) {
        if (n == 10) {
            return TypeFormat.format(l, stringBuffer);
        }
        if (n < 2 || n > 36) {
            throw new IllegalArgumentException("radix: " + n);
        }
        if (l < 0L) {
            stringBuffer.append('-');
        } else {
            l = -l;
        }
        TypeFormat.format2(l, n, stringBuffer);
        return stringBuffer;
    }

    private static void format2(long l, int n, StringBuffer stringBuffer) {
        if (l <= (long)(-n)) {
            TypeFormat.format2(l / (long)n, n, stringBuffer);
            stringBuffer.append(DIGITS[(int)(-(l % (long)n))]);
        } else {
            stringBuffer.append(DIGITS[(int)(-l)]);
        }
    }

    public static StringBuffer format(float f, StringBuffer stringBuffer) {
        return TypeFormat.format(f, 0.0f, stringBuffer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StringBuffer format(float f, float f2, StringBuffer stringBuffer) {
        boolean bl;
        if (f2 > 0.0f) {
            bl = true;
            return TypeFormat.format(f, f2, bl, stringBuffer);
        } else {
            if (f2 != 0.0f) throw new IllegalArgumentException("precision: Negative values not allowed");
            if (f == 0.0f) return stringBuffer.append("0.0");
            bl = false;
            f2 = Math.max(Math.abs(f * FLOAT_RELATIVE_ERROR), Float.MIN_VALUE);
        }
        return TypeFormat.format(f, f2, bl, stringBuffer);
    }

    public static StringBuffer format(double d, StringBuffer stringBuffer) {
        return TypeFormat.format(d, 0.0, stringBuffer);
    }

    public static StringBuffer format(double d, int n, StringBuffer stringBuffer) {
        if (n >= 1 && n <= 19) {
            double d2 = Math.abs(d / DOUBLE_POW_10[n - 1]);
            return TypeFormat.format(d, d2, stringBuffer);
        }
        throw new IllegalArgumentException("digits: " + n + " is not in range [1 .. 19]");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StringBuffer format(double d, double d2, StringBuffer stringBuffer) {
        boolean bl = false;
        if (d2 > 0.0) {
            bl = true;
            return TypeFormat.format(d, d2, bl, stringBuffer);
        } else if (d2 == 0.0) {
            if (d == 0.0) return stringBuffer.append("0.0");
            d2 = Math.max(Math.abs(d * DOUBLE_RELATIVE_ERROR), Double.MIN_VALUE);
            return TypeFormat.format(d, d2, bl, stringBuffer);
        } else {
            if (!(d2 < 0.0)) return TypeFormat.format(d, d2, bl, stringBuffer);
            throw new IllegalArgumentException("precision: Negative values not allowed");
        }
    }

    private static StringBuffer format(double d, double d2, boolean bl, StringBuffer stringBuffer) {
        int n;
        double d3;
        if (Double.isNaN(d)) {
            return stringBuffer.append("NaN");
        }
        if (Double.isInfinite(d)) {
            return d >= 0.0 ? stringBuffer.append("Infinity") : stringBuffer.append("-Infinity");
        }
        if (d < 0.0) {
            d = -d;
            stringBuffer.append('-');
        }
        if ((d3 = TypeFormat.multE(d, -(n = (int)Math.floor(Math.log(d2) / LOG_10)))) >= 9.223372036854776E18) {
            throw new IllegalArgumentException("Specified precision would result in too many digits");
        }
        int n2 = stringBuffer.length();
        TypeFormat.format(Math.round(d3), stringBuffer);
        int n3 = stringBuffer.length() - n2;
        int n4 = n3 + n;
        boolean bl2 = false;
        if (n4 <= -LEADING_ZEROS.length || n4 > n3) {
            stringBuffer.insert(n2 + 1, '.');
            bl2 = true;
        } else if (n4 > 0) {
            stringBuffer.insert(n2 + n4, '.');
        } else {
            stringBuffer.insert(n2, LEADING_ZEROS[-n4]);
        }
        if (!bl) {
            int n5 = stringBuffer.length();
            while (stringBuffer.charAt(--n5) == '0') {
            }
            stringBuffer.setLength(n5 + 1);
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) == '.') {
            if (bl) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            } else {
                stringBuffer.append('0');
            }
        }
        if (bl2) {
            stringBuffer.append('E');
            TypeFormat.format(n4 - 1, stringBuffer);
        }
        return stringBuffer;
    }

    private static final double multE(double d, int n) {
        if (n >= 0) {
            if (n <= 308) {
                return d * DOUBLE_POW_10[n];
            }
            n = Math.min(308, n - 21);
            return (d *= 1.0E21) * DOUBLE_POW_10[n];
        }
        if (n >= -308) {
            return d / DOUBLE_POW_10[-n];
        }
        n = Math.max(-308, n + 21);
        return (d /= 1.0E21) / DOUBLE_POW_10[-n];
    }

    static {
        int n = 1;
        for (int i = 0; i < 10; ++i) {
            TypeFormat.INT_POW_10[i] = n;
            n *= 10;
        }
        LONG_POW_10 = new long[19];
        long l = 1L;
        for (int i = 0; i < 19; ++i) {
            TypeFormat.LONG_POW_10[i] = l;
            l *= 10L;
        }
        LOG_10 = Math.log(10.0);
        FLOAT_RELATIVE_ERROR = (float)Math.pow(2.0, -24.0);
        DOUBLE_RELATIVE_ERROR = Math.pow(2.0, -53.0);
        LEADING_ZEROS = new String[]{"0.", "0.0", "0.00"};
        DOUBLE_POW_10 = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22, 1.0E23, 1.0E24, 1.0E25, 1.0E26, 1.0E27, 1.0E28, 1.0E29, 1.0E30, 1.0E31, 1.0E32, 1.0E33, 1.0E34, 1.0E35, 1.0E36, 1.0E37, 1.0E38, 1.0E39, 1.0E40, 1.0E41, 1.0E42, 1.0E43, 1.0E44, 1.0E45, 1.0E46, 1.0E47, 1.0E48, 1.0E49, 1.0E50, 1.0E51, 1.0E52, 1.0E53, 1.0E54, 1.0E55, 1.0E56, 1.0E57, 1.0E58, 1.0E59, 1.0E60, 1.0E61, 1.0E62, 1.0E63, 1.0E64, 1.0E65, 1.0E66, 1.0E67, 1.0E68, 1.0E69, 1.0E70, 1.0E71, 1.0E72, 1.0E73, 1.0E74, 1.0E75, 1.0E76, 1.0E77, 1.0E78, 1.0E79, 1.0E80, 1.0E81, 1.0E82, 1.0E83, 1.0E84, 1.0E85, 1.0E86, 1.0E87, 1.0E88, 1.0E89, 1.0E90, 1.0E91, 1.0E92, 1.0E93, 1.0E94, 1.0E95, 1.0E96, 1.0E97, 1.0E98, 1.0E99, 1.0E100, 1.0E101, 1.0E102, 1.0E103, 1.0E104, 1.0E105, 1.0E106, 1.0E107, 1.0E108, 1.0E109, 1.0E110, 1.0E111, 1.0E112, 1.0E113, 1.0E114, 1.0E115, 1.0E116, 1.0E117, 1.0E118, 1.0E119, 1.0E120, 1.0E121, 1.0E122, 1.0E123, 1.0E124, 1.0E125, 1.0E126, 1.0E127, 1.0E128, 1.0E129, 1.0E130, 1.0E131, 1.0E132, 1.0E133, 1.0E134, 1.0E135, 1.0E136, 1.0E137, 1.0E138, 1.0E139, 1.0E140, 1.0E141, 1.0E142, 1.0E143, 1.0E144, 1.0E145, 1.0E146, 1.0E147, 1.0E148, 1.0E149, 1.0E150, 1.0E151, 1.0E152, 1.0E153, 1.0E154, 1.0E155, 1.0E156, 1.0E157, 1.0E158, 1.0E159, 1.0E160, 1.0E161, 1.0E162, 1.0E163, 1.0E164, 1.0E165, 1.0E166, 1.0E167, 1.0E168, 1.0E169, 1.0E170, 1.0E171, 1.0E172, 1.0E173, 1.0E174, 1.0E175, 1.0E176, 1.0E177, 1.0E178, 1.0E179, 1.0E180, 1.0E181, 1.0E182, 1.0E183, 1.0E184, 1.0E185, 1.0E186, 1.0E187, 1.0E188, 1.0E189, 1.0E190, 1.0E191, 1.0E192, 1.0E193, 1.0E194, 1.0E195, 1.0E196, 1.0E197, 1.0E198, 1.0E199, 1.0E200, 1.0E201, 1.0E202, 1.0E203, 1.0E204, 1.0E205, 1.0E206, 1.0E207, 1.0E208, 1.0E209, 1.0E210, 1.0E211, 1.0E212, 1.0E213, 1.0E214, 1.0E215, 1.0E216, 1.0E217, 1.0E218, 1.0E219, 1.0E220, 1.0E221, 1.0E222, 1.0E223, 1.0E224, 1.0E225, 1.0E226, 1.0E227, 1.0E228, 1.0E229, 1.0E230, 1.0E231, 1.0E232, 1.0E233, 1.0E234, 1.0E235, 1.0E236, 1.0E237, 1.0E238, 1.0E239, 1.0E240, 1.0E241, 1.0E242, 1.0E243, 1.0E244, 1.0E245, 1.0E246, 1.0E247, 1.0E248, 1.0E249, 1.0E250, 1.0E251, 1.0E252, 1.0E253, 1.0E254, 1.0E255, 1.0E256, 1.0E257, 1.0E258, 1.0E259, 1.0E260, 1.0E261, 1.0E262, 1.0E263, 1.0E264, 1.0E265, 1.0E266, 1.0E267, 1.0E268, 1.0E269, 1.0E270, 1.0E271, 1.0E272, 1.0E273, 1.0E274, 1.0E275, 1.0E276, 1.0E277, 1.0E278, 1.0E279, 1.0E280, 1.0E281, 1.0E282, 1.0E283, 1.0E284, 1.0E285, 1.0E286, 1.0E287, 1.0E288, 1.0E289, 1.0E290, 1.0E291, 1.0E292, 1.0E293, 1.0E294, 1.0E295, 1.0E296, 1.0E297, 1.0E298, 1.0E299, 1.0E300, 1.0E301, 1.0E302, 1.0E303, 1.0E304, 1.0E305, 1.0E306, 1.0E307, 1.0E308};
    }
}

