/*
 * Decompiled with CFR 0.152.
 */
package com.dautelle.util;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public final class Utf8StreamReader
extends Reader {
    private InputStream _inStream;
    private int _start;
    private int _end;
    private final byte[] _bytes;
    private int _code;
    private int _moreBytes;

    public Utf8StreamReader() {
        this(2048);
    }

    public Utf8StreamReader(int n) {
        this._bytes = new byte[n];
    }

    public Utf8StreamReader setInputStream(InputStream inputStream) {
        this._inStream = inputStream;
        return this;
    }

    @Override
    public boolean ready() throws IOException {
        if (this._inStream != null) {
            return this._end - this._start > 0 || this._inStream.available() != 0;
        }
        throw new IOException("Stream closed");
    }

    @Override
    public void close() throws IOException {
        if (this._inStream != null) {
            this._inStream.close();
            this._start = 0;
            this._end = 0;
            this._code = 0;
            this._moreBytes = 0;
            this._inStream = null;
        }
    }

    @Override
    public int read() throws IOException {
        int n = this._bytes[this._start];
        return n >= 0 && this._start++ < this._end ? n : this.read2();
    }

    private int read2() throws IOException {
        if (this._start < this._end) {
            byte by;
            if ((by = this._bytes[this._start++]) >= 0 && this._moreBytes == 0) {
                return by;
            }
            if ((by & 0xC0) == 128 && this._moreBytes != 0) {
                this._code = this._code << 6 | by & 0x3F;
                if (--this._moreBytes == 0) {
                    return this._code;
                }
                return this.read2();
            }
            if ((by & 0xE0) == 192 && this._moreBytes == 0) {
                this._code = by & 0x1F;
                this._moreBytes = 1;
                return this.read2();
            }
            if ((by & 0xF0) == 224 && this._moreBytes == 0) {
                this._code = by & 0xF;
                this._moreBytes = 2;
                return this.read2();
            }
            if ((by & 0xF8) == 240 && this._moreBytes == 0) {
                this._code = by & 7;
                this._moreBytes = 3;
                return this.read2();
            }
            if ((by & 0xFC) == 248 && this._moreBytes == 0) {
                this._code = by & 3;
                this._moreBytes = 4;
                return this.read2();
            }
            if ((by & 0xFE) == 252 && this._moreBytes == 0) {
                this._code = by & 1;
                this._moreBytes = 5;
                return this.read2();
            }
            throw new CharConversionException("Invalid UTF-8 Encoding");
        }
        if (this._inStream != null) {
            this._start = 0;
            this._end = this._inStream.read(this._bytes, 0, this._bytes.length);
            if (this._end > 0) {
                return this.read2();
            }
            if (this._moreBytes == 0) {
                return -1;
            }
            throw new CharConversionException("Unexpected end of stream");
        }
        throw new IOException("Stream closed");
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this._inStream != null) {
            if (this._start >= this._end) {
                this._start = 0;
                this._end = this._inStream.read(this._bytes, 0, this._bytes.length);
                if (this._end <= 0) {
                    return this._end;
                }
            }
            int n3 = n + n2;
            int n4 = n;
            while (n4 < n3) {
                byte by = this._bytes[this._start];
                if (by >= 0 && ++this._start < this._end) {
                    cArray[n4++] = (char)by;
                    continue;
                }
                if (by < 0) {
                    if (n4 < n3 - 1) {
                        int n5 = this.read2();
                        if (n5 < 65536) {
                            cArray[n4++] = (char)n5;
                        } else if (n5 <= 0x10FFFF) {
                            cArray[n4++] = (char)((n5 - 65536 >> 10) + 55296);
                            cArray[n4++] = (char)((n5 - 65536 & 0x3FF) + 56320);
                        } else {
                            throw new CharConversionException("Cannot convert U+" + Integer.toHexString(n5) + " to char (code greater than U+10FFFF)");
                        }
                        if (this._start < this._end) continue;
                    }
                    return n4 - n;
                }
                cArray[n4++] = (char)by;
                return n4 - n;
            }
            return n2;
        }
        throw new IOException("Stream closed");
    }
}

