/*
 * Decompiled with CFR 0.152.
 */
package com.dautelle.util;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public final class Utf8StreamWriter
extends Writer {
    private OutputStream _outStream;
    private final byte[] _bytes;
    private int _index;
    private char _highSurrogate;

    public Utf8StreamWriter() {
        this(2048);
    }

    public Utf8StreamWriter(int n) {
        this._bytes = new byte[n];
    }

    public Utf8StreamWriter setOutputStream(OutputStream outputStream) {
        this._outStream = outputStream;
        return this;
    }

    public void write(char c) throws IOException {
        if (c < '\ud800' || c > '\udfff') {
            this.write((int)c);
        } else if (c < '\udc00') {
            this._highSurrogate = c;
        } else {
            int n = (this._highSurrogate - 55296 << 10) + (c - 56320) + 65536;
            this.write(n);
        }
    }

    @Override
    public void write(int n) throws IOException {
        if ((n & 0xFFFFFF80) == 0) {
            this._bytes[this._index] = (byte)n;
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
        } else {
            this.write2(n);
        }
    }

    private void write2(int n) throws IOException {
        if ((n & 0xFFFFF800) == 0) {
            this._bytes[this._index] = (byte)(0xC0 | n >> 6);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
        } else if ((n & 0xFFFF0000) == 0) {
            this._bytes[this._index] = (byte)(0xE0 | n >> 12);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n >> 6 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
        } else if ((n & 0xFF200000) == 0) {
            this._bytes[this._index] = (byte)(0xF0 | n >> 18);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n >> 12 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n >> 6 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
        } else if ((n & 0xF4000000) == 0) {
            this._bytes[this._index] = (byte)(0xF8 | n >> 24);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n >> 18 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n >> 12 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n >> 6 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
        } else if ((n & Integer.MIN_VALUE) == 0) {
            this._bytes[this._index] = (byte)(0xFC | n >> 30);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n >> 24 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n >> 18 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n >> 12 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n >> 6 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
        } else {
            throw new CharConversionException("Illegal character U+" + Integer.toHexString(n));
        }
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.write(cArray[i]);
        }
    }

    @Override
    public void write(String string, int n, int n2) throws IOException {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.write(string.charAt(i));
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this._outStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this._outStream != null) {
            this.flushBuffer();
            this._outStream.close();
            this._outStream = null;
        }
    }

    private void flushBuffer() throws IOException {
        if (this._outStream == null) {
            throw new IOException("Stream closed");
        }
        this._outStream.write(this._bytes, 0, this._index);
        this._index = 0;
    }
}

