/*
 * Decompiled with CFR 0.152.
 */
package com.dautelle.xml;

import com.dautelle.xml.ConstructorException;
import com.dautelle.xml.ConstructorHandler;
import com.dautelle.xml.sax.RealtimeParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Constructor {
    private final RealtimeParser _parser = new RealtimeParser();
    private final ConstructorHandler _handler = new ConstructorHandler();

    public Constructor() {
        this._parser.setContentHandler(this._handler);
    }

    public Object create(InputStream inputStream) throws ConstructorException {
        return this.create(new InputSource(inputStream));
    }

    public Object create(Reader reader) throws ConstructorException {
        return this.create(new InputSource(reader));
    }

    public Object create(File file) throws ConstructorException {
        try {
            return this.create(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConstructorException(fileNotFoundException);
        }
    }

    public Object create(URL uRL) throws ConstructorException {
        String string = uRL.toExternalForm();
        return this.create(new InputSource(string));
    }

    public Object create(InputSource inputSource) throws ConstructorException {
        try {
            this._parser.parse(inputSource);
            return this._handler._root;
        }
        catch (SAXParseException sAXParseException) {
            String string = sAXParseException.getPublicId() != null ? sAXParseException.getMessage() + " (" + sAXParseException.getPublicId() + ", line " + sAXParseException.getLineNumber() + ", column " + sAXParseException.getColumnNumber() + ")" : (sAXParseException.getSystemId() != null ? sAXParseException.getMessage() + " (" + sAXParseException.getSystemId() + ", line " + sAXParseException.getLineNumber() + ", column " + sAXParseException.getColumnNumber() + ")" : sAXParseException.getMessage() + " (line " + sAXParseException.getLineNumber() + ", column " + sAXParseException.getColumnNumber() + ")");
            throw new ConstructorException(string);
        }
        catch (SAXException sAXException) {
            throw new ConstructorException(sAXException);
        }
        catch (IOException iOException) {
            throw new ConstructorException(iOException);
        }
    }
}

