/*
 * Decompiled with CFR 0.152.
 */
package com.dautelle.xml;

import com.dautelle.util.FastMap;
import com.dautelle.xml.CharData;
import com.dautelle.xml.XmlElement;
import com.dautelle.xml.sax.Attributes;
import com.dautelle.xml.sax.ContentHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

final class ConstructorHandler
implements ContentHandler,
ErrorHandler {
    private static final Class[] PARAM_XML_ELEMENT = new Class[]{XmlElement.class};
    private int _level;
    private final StringBuffer _charBuffer = new StringBuffer();
    private Locator _locator;
    Object _root;
    final XmlElement[] _stack = new XmlElement[64];
    private final Object[] _paramsTmp = new Object[1];
    private final FastMap _methodCache = new FastMap();
    private FastMap _classRecords = new FastMap();

    ConstructorHandler() {
        this._stack[0] = new XmlElement();
        for (int i = 1; i < this._stack.length; ++i) {
            this._stack[i] = new XmlElement();
            this._stack[i]._parent = this._stack[i - 1];
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    @Override
    public void startDocument() {
        this._level = 0;
    }

    @Override
    public void endDocument() {
        this._root = this._stack[0]._content.size() == 1 ? this._stack[0]._content.get(0) : null;
        for (int i = 0; i <= this._level; ++i) {
            this._stack[i].reset();
        }
    }

    @Override
    public void startElement(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, Attributes attributes) throws SAXException {
        this.flushCharData();
        XmlElement xmlElement = this._stack[++this._level];
        xmlElement._factoryClass = this.classFor(charSequence, charSequence2);
        for (int i = 0; i < attributes.getLength(); ++i) {
            CharSequence charSequence4 = attributes.getQName(i);
            CharSequence charSequence5 = attributes.getValue(i);
            xmlElement.setAttribute(charSequence4, charSequence5);
        }
    }

    @Override
    public void endElement(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) throws SAXException {
        this.flushCharData();
        XmlElement xmlElement = this._stack[this._level];
        try {
            Method method = (Method)this._methodCache.get(xmlElement._factoryClass);
            if (method == null) {
                method = xmlElement._factoryClass.getMethod("valueOf", PARAM_XML_ELEMENT);
                this._methodCache.put(xmlElement._factoryClass, method);
            }
            this._paramsTmp[0] = this._stack[this._level];
            Object object = method.invoke(null, this._paramsTmp);
            this._stack[this._level - 1]._content.add(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAXParseException(charSequence3 + " valueOf(XmlElement) inaccessible", this._locator);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new SAXParseException(charSequence3 + " valueOf(XmlElement) not found", this._locator);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SAXParseException(charSequence3 + " valueOf(XmlElement) throws " + invocationTargetException.getTargetException(), this._locator);
        }
        this._stack[this._level].reset();
        --this._level;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        this._charBuffer.append(cArray, n, n2);
    }

    @Override
    public void startPrefixMapping(CharSequence charSequence, CharSequence charSequence2) {
    }

    @Override
    public void endPrefixMapping(CharSequence charSequence) {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    @Override
    public void processingInstruction(CharSequence charSequence, CharSequence charSequence2) {
    }

    @Override
    public void skippedEntity(CharSequence charSequence) {
    }

    @Override
    public void warning(SAXParseException sAXParseException) {
        System.err.println("XML Parsing Warning: " + sAXParseException);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    private void flushCharData() {
        for (int i = 0; i < this._charBuffer.length(); ++i) {
            if (this._charBuffer.charAt(i) <= ' ') continue;
            CharData charData = new CharData(this._charBuffer.toString());
            this._stack[this._level]._content.add(charData);
            break;
        }
        this._charBuffer.setLength(0);
    }

    private Class classFor(CharSequence charSequence, CharSequence charSequence2) throws SAXException {
        String string;
        ClassRecord classRecord = (ClassRecord)this._classRecords.get(charSequence2);
        if (classRecord != null && charSequence.equals(classRecord._uri)) {
            return classRecord._class;
        }
        String string2 = charSequence.toString();
        String string3 = charSequence2.toString();
        if (charSequence.length() == 0) {
            string = string3;
        } else if (string2.startsWith("java:")) {
            String string4 = string2.substring(5);
            string = string4.length() == 0 ? string3 : string4 + "." + charSequence2;
        } else {
            throw new SAXParseException("Invalid URI (must use a java scheme)", this._locator);
        }
        try {
            classRecord = new ClassRecord();
            classRecord._uri = string2;
            classRecord._class = Class.forName(string);
            this._classRecords.put(string3, classRecord);
            return classRecord._class;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SAXParseException("Class " + string + " not found", this._locator);
        }
    }

    private static class ClassRecord {
        String _uri;
        Class _class;

        private ClassRecord() {
        }
    }
}

