/*
 * Decompiled with CFR 0.152.
 */
package com.dautelle.xml.sax;

import com.dautelle.util.TypeFormat;
import com.dautelle.xml.sax.AttributeEntry;
import com.dautelle.xml.sax.Attributes;
import com.dautelle.xml.sax.CharSequenceImpl;
import java.util.Map;

final class AttributesImpl
implements Attributes {
    private Map defaultValues;
    int _length;
    AttributeEntry[] _entries = new AttributeEntry[0];

    public AttributesImpl() {
        this.ensureCapacity(64);
    }

    @Override
    public int getLength() {
        return this._length;
    }

    @Override
    public CharSequence getURI(int n) {
        if (n >= 0 && n < this._length) {
            return this._entries[n].uri;
        }
        return null;
    }

    @Override
    public CharSequence getLocalName(int n) {
        if (n >= 0 && n < this._length) {
            return this._entries[n].localName;
        }
        return null;
    }

    @Override
    public CharSequence getQName(int n) {
        if (n >= 0 && n < this._length) {
            return this._entries[n].qName;
        }
        return null;
    }

    @Override
    public String getType(int n) {
        if (n >= 0 && n < this._length) {
            return "CDATA";
        }
        return null;
    }

    @Override
    public CharSequence getValue(int n) {
        if (n >= 0 && n < this._length) {
            return this._entries[n].value;
        }
        return null;
    }

    @Override
    public int getIndex(CharSequence charSequence, CharSequence charSequence2) {
        for (int i = 0; i < this._length; ++i) {
            AttributeEntry attributeEntry = this._entries[i];
            if (!attributeEntry.localName.equals(charSequence2) || !attributeEntry.uri.equals(charSequence)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getIndex(CharSequence charSequence) {
        for (int i = 0; i < this._length; ++i) {
            if (!this._entries[i].qName.equals(charSequence)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getType(CharSequence charSequence, CharSequence charSequence2) {
        return this.getIndex(charSequence, charSequence2) >= 0 ? "CDATA" : null;
    }

    @Override
    public String getType(CharSequence charSequence) {
        return this.getIndex(charSequence) >= 0 ? "CDATA" : null;
    }

    @Override
    public CharSequence getValue(CharSequence charSequence, CharSequence charSequence2) {
        int n = this.getIndex(charSequence, charSequence2);
        return n >= 0 ? this._entries[n].value : null;
    }

    @Override
    public CharSequence getValue(CharSequence charSequence) {
        int n = this.getIndex(charSequence);
        if (n >= 0) {
            return this._entries[n].value;
        }
        if (null != this.defaultValues) {
            return (CharSequence)this.defaultValues.get(charSequence);
        }
        return null;
    }

    public void add(CharSequenceImpl charSequenceImpl, CharSequenceImpl charSequenceImpl2, CharSequenceImpl charSequenceImpl3, CharSequenceImpl charSequenceImpl4) {
        if (this._length >= this._entries.length) {
            this.ensureCapacity(this._entries.length * 2);
        }
        AttributeEntry attributeEntry = this._entries[this._length++];
        attributeEntry.uri = charSequenceImpl;
        attributeEntry.localName = charSequenceImpl2;
        attributeEntry.qName = charSequenceImpl3;
        attributeEntry.value = charSequenceImpl4;
    }

    void clear() {
        this._length = 0;
    }

    public void ensureCapacity(int n) {
        AttributeEntry[] attributeEntryArray = new AttributeEntry[n];
        System.arraycopy(this._entries, 0, attributeEntryArray, 0, this._entries.length);
        for (int i = this._entries.length; i < attributeEntryArray.length; ++i) {
            attributeEntryArray[i] = new AttributeEntry();
        }
        this._entries = attributeEntryArray;
    }

    @Override
    public boolean getBoolean(CharSequence charSequence) {
        CharSequence charSequence2;
        int n = this.getIndex(charSequence);
        if (n >= 0) {
            return TypeFormat.parseBoolean(this._entries[n].value);
        }
        if (null != this.defaultValues && null != (charSequence2 = (CharSequence)this.defaultValues.get(charSequence))) {
            return TypeFormat.parseBoolean(charSequence2);
        }
        throw new NullPointerException(charSequence + " attribute not found");
    }

    @Override
    public boolean getBoolean(CharSequence charSequence, boolean bl) {
        CharSequence charSequence2;
        int n = this.getIndex(charSequence);
        if (n >= 0) {
            return TypeFormat.parseBoolean(this._entries[n].value);
        }
        if (null != this.defaultValues && null != (charSequence2 = (CharSequence)this.defaultValues.get(charSequence))) {
            return TypeFormat.parseBoolean(charSequence2);
        }
        return bl;
    }

    @Override
    public double getDouble(CharSequence charSequence) {
        CharSequence charSequence2;
        int n = this.getIndex(charSequence);
        if (n >= 0) {
            return TypeFormat.parseDouble(this._entries[n].value);
        }
        if (null != this.defaultValues && null != (charSequence2 = (CharSequence)this.defaultValues.get(charSequence))) {
            return TypeFormat.parseDouble(charSequence2);
        }
        throw new NullPointerException(charSequence + " attribute not found");
    }

    @Override
    public double getDouble(CharSequence charSequence, double d) {
        CharSequence charSequence2;
        int n = this.getIndex(charSequence);
        if (n >= 0) {
            return TypeFormat.parseDouble(this._entries[n].value);
        }
        if (null != this.defaultValues && null != (charSequence2 = (CharSequence)this.defaultValues.get(charSequence))) {
            return TypeFormat.parseDouble(charSequence2);
        }
        return d;
    }

    @Override
    public int getInt(CharSequence charSequence) {
        CharSequence charSequence2;
        int n = this.getIndex(charSequence);
        if (n >= 0) {
            return TypeFormat.parseInt(this._entries[n].value);
        }
        if (null != this.defaultValues && null != (charSequence2 = (CharSequence)this.defaultValues.get(charSequence))) {
            return TypeFormat.parseInt(charSequence2);
        }
        throw new NullPointerException(charSequence + " attribute not found");
    }

    @Override
    public int getInt(CharSequence charSequence, int n) {
        CharSequence charSequence2;
        int n2 = this.getIndex(charSequence);
        if (n2 >= 0) {
            return TypeFormat.parseInt(this._entries[n2].value);
        }
        if (null != this.defaultValues && null != (charSequence2 = (CharSequence)this.defaultValues.get(charSequence))) {
            return TypeFormat.parseInt(charSequence2);
        }
        return n;
    }

    @Override
    public long getLong(CharSequence charSequence) {
        CharSequence charSequence2;
        int n = this.getIndex(charSequence);
        if (n >= 0) {
            return TypeFormat.parseLong(this._entries[n].value);
        }
        if (null != this.defaultValues && null != (charSequence2 = (CharSequence)this.defaultValues.get(charSequence))) {
            return TypeFormat.parseLong(charSequence2);
        }
        throw new NullPointerException(charSequence + " attribute not found");
    }

    @Override
    public long getLong(CharSequence charSequence, long l) {
        CharSequence charSequence2;
        int n = this.getIndex(charSequence);
        if (n >= 0) {
            return TypeFormat.parseLong(this._entries[n].value);
        }
        if (null != this.defaultValues && null != (charSequence2 = (CharSequence)this.defaultValues.get(charSequence))) {
            return TypeFormat.parseLong(charSequence2);
        }
        return l;
    }

    @Override
    public String getString(CharSequence charSequence) {
        CharSequence charSequence2;
        int n = this.getIndex(charSequence);
        if (n >= 0) {
            return this._entries[n].value.toString();
        }
        if (null != this.defaultValues && null != (charSequence2 = (CharSequence)this.defaultValues.get(charSequence))) {
            return charSequence2.toString();
        }
        throw new NullPointerException(charSequence + " attribute not found");
    }

    @Override
    public String getString(CharSequence charSequence, String string) {
        CharSequence charSequence2;
        int n = this.getIndex(charSequence);
        if (n >= 0) {
            return this._entries[n].value.toString();
        }
        if (null != this.defaultValues && null != (charSequence2 = (CharSequence)this.defaultValues.get(charSequence))) {
            return charSequence2.toString();
        }
        return string;
    }

    @Override
    public boolean hasAttribute(CharSequence charSequence) {
        return this.getIndex(charSequence) >= 0;
    }

    @Override
    public void setDefaultValues(Map map) {
        this.defaultValues = map;
    }
}

