/*
 * Decompiled with CFR 0.152.
 */
package com.dautelle.xml.sax;

import com.dautelle.xml.sax.CharSequenceImpl;
import com.dautelle.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

final class Namespace {
    private CharSequenceImpl[] _stack = new CharSequenceImpl[0];
    private int _length;
    private CharSequenceImpl _default;
    private ContentHandler _contentHandler;

    public Namespace() {
        this.ensureCapacity(64);
        this.reset();
    }

    public void push(CharSequenceImpl charSequenceImpl) {
        if (this._stack.length - this._length < 2) {
            this.ensureCapacity(this._stack.length * 2);
        }
        this._stack[this._length++] = charSequenceImpl;
        this._stack[this._length++] = null;
    }

    public CharSequenceImpl pop() throws SAXException {
        this._length -= 2;
        CharSequenceImpl charSequenceImpl = this._stack[this._length];
        while (this._length >= 2) {
            CharSequenceImpl charSequenceImpl2 = this._stack[this._length - 1];
            if (charSequenceImpl2 == null) {
                return charSequenceImpl;
            }
            CharSequenceImpl charSequenceImpl3 = this._stack[this._length - 2];
            this._contentHandler.endPrefixMapping(charSequenceImpl3);
            if (charSequenceImpl3.length == 0) {
                this._default = this.getUri(CharSequenceImpl.EMPTY);
            }
            this._length -= 2;
        }
        return charSequenceImpl;
    }

    public void map(CharSequenceImpl charSequenceImpl, CharSequenceImpl charSequenceImpl2) throws SAXException {
        if (this._stack.length - this._length < 2) {
            this.ensureCapacity(this._stack.length * 2);
        }
        this._stack[this._length++] = charSequenceImpl;
        this._stack[this._length++] = charSequenceImpl2;
        this._contentHandler.startPrefixMapping(charSequenceImpl, charSequenceImpl2);
        if (charSequenceImpl.length == 0) {
            this._default = charSequenceImpl2;
        }
    }

    public CharSequenceImpl getUri(CharSequenceImpl charSequenceImpl) {
        for (int i = this._length - 1; i > 0; i -= 2) {
            CharSequenceImpl charSequenceImpl2;
            CharSequenceImpl charSequenceImpl3 = this._stack[i];
            if (charSequenceImpl3 == null || !(charSequenceImpl2 = this._stack[i - 1]).equals(charSequenceImpl)) continue;
            return charSequenceImpl3;
        }
        return null;
    }

    public CharSequenceImpl getDefault() {
        return this._default;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this._contentHandler = contentHandler;
    }

    public void reset() {
        this._stack[0] = CharSequenceImpl.EMPTY;
        this._stack[1] = CharSequenceImpl.EMPTY;
        this._length = 2;
        this._default = CharSequenceImpl.EMPTY;
        this.push(CharSequenceImpl.EMPTY);
    }

    public void ensureCapacity(int n) {
        CharSequenceImpl[] charSequenceImplArray = new CharSequenceImpl[n];
        System.arraycopy(this._stack, 0, charSequenceImplArray, 0, this._stack.length);
        this._stack = charSequenceImplArray;
    }
}

