/*
 * Decompiled with CFR 0.152.
 */
package com.dautelle.xml.sax;

import com.dautelle.xml.sax.XMLReaderImpl;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Parser;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderAdapter;

public final class SAXParserFactoryImpl
extends SAXParserFactory {
    public SAXParserFactoryImpl() {
        this.setNamespaceAware(true);
        this.setValidating(false);
    }

    @Override
    public SAXParser newSAXParser() throws ParserConfigurationException {
        if (this.isValidating()) {
            throw new ParserConfigurationException("com.dautelle.xml.sax.XMLReaderImpl is non-validating");
        }
        if (!this.isNamespaceAware()) {
            throw new ParserConfigurationException("com.dautelle.xml.sax.XMLReaderImpl parser is namespace-aware");
        }
        return new SAXParserImpl();
    }

    @Override
    public boolean getFeature(String string) throws SAXNotRecognizedException {
        if (string.equals("http://xml.org/sax/features/namespaces")) {
            return true;
        }
        if (string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return true;
        }
        throw new SAXNotRecognizedException("Feature " + string + " not recognized");
    }

    @Override
    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException {
        if (string.equals("http://xml.org/sax/features/namespaces") || string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return;
        }
        throw new SAXNotRecognizedException("Feature " + string + " not recognized");
    }

    private static final class SAXParserImpl
    extends SAXParser {
        private final XMLReader _xmlReader = new XMLReaderImpl();

        private SAXParserImpl() {
        }

        @Override
        public Parser getParser() {
            return new XMLReaderAdapter(this._xmlReader);
        }

        @Override
        public XMLReader getXMLReader() {
            return this._xmlReader;
        }

        @Override
        public boolean isNamespaceAware() {
            return true;
        }

        @Override
        public boolean isValidating() {
            return false;
        }

        @Override
        public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
            return this._xmlReader.getProperty(string);
        }

        @Override
        public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
            this._xmlReader.setProperty(string, object);
        }
    }
}

