/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.awt.Color;
import java.io.Serializable;
import java.util.StringTokenizer;
import org.jdom.IllegalDataException;
import org.jdom.IllegalNameException;
import org.jdom.Verifier;

public final class Attribute
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 520L;
    private String name;
    private String value;

    public Attribute(String string, String string2) {
        this.setName(string);
        this.setValue(string2);
    }

    public String getName() {
        return this.name;
    }

    public Attribute setName(String string) {
        String string2 = Verifier.checkAttributeName(string);
        if (string2 != null) {
            throw new IllegalNameException(string, "attribute", string2);
        }
        this.name = string;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public Attribute setValue(String string) {
        String string2 = null;
        string2 = Verifier.checkCharacterData(string);
        if (string2 != null) {
            throw new IllegalDataException(string, "attribute", string2);
        }
        this.value = string;
        return this;
    }

    public String toString() {
        return new StringBuffer().append("[Attribute: ").append(this.getName()).append("=\"").append(this.value).append("\"").append("]").toString();
    }

    public final boolean equals(Object object) {
        return object == this;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public Object clone() {
        Attribute attribute = null;
        try {
            attribute = (Attribute)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return attribute;
    }

    public int getIntValue() {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("Value is not an int : " + this.value);
        }
    }

    public long getLongValue() {
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("Value is not a long : " + this.value);
        }
    }

    public float getFloatValue() {
        try {
            return Float.parseFloat(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("Value is not a float : " + this.value);
        }
    }

    public double getDoubleValue() {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("Value is not a double : " + this.value);
        }
    }

    public boolean getBooleanValue() {
        if (this.value.equalsIgnoreCase("true") || this.value.equalsIgnoreCase("on") || this.value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (this.value.equalsIgnoreCase("false") || this.value.equalsIgnoreCase("off") || this.value.equalsIgnoreCase("no")) {
            return false;
        }
        throw new RuntimeException("Value is not a boolean : " + this.value);
    }

    public Color getColorValue() {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.value, ",");
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            return new Color(n, n2, n3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("Value is not a color : " + this.value);
        }
    }
}

