/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.IllegalAddException;

final class AttributeList
extends AbstractList
implements List,
Serializable {
    private static final long serialVersionUID = 520L;
    private static final int INITIAL_ARRAY_SIZE = 3;
    private ArrayList list;

    @Override
    public boolean add(Object object) {
        int n = this.indexOfDuplicate(object);
        if (n < 0) {
            this.add(this.size(), object);
        } else {
            this.set(n, object);
        }
        return true;
    }

    public void add(int n, Object object) {
        if (!(object instanceof Attribute)) {
            if (object == null) {
                throw new IllegalAddException("Cannot add null attribute");
            }
            throw new IllegalAddException("Class " + object.getClass().getName() + " is not an attribute");
        }
        this.add(n, (Attribute)object);
        ++this.modCount;
    }

    protected void add(int n, Attribute attribute) {
        int n2;
        if (attribute == null) {
            throw new IllegalAddException("Cannot add null attribute");
        }
        if (this.list == null) {
            if (n == 0) {
                this.ensureCapacity(3);
            } else {
                throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
            }
        }
        if ((n2 = this.indexOfDuplicate(attribute)) >= 0) {
            throw new IllegalAddException("Cannot add duplicate attribute");
        }
        this.list.add(n, attribute);
    }

    @Override
    public boolean addAll(Collection collection) {
        return this.addAll(this.size(), collection);
    }

    public boolean addAll(int n, Collection collection) {
        if (this.list == null && n != 0) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        if (collection == null || collection.size() == 0) {
            return false;
        }
        int n2 = 0;
        try {
            for (Object e : collection) {
                this.add(n + n2, e);
                ++n2;
            }
        }
        catch (RuntimeException runtimeException) {
            for (int i = 0; i < n2; ++i) {
                this.remove(n + i);
            }
            throw runtimeException;
        }
        return true;
    }

    protected void ensureCapacity(int n) {
        if (this.list == null) {
            this.list = new ArrayList(n);
        } else {
            this.list.ensureCapacity(n);
        }
    }

    public Object get(int n) {
        if (this.list == null) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        return this.list.get(n);
    }

    protected Object get(String string) {
        int n = this.indexOf(string);
        if (n < 0) {
            return null;
        }
        return this.list.get(n);
    }

    protected int indexOf(String string) {
        if (this.list != null) {
            for (int i = 0; i < this.list.size(); ++i) {
                Attribute attribute = (Attribute)this.list.get(i);
                String string2 = attribute.getName();
                if (!string2.equals(string)) continue;
                return i;
            }
        }
        return -1;
    }

    public Object remove(int n) {
        if (this.list == null) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        Object e = this.list.get(n);
        ++this.modCount;
        this.list.remove(n);
        return e;
    }

    public void clearAndSet(Collection collection) {
        ArrayList arrayList = this.list;
        this.list = null;
        if (collection != null && collection.size() != 0) {
            this.ensureCapacity(collection.size());
            try {
                this.addAll(0, collection);
            }
            catch (RuntimeException runtimeException) {
                this.list = arrayList;
                throw runtimeException;
            }
        }
    }

    protected boolean remove(String string) {
        int n = this.indexOf(string);
        if (n < 0) {
            return false;
        }
        return this.list.remove(n) != null;
    }

    public Object set(int n, Object object) {
        if (this.list == null) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        int n2 = this.indexOfDuplicate(object);
        if (n2 >= 0 && n2 != n) {
            throw new IllegalAddException("Cannot set duplicate attribute");
        }
        Object object2 = this.remove(n);
        try {
            this.add(n, object);
        }
        catch (RuntimeException runtimeException) {
            this.add(n, object2);
            throw runtimeException;
        }
        return object2;
    }

    private int indexOfDuplicate(Object object) {
        int n = -1;
        if (object instanceof Attribute) {
            Attribute attribute = (Attribute)object;
            String string = attribute.getName();
            n = this.indexOf(string);
        }
        return n;
    }

    @Override
    public int size() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    @Override
    public String toString() {
        if (this.list != null && this.list.size() > 0) {
            return this.list.toString();
        }
        return "[]";
    }
}

