/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.IllegalAddException;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;

class ContentList
extends AbstractList
implements List,
Cloneable,
Serializable {
    private static final long serialVersionUID = 520L;
    private static final int INITIAL_ARRAY_SIZE = 5;
    protected ArrayList list;

    protected ContentList() {
        this.ensureCapacity(5);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void add(int n, Object object) {
        if (object instanceof Element) {
            this.add(n, (Element)object);
        } else if (object instanceof Comment) {
            this.add(n, (Comment)object);
        } else if (object instanceof ProcessingInstruction) {
            this.add(n, (ProcessingInstruction)object);
        } else if (object instanceof CDATA) {
            this.add(n, (CDATA)object);
        } else if (object instanceof Text) {
            this.add(n, (Text)object);
        } else if (object instanceof EntityRef) {
            this.add(n, (EntityRef)object);
        } else {
            if (object == null) {
                throw new IllegalAddException("Cannot add null object");
            }
            throw new IllegalAddException("Class " + object.getClass().getName() + " is of unrecognized type and cannot be added");
        }
    }

    protected void add(int n, Element element) {
        if (element == null) {
            throw new IllegalAddException("Cannot add null object");
        }
        if (this.list == null) {
            if (n == 0) {
                this.ensureCapacity(5);
            } else {
                throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
            }
        }
        this.list.add(n, element);
        ++this.modCount;
    }

    protected void add(int n, Comment comment) {
        if (comment == null) {
            throw new IllegalAddException("Cannot add null object");
        }
        if (this.list == null) {
            if (n == 0) {
                this.ensureCapacity(5);
            } else {
                throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
            }
        }
        this.list.add(n, comment);
        ++this.modCount;
    }

    protected void add(int n, ProcessingInstruction processingInstruction) {
        if (processingInstruction == null) {
            throw new IllegalAddException("Cannot add null object");
        }
        if (this.list == null) {
            if (n == 0) {
                this.ensureCapacity(5);
            } else {
                throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
            }
        }
        this.list.add(n, processingInstruction);
        ++this.modCount;
    }

    protected void add(int n, CDATA cDATA) {
        if (cDATA == null) {
            throw new IllegalAddException("Cannot add null object");
        }
        if (this.list == null) {
            if (n == 0) {
                this.ensureCapacity(5);
            } else {
                throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
            }
        }
        this.list.add(n, cDATA);
        ++this.modCount;
    }

    protected void add(int n, Text text) {
        if (text == null) {
            throw new IllegalAddException("Cannot add null object");
        }
        if (this.list == null) {
            if (n == 0) {
                this.ensureCapacity(5);
            } else {
                throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
            }
        }
        this.list.add(n, text);
        ++this.modCount;
    }

    protected void add(int n, EntityRef entityRef) {
        if (entityRef == null) {
            throw new IllegalAddException("Cannot add null object");
        }
        if (this.list == null) {
            if (n == 0) {
                this.ensureCapacity(5);
            } else {
                throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
            }
        }
        this.list.add(n, entityRef);
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection collection) {
        return this.addAll(this.size(), collection);
    }

    public boolean addAll(int n, Collection collection) {
        if (this.list == null && n != 0) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        if (collection == null || collection.size() == 0) {
            return false;
        }
        int n2 = 0;
        try {
            for (Object e : collection) {
                this.add(n + n2, e);
                ++n2;
            }
        }
        catch (RuntimeException runtimeException) {
            for (int i = 0; i < n2; ++i) {
                this.remove(n + i);
            }
            throw runtimeException;
        }
        return true;
    }

    protected void ensureCapacity(int n) {
        if (this.list == null) {
            this.list = new ArrayList(n);
        } else {
            this.list.ensureCapacity(n);
        }
    }

    public Object get(int n) {
        if (this.list == null) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        return this.list.get(n);
    }

    protected List getView(Filter filter) {
        return new FilterList(filter);
    }

    protected Element[] getElements() {
        FilterList filterList = new FilterList(new ElementFilter());
        return filterList.getElements();
    }

    protected Element[] getElements(String string) {
        FilterList filterList = new FilterList(new ElementFilter(string));
        return filterList.getElements();
    }

    protected int indexOfFirstElement() {
        if (this.list != null) {
            for (int i = 0; i < this.list.size(); ++i) {
                if (!(this.list.get(i) instanceof Element)) continue;
                return i;
            }
        }
        return -1;
    }

    public Object remove(int n) {
        if (this.list == null) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        Object e = this.list.get(n);
        this.list.remove(n);
        ++this.modCount;
        return e;
    }

    protected void clearAndSet(Collection collection) {
        ArrayList arrayList = this.list;
        this.list = null;
        if (collection != null && collection.size() != 0) {
            this.ensureCapacity(collection.size());
            try {
                this.addAll(0, collection);
            }
            catch (RuntimeException runtimeException) {
                this.list = arrayList;
                throw runtimeException;
            }
        }
    }

    public Object set(int n, Object object) {
        if (this.list == null) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        Object object2 = this.remove(n);
        try {
            this.add(n, object);
        }
        catch (RuntimeException runtimeException) {
            this.add(n, object2);
            throw runtimeException;
        }
        return object2;
    }

    @Override
    public int size() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    @Override
    public String toString() {
        if (this.list != null && this.list.size() > 0) {
            return this.list.toString();
        }
        return "[]";
    }

    public int getModCount() {
        return this.modCount;
    }

    class FilterListIterator
    implements ListIterator {
        static final int CREATE = 0;
        static final int HASPREV = 1;
        static final int HASNEXT = 2;
        static final int PREV = 3;
        static final int NEXT = 4;
        static final int ADD = 5;
        static final int REMOVE = 6;
        static final int SET = 7;
        Filter filter;
        int lastOperation;
        int initialCursor;
        int cursor;
        int last;
        int expected;

        FilterListIterator(Filter filter, int n) {
            this.filter = filter;
            this.initialCursor = this.initializeCursor(n);
            this.last = -1;
            this.expected = ContentList.this.getModCount();
            this.lastOperation = 0;
        }

        @Override
        public boolean hasNext() {
            this.checkConcurrentModification();
            switch (this.lastOperation) {
                case 0: {
                    this.cursor = this.initialCursor;
                    break;
                }
                case 3: {
                    this.cursor = this.last;
                    break;
                }
                case 4: {
                    this.cursor = this.moveForward(this.last + 1);
                    break;
                }
                case 5: 
                case 6: {
                    this.cursor = this.moveForward(this.last);
                    break;
                }
                case 1: {
                    this.cursor = this.moveForward(this.cursor + 1);
                    break;
                }
            }
            if (this.lastOperation != 0) {
                this.lastOperation = 2;
            }
            return this.cursor < ContentList.this.size();
        }

        @Override
        public Object next() {
            this.checkConcurrentModification();
            if (!this.hasNext()) {
                throw new IllegalStateException("no next item");
            }
            this.last = this.cursor;
            this.lastOperation = 4;
            return ContentList.this.get(this.last);
        }

        @Override
        public boolean hasPrevious() {
            this.checkConcurrentModification();
            switch (this.lastOperation) {
                case 0: {
                    this.cursor = this.initialCursor;
                    if (this.cursor < ContentList.this.size()) break;
                    this.cursor = this.moveBackward(this.initialCursor);
                    break;
                }
                case 3: 
                case 6: {
                    this.cursor = this.moveBackward(this.last - 1);
                    break;
                }
                case 2: {
                    this.cursor = this.moveBackward(this.cursor - 1);
                    break;
                }
                case 4: 
                case 5: {
                    this.cursor = this.last;
                    break;
                }
            }
            if (this.lastOperation != 0) {
                this.lastOperation = 1;
            }
            return this.cursor >= 0;
        }

        public Object previous() {
            this.checkConcurrentModification();
            if (!this.hasPrevious()) {
                throw new IllegalStateException("no previous item");
            }
            this.last = this.cursor;
            this.lastOperation = 3;
            return ContentList.this.get(this.last);
        }

        @Override
        public int nextIndex() {
            this.checkConcurrentModification();
            this.hasNext();
            int n = 0;
            for (int i = 0; i < ContentList.this.size(); ++i) {
                if (!this.filter.matches(ContentList.this.get(i))) continue;
                if (i == this.cursor) {
                    return n;
                }
                ++n;
            }
            this.expected = ContentList.this.getModCount();
            return n;
        }

        @Override
        public int previousIndex() {
            this.checkConcurrentModification();
            if (this.hasPrevious()) {
                int n = 0;
                for (int i = 0; i < ContentList.this.size(); ++i) {
                    if (!this.filter.matches(ContentList.this.get(i))) continue;
                    if (i == this.cursor) {
                        return n;
                    }
                    ++n;
                }
            }
            return -1;
        }

        public void add(Object object) {
            this.checkConcurrentModification();
            if (this.lastOperation != 3 && this.lastOperation != 4) {
                throw new IllegalStateException("no preceeding call to prev() or next()");
            }
            if (!this.filter.canAdd(object)) {
                throw new IllegalAddException("Filter won't allow add of " + object.getClass().getName());
            }
            ContentList.this.add(this.last, object);
            this.expected = ContentList.this.getModCount();
            this.lastOperation = 5;
        }

        @Override
        public void remove() {
            this.checkConcurrentModification();
            if (this.lastOperation != 3 && this.lastOperation != 4) {
                throw new IllegalStateException("no preceeding call to prev() or next()");
            }
            Object object = ContentList.this.get(this.last);
            if (!this.filter.canRemove(object)) {
                throw new IllegalAddException("Filter won't allow " + object.getClass().getName() + " (index " + this.last + ") to be removed");
            }
            ContentList.this.remove(this.last);
            this.expected = ContentList.this.getModCount();
            this.lastOperation = 6;
        }

        public void set(Object object) {
            this.checkConcurrentModification();
            if (this.lastOperation != 3 && this.lastOperation != 4) {
                throw new IllegalStateException("no preceeding call to prev() or next()");
            }
            if (this.filter.canAdd(object)) {
                Object object2 = ContentList.this.get(this.last);
                if (!this.filter.canRemove(object2)) {
                    throw new IllegalAddException("Filter won't allow " + object2.getClass().getName() + " (index " + this.last + ") to be removed");
                }
            } else {
                throw new IllegalAddException("Filter won't allow index " + this.last + " to be set to " + object.getClass().getName());
            }
            ContentList.this.set(this.last, object);
            this.expected = ContentList.this.getModCount();
            this.lastOperation = 6;
        }

        private int initializeCursor(int n) {
            if (n < 0) {
                throw new IndexOutOfBoundsException("Index: " + n);
            }
            int n2 = 0;
            for (int i = 0; i < ContentList.this.size(); ++i) {
                Object object = ContentList.this.get(i);
                if (!this.filter.matches(object)) continue;
                if (n == n2) {
                    return i;
                }
                ++n2;
            }
            if (n > n2) {
                throw new IndexOutOfBoundsException("Index: " + n + " Size: " + n2);
            }
            return ContentList.this.size();
        }

        private int moveForward(int n) {
            if (n < 0) {
                n = 0;
            }
            for (int i = n; i < ContentList.this.size(); ++i) {
                Object object = ContentList.this.get(i);
                if (!this.filter.matches(object)) continue;
                return i;
            }
            return ContentList.this.size();
        }

        private int moveBackward(int n) {
            if (n >= ContentList.this.size()) {
                n = ContentList.this.size() - 1;
            }
            for (int i = n; i >= 0; --i) {
                Object object = ContentList.this.get(i);
                if (!this.filter.matches(object)) continue;
                return i;
            }
            return -1;
        }

        private void checkConcurrentModification() {
            if (this.expected != ContentList.this.getModCount()) {
                throw new ConcurrentModificationException();
            }
        }
    }

    class FilterList
    extends AbstractList {
        protected Filter filter;
        int count = 0;
        int expected = 0;

        FilterList(Filter filter) {
            this.filter = filter;
        }

        @Override
        public void add(int n, Object object) {
            if (this.filter.canAdd(object)) {
                int n2 = this.getAdjustedIndex(n);
                ContentList.this.add(n2, object);
                ++this.expected;
                ++this.count;
            } else {
                throw new IllegalAddException("Filter won't allow the " + object.getClass().getName() + " '" + object + "' to be added to the list");
            }
        }

        @Override
        public Object get(int n) {
            int n2 = this.getAdjustedIndex(n);
            return ContentList.this.get(n2);
        }

        @Override
        public Iterator iterator() {
            return new FilterListIterator(this.filter, 0);
        }

        @Override
        public ListIterator listIterator() {
            return new FilterListIterator(this.filter, 0);
        }

        @Override
        public ListIterator listIterator(int n) {
            return new FilterListIterator(this.filter, n);
        }

        @Override
        public Object remove(int n) {
            int n2 = this.getAdjustedIndex(n);
            Object object = ContentList.this.get(n2);
            if (this.filter.canRemove(object)) {
                object = ContentList.this.remove(n2);
                ++this.expected;
                --this.count;
            } else {
                throw new IllegalAddException("Filter won't allow the " + object.getClass().getName() + " '" + object + "' (index " + n + ") to be removed");
            }
            return object;
        }

        @Override
        public Object set(int n, Object object) {
            Object object2 = null;
            if (this.filter.canAdd(object)) {
                int n2 = this.getAdjustedIndex(n);
                object2 = ContentList.this.get(n2);
                if (!this.filter.canRemove(object2)) {
                    throw new IllegalAddException("Filter won't allow the " + object2.getClass().getName() + " '" + object2 + "' (index " + n + ") to be removed");
                }
                object2 = ContentList.this.set(n2, object);
                this.expected += 2;
            } else {
                throw new IllegalAddException("Filter won't allow index " + n + " to be set to " + object.getClass().getName());
            }
            return object2;
        }

        @Override
        public int size() {
            if (this.expected == ContentList.this.getModCount()) {
                return this.count;
            }
            this.count = 0;
            for (int i = 0; i < ContentList.this.size(); ++i) {
                Object e = ContentList.this.list.get(i);
                if (!this.filter.matches(e)) continue;
                ++this.count;
            }
            this.expected = ContentList.this.getModCount();
            return this.count;
        }

        public Element[] getElements() {
            int n = ContentList.this.size();
            ArrayList arrayList = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                Object e = ContentList.this.list.get(i);
                if (!this.filter.matches(e)) continue;
                arrayList.add(e);
            }
            Element[] elementArray = new Element[arrayList.size()];
            arrayList.toArray(elementArray);
            return elementArray;
        }

        private final int getAdjustedIndex(int n) {
            int n2 = 0;
            for (int i = 0; i < ContentList.this.list.size(); ++i) {
                Object e = ContentList.this.list.get(i);
                if (!this.filter.matches(e)) continue;
                if (n == n2) {
                    return i;
                }
                ++n2;
            }
            if (n == n2) {
                return ContentList.this.list.size();
            }
            return ContentList.this.list.size() + 1;
        }
    }
}

